package com.biz.crm.tpm.business.audit.fee.local.repository.prediction;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.prediction.AuditFeePrediction;
import com.biz.crm.tpm.business.audit.fee.local.mapper.prediction.AuditFeePredictionMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.prediction.AuditFeePredictionVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import jodd.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Optional;

/**
 * 扣费预测
 *
 * @author zy
 * @date 2022-09-23
 */
@Component
public class AuditFeePredictionRepository extends ServiceImpl<AuditFeePredictionMapper, AuditFeePrediction> {

    /**
     * 根据是否核销完成查询所有
     * @param wholeAudit
     * @return
     */
    public List<AuditFeePrediction> findAll(String wholeAudit) {
        if (StringUtils.isEmpty(wholeAudit)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(AuditFeePrediction::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeePrediction::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeePrediction::getWholeAudit,wholeAudit)
                .list();
    }

    /**
     * 根据活动细案编码集合查询
     * @param activityDetailPlanItemCodes
     * @return
     */
    public List<AuditFeePrediction> findByActivityDetailPlanItemCodes(List<String> activityDetailPlanItemCodes) {
        if (CollectionUtils.isEmpty(activityDetailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(AuditFeePrediction::getDetailPlanItemCode,activityDetailPlanItemCodes)
                .eq(AuditFeePrediction::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeePrediction::getTenantCode, TenantUtils.getTenantCode())
                .orderByAsc(AuditFeePrediction::getDetailPlanItemCode)
                .list();
    }

    public Page<AuditFeePredictionVo> findByConditions(Pageable pageable, AuditFeePredictionDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<AuditFeePredictionVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto = Optional.ofNullable(dto).orElse(new AuditFeePredictionDto());
        if (StringUtil.isEmpty(dto.getTenantCode())){
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.baseMapper.findByConditions(page,dto);
    }

    public Page<String> findDetailPlanCodes(Pageable pageable) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<String> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.baseMapper.findDetailPlanCodes(page);
    }

    public List<String> findExistItemCode(List<String> itemCodeList) {
        return this.baseMapper.findExistItemCode(itemCodeList);
    }
}
