package com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDetailPlanShare;
import com.biz.crm.tpm.business.audit.fee.local.mapper.settlement.check.AuditFeeSettlementCheckDetailPlanMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDetailPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 结算核对-细案
 *
 * @author zy
 * @date 2022-09-25
 */
@Component
public class AuditFeeSettlementCheckDetailPlanRepository extends ServiceImpl<AuditFeeSettlementCheckDetailPlanMapper, AuditFeeSettlementCheckDetailPlan> {

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private AuditFeeSettlementCheckDetailPlanShareRepository auditFeeSettlementCheckDetailPlanShareRepository;

    /**
     * 根据编码查询
     * @param code
     * @return
     */
    public List<AuditFeeSettlementCheckDetailPlan> findByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(AuditFeeSettlementCheckDetailPlan::getCode,code)
                .list();
    }

    public List<AuditFeeSettlementCheckDetailPlanVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        return this.baseMapper.findWithShare(ids, TenantUtils.getTenantCode());
    }

    public Page<AuditFeeSettlementCheckDetailPlanVo> findByConditions(Page<AuditFeeSettlementCheckDetailPlanVo> page, AuditFeeSettlementCheckDetailPlanDto dto) {
        return this.baseMapper.findByConditions(page,dto);
    }

    /**
     * 根据code集合删除
     * @param codes
     */
    public void removeByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        this.lambdaUpdate()
                .in(AuditFeeSettlementCheckDetailPlan::getCode,codes)
                .remove();
        // 删除关联的分摊数据
        LambdaQueryWrapper<AuditFeeSettlementCheckDetailPlanShare> deleteShareWrapper = new LambdaQueryWrapper<>();
        deleteShareWrapper.in(AuditFeeSettlementCheckDetailPlanShare::getCode, codes);
        auditFeeSettlementCheckDetailPlanShareRepository.remove(deleteShareWrapper);
    }

    /**
     * 根据code和费用单编码删除
     * @param code
     * @param feeDetailCodes
     */
    public void removeByCodeAndFeeDetailCode(String code, List<String> feeDetailCodes) {
        if (StringUtils.isEmpty(code)) {
            return;
        }
        this.lambdaUpdate()
                .eq(AuditFeeSettlementCheckDetailPlan::getCode,code)
                .remove();
    }


    public List<AuditFeeSettlementCheckDetailPlanDto> findDtoByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return Lists.newArrayList();
        }
        List<AuditFeeSettlementCheckDetailPlanVo> list = this.baseMapper.findWithShareByCodes(Lists.newArrayList(code), TenantUtils.getTenantCode());

        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List<AuditFeeSettlementCheckDetailPlanDto>) this.nebulaToolkitService.copyCollectionByWhiteList(list,AuditFeeSettlementCheckDetailPlanVo.class,AuditFeeSettlementCheckDetailPlanDto.class, HashSet.class, ArrayList.class);
    }

    public void saveWithShare(List<AuditFeeSettlementCheckDetailPlan> detailPlanList) {
        if (CollectionUtils.isEmpty(detailPlanList)) return;

        List<AuditFeeSettlementCheckDetailPlanShare> shares = new ArrayList<>(detailPlanList.size());
        detailPlanList.forEach(e -> {
            e.setId(null);

            AuditFeeSettlementCheckDetailPlanShare share = new AuditFeeSettlementCheckDetailPlanShare();
            share.setCode(e.getCode());
            share.setDetailPlanItemCode(e.getDetailPlanItemCode());
            share.setAuditFeeCheckShareAmount(e.getAuditFeeCheckShareAmount());
            share.setToBeSupplementedAmount(e.getToBeSupplementedAmount());
            share.setThisAuditAmount(e.getThisAuditAmount());
            shares.add(share);
        });
        this.saveBatch(detailPlanList);
        auditFeeSettlementCheckDetailPlanShareRepository.saveBatch(shares);
    }

    public List<AuditFeeSettlementCheckDetailPlanVo> findActivityAndShareByActivityItemCodes(List<String> activityItemCodes) {
        if (CollectionUtils.isEmpty(activityItemCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeSettlementCheckDetailPlanVo> list = this.baseMapper.findActivityAndShareByActivityItemCodes(activityItemCodes,TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public List<String> findNoConfirmByDetailPlanItemCodeList(List<String> detailPlanItemCodes) {
        return baseMapper.findNoConfirmByDetailPlanItemCodeList(detailPlanItemCodes,TenantUtils.getTenantCode());
    }
}
