package com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDiff;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDiffShare;
import com.biz.crm.tpm.business.audit.fee.local.mapper.settlement.check.AuditFeeSettlementCheckDiffMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDiffVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 结算核对-差异费
 *
 * @author zy
 * @date 2022-09-25
 */
@Component
public class AuditFeeSettlementCheckDiffRepository extends ServiceImpl<AuditFeeSettlementCheckDiffMapper, AuditFeeSettlementCheckDiff> {

    @Autowired
    private AuditFeeSettlementCheckDiffShareRepository auditFeeSettlementCheckDiffShareRepository;

    /**
     * 根据code集合删除
     * @param codes
     */
    public void removeByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        this.lambdaUpdate()
                .in(AuditFeeSettlementCheckDiff::getCode,codes)
                .remove();

        LambdaQueryWrapper<AuditFeeSettlementCheckDiffShare> deleteShareWrapper = new LambdaQueryWrapper<>();
        deleteShareWrapper.in(AuditFeeSettlementCheckDiffShare::getCode, codes);
        auditFeeSettlementCheckDiffShareRepository.remove(deleteShareWrapper);
    }

    public List<AuditFeeSettlementCheckDiffVo> findAllByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return new ArrayList<>(0);
        }
        return this.baseMapper.findWithShareByCodes(Lists.newArrayList(code), TenantUtils.getTenantCode());
    }

    public void saveWithShare(List<AuditFeeSettlementCheckDiff> diffList) {
        if (CollectionUtils.isEmpty(diffList)) {
            return;
        }
        ArrayList<AuditFeeSettlementCheckDiffShare> shares = new ArrayList<>(diffList.size());
        diffList.forEach(e -> {
            e.setId(null);

            AuditFeeSettlementCheckDiffShare share = new AuditFeeSettlementCheckDiffShare();
            share.setCode(e.getCode());
            share.setFeeDiffLedgerCode(e.getFeeDiffLedgerCode());
            share.setDeductAmount(e.getDeductAmount());
            shares.add(share);
        });
        this.saveBatch(diffList);
        auditFeeSettlementCheckDiffShareRepository.saveBatch(shares);
    }
}
