package com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckCost;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckFee;
import com.biz.crm.tpm.business.audit.fee.local.mapper.settlement.check.AuditFeeSettlementCheckFeeMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckFeeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckFeeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 结算核对-费用单
 *
 * @author zy
 * @date 2022-09-25
 */
@Component
public class AuditFeeSettlementCheckFeeRepository extends ServiceImpl<AuditFeeSettlementCheckFeeMapper, AuditFeeSettlementCheckFee> {



    /**
     * 根据编码查询
     * @param code
     * @return
     */
    public List<AuditFeeSettlementCheckFee> findByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(AuditFeeSettlementCheckFee::getCode,code)
                .list();
    }

    public AuditFeeSettlementCheckFee findByDetailCode(String feeDetailCode) {
        LambdaQueryWrapper<AuditFeeSettlementCheckFee> query = new LambdaQueryWrapper<>();
        query.eq(AuditFeeSettlementCheckFee::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        query.eq(AuditFeeSettlementCheckFee::getTenantCode, TenantUtils.getTenantCode());
        query.eq(AuditFeeSettlementCheckFee::getFeeDetailCode, feeDetailCode);
        query.last("limit 1");
        return this.getOne(query);
    }

    public Page<AuditFeeSettlementCheckFeeVo> findByConditions(Page<AuditFeeSettlementCheckFeeVo> page, AuditFeeSettlementCheckFeeDto dto) {
        return this.baseMapper.findByConditions(page,dto);
    }

    /**
     * 根据code集合删除
     * @param codes
     */
    public void removeByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        this.lambdaUpdate()
                .in(AuditFeeSettlementCheckFee::getCode, codes)
                .remove();
    }

    public List<String> findFeeDetailCodeByFeeDetailCodes(List<String> feeDetailCodes) {
        if (CollectionUtils.isEmpty(feeDetailCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeSettlementCheckFee> list = this.lambdaQuery()
            .select(AuditFeeSettlementCheckFee::getFeeDetailCode)
            .eq(AuditFeeSettlementCheckFee::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeSettlementCheckFee::getTenantCode, TenantUtils.getTenantCode())
            .in(AuditFeeSettlementCheckFee::getFeeDetailCode, feeDetailCodes)
            .list();
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>(0);
        }
        return list.stream().map(AuditFeeSettlementCheckFee::getFeeDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public Set<String> findFeeDetailCodeByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) return new HashSet<>(0);
        List<AuditFeeSettlementCheckFee> list = this.lambdaQuery()
            .select(AuditFeeSettlementCheckFee::getFeeDetailCode)
            .eq(AuditFeeSettlementCheckFee::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeSettlementCheckFee::getTenantCode, TenantUtils.getTenantCode())
            .in(AuditFeeSettlementCheckFee::getCode, codes)
            .list();
        if (CollectionUtils.isEmpty(list)) return new HashSet<>(0);
        return list.stream().map(AuditFeeSettlementCheckFee::getFeeDetailCode).filter(Objects::nonNull).collect(Collectors.toSet());
    }

}
