package com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheck;
import com.biz.crm.tpm.business.audit.fee.local.mapper.settlement.check.AuditFeeSettlementCheckMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditStateEnum;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 结算核对
 *
 * @author zy
 * @date 2022-09-25
 */
@Component
public class AuditFeeSettlementCheckRepository extends ServiceImpl<AuditFeeSettlementCheckMapper, AuditFeeSettlementCheck> {


    public void removeByConfirm(String isConfirm) {
        this.lambdaUpdate()
                .eq(AuditFeeSettlementCheck::getIsConfirm,isConfirm)
                .remove();

    }

    public List<AuditFeeSettlementCheck> findByConfirm(String isConfirm) {
        if (StringUtils.isEmpty(isConfirm)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(AuditFeeSettlementCheck::getIsConfirm,isConfirm)
                .list();
    }

    public AuditFeeSettlementCheck findByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(AuditFeeSettlementCheck::getCode,code)
                .one();
    }

    /**
     * 所有单据未确认并且差异未确认的数据
     * @param templateCode
     */
    public List<String> findAllExtConfirm(String templateCode) {
        return this.baseMapper.findAllExtConfirm(templateCode);
    }

    public void removeByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        this.lambdaUpdate()
                .in(AuditFeeSettlementCheck::getCode,codes)
                .remove();
    }

    public List<AuditFeeSettlementCheck> findNotConfirmedByKeyList(List<String> keyList) {
        if (CollectionUtils.isEmpty(keyList)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(AuditFeeSettlementCheck::getMd5UniqueKey, keyList)
                .eq(AuditFeeSettlementCheck::getIsConfirm, YesOrNoEnum.NO.getCode())
                .eq(AuditFeeSettlementCheck::getDiffStatus, AuditStateEnum.WAIT_CONFIRM.getCode())
                .list();
    }
}
