package com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckFee;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckSettlement;
import com.biz.crm.tpm.business.audit.fee.local.mapper.settlement.check.AuditFeeSettlementCheckSettlementMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckSettlementDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckSettlementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 结算核对-结算单
 *
 * @author zy
 * @date 2022-09-25
 */
@Component
public class AuditFeeSettlementCheckSettlementRepository extends ServiceImpl<AuditFeeSettlementCheckSettlementMapper, AuditFeeSettlementCheckSettlement> {

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 根据编码查询
     * @param code
     * @return
     */
    public List<AuditFeeSettlementCheckSettlement> findByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(AuditFeeSettlementCheckSettlement::getCode,code)
                .list();
    }

    public AuditFeeSettlementCheckSettlement findByDetailCode(String settlementDetailCode) {
        LambdaQueryWrapper<AuditFeeSettlementCheckSettlement> query = new LambdaQueryWrapper<>();
        query.eq(AuditFeeSettlementCheckSettlement::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        query.eq(AuditFeeSettlementCheckSettlement::getTenantCode, TenantUtils.getTenantCode());
        query.eq(AuditFeeSettlementCheckSettlement::getSettlementDetailCode, settlementDetailCode);
        query.last("limit 1");
        return this.getOne(query);
    }

    public Page<AuditFeeSettlementCheckSettlementVo> findByConditions(Page<AuditFeeSettlementCheckSettlementVo> page, AuditFeeSettlementCheckSettlementDto dto) {
        return this.baseMapper.findByConditions(page,dto);
    }

    /**
     * 根据code集合删除
     * @param codes
     */
    public void removeByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        this.lambdaUpdate()
                .in(AuditFeeSettlementCheckSettlement::getCode,codes)
                .remove();
    }

    /**
     * 根据code和费用单编码查询
     * @param code
     * @param settlementDetailCodes
     * @return
     */
    public List<AuditFeeSettlementCheckSettlement> findByCodeAndSettlementDetailCodes(String code, List<String> settlementDetailCodes) {
        if (StringUtils.isEmpty(code) || CollectionUtils.isEmpty(settlementDetailCodes)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(AuditFeeSettlementCheckSettlement::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeSettlementCheckSettlement::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeeSettlementCheckSettlement::getCode,code)
                .in(AuditFeeSettlementCheckSettlement::getSettlementDetailCode,settlementDetailCodes)
                .list();
    }

    public List<String> findSettlementDetailCodeBySettlementDetailCodes(List<String> settlementDetailCodes) {
        if (CollectionUtils.isEmpty(settlementDetailCodes)) {
            return new ArrayList<>(0);
        }
        List<AuditFeeSettlementCheckSettlement> list = this.lambdaQuery()
            .select(AuditFeeSettlementCheckSettlement::getSettlementDetailCode)
            .eq(AuditFeeSettlementCheckSettlement::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeSettlementCheckSettlement::getTenantCode, TenantUtils.getTenantCode())
            .in(AuditFeeSettlementCheckSettlement::getSettlementDetailCode, settlementDetailCodes)
            .list();
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>(0);
        }
        return list.stream().map(AuditFeeSettlementCheckSettlement::getSettlementDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<String> findSettlementDetailCodeByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<>(0);
        }
        List<AuditFeeSettlementCheckSettlement> list = this.lambdaQuery()
            .select(AuditFeeSettlementCheckSettlement::getSettlementDetailCode)
            .eq(AuditFeeSettlementCheckSettlement::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeSettlementCheckSettlement::getTenantCode, TenantUtils.getTenantCode())
            .in(AuditFeeSettlementCheckSettlement::getCode, codes)
            .list();
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>(0);
        }
        return list.stream().map(AuditFeeSettlementCheckSettlement::getSettlementDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<AuditFeeSettlementCheckSettlementDto> findAllByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return Lists.newArrayList();
        }
        List<AuditFeeSettlementCheckSettlement> list = this.lambdaQuery()
                .eq(AuditFeeSettlementCheckSettlement::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeSettlementCheckSettlement::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeeSettlementCheckSettlement::getCode,code)
                .list();
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List<AuditFeeSettlementCheckSettlementDto>) this.nebulaToolkitService.copyCollectionByWhiteList(list,AuditFeeSettlementCheckSettlement.class,AuditFeeSettlementCheckSettlementDto.class, HashSet.class, ArrayList.class);
    }

    public AuditFeeSettlementCheckSettlement findFirstByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        AuditFeeSettlementCheckSettlement settlement = this.baseMapper.findFirstByCode(code);
        return settlement;
    }
}
