package com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check;

import com.alibaba.excel.util.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckUpdateMatched;
import com.biz.crm.tpm.business.audit.fee.local.mapper.settlement.check.AuditFeeSettlementCheckUpdateMatchedMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/11/26
 */
@Component
public class AuditFeeSettlementCheckUpdateMatchedRepository extends ServiceImpl<AuditFeeSettlementCheckUpdateMatchedMapper, AuditFeeSettlementCheckUpdateMatched> {

    public Page<AuditFeeSettlementCheckUpdateMatched> findByCondition(PageRequest pageable, String date) {
        date = Optional.ofNullable(date).orElse(DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH_DAY));
        Page<InvoiceExpenseSheetDto> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.baseMapper.findByCondition(page,date, TenantUtils.getTenantCode());
    }

    public void deleteMatchedData(String date) {
        this.lambdaUpdate()
                .eq(AuditFeeSettlementCheckUpdateMatched::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeSettlementCheckUpdateMatched::getTenantCode,TenantUtils.getTenantCode())
                .le(AuditFeeSettlementCheckUpdateMatched::getCreateTime,date)
                .remove();
    }
}
