package com.biz.crm.tpm.business.audit.fee.local.repository.track;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrackDetailExtend;
import com.biz.crm.tpm.business.audit.fee.local.mapper.track.AuditFeeDiffTrackDetailExtendMapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

/**
 * 核销费用核对关联差异费用(repository)
 *
 * @author makejava
 * @date 2022-11-14 17:32:57
 */
@Component
public class AuditFeeDiffTrackDetailExtendRepository extends ServiceImpl<AuditFeeDiffTrackDetailExtendMapper, AuditFeeDiffTrackDetailExtend> {

    public AuditFeeDiffTrackDetailExtend findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditFeeDiffTrackDetailExtend> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) return new ArrayList<>(0);
        ArrayList<AuditFeeDiffTrackDetailExtend> auditFeeDiffTrackDetailList = new ArrayList<>();
        for (String id : ids) {
            AuditFeeDiffTrackDetailExtend byId = this.findById(id);
            auditFeeDiffTrackDetailList.add(byId);
        }
        return auditFeeDiffTrackDetailList;
    }

}
