package com.biz.crm.tpm.business.audit.fee.local.repository.track;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrackDetailLedger;
import com.biz.crm.tpm.business.audit.fee.local.mapper.track.AuditFeeDiffTrackDetailLedgerMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

/**
 * 核销费用核对关联差异费用(repository)
 *
 * @author makejava
 * @date 2022-11-14 17:32:57
 */
@Component
public class AuditFeeDiffTrackDetailLedgerRepository extends ServiceImpl<AuditFeeDiffTrackDetailLedgerMapper, AuditFeeDiffTrackDetailLedger> {

  public List<AuditFeeDiffTrackDetailLedger> findByDetailCodeList(List<String> detailCodeList) {
    if (CollectionUtils.isEmpty(detailCodeList)) return new ArrayList<>(0);
    return this.lambdaQuery()
        .eq(AuditFeeDiffTrackDetailLedger::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(AuditFeeDiffTrackDetailLedger::getTenantCode, TenantUtils.getTenantCode())
        .in(AuditFeeDiffTrackDetailLedger::getDetailCode, detailCodeList)
        .list();
  }

  public List<AuditFeeDiffTrackDetailLedger> findByPlanCodeList(List<String> planCodeList) {
    if (CollectionUtils.isEmpty(planCodeList)) return new ArrayList<>(0);
    return this.lambdaQuery()
        .eq(AuditFeeDiffTrackDetailLedger::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(AuditFeeDiffTrackDetailLedger::getTenantCode, TenantUtils.getTenantCode())
        .in(AuditFeeDiffTrackDetailLedger::getPlanCode, planCodeList)
        .list();
  }

  public void removeBatchByPlanCodeList(List<String> planCodeList) {
    if (CollectionUtils.isNotEmpty(planCodeList)) {
      this.lambdaUpdate()
          .set(AuditFeeDiffTrackDetailLedger::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
          .eq(AuditFeeDiffTrackDetailLedger::getTenantCode, TenantUtils.getTenantCode())
          .in(AuditFeeDiffTrackDetailLedger::getPlanCode, planCodeList)
          .update();
    }
  }
}
