package com.biz.crm.tpm.business.audit.fee.local.repository.track;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrackDetail;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrackDetailExtend;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrackDetailLedger;
import com.biz.crm.tpm.business.audit.fee.local.mapper.track.AuditFeeDiffTrackDetailMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailLedgerVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 核销费用核对关联差异费用(repository)
 *
 * @author makejava
 * @date 2022-11-14 17:32:57
 */
@Component
public class AuditFeeDiffTrackDetailRepository extends ServiceImpl<AuditFeeDiffTrackDetailMapper, AuditFeeDiffTrackDetail> {
    @Autowired
    private AuditFeeDiffTrackDetailExtendRepository auditFeeDiffTrackDetailExtendRepository;
    @Autowired
    private AuditFeeDiffTrackDetailLedgerRepository auditFeeDiffTrackDetailLedgerRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditFeeDiffTrackDetailVo> findByConditions(Page<AuditFeeDiffTrackDetailVo> page, AuditFeeDiffTrackDetailDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditFeeDiffTrackDetail findById(String id) {
        AuditFeeDiffTrackDetail auditFeeDiffTrackDetail = this.baseMapper.selectById(id);
        if (auditFeeDiffTrackDetail == null) return null;
        AuditFeeDiffTrackDetailExtend extend = auditFeeDiffTrackDetailExtendRepository.findById(auditFeeDiffTrackDetail.getId());
        if (extend == null) return auditFeeDiffTrackDetail;
        BeanUtils.copyProperties(extend, auditFeeDiffTrackDetail);
        return auditFeeDiffTrackDetail;
    }

    public List<AuditFeeDiffTrackDetailVo> findByPlanCodeList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) return new ArrayList<>();
        List<AuditFeeDiffTrackDetailVo> detailPLanList = this.baseMapper.findByPlanCodeList(planCodeList);
        // 补充差异台账数据
        List<AuditFeeDiffTrackDetailLedger> diffList = auditFeeDiffTrackDetailLedgerRepository.findByPlanCodeList(planCodeList);
        if (CollectionUtils.isNotEmpty(diffList)) {
            Collection<AuditFeeDiffTrackDetailLedgerVo> diffVoList = nebulaToolkitService.copyCollectionByBlankList(diffList, AuditFeeDiffTrackDetailLedger.class, AuditFeeDiffTrackDetailLedgerVo.class, HashSet.class, ArrayList.class);
            Map<String, List<AuditFeeDiffTrackDetailLedgerVo>> detailCodeDiffMap = diffVoList.stream().collect(Collectors.groupingBy(AuditFeeDiffTrackDetailLedgerVo::getDetailCode));
            for (AuditFeeDiffTrackDetailVo vo : detailPLanList) {
                vo.setAuditFeeDiffTrackDetailLedgerList(detailCodeDiffMap.get(vo.getDetailCode()));
            }
        }
        return detailPLanList;
    }

    public void createBatch(List<AuditFeeDiffTrackDetailDto> detailDtoList) {
        if (CollectionUtils.isEmpty(detailDtoList)) return;
        for (AuditFeeDiffTrackDetailDto dto : detailDtoList) {
            AuditFeeDiffTrackDetail auditFeeDiffTrackDetail = nebulaToolkitService.copyObjectByWhiteList(dto, AuditFeeDiffTrackDetail.class, HashSet.class, ArrayList.class);
            auditFeeDiffTrackDetail.setIsClose(BooleanEnum.FALSE.getCapital());
            auditFeeDiffTrackDetail.setCowManagerState(InterfacePushStateEnum.NOT_PUSH.getCode());
            this.initInfo(auditFeeDiffTrackDetail);
            if (auditFeeDiffTrackDetail.getDetailCode() == null) {
                auditFeeDiffTrackDetail.setDetailCode(generateCodeService.generateCode(AuditFeeConstants.AUDIT_FEE_DIFF_TRACK_DETAIL_CODE, 1).get(0));
            }

            // 本地差异费用台账
            List<AuditFeeDiffTrackDetailLedgerDto> diffList = dto.getAuditFeeDiffTrackDetailLedgerList();
            BigDecimal salesAmount = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(diffList)) {
                for (AuditFeeDiffTrackDetailLedgerDto diffDto : diffList) {
                    Validate.notNull(diffDto.getUsedAmount(),"差异费用使用金额为空");
                    AuditFeeDiffTrackDetailLedger diffTrackDetailLedger = nebulaToolkitService.copyObjectByWhiteList(diffDto, AuditFeeDiffTrackDetailLedger.class, HashSet.class, ArrayList.class);
                    this.initInfo(diffTrackDetailLedger);
                    diffTrackDetailLedger.setDetailCode(auditFeeDiffTrackDetail.getDetailCode());
                    diffTrackDetailLedger.setPlanCode(auditFeeDiffTrackDetail.getPlanCode());
                    auditFeeDiffTrackDetailLedgerRepository.save(diffTrackDetailLedger);
                    salesAmount = salesAmount.add(diffTrackDetailLedger.getUsedAmount());
                }
            }
            auditFeeDiffTrackDetail.setSalesAmount(salesAmount);
            this.save(auditFeeDiffTrackDetail);
            // extend info
            AuditFeeDiffTrackDetailExtend extend = nebulaToolkitService.copyObjectByWhiteList(dto, AuditFeeDiffTrackDetailExtend.class, HashSet.class, ArrayList.class);
            extend.setId(auditFeeDiffTrackDetail.getId());
            auditFeeDiffTrackDetailExtendRepository.save(extend);
        }
    }

    public void removeBatchByPlanCodeList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) return;
        this.lambdaUpdate()
            .set(AuditFeeDiffTrackDetail::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
            .eq(AuditFeeDiffTrackDetail::getTenantCode, TenantUtils.getTenantCode())
            .in(AuditFeeDiffTrackDetail::getPlanCode, planCodeList)
            .update();

        // 移除detail关联的本地差异台账数据
        auditFeeDiffTrackDetailLedgerRepository.removeBatchByPlanCodeList(planCodeList);
    }

    public List<AuditFeeDiffTrackDetailVo> findByTemplateConfigCodeList(List<String> templateConfigCodeList) {
        if (CollectionUtils.isEmpty(templateConfigCodeList)) return new ArrayList<>();
        return this.baseMapper.findByTemplateConfigCodeList(templateConfigCodeList);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditFeeDiffTrackDetail> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) return new ArrayList<>(0);
        ArrayList<AuditFeeDiffTrackDetail> auditFeeDiffTrackDetailList = new ArrayList<>();
        for (String id : ids) {
            AuditFeeDiffTrackDetail byId = this.findById(id);
            auditFeeDiffTrackDetailList.add(byId);
        }
        return auditFeeDiffTrackDetailList;
    }

    private void initInfo(TenantFlagOpEntity entity){
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setId(UUID.randomUUID().toString().replace("-", ""));
    }

    public Page<AuditFeeDiffTrackDetailVo> auditFindByConditions(Page<AuditFeeDiffTrackDetailVo> page, AuditFeeDiffTrackDetailDto dto) {
        return this.baseMapper.auditFindByConditions(page, dto);
    }



    /**
     * 更新推送牛人管家成功的明细状态
     * @param successCodes 明细编码集合
     */
    public void updateDetailPlanCowManagerState(List<String> successCodes) {
        if(org.springframework.util.CollectionUtils.isEmpty(successCodes)){
            return;
        }

    }

    public void updateAlreadyAuditAmountByValidationPass(List<AuditFeeDiffTrackDetailDto> updateList) {
        if (CollectionUtils.isEmpty(updateList)) {
            return;
        }
        this.baseMapper.updateAlreadyAuditAmountByValidationPass(updateList,TenantUtils.getTenantCode());
    }

    public List<AuditFeeDiffTrackDetailVo> findByDetailCodes(List<String> detailCodes){
        return this.baseMapper.findByDetailCodes(detailCodes, TenantUtils.getTenantCode());
    }

    public List<String> findEndCastFormByDetailCodes(List<String> detailCodes) {
        return this.baseMapper.findEndCastFormByDetailCodes(detailCodes,TenantUtils.getTenantCode());
    }

    public List<AuditFeeDiffTrackDetailVo> pushCowManagerManual() {
        return this.baseMapper.findNeedBePushCowManagerButNot(TenantUtils.getTenantCode());
    }
}
