package com.biz.crm.tpm.business.audit.fee.local.repository.track;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrack;
import com.biz.crm.tpm.business.audit.fee.local.mapper.track.AuditFeeDiffTrackMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 核销费用核对关联差异费用(repository)
 *
 * @author makejava
 * @date 2022-11-14 17:32:57
 */
@Component
public class AuditFeeDiffTrackRepository extends ServiceImpl<AuditFeeDiffTrackMapper, AuditFeeDiffTrack> {

    public Page<AuditFeeDiffTrackVo> findByConditions(Page<AuditFeeDiffTrackVo> page, AuditFeeDiffTrackDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditFeeDiffTrack findById(String id) {
        return this.baseMapper.selectById(id);
    }

    public List<AuditFeeDiffTrack> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditFeeDiffTrack::getId, ids).list();
    }

    public AuditFeeDiffTrack findByPlanCode(String planCode) {
        if (planCode == null) return null;
        return lambdaQuery()
            .eq(AuditFeeDiffTrack::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFeeDiffTrack::getTenantCode, TenantUtils.getTenantCode())
            .eq(AuditFeeDiffTrack::getPlanCode, planCode)
            .last("limit 1")
            .one();
    }

    public void updateProcessStatusAndProcessNo(List<String> codeList, String processStatus, String processNo) {
        if (CollectionUtils.isEmpty(codeList)) {
            return;
        }
        this.update(Wrappers.lambdaUpdate(AuditFeeDiffTrack.class)
            .set(AuditFeeDiffTrack::getProcessStatus, processStatus)
            .set(AuditFeeDiffTrack::getProcessNo, processNo)
            .in(AuditFeeDiffTrack::getPlanCode, codeList)
            .eq(AuditFeeDiffTrack::getTenantCode, TenantUtils.getTenantCode())
        );
    }

    public void updateProcessStatus(List<String> codeList, String processStatus) {
        if (CollectionUtils.isEmpty(codeList)) {
            return;
        }
        this.update(Wrappers.lambdaUpdate(AuditFeeDiffTrack.class)
            .set(AuditFeeDiffTrack::getProcessStatus, processStatus)
            .in(AuditFeeDiffTrack::getPlanCode, codeList)
            .eq(AuditFeeDiffTrack::getTenantCode, TenantUtils.getTenantCode())
        );
    }

    public void initInfo(TenantFlagOpEntity entity){
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setId(UUID.randomUUID().toString().replace("-", ""));
    }

    public AuditFeeDiffTrack findByProcessNo(String processNo) {
        return this.lambdaQuery()
                .eq(AuditFeeDiffTrack::getTenantCode,TenantUtils.getTenantCode())
                .eq(AuditFeeDiffTrack::getProcessNo,processNo)
                .one();
    }
}
