package com.biz.crm.tpm.business.audit.fee.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import org.springframework.data.domain.Pageable;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/5/29
 */
public interface AuditFeeCheckPosService {

    /**
     * 更新数据
     *
     * @param dto
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-10-05 19:42
     */
    void update(AuditFeeCheckPosDto dto);


    /**
     * 活动明细分页
     *
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-10-05 23:04
     */
    Page<ActivityDetailPlanItemVo> findActivityDetailPlanItemPage(Pageable pageable, ActivityDetailPlanItemDto dto);

    /**
     * 分子活动明细分页
     *
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-10-05 23:04
     */
    Page<SubComActivityDetailPlanItemVo> findSubComActivityDetailPlanItemPage(Pageable pageable, SubComActivityDetailPlanItemDto dto);
}
