package com.biz.crm.tpm.business.audit.fee.local.service;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.prediction.AuditFeePredictionVoService;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditPassEventDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AutoAuditDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditPassEventListener;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

/**
 * @Description
 * @Author zhouYang
 * @Date 2023/10/9
 */
@Slf4j
@Component
public class AuditPassEventListenerImpl implements AuditPassEventListener {

    @Autowired
    private AuditFeePredictionVoService auditFeePredictionVoService;

    /**
     * 活动细案核销后事件
     * @param dto
     */
    @Override
    public void onUpdateAuditInfo(AuditPassEventDto dto) {
        log.info("活动细案核销后事件参数：{}", JSONObject.toJSONString(dto));
        if (Objects.isNull(dto) || CollectionUtils.isEmpty(dto.getAuditUpdateDataList())) {
            return;
        }
        List<AuditFeePredictionDto> dtos = Lists.newArrayList();
        dto.getAuditUpdateDataList().forEach(e -> {
            AuditFeePredictionDto predictionDto = new AuditFeePredictionDto();
            predictionDto.setWholeAudit(e.getWholeAudit());
            predictionDto.setAlreadyAuditAmount(e.getThisAuditAmount());
            predictionDto.setDetailPlanItemCode(e.getActivityDetailCode());
            dtos.add(predictionDto);
        });
        this.auditFeePredictionVoService.updateWholeAudit(dtos);
    }
}
