package com.biz.crm.tpm.business.audit.fee.local.service.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditCheckDetailExportsDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchResultEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchStatusEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditCheckDetailExportsVo;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.base.CaseFormat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @ClassName AuditCheckDetailExportProcess
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/3/22 15:42
 **/
@Component
public class AuditCheckDetailExportProcess implements ExportProcess<AuditCheckDetailExportsVo> {

    @Autowired(required = false)
    private AuditFeeCheckMapper auditFeeCheckMapper;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private RedisService redisService;

    private static final String CACHE_KEY = "tpm:AuditCheckDetailExportProcess:";
    private static final String SOURCE_TYPE = "source_type";
    private static final String DETAIL_PLAN = "detail_plan";
    private static final String COST = "cost";
    private static final String DIFF = "diff";

    @Override
    public Integer getTotal(Map<String, Object> params) {
        AuditCheckDetailExportsDto dto = this.transferParamToDto(params);
        Integer total = this.getTotalTotal(dto);
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    private Integer getTotalTotal(AuditCheckDetailExportsDto dto) {
        Integer detailPlanTotal = this.auditFeeCheckMapper.getTotal(dto, "1");
        Integer costTotal = this.auditFeeCheckMapper.getTotal(dto, "2");
        return detailPlanTotal + costTotal;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        AuditCheckDetailExportsDto dto = this.transferParamToDto(params);
        dto.setOffset(vo.getPageNo() * this.getPageSize());
        dto.setLimit(this.getPageSize());
        List<AuditCheckDetailExportsVo> data = this.findDataAll(vo, dto);
        this.codeToDesc(data);
        return JSON.parseArray(JSON.toJSONString(data));
    }

    /**
     * 按固定顺序依次查3张明细表
     *
     * @param vo
     * @param dto
     * @return
     */
    public List<AuditCheckDetailExportsVo> findDataAll(ExportTaskProcessVo vo, AuditCheckDetailExportsDto dto) {
        Integer limit = dto.getLimit();
        List<AuditCheckDetailExportsVo> result = new ArrayList<>();
        String key = CACHE_KEY + vo.getTaskCode() + ":" + SOURCE_TYPE;
        Object sourceType = redisService.get(key);
        //1、
        if (Objects.isNull(sourceType) || DETAIL_PLAN.equals(sourceType.toString())) {
            AuditCheckDetailExportsDto pageDto = this.getCachePage(vo, dto, DETAIL_PLAN, 0);
            List<AuditCheckDetailExportsVo> detailPlanVos = this.auditFeeCheckMapper.findData(pageDto, "1");
            this.buildCachePage(vo, dto, DETAIL_PLAN, detailPlanVos.size());
            result.addAll(detailPlanVos);
        }
        if (result.size() == limit) {
            redisService.set(key, DETAIL_PLAN, 60 * 60 * 6);
            return result;
        }

        //2、
        if (Objects.isNull(sourceType) || COST.equals(sourceType.toString())) {
            AuditCheckDetailExportsDto pageDto = this.getCachePage(vo, dto, COST, result.size());
            List<AuditCheckDetailExportsVo> costVos = this.auditFeeCheckMapper.findData(pageDto, "2");
            this.buildCachePage(vo, dto, COST, costVos.size());
            result.addAll(costVos);
        }
        if (result.size() == limit) {
            redisService.set(key, COST, 60 * 60 * 6);
            return result;
        }

        //3、
//        if (Objects.isNull(sourceType) || DIFF.equals(sourceType.toString())) {
//            AuditCheckDetailExportsDto pageDto = this.getCachePage(vo, dto, DIFF, result.size());
//            List<AuditCheckDetailExportsVo> diffVos = this.auditFeeCheckMapper.findData(pageDto, "3");
//            this.buildCachePage(vo, dto, DIFF, diffVos.size());
//            result.addAll(diffVos);
//        }
//        if (result.size() == limit) {
//            redisService.set(key, DIFF, 60 * 60 * 6);
//            return result;
//        }

        //3、
//        if (Objects.isNull(sourceType) || STATEMENT.equals(sourceType.toString())) {
//            AuditCheckDetailExportsDto pageDto = this.getCachePage(vo, dto, STATEMENT, result.size());
//            List<AuditCheckDetailExportsVo> statementVos = this.auditFeeCheckMapper.findData(pageDto, "3");
//            this.buildCachePage(vo, dto, STATEMENT, statementVos.size());
//            result.addAll(statementVos);
//        }
//        if (result.size() == limit) {
//            redisService.set(key, STATEMENT, 60 * 60 * 6);
//            return result;
//        }
        redisService.del(key);
        return result;
    }

    /**
     * 获取分页缓存
     *
     * @param vo
     * @param dto
     * @param sourceType 明细表类型
     * @param offset     limit偏移量
     * @return
     */
    private AuditCheckDetailExportsDto getCachePage(ExportTaskProcessVo vo, AuditCheckDetailExportsDto dto, String sourceType, Integer offset) {
        String key = CACHE_KEY + vo.getTaskCode() + ":" + sourceType;
        Object o = redisService.get(key);
        if (Objects.isNull(o)) {
            dto.setLimit(dto.getLimit() - offset);
            return dto;
        }
        return JSONObject.parseObject(o.toString(), AuditCheckDetailExportsDto.class);
    }

    /**
     * 查询偏移量处理
     *
     * @param vo
     * @param dto
     * @param sourceType 明细表类型
     * @param currSize   本次查询数量
     */
    private void buildCachePage(ExportTaskProcessVo vo, AuditCheckDetailExportsDto dto, String sourceType, Integer currSize) {
        String key = CACHE_KEY + vo.getTaskCode() + ":" + sourceType;
        AuditCheckDetailExportsDto cacheVo = new AuditCheckDetailExportsDto();
        BeanUtils.copyProperties(dto, cacheVo);
        cacheVo.setOffset(dto.getOffset() + currSize);
        redisService.set(key, JSONObject.toJSONString(cacheVo), 60 * 60 * 6);
    }

    @Override
    public String getBusinessCode() {
        return "TPM_AUDIT_FEE_DETAIL_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "费用核对明细导出";
    }

    @Override
    public Class<AuditCheckDetailExportsVo> findCrmExcelVoClass() {
        return AuditCheckDetailExportsVo.class;
    }

    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    /**
     * 将参数转换为对象
     *
     * @param params
     * @return
     */
    public AuditCheckDetailExportsDto transferParamToDto(Map<String, Object> params) {
        Map<String, Object> lowerCamelParamMap = new HashMap<>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String param = entry.getKey();
            if (!param.contains("_")) {
                continue;
            }
            String lowerCamelParam = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, param.substring(0, param.lastIndexOf("_")));
            lowerCamelParamMap.put(lowerCamelParam, entry.getValue());
        }
        AuditCheckDetailExportsDto dto = JSONObject.parseObject(JSON.toJSONString(lowerCamelParamMap), AuditCheckDetailExportsDto.class);
        dto.setTenantCode(TenantUtils.getTenantCode());
        return dto;
    }

    /**
     * 字典类型编码转描述
     *
     * @param data
     */
    public void codeToDesc(List<AuditCheckDetailExportsVo> data) {

        //业态
        Map<String, String> formatDictMap = dictToolkitService.findMapByDictTypeCode(AuditFeeConstants.MDM_BUSINESS_FORMAT);

        //业务单元
        Map<String, String> unitDictMap = dictToolkitService.findMapByDictTypeCode(AuditFeeConstants.MDM_BUSINESS_UNIT);

        //模板类型
        Map<String, String> templateTypeDictMap = dictToolkitService.findMapByDictTypeCode(AuditFeeConstants.TPM_DEDUCTION_MATCHING_TEMPLATE_TYPE);

        //区域
        Map<String, String> regionDictMap = dictToolkitService.findMapByDictTypeCode(AuditFeeConstants.MDM_CUSTOMIZE_ORG);


        for (AuditCheckDetailExportsVo exportsVo : data) {

            //业态
            if (StringUtils.isNotBlank(formatDictMap.get(exportsVo.getBusinessFormatCode()))) {
                exportsVo.setBusinessFormatCode(formatDictMap.get(exportsVo.getBusinessFormatCode()));
            }

            //业务单元
            if (StringUtils.isNotBlank(unitDictMap.get(exportsVo.getBusinessUnitCode()))) {
                exportsVo.setBusinessUnitCode(unitDictMap.get(exportsVo.getBusinessUnitCode()));
            }

            //匹配状态
            MatchStatusEnum statusEnum = MatchStatusEnum.getEnumByCode(exportsVo.getMatchStatus());
            if (Objects.nonNull(statusEnum)) {
                exportsVo.setMatchStatus(statusEnum.getDesc());
            }

            //匹配结果
            MatchResultEnum resultEnum = MatchResultEnum.getEnumByCode(exportsVo.getMatchResult());
            if (Objects.nonNull(resultEnum)) {
                exportsVo.setMatchResult(resultEnum.getDesc());
            }

            //是否分摊
            if (StringUtils.isNotBlank(exportsVo.getIsShare())) {
                for (BooleanEnum booleanEnum : BooleanEnum.values()) {
                    if (StringUtils.equals(booleanEnum.getCapital(), exportsVo.getIsShare())) {
                        exportsVo.setIsShare(booleanEnum.getSure());
                    }
                }
            }

            //模板类型
            if (StringUtils.isNotBlank(templateTypeDictMap.get(exportsVo.getMatchTemplateType()))) {
                exportsVo.setMatchTemplateType(templateTypeDictMap.get(exportsVo.getMatchTemplateType()));
            }

            //对账年月
            if (Objects.nonNull(exportsVo.getReconciliationDate())) {
                exportsVo.setReconciliationDateStr(DateUtil.dateToStr(exportsVo.getReconciliationDate(), DateUtil.date_yyyy_MM));
            }

            //对账日期
            if (Objects.nonNull(exportsVo.getReconciliationDateTime())) {
                exportsVo.setReconciliationDateTimeStr(DateUtil.dateToStr(exportsVo.getReconciliationDateTime(), DateUtil.date_yyyy_MM_dd));
            }

            //区域
            if (StringUtils.isNotBlank(regionDictMap.get(exportsVo.getAreaCode()))) {
                exportsVo.setAreaCode(regionDictMap.get(exportsVo.getAreaCode()));
            }

            //开始时间
            if (Objects.nonNull(exportsVo.getBeginTime())) {
                exportsVo.setBeginTimeStr(DateUtil.dateToStr(exportsVo.getBeginTime(), DateUtil.date_yyyy_MM_dd_HH_mm_ss));
            }

            //结束时间
            if (Objects.nonNull(exportsVo.getEndTime())) {
                exportsVo.setEndTimeStr(DateUtil.dateToStr(exportsVo.getEndTime(), DateUtil.date_yyyy_MM_dd_HH_mm_ss));
            }

            //单据日期
            if (Objects.nonNull(exportsVo.getDocumentsDate())) {
                exportsVo.setDocumentsDateStr(DateUtil.dateToStr(exportsVo.getDocumentsDate(), DateUtil.date_yyyy_MM_dd_HH_mm_ss));
            }


        }
    }
}
