package com.biz.crm.tpm.business.audit.fee.local.service.exports;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.fee.local.service.exports.vo.AuditFeeCheckCostExportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckCostVoCacheService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 费用核对-费用单导出
 * @author liyang
 * @date 2023/10/18
 */
@Component
@Slf4j
public class AuditFeeCheckCostExportProcess implements ExportProcess<AuditFeeCheckCostExportVo> {

  @Autowired(required = false)
  private AuditFeeCheckCostVoCacheService checkCostVoCacheService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private DictToolkitService dictToolkitService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    log.info("费用核对-费用单导出-getTotal");
    Object cacheKey = params.get("cacheKey");
    Validate.notNull(cacheKey, "未传入cacheKey");
    long total = checkCostVoCacheService.findCacheListSize(String.valueOf(cacheKey));
    Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
    return Math.toIntExact(total);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    log.info("费用核对-费用单导出-getData");
    Object cacheKey = params.get("cacheKey");
    Validate.notNull(cacheKey, "未传入cacheKey");
    List<AuditFeeCheckCostVo> dataList = checkCostVoCacheService.findCacheList(String.valueOf(cacheKey));
    List<AuditFeeCheckCostExportVo> exportVoList = this.adjustData(dataList);
    return this.toJSONArray(exportVoList);
  }

  private List<AuditFeeCheckCostExportVo> adjustData(List<AuditFeeCheckCostVo> dataList) {
    if (CollectionUtils.isEmpty(dataList)) {
      return new ArrayList<>(0);
    }
    List<AuditFeeCheckCostExportVo> exportVoList = (List<AuditFeeCheckCostExportVo>) nebulaToolkitService.copyCollectionByWhiteList(dataList,
        AuditFeeCheckCostVo.class, AuditFeeCheckCostExportVo.class, HashSet.class, ArrayList.class);

    //区域
    Map<String, String> regionDictMap = dictToolkitService.findMapByDictTypeCode(AuditFeeConstants.MDM_CUSTOMIZE_ORG);
    for (AuditFeeCheckCostExportVo exportVo : exportVoList) {
      exportVo.setDeductionAmountTaxStr(String.valueOf(exportVo.getDeductionAmountTax()));
      exportVo.setBusinessAreaStr(regionDictMap.get(exportVo.getBusinessArea()));
    }
    return exportVoList;
  }

  @Override
  public String getBusinessCode() {
    return "TPM_AUDIT_FEE_CHECK_COST_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "费用核对-费用单导出";
  }
}
