package com.biz.crm.tpm.business.audit.fee.local.service.exports;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.fee.local.service.exports.vo.AuditFeeCheckDetailPlanExportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoCacheService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 费用核对-细案导出
 * @author liyang
 * @date 2023/10/18
 */
@Component
@Slf4j
public class AuditFeeCheckDetailPlanExportProcess implements ExportProcess<AuditFeeCheckDetailPlanExportVo> {

  @Autowired(required = false)
  private AuditFeeCheckDetailPlanVoCacheService auditFeeCheckDetailPlanVoCacheService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    log.info("费用核对-细案导出-getTotal");
    Object cacheKey = params.get("cacheKey");
    Validate.notNull(cacheKey, "未传入cacheKey");
    long total = auditFeeCheckDetailPlanVoCacheService.findCacheListSize(String.valueOf(cacheKey));
    Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
    return Math.toIntExact(total);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    log.info("费用核对-细案导出-getData");
    Object cacheKey = params.get("cacheKey");
    Validate.notNull(cacheKey, "未传入cacheKey");
    List<AuditFeeCheckDetailPlanVo> dataList = auditFeeCheckDetailPlanVoCacheService.findCacheList(String.valueOf(cacheKey));
    List<AuditFeeCheckDetailPlanExportVo> exportVoList = this.adjustData(dataList);
    return this.toJSONArray(exportVoList);
  }

  private List<AuditFeeCheckDetailPlanExportVo> adjustData(List<AuditFeeCheckDetailPlanVo> dataList) {
    if (CollectionUtils.isEmpty(dataList)) {
      return new ArrayList<>(0);
    }
    List<AuditFeeCheckDetailPlanExportVo> exportVoList = (List<AuditFeeCheckDetailPlanExportVo>) nebulaToolkitService.copyCollectionByWhiteList(dataList,
        AuditFeeCheckDetailPlanVo.class, AuditFeeCheckDetailPlanExportVo.class, HashSet.class, ArrayList.class);
    for (AuditFeeCheckDetailPlanExportVo exportVo : exportVoList) {
      exportVo.setActivityBeginDateStr(DateUtil.formatDate(exportVo.getActivityBeginDate()));
      exportVo.setActivityEndDateStr(DateUtil.formatDate(exportVo.getActivityEndDate()));
//      exportVo.setActivityYearMonthStr(DateUtil.format(exportVo.getActivityYearMonth(), "yyyy-MM"));

      exportVo.setApplyAmountStr(this.avoidNullToString(exportVo.getApplyAmount()));
      exportVo.setPredictionAuditAmountStr(this.avoidNullToString(exportVo.getPredictionAuditAmount()));
      exportVo.setAlreadyAuditAmountStr(this.avoidNullToString(exportVo.getAlreadyAuditAmount()));
      exportVo.setCanAuditAmountStr(this.avoidNullToString(exportVo.getCanAuditAmount()));
      exportVo.setAuditFeeCheckShareAmountStr(this.avoidNullToString(exportVo.getAuditFeeCheckShareAmount()));
      exportVo.setToBeSupplementedAmountStr(this.avoidNullToString(exportVo.getToBeSupplementedAmount()));
      exportVo.setThisAuditAmountStr(this.avoidNullToString(exportVo.getThisAuditAmount()));
    }
    return exportVoList;
  }

  private String avoidNullToString(Object o) {
    return o == null ? null : String.valueOf(o);
  }

  @Override
  public String getBusinessCode() {
    return "TPM_AUDIT_FEE_CHECK_DETAIL_PLAN_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "费用核对-细案导出";
  }
}
