package com.biz.crm.tpm.business.audit.fee.local.service.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.ie.sdk.process.MnExportProcess;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemModifyVo;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.track.AuditFeeDiffTrackDetailPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @author liyang
 * @date 2023/11/28
 * @description: 差异追踪明细导出-按模板配置
 */
@Component
@Slf4j
public class AuditFeeDiffTrackItemExportByTemplateProcess extends MnExportProcess {

  @Autowired(required = false)
  private AuditFeeDiffTrackDetailVoService diffTrackItemService;


  @Autowired(required = false)
  private AuditFeeDiffTrackDetailPageCacheHelper diffTrackDetailCacheHelper;

  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  /**
   * 活动模板服务
   */
  @Autowired(required = false)
  private ActivitiesTemplateSdkService activitiesTemplateSdkService;

  protected static final ThreadLocal<ActivitiesTemplateConfigVo> templateConfigVoThreadLocal = new ThreadLocal<>();

  @Override
  public Integer getTotal(Map<String, Object> params) {
    Object cacheKeyObj = params.get("cacheKey");
    Validate.notNull(cacheKeyObj, "缓存键，参数未传入");
    String cacheKey = cacheKeyObj.toString();
    Integer total = diffTrackDetailCacheHelper.getTotal(cacheKey);
    Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
        "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
    return total;
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    Object cacheKeyObj = params.get("cacheKey");
    Validate.notNull(cacheKeyObj, "缓存键，参数未传入");
    String cacheKey = cacheKeyObj.toString();
    List<AuditFeeDiffTrackDetailDto> cacheList = diffTrackItemService.findCacheList(cacheKey);
    //调整
    adjustData(cacheKey, cacheList);
    return JSON.parseArray(JSON.toJSONString(cacheList, SerializerFeature.WriteDateUseDateFormat));
  }

  /**
   * 调整数据
   */
  private void adjustData(String cacheKey, Collection<AuditFeeDiffTrackDetailDto> list) {
    if (CollectionUtils.isEmpty(list)){
      return;
    }
    ActivitiesTemplateConfigVo templateConfigVo = templateConfigVoThreadLocal.get();
    // 模板配置字段数据
    List<ActivitiesTemplateConfigDetailVo> dictFieldList = templateConfigVo.getDetails().stream().filter(item -> StringUtil.isNotEmpty(item.getDictCode())).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(dictFieldList)){
      return;
    }
    // 需要的数据字典type
    List<String> dictCodes = dictFieldList.stream().map(ActivitiesTemplateConfigDetailVo::getDictCode).distinct().collect(Collectors.toList());
    Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodes);
    Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue,(o,n)->n)),(o,n)->n));

    // 目标类属性
    PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(AuditFeeDiffTrackDetailDto.class);
    Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));

    // 遍历数据
    for (AuditFeeDiffTrackDetailDto data : list) {
      // 遍历模板配置字段
      for (ActivitiesTemplateConfigDetailVo activitiesTemplateConfigDetailVo : dictFieldList) {
        // 根据模板属性名 获取目标类属性，属性不存在将跳过这个属性
        PropertyDescriptor propertyDescriptor = propertyMap.get(activitiesTemplateConfigDetailVo.getField());
        if (null == propertyDescriptor){
          continue;
        }
        try {
          //
          Object originValue = propertyDescriptor.getReadMethod().invoke(data);
          if (null == originValue){
            continue;
          }
          String originStrValue = originValue.toString();
          Map<String, String> thisDictMap = dictMapMap.get(activitiesTemplateConfigDetailVo.getDictCode());
          propertyDescriptor.getWriteMethod().invoke(data,thisDictMap.getOrDefault(originStrValue,originStrValue));
        } catch (IllegalAccessException | InvocationTargetException e) {
          throw new RuntimeException(e);
        }
      }
    }
  }

  @Override
  public List<List<String>> findHead(ExportTaskProcessVo task, Map<String, Object> paramsMap) {
    Object cacheKeyObj = paramsMap.get("cacheKey");
    Validate.notNull(cacheKeyObj, "缓存键，参数未传入");
    String cacheKey = cacheKeyObj.toString();

    //有策略编码，从数据库里面查出来放到缓存里面
    String[] split = cacheKey.split(":");
    String templateCode = split[split.length-1];//模板编码

    ActivitiesTemplateConfigVo templateConfigVo = activitiesTemplateSdkService.findByCode(templateCode);
    if (null ==  templateConfigVo){
      throw new RuntimeException("活动模板配置["+templateCode+"]查询失败");
    }
    templateConfigVoThreadLocal.set(templateConfigVo);
    List<List<String>> result = Lists.newArrayList();
    for (ActivitiesTemplateConfigDetailVo detail : templateConfigVo.getDetails()) {
      if (null == detail.getVisible() || !detail.getVisible()){
        continue;
      }
      result.add(Lists.newArrayList(detail.getTitle()));
    }
    return result;
  }

  @Override
  public List<String> findCrmExcelColumnField(ExportTaskProcessVo task, Map<String, Object> paramsMap) {
    Object cacheKeyObj = paramsMap.get("cacheKey");
    Validate.notNull(cacheKeyObj, "缓存键，参数未传入");
    String cacheKey = cacheKeyObj.toString();

    ActivitiesTemplateConfigVo templateConfigVo = templateConfigVoThreadLocal.get();

    List<String> list = Lists.newArrayList();
    for (ActivitiesTemplateConfigDetailVo detail : templateConfigVo.getDetails()) {
      if (null == detail.getVisible() || !detail.getVisible()){
        continue;
      }
      list.add(detail.getField());
    }
    return list;
  }

  @Override
  public String getBusinessCode() {
    return "TPM_AUDIT_FEE_DIFF_TRACK_DETAIL_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "TPM-差异费用追踪活动明细导出-按模板配置";
  }
}
