package com.biz.crm.tpm.business.audit.fee.local.service.exports;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckDetailPlanService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDetailPlanExportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.local.constants.AuditConstants;
import com.biz.crm.tpm.business.audit.sdk.constant.AuditConstant;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 结算核对-细案导出
 */
@Slf4j
@Component
public class AuditFeeSettlementCheckDetailPlanExportsProcess implements ExportProcess<AuditFeeSettlementCheckDetailPlanExportVo> {

    @Autowired
    private AuditFeeSettlementCheckDetailPlanService auditFeeSettlementCheckDetailPlanService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DictToolkitService dictToolkitService;

    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        Integer total = this.auditFeeSettlementCheckDetailPlanService.getTotal((String) params.get("cacheKey"));
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        String cacheKey = (String) params.get("cacheKey");
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, this.getPageSize());
        AuditFeeSettlementCheckDetailPlanDto dto = new AuditFeeSettlementCheckDetailPlanDto();
        Page<AuditFeeSettlementCheckDetailPlanVo> cachePage = this.auditFeeSettlementCheckDetailPlanService.findCachePageList(pageable, dto, cacheKey);
        if (cachePage.getTotal() == 0) {
            return new JSONArray();
        }
        List<AuditFeeSettlementCheckDetailPlanExportVo> exportsVos = (List<AuditFeeSettlementCheckDetailPlanExportVo>) nebulaToolkitService.copyCollectionByWhiteList(
                cachePage.getRecords(), AuditFeeSettlementCheckDetailPlanVo.class, AuditFeeSettlementCheckDetailPlanExportVo.class, LinkedHashSet.class, ArrayList.class);
        // 数据转换
        this.buildData(exportsVos);
        //return JSON.parseArray(JSON.toJSONString(exportsVos));
        return toJSONArray(exportsVos);
    }

    private void buildData(Collection<AuditFeeSettlementCheckDetailPlanExportVo> exportsVos) {
        //区域
        Map<String, String> regionDictMap = dictToolkitService.findMapByDictTypeCode(AuditFeeConstants.MDM_CUSTOMIZE_ORG);
        Map<String, String> methodDictMap = dictToolkitService.findMapByDictTypeCode(AuditConstants.PURCHASE_METHOD);
        Map<String, String> auditDictMap = dictToolkitService.findMapByDictTypeCode(AuditConstant.TPM_AUDIT_FORM);
        if (CollectionUtils.isNotEmpty(exportsVos)) {
            exportsVos.forEach(e -> {
                if(Objects.nonNull(e.getActivityBeginDate())) {
                    e.setActivityBeginDateStr(DateUtil.dateStrYYYYMMDD(e.getActivityBeginDate()));
                }
                if(Objects.nonNull(e.getActivityEndDate())) {
                    e.setActivityEndDateStr(DateUtil.dateStrYYYYMMDD(e.getActivityEndDate()));
                }
                if(Objects.nonNull(e.getActivityYearMonth())) {
                    e.setActivityYearMonthStr(DateUtil.formatDate(e.getActivityYearMonth(),DateUtil.DEFAULT_YEAR_MONTH));
                }
                //区域
                if (StringUtils.isNotBlank(regionDictMap.get(e.getRegion()))) {
                    e.setRegion(regionDictMap.get(e.getRegion()));
                }
                //结案形式
                if (StringUtils.isNotBlank(auditDictMap.get(e.getAuditForm()))) {
                    e.setAuditForm(auditDictMap.get(e.getAuditForm()));
                }
                //购买方式
                if (StringUtils.isNotBlank(methodDictMap.get(e.getBuyWay()))) {
                    e.setBuyWay(methodDictMap.get(e.getBuyWay()));
                }
            });
        }
    }

    @Override
    public String getBusinessCode() {
        return "AUDIT_FEE_SETTLEMENT_CHECK_DETAIL_PLAN_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "结算核对-细案导出";
    }
}
