package com.biz.crm.tpm.business.audit.fee.local.service.exports;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckFeeService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckFeeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckFeeExportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckFeeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

/**
 * 结算核对-费用单导出
 */
@Slf4j
@Component
public class AuditFeeSettlementCheckFeeExportsProcess implements ExportProcess<AuditFeeSettlementCheckFeeExportVo> {

    @Autowired
    private AuditFeeSettlementCheckFeeService auditFeeSettlementCheckFeeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DictToolkitService dictToolkitService;

    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        Integer total = this.auditFeeSettlementCheckFeeService.getTotal((String) params.get("cacheKey"));
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        String cacheKey = (String) params.get("cacheKey");
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, this.getPageSize());
        AuditFeeSettlementCheckFeeDto dto = new AuditFeeSettlementCheckFeeDto();
        Page<AuditFeeSettlementCheckFeeVo> cachePage = this.auditFeeSettlementCheckFeeService.findCachePageList(pageable, dto, cacheKey);
        if (cachePage.getTotal() == 0) {
            return new JSONArray();
        }
        Collection<AuditFeeSettlementCheckFeeExportVo> exportsVos = nebulaToolkitService.copyCollectionByWhiteList(
                cachePage.getRecords(), AuditFeeSettlementCheckFeeVo.class, AuditFeeSettlementCheckFeeExportVo.class, LinkedHashSet.class, ArrayList.class);
        // 数据转换
        this.buildData(exportsVos);
        return JSON.parseArray(JSON.toJSONString(exportsVos));
    }

    private void buildData(Collection<AuditFeeSettlementCheckFeeExportVo> exportsVos) {
        //区域
        Map<String, String> regionDictMap = dictToolkitService.findMapByDictTypeCode(AuditFeeConstants.MDM_CUSTOMIZE_ORG);

        if (CollectionUtils.isNotEmpty(exportsVos)) {
            exportsVos.forEach(e -> {
                //区域
                if (StringUtils.isNotBlank(regionDictMap.get(e.getBusinessArea()))) {
                    e.setBusinessArea(regionDictMap.get(e.getBusinessArea()));
                }
            });
        }
    }

    @Override
    public String getBusinessCode() {
        return "AUDIT_FEE_SETTLEMENT_CHECK_FEE_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "结算核对-费用单导出";
    }
}
