package com.biz.crm.tpm.business.audit.fee.local.service.exports;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckSettlementService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.auditFeeVerifyDecide.AuditFeeVerifyDecideDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckSettlementDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckSettlementExportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckSettlementVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditListExportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

/**
 * 结算核对-结算单导出
 * @author zy
 */
@Slf4j
@Component
public class AuditFeeSettlementCheckSettlementExportsProcess implements ExportProcess<AuditFeeSettlementCheckSettlementExportVo> {

    @Autowired
    private AuditFeeSettlementCheckSettlementService settlementService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DictToolkitService dictToolkitService;

    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        Integer total = settlementService.getTotal((String) params.get("cacheKey"));
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        String cacheKey = (String) params.get("cacheKey");
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, this.getPageSize());
        AuditFeeSettlementCheckSettlementDto dto = new AuditFeeSettlementCheckSettlementDto();
        Page<AuditFeeSettlementCheckSettlementVo> cachePage = settlementService.findCachePageList(pageable, dto, cacheKey);
        if (cachePage.getTotal() == 0) {
            return new JSONArray();
        }
        Collection<AuditFeeSettlementCheckSettlementExportVo> exportsVos = nebulaToolkitService.copyCollectionByWhiteList(
                cachePage.getRecords(), AuditFeeSettlementCheckSettlementVo.class, AuditFeeSettlementCheckSettlementExportVo.class, LinkedHashSet.class, ArrayList.class);
        // 数据转换
        this.buildDate(exportsVos);
        return JSON.parseArray(JSON.toJSONString(exportsVos));
    }

    private void buildDate(Collection<AuditFeeSettlementCheckSettlementExportVo> exportsVos) {
        //区域
        Map<String, String> regionDictMap = dictToolkitService.findMapByDictTypeCode(AuditFeeConstants.MDM_CUSTOMIZE_ORG);

        if (CollectionUtils.isNotEmpty(exportsVos)) {
            exportsVos.forEach(e -> {
                //区域
                if (StringUtils.isNotBlank(regionDictMap.get(e.getBusinessArea()))) {
                    e.setBusinessArea(regionDictMap.get(e.getBusinessArea()));
                }
            });
        }
    }

    @Override
    public String getBusinessCode() {
        return "AUDIT_FEE_SETTLEMENT_CHECK_SETTLEMENT_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "结算核对-结算单导出";
    }
}
