package com.biz.crm.tpm.business.audit.fee.local.service.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckDetailPlanMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.auditFeeVerifyDecide.AuditFeeVerifyDecideDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditCheckDetailExportsDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.auditFeeVerifyDecide.AuditFeeVerifyDecideExportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.auditFeeVerifyDecide.AuditFeeVerifyDecideVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.base.CaseFormat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

import static com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants.MDM_BUSINESS_FORMAT;
import static com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants.MDM_BUSINESS_UNIT;
import static com.biz.crm.tpm.business.examine.circular.sdk.constant.TpmExamineCircularConstant.MDM_CUSTOMIZE_ORG;

/**
 * @ClassName AuditFeeVerifyDecideExportProcess
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/3/29 16:05
 **/
@Component
@Slf4j
public class AuditFeeVerifyDecideExportProcess implements ExportProcess<AuditFeeVerifyDecideExportVo> {

    @Resource
    private AuditFeeCheckDetailPlanMapper auditFeeCheckDetailPlanMapper;

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    @Resource
    private DictDataVoService dictDataVoService;


    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        AuditFeeVerifyDecideDto dto = this.transferParamToDto(params);
        Integer total = this.auditFeeCheckDetailPlanMapper.findAuditFeeVerifyDecideExportTotal(dto);
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        AuditFeeVerifyDecideDto dto = this.transferParamToDto(params);
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, this.getPageSize());
        Page<AuditFeeVerifyDecideVo> page = new Page<>(pageable.getPageNumber(),pageable.getPageSize());
        Page<AuditFeeVerifyDecideVo> result = this.auditFeeCheckDetailPlanMapper.findAuditFeeVerifyDecideByConditionsNew(page,dto);
        Collection<AuditFeeVerifyDecideExportVo> exportVos = this.nebulaToolkitService.copyCollectionByWhiteList(result.getRecords(), AuditFeeVerifyDecideVo.class, AuditFeeVerifyDecideExportVo.class, HashSet.class, ArrayList.class);
        this.codeToDesc(new ArrayList<>(exportVos));
        return JSONArray.parseArray(JSON.toJSONString(exportVos));
    }

    @Override
    public String getBusinessCode() {
        return "TPM_AUDIT_FEE_VERIFY_DECIDE_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "扣费核定表导出";
    }

    @Override
    public Class<AuditFeeVerifyDecideExportVo> findCrmExcelVoClass(){
        return AuditFeeVerifyDecideExportVo.class;
    }

    /**
     * Map参数转查询对象
     * @param params
     * @return
     */
    public AuditFeeVerifyDecideDto transferParamToDto(Map<String, Object> params){
        Map<String,Object> lowerCamelParamMap = new HashMap<>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String param = entry.getKey();
            if (!param.contains("_")){
                continue;
            }
            String lowerCamelParam = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, param.substring(0,param.lastIndexOf("_")));
            lowerCamelParamMap.put(lowerCamelParam,entry.getValue());
        }
        AuditFeeVerifyDecideDto dto = JSONObject.parseObject(JSON.toJSONString(lowerCamelParamMap), AuditFeeVerifyDecideDto.class);
        dto.setTenantCode(TenantUtils.getTenantCode());
        return dto;
    }

    /**
     * 编码转名称
     * @param exportVos
     */
    public void codeToDesc(List<AuditFeeVerifyDecideExportVo> exportVos){

        //业态
        List<DictDataVo> businessUnitDict = dictDataVoService.findByDictTypeCode(MDM_BUSINESS_UNIT);
        Map<String, String> businessUnitDictMap = businessUnitDict.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));

        //业务单元
        List<DictDataVo> businessFormatDict = dictDataVoService.findByDictTypeCode(MDM_BUSINESS_FORMAT);
        Map<String, String> businessFormatDictMap = businessFormatDict.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));

        //区域
        List<DictDataVo> regionDictType = dictDataVoService.findByDictTypeCode(MDM_CUSTOMIZE_ORG);
        Map<String, String> regionMap = regionDictType.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));

        for (AuditFeeVerifyDecideExportVo exportVo : exportVos) {

            //业态
            if (StringUtils.isNotBlank(exportVo.getBusinessFormatCode())){
                exportVo.setBusinessFormatName(businessFormatDictMap.get(exportVo.getBusinessFormatCode()));
            }

            //业务单元
            if (StringUtils.isNotBlank(exportVo.getBusinessUnitCode())){
                exportVo.setBusinessUnitName(businessUnitDictMap.get(exportVo.getBusinessUnitCode()));
            }

            //区域
            if(StringUtils.isNotBlank(exportVo.getActivityOrgCode())){
                exportVo.setActivityOrgName(regionMap.get(exportVo.getActivityOrgCode()));
            }

        }
    }

}
