package com.biz.crm.tpm.business.audit.fee.local.service.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Getter;
import lombok.Setter;

/**
 * 费用核对费用单导出Vo
 * @author liyang
 * @date 2023/10/18
 */
@ApiModel(value = "AuditFeeCheckCostExportVo",description = "费用核对-费用单导出Vo")
@Getter
@Setter
@CrmExcelExport
public class AuditFeeCheckCostExportVo extends CrmExcelVo {

  @CrmExcelColumn("未匹配pos原因")
  private String posRemark;

  @ApiModelProperty("扣费匹配单号")
  private String auditFeeCheckCode;

  @CrmExcelColumn("企业费用单编码")
  private String companyCostCode;

  @CrmExcelColumn("业务区域")
  private String businessAreaStr;
  private String businessArea;

  @CrmExcelColumn("扣费明细项编码")
  private String deductionCode;

  @CrmExcelColumn("关联零售商编码")
  private String customerRetailerCode;

  @CrmExcelColumn("关联零售商名称")
  private String customerRetailerName;

  @CrmExcelColumn("省编码(门店管理-省)")
  private String provinceCode;

  @CrmExcelColumn("省名称(门店管理-省)")
  private String provinceName;

  @CrmExcelColumn("售达方编码/客户编码")
  private String soldToPartyCode;

  @CrmExcelColumn("售达方名称/客户名称")
  private String soldToPartyName;

  @CrmExcelColumn("送达方编码/门店编码")
  private String deliveryPartyCode;

  @CrmExcelColumn("送达方名称/门店名称")
  private String deliveryPartyName;

  @CrmExcelColumn("产品编码")
  private String productCode;

  @CrmExcelColumn("产品名称")
  private String productName;

  @CrmExcelColumn("档期名称")
  private String slotDateName;

  @CrmExcelColumn("费用日期 (kms单据日期)")
  private String orderDate;

  @CrmExcelColumn("费用年月 (费用日期的年月)")
  private String orderYearMonth;

  @CrmExcelColumn("单据年月")
  private String actualYearMonth;

  @CrmExcelColumn("扣费明细项名称")
  private String deductionName;

  @CrmExcelColumn("结案形式")
  private String auditWay;

  @CrmExcelColumn("兑付方式")
  private String cashingType;

  @CrmExcelColumn("扣费金额含税")
  private String deductionAmountTaxStr;
  private BigDecimal deductionAmountTax;

  @CrmExcelColumn("备注")
  private String remark;

}
