package com.biz.crm.tpm.business.audit.fee.local.service.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 费用核对-细案导出Vo
 * @author liyang
 * @date 2023/10/18
 */
@ApiModel(value = "AuditFeeCheckCostExportVo",description = "费用核对-细案导出Vo")
@Getter
@Setter
@CrmExcelExport
public class AuditFeeCheckDetailPlanExportVo extends CrmExcelVo {

  @CrmExcelColumn("核销费用核对表扣费匹配单号")
  private String auditFeeCheckCode;

  @CrmExcelColumn("活动细案明细编码")
  private String detailPlanItemCode;

  @CrmExcelColumn("活动细案明细名称")
  private String activityDetailItemName;

  @CrmExcelColumn("活动编号")
  private String detailPlanCode;

  @CrmExcelColumn("活动名称")
  private String detailPlanName;

//  @CrmExcelColumn("活动开始日期")
  private Date activityBeginDate;

  @CrmExcelColumn("活动开始日期")
  private String activityBeginDateStr;

//  @CrmExcelColumn("活动结束日期")
  private Date activityEndDate;

  @CrmExcelColumn("活动结束日期")
  private String activityEndDateStr;

  @CrmExcelColumn("活动年月")
  private String activityYearMonth;

  @CrmExcelColumn("零售商编码")
  private String systemCode;

  @CrmExcelColumn("零售商名称")
  private String systemName;

  @CrmExcelColumn("区域编码")
  private String region;

  @CrmExcelColumn("区域名称")
  private String regionName;

  @CrmExcelColumn("省份编码")
  private String provinceCode;

  @CrmExcelColumn("省份名称")
  private String provinceName;

  @CrmExcelColumn("活动分类编码")
  private String activityTypeCode;

  @CrmExcelColumn("活动分类名称")
  private String activityTypeName;

  @CrmExcelColumn("活动形式编码")
  private String activityFormCode;

  @CrmExcelColumn("活动形式名称")
  private String activityFormName;

  @CrmExcelColumn("结案形式")
  private String auditForm;

  @CrmExcelColumn("购买方式")
  private String buyWay;

  @CrmExcelColumn("核销方式")
  private String writeOffMethod;

  @CrmExcelColumn("门店编码")
  private String terminalCode;

  @CrmExcelColumn("门店名称")
  private String terminalName;

  @CrmExcelColumn("产品编码")
  private String productCode;

  @CrmExcelColumn("产品名称")
  private String productName;

  @CrmExcelColumn("档期名称")
  private String scheduleName;

//  @CrmExcelColumn("申请金额")
  private BigDecimal applyAmount;

  @CrmExcelColumn("申请金额")
  private String applyAmountStr;

//  @CrmExcelColumn("预估核销金额")
  private BigDecimal predictionAuditAmount;

  @CrmExcelColumn("预估核销金额")
  private String predictionAuditAmountStr;

//  @CrmExcelColumn("已核销金额")
  private BigDecimal alreadyAuditAmount;

  @CrmExcelColumn("已核销金额")
  private String alreadyAuditAmountStr;

//  @CrmExcelColumn("可核销金额")
  private BigDecimal canAuditAmount;

  @CrmExcelColumn("可核销金额")
  private String canAuditAmountStr;

//  @CrmExcelColumn("扣费匹配分摊金额，一个细案可分摊多个核对数据，故此属性根据核对编号存在不同的值")
  private BigDecimal auditFeeCheckShareAmount;

  @CrmExcelColumn("本次扣费金额（元）")
  private String auditFeeCheckShareAmountStr;

//  @ApiModelProperty("待补录金额（元）")
  private BigDecimal toBeSupplementedAmount;

  @CrmExcelColumn("待补录金额（元）")
  private String toBeSupplementedAmountStr;

//  @ApiModelProperty("本次核销金额（元）")
  private BigDecimal thisAuditAmount;

  @CrmExcelColumn("本次核销金额（元）")
  private String thisAuditAmountStr;
}
