package com.biz.crm.tpm.business.audit.fee.local.service.imports;

import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.constant.DictConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.mn.common.base.util.MnBeanUtils;
import com.biz.crm.mn.common.ie.sdk.process.MnImportProcess;
import com.biz.crm.mn.common.ie.sdk.vo.MnCrmExcelVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.audit.fee.local.service.imports.vo.AuditFeeDiffDisposeDetailImportVo;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.dispose.AuditFeeDiffDisposeDetailPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description 核销差异费用处理明细导入(按模版导入)
 * @Author YangWei
 * @Date 2023/2/2 下午4:17
 */
@Slf4j
@Component
public class AuditFeeDiffDisposeDetailImportProcess extends MnImportProcess<AuditFeeDiffDisposeDetailImportVo> {

    @Autowired(required = false)
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Resource
    private DictDataVoService dictDataVoService;

    @Resource
    private AuditFeeDiffDisposeDetailPageCacheHelper cacheHelper;

    @Autowired
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    /**
     * 数据字典
     */
    private Map<String, List<DictDataVo>> dictMap = Maps.newHashMap();

    @Override
    public Integer getHeadTitleRowIndex() {
        return 0;
    }

    @Override
    public Map<Integer, String> analysisHeadFieldMap(Map<String, Object> params, Map<Integer, String> headMap) {
        String templateConfigCode = String.valueOf(params.get("templateConfigCode"));
        Assert.hasText(templateConfigCode, "差异费用模版编码不能为空");
        ActivitiesTemplateConfigVo templateConfigVo = this.activitiesTemplateSdkService.findByCode(templateConfigCode);
        Assert.notNull(templateConfigVo, "未查到差异费用模版信息");
        Map<String, String> templateFieldMap = templateConfigVo.getDetails().stream()
            .filter(item -> StringUtils.isNotEmpty(item.getTitle()))
            .collect(Collectors.toMap(ActivitiesTemplateConfigDetailVo::getTitle, ActivitiesTemplateConfigDetailVo::getField, (o, n) -> n));

        Map<Integer, String> headFieldMap = Maps.newHashMap();
        for (Map.Entry<Integer, String> entry : headMap.entrySet()) {
            headFieldMap.put(entry.getKey(),templateFieldMap.get(entry.getValue()));
        }
        return headFieldMap;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditFeeDiffDisposeDetailImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        List<Map<String,Object>> importMaps = data.values().stream().map(MnCrmExcelVo::getData).collect(Collectors.toList());
        List<AuditFeeDiffDisposeDetailDto> importVos = MnBeanUtils.mapListToBeanList(importMaps, AuditFeeDiffDisposeDetailDto.class,false);
        String cacheKey = String.valueOf(params.get("cacheKey"));
        Assert.hasText(cacheKey,"cacheKey不能为空");
        try {
            //初始数据字典
            this.initDict();
            //校验
            this.validate(importVos);
            //保存
            importVos.forEach(dto -> {
                this.cacheHelper.importSave(cacheKey, dto);
            });
        } catch (IllegalArgumentException e) {
            throw e;
        } catch (Exception e) {
            String error = ExceptionStackMsgUtil.stackMsg(e);
            log.error("差异费用处理明细导入异常:{}", error);
            throw new IllegalArgumentException("导入异常[" + error + "]");
        }
        return null;
    }

    /**
     * 初始数据字典
     * @param
     */
    private void initDict() {
        this.dictMap = this.dictDataVoService.findByDictTypeCodeList(
            Lists.newArrayList(AuditFeeConstants.MDM_BUSINESS_FORMAT
                , AuditFeeConstants.MDM_BUSINESS_UNIT));
    }

    /**
     * 校验
     * @param dto
     * @return {@link MonthBudgetDto}
     */
    private void validate(List<AuditFeeDiffDisposeDetailDto> dto) {
        //校验数据字典
        this.verifyDictCode(dto);
    }

    /**
     * 校验数据字典
     * @param vo
     */
    private void verifyDictCode(List<AuditFeeDiffDisposeDetailDto> dto) {

    }

    /**
     * 获取字典对应的value值
     *
     * @param dictValue
     * @param typeCode
     * @return
     */
    private String findDictValueOrCode(String dictValue, String typeCode) {
        DictDataVo dictDataVo = this.dictMap.get(typeCode).stream()
            .filter(a -> a.getDictValue().equals(dictValue) || a.getDictCode().equals(dictValue)).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty(dictDataVo)) {
            return dictDataVo.getDictCode();
        }
        return null;
    }

    @Override
    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<AuditFeeDiffDisposeDetailImportVo> findCrmExcelVoClass() {
        return AuditFeeDiffDisposeDetailImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_AUDIT_FEE_DIFF_DISPOSE_DETAIL_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM-核销差异费用处理明细导入";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_AUDIT_FEE_DIFF_DISPOSE_DETAIL_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-核销差异费用处理明细导入";
    }

}