package com.biz.crm.tpm.business.audit.fee.local.service.imports;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.brand.sdk.dto.ProductBrandFormatDto;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.promotion.material.sdk.service.PromotionMaterialService;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.PromotionMaterialVO;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.MnBeanUtils;
import com.biz.crm.mn.common.ie.sdk.process.MnImportProcess;
import com.biz.crm.mn.common.ie.sdk.vo.MnCrmExcelVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.contract.sdk.enums.ContractTypeEnum;
import com.biz.crm.tpm.business.activity.contract.sdk.service.ActivityContractSdkService;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractVo;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.enums.VerticalActivityTypeEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.WriteOffMethodEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.ActivityPlanQuerySchemeForecastListener;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.dto.ActivityPlanQuerySchemeForecastDto;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQuerySchemeForecastCashVo;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQuerySchemeForecastResponse;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.fee.local.service.imports.vo.AuditFeeDiffTrackDetailImportVo;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.track.AuditFeeDiffTrackDetailPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailImportDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditStateEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 差异费用追踪活动导入-通用，按模板导入 ActivityPlanDY00000010ImportsProcess
 *
 * @author liyang
 * @date 2023/10/05
 */
@Slf4j
@Component
public class AuditFeeDiffTrackDetailImportProcess extends
    MnImportProcess<AuditFeeDiffTrackDetailImportVo> {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private AuditFeeDiffTrackDetailPageCacheHelper auditFeeDiffTrackDetailPageCacheHelper;

  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Autowired(required = false)
  private ActivityTypeService activityTypeService;
  @Autowired(required = false)
  private ActivityFormService activityFormService;
  @Autowired(required = false)
  private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;
  @Autowired(required = false)
  private SalesOrgVoService salesOrgVoService;
  @Autowired(required = false)
  private TerminalVoService terminalVoService;
  @Autowired(required = false)
  private CustomerVoService customerVoService;
  @Autowired(required = false)
  private AuditFormulaMainService auditFormulaMainService;
  @Autowired(required = false)
  private ProductBrandService productBrandService;
  @Autowired(required = false)
  private ProductVoService productVoService;
  @Autowired(required = false)
  private ProductLevelVoSdkService productLevelVoSdkService;
  @Autowired(required = false)
  private CustomerRetailerVoService customerRetailerVoService;

  @Autowired(required = false)
  private ActivitiesTemplateSdkService activitiesTemplateSdkService;

  @Autowired(required = false)
  private ActivityContractSdkService activityContractSdkService;

  @Autowired(required = false)
  private PromotionMaterialService promotionMaterialService;

  @Autowired(required = false)
  private NebulaNetEventClient nebulaNetEventClient;

  protected static final ThreadLocal<ActivitiesTemplateConfigVo> templateConfigVoThreadLocal = new ThreadLocal<>();

  @Override
  public Map<Integer, String> analysisHeadFieldMap(Map<String, Object> params, Map<Integer, String> headMap) {
    String cacheKey = String.valueOf(params.get("cacheKey"));
    //有策略编码，从数据库里面查出来放到缓存里面
    String[] split = cacheKey.split(":");
    String templateCode = split[split.length - 1];//模板编码

    ActivitiesTemplateConfigVo templateConfigVo = activitiesTemplateSdkService.findByCode(templateCode);
    if (null == templateConfigVo) {
      throw new RuntimeException("模板解析错误！");
    }
    templateConfigVoThreadLocal.set(templateConfigVo);
    // 中文->属性名
    Map<String, String> templateFieldMap = templateConfigVo.getDetails().stream()
        .filter(item -> StringUtils.isNotEmpty(item.getTitle()))
        .collect(Collectors.toMap(ActivitiesTemplateConfigDetailVo::getTitle,
            ActivitiesTemplateConfigDetailVo::getField, (o, n) -> n));

    Map<Integer, String> headFieldMap = Maps.newHashMap();
    for (Map.Entry<Integer, String> entry : headMap.entrySet()) {
      headFieldMap.put(entry.getKey(), templateFieldMap.get(entry.getValue()));
    }
    // excel列号码->属性名
    return headFieldMap;
  }

  @Override
  public Map<Integer, String> execute(LinkedHashMap<Integer, AuditFeeDiffTrackDetailImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
    log.info("差异费用追踪活动导入数据:{}", JSON.toJSONString(data));
    log.info("差异费用追踪活动导入参数:{}", JSON.toJSONString(params));
    log.info("差异费用追踪活动导入Global参数:{}", JSON.toJSONString(paramsVo));
    log.info("差异费用追踪活动导入开始");

    String cacheKey = String.valueOf(params.get("cacheKey"));
    //有策略编码，从数据库里面查出来放到缓存里面
    String[] split = cacheKey.split(":");
    String templateCode = split[split.length - 1];//模板编码

    Map<Integer, String> errorMap = Maps.newHashMap();
    Map<Integer, List<String>> errorListMap = Maps.newHashMap();
    try {
      String businessFormatCode = String.valueOf(params.get("businessFormatCode"));
      String businessUnitCode = String.valueOf(params.get("businessUnitCode"));

      List<Map<String, Object>> importMaps = data.values().stream().map(MnCrmExcelVo::getData).collect(Collectors.toList());
      ActivitiesTemplateConfigVo templateConfigVo = templateConfigVoThreadLocal.get();

      // 必填校验
      List<ActivitiesTemplateConfigDetailVo> allFieldList = templateConfigVo.getDetails().stream().filter(item -> item.getRequired() != null && item.getRequired()).collect(Collectors.toList());
      data.forEach((key, value) -> {
        List<String> errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
        Map<String, Object> importRowMap = value.getData();
        for (ActivitiesTemplateConfigDetailVo activitiesTemplateConfigDetailVo : allFieldList) {
          Object fieldObj = importRowMap.get(activitiesTemplateConfigDetailVo.getField());
          try {
            if (Boolean.TRUE.equals(activitiesTemplateConfigDetailVo.getRequired()) && null == fieldObj) {
              errorList.add("字段【" + activitiesTemplateConfigDetailVo.getTitle() + "】必填！");
            }
          } catch (Exception e) {
            log.error(e.getMessage(), e);
            errorList.add(e.getMessage());
          }
        }
      });

      // 数字字典
      List<ActivitiesTemplateConfigDetailVo> dictFieldList = templateConfigVo.getDetails().stream().filter(item -> StringUtils.isNotEmpty(item.getDictCode())).collect(Collectors.toList());
      //数据字典 活动模板与具体活动形式的映射 字典编码（plan_template_map）
      Map<String, String> planTemplateMap = new HashMap<>();
      if (dictFieldList.size() > 0) {
        List<String> dictCodeList = dictFieldList.stream().filter(item -> StringUtils.isNotEmpty(item.getDictCode())).map(ActivitiesTemplateConfigDetailVo::getDictCode).collect(Collectors.toList());
        dictCodeList.add("plan_template_map");
        Map<String, List<DictDataVo>> dictMap = !CollectionUtils.isEmpty(dictCodeList) ? dictDataVoService.findByDictTypeCodeList(dictCodeList) : new HashMap<>();
        Map<String, Map<String, String>> dictMapMap = CollectionUtils.isEmpty(dictMap) ? new HashMap<>() :
            dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n)), (o, n) -> n));

        if (!CollectionUtils.isEmpty(dictMapMap)) {
          List<DictDataVo> planTemplateDictDataVos = dictMap.get("plan_template_map");
          if (null != planTemplateDictDataVos) {
            planTemplateMap = planTemplateDictDataVos.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> n));
          }
        }
        //先校验一遍数据字典并赋值
        data.forEach((key, value) -> {
          List<String> errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
          Map<String, Object> importRowMap = value.getData();
          for (ActivitiesTemplateConfigDetailVo activitiesTemplateConfigDetailVo : dictFieldList) {
            Object fieldObj = importRowMap.get(activitiesTemplateConfigDetailVo.getField());
            try {
              //一二级渠道名称处理
//              if ("firstChannelCode".equals(activitiesTemplateConfigDetailVo.getField())) {
//                importMap.put("firstChannelName", fieldObj);
//              }
//              if ("secondChannelCode".equals(activitiesTemplateConfigDetailVo.getField())) {
//                importMap.put("secondChannelName", fieldObj);
//              }
//              if (Boolean.TRUE.equals(activitiesTemplateConfigDetailVo.getRequired()) && null == fieldObj) {
//                errorList.add("字段【" + activitiesTemplateConfigDetailVo.getTitle() + "】必填！");
//              }
              if (null != fieldObj && StringUtils.isNotEmpty(activitiesTemplateConfigDetailVo.getDictCode())) {
                this.validateAndConvertDictData(dictMapMap, activitiesTemplateConfigDetailVo.getDictCode(), fieldObj.toString(), s -> importRowMap.put(activitiesTemplateConfigDetailVo.getField(), s), activitiesTemplateConfigDetailVo.getTitle());
              }
            } catch (Exception e) {
              log.error(e.getMessage(), e);
              errorList.add(e.getMessage());
            }
          }
        });
      }

      List<AuditFeeDiffTrackDetailImportDto> importVos = MnBeanUtils.mapListToBeanList(importMaps, AuditFeeDiffTrackDetailImportDto.class, false);

//    销售组织编码、门店编码、售达方编码、品牌、品类、品项、赠品编码、产品编码等通过导入编码的字段，根据编码识别名称保存

      Set<String> orgCodeSet = Sets.newHashSet();
      Set<String> activityTypeCodeSet = Sets.newHashSet();
      Set<String> activityFormCodeSet = Sets.newHashSet();
      Set<String> diffLedgerCodeSet = Sets.newHashSet();
      Set<String> customerCodeSet = Sets.newHashSet();
      Set<String> terminalCodeSet = Sets.newHashSet();
      Set<String> terminalChannelSet = Sets.newHashSet();
      Set<String> productBrandCodeSet = Sets.newHashSet();
      Set<String> productLevelCodeSet = Sets.newHashSet();
      Set<String> productCodeSet = Sets.newHashSet();
      Set<String> salesOrgCodeSet = Sets.newHashSet();
      Set<String> auditFormulaCodeSet = Sets.newHashSet();
      Set<String> customerRetailerCodeSet = Sets.newHashSet();
      Set<String> customerRetailerNameSet = Sets.newHashSet();
      Set<String> contractCodeSet = Sets.newHashSet();
      Set<String> materialCodeSet = Sets.newHashSet();
      Set<String> schemeForecastDetailCodeSet = Sets.newHashSet();

      int key = 0;
      for (AuditFeeDiffTrackDetailImportDto importVo : importVos) {
        List<String> errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
        try {
          if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
            activityTypeCodeSet.add(importVo.getActivityTypeCode());
          }
          if (StringUtils.isNotEmpty(importVo.getActivityFormCode())) {
            activityFormCodeSet.add(importVo.getActivityFormCode());
          }
          if (StringUtils.isNotEmpty(importVo.getFeeDiffLedgerCode())) {
            diffLedgerCodeSet.addAll(Arrays.asList(importVo.getFeeDiffLedgerCode().replace("，", ",").split(",")));
          }
          if (StringUtils.isNotEmpty(importVo.getSalesInstitutionErpCode())) {
            if (StringUtils.isEmpty(importVo.getDistributionChannelCode())) {
              throw new RuntimeException("导入销售组织时分销渠道不能为空！");
            }
            importVo.setActivityOrgCode(importVo.getDistributionChannelCode() + businessFormatCode
                + importVo.getSalesInstitutionErpCode());
          }
          if (StringUtils.isNotEmpty(importVo.getActivityOrgCode())) {
            salesOrgCodeSet.add(importVo.getActivityOrgCode());
          }
          if (StringUtils.isNotEmpty(importVo.getCustomerErpCode())) {
            if (StringUtils.isEmpty(importVo.getSalesInstitutionErpCode()) || StringUtils.isEmpty(
                importVo.getDistributionChannelCode())) {
              //导入的时候拼接吧
              throw new RuntimeException("导入客户时销售机构编码和分销渠道不能为空！");
            }
            customerCodeSet.add(
                importVo.getCustomerErpCode() + importVo.getSalesInstitutionErpCode()
                    + importVo.getDistributionChannelCode() + businessFormatCode);
          }
          if (StringUtils.isNotEmpty(importVo.getTerminalCode())) {
            terminalCodeSet.add(importVo.getTerminalCode());
          }
          //零售商支持多选
          if (StringUtils.isNotEmpty(importVo.getSystemCode())) {
            customerRetailerCodeSet.addAll(Arrays.asList(importVo.getSystemCode().replace("，", ",").split(",")));
          }
          if (StringUtils.isNotEmpty(importVo.getSystemName())) {
            customerRetailerNameSet.addAll(Arrays.asList(importVo.getSystemName().replace("，", ",").split(",")));
          }
          if (StringUtils.isNotEmpty(importVo.getAuditConditionCode())) {
            auditFormulaCodeSet.add(importVo.getAuditConditionCode());
          }
          if (StringUtils.isNotEmpty(importVo.getProductBrandCode())) {
            productBrandCodeSet.add(importVo.getProductBrandCode());
          }
          if (StringUtils.isNotEmpty(importVo.getProductCode())) {
            productCodeSet.add(importVo.getProductCode());
          }
          if (StringUtils.isNotEmpty(importVo.getProductItemCode())) {
            productLevelCodeSet.add(importVo.getProductItemCode());
          }
          if (StringUtils.isNotEmpty(importVo.getProductCategoryCode())) {
            productLevelCodeSet.add(importVo.getProductCategoryCode());
          }
          if (StringUtils.isNotEmpty(importVo.getContractCode())) {
            contractCodeSet.add(importVo.getContractCode());
          }
          if (StringUtils.isNotEmpty(importVo.getMaterialCode())) {
            materialCodeSet.add(importVo.getMaterialCode());
          }
        } catch (RuntimeException e) {
          log.error("", e);
          errorList.add(e.getMessage());
        } catch (Exception e) {
          log.error(e.getMessage(), e);
          errorList.add(e.getMessage());
        } finally {
          key++;
        }
      }

      Map<String, String> salesOrgMap = Maps.newHashMap();
      Map<String, TerminalVo> terminalMap = Maps.newHashMap();
      Map<String, CustomerVo> customerMap = Maps.newHashMap();
      Map<String, String> activityTypeMap = Maps.newHashMap();
      Map<String, ActivityFormVo> activityFormMap = Maps.newHashMap();
      Map<String, AuditFeeDiffLedgerVo> diffLedgerMap = Maps.newHashMap();
      Map<String, AuditFormulaMainVo> auditFormulaMap = Maps.newHashMap();
      if (!CollectionUtils.isEmpty(activityTypeCodeSet)) {
        List<ActivityTypeVo> activityTypeList = activityTypeService.findByCodes(
            Lists.newArrayList(activityTypeCodeSet));
        activityTypeMap = activityTypeList.stream().collect(
            Collectors.toMap(ActivityTypeVo::getActivityTypeCode,
                ActivityTypeVo::getActivityTypeName, (o, n) -> n));
      }
      if (!CollectionUtils.isEmpty(activityFormCodeSet)) {
        List<String> activityFormCodeList = Lists.newArrayList(activityFormCodeSet);
        ActivityFormDto activityFormDto = new ActivityFormDto();
        activityFormDto.setActivityFormCodeList(activityFormCodeList);
        List<ActivityFormVo> activityFormVos = activityFormService.findListByConditions(
            activityFormDto);
        activityFormMap = activityFormVos.stream()
            .collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
      }
      if (!CollectionUtils.isEmpty(diffLedgerCodeSet)) {
        List<AuditFeeDiffLedgerVo> diffLedgerVoList = auditFeeDiffLedgerVoService.findDetailByCodes(Lists.newArrayList(diffLedgerCodeSet));
        diffLedgerMap = diffLedgerVoList.stream().collect(Collectors.toMap(AuditFeeDiffLedgerVo::getFeeDiffLedgerCode, Function.identity(), (o, n) -> n));
      }
      if (!CollectionUtils.isEmpty(salesOrgCodeSet)) {
        List<SalesOrgVo> salesOrgList = salesOrgVoService.findBySalesOrgCodes(
            Lists.newArrayList(salesOrgCodeSet));
        if (!CollectionUtils.isEmpty(salesOrgList)) {
          salesOrgMap = salesOrgList.stream().collect(
              Collectors.toMap(SalesOrgVo::getSalesOrgCode, SalesOrgVo::getSalesOrgName,
                  (o, n) -> n));
        }
      }
      if (!CollectionUtils.isEmpty(terminalCodeSet)) {
        List<TerminalVo> terminalVos = terminalVoService.findBaseByTerminalCodes(
            Lists.newArrayList(terminalCodeSet));
        if (!CollectionUtils.isEmpty(terminalVos)) {
          terminalMap = terminalVos.stream().collect(
              Collectors.toMap(TerminalVo::getTerminalCode, Function.identity(), (o, n) -> n));
        }
      }
      if (!CollectionUtils.isEmpty(customerCodeSet)) {
        List<CustomerVo> customerVos = customerVoService.findBaseByCustomerCodes(
            Lists.newArrayList(customerCodeSet));
        if (!CollectionUtils.isEmpty(customerVos)) {
          customerMap = customerVos.stream()
              .collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
      }
      if (!CollectionUtils.isEmpty(auditFormulaCodeSet)) {
        List<AuditFormulaMainVo> auditFormulaList = auditFormulaMainService.findByCodeList(
            Lists.newArrayList(auditFormulaCodeSet));
        if (!CollectionUtils.isEmpty(auditFormulaList)) {
          auditFormulaMap = auditFormulaList.stream().collect(
              Collectors.toMap(AuditFormulaMainVo::getAuditFormulaCode, Function.identity(),
                  (o, n) -> n));
        }
      }
      Map<String, String> productBrandMap = Maps.newHashMap();
      if (!CollectionUtils.isEmpty(productBrandCodeSet)) {
        ProductBrandFormatDto productBrandFormatDto = new ProductBrandFormatDto();
        productBrandFormatDto.setBusinessFormatCode(businessFormatCode);
        productBrandFormatDto.setCodes(Lists.newArrayList(productBrandCodeSet));
        Map<String, String> productBrandMapTemp = productBrandService.findNameByCodesAndFormat(
            productBrandFormatDto);
        if (null != productBrandMapTemp) {
          productBrandMap = productBrandMapTemp;
        }
      }
      Map<String, String> productCategoryMap = Maps.newHashMap();
      Map<String, String> productItemMap = Maps.newHashMap();
      if (!CollectionUtils.isEmpty(productLevelCodeSet)) {
        List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByBusinessFormatAndCodes(
            businessFormatCode, Lists.newArrayList(productLevelCodeSet));
        List<ProductLevelVo> productCategoryList = productLevelVos.stream()
            .filter(item -> ProductLevelEnum.category.equals(item.getProductLevelType()))
            .collect(Collectors.toList());
        productCategoryMap = productCategoryList.stream().collect(
            Collectors.toMap(ProductLevelVo::getProductLevelCode,
                ProductLevelVo::getProductLevelName, (o, n) -> n));
        List<ProductLevelVo> productItemList = productLevelVos.stream()
            .filter(item -> ProductLevelEnum.items.equals(item.getProductLevelType()))
            .collect(Collectors.toList());
        productItemMap = productItemList.stream().collect(
            Collectors.toMap(ProductLevelVo::getProductLevelCode,
                ProductLevelVo::getProductLevelName, (o, n) -> n));
      }
      Map<String, ProductVo> productMap = Maps.newHashMap();
      if (!CollectionUtils.isEmpty(productCodeSet)) {
        List<ProductVo> productVos = productVoService.findByCodes(
            Lists.newArrayList(productCodeSet));
        productMap = productVos.stream()
            .collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o, n) -> n));
      }
      Map<String, String> customerRetailerMap = Maps.newHashMap();
      if (!CollectionUtils.isEmpty(customerRetailerCodeSet)) {
        List<CustomerRetailerVo> customerRetailerVos = customerRetailerVoService.findByCodes(
            Lists.newArrayList(customerRetailerCodeSet));
        if (!CollectionUtils.isEmpty(customerRetailerVos)) {
          customerRetailerMap = customerRetailerVos.stream().collect(
              Collectors.toMap(CustomerRetailerVo::getCustomerRetailerCode,
                  CustomerRetailerVo::getCustomerRetailerName, (o, n) -> n));
        }
      }
      Map<String, String> systemMap = Maps.newHashMap();
      if (!CollectionUtils.isEmpty(customerRetailerNameSet)) {
        List<CustomerRetailerVo> customerRetailerVos = customerRetailerVoService.findByNames(
            Lists.newArrayList(customerRetailerNameSet));
        if (!CollectionUtils.isEmpty(customerRetailerVos)) {
          systemMap = customerRetailerVos.stream().collect(
              Collectors.toMap(CustomerRetailerVo::getCustomerRetailerName,
                  CustomerRetailerVo::getCustomerRetailerCode, (o, n) -> n));
        }
      }
      Map<String, ActivityContractVo> contractVoMap = Maps.newHashMap();
      if (!CollectionUtils.isEmpty(contractCodeSet)) {
        List<ActivityContractVo> contractVoList = activityContractSdkService.findByCodeList(
            Lists.newArrayList(contractCodeSet));
        if (!CollectionUtils.isEmpty(contractVoList)) {
          contractVoMap = contractVoList.stream().collect(
              Collectors.toMap(ActivityContractVo::getContractNo, Function.identity(),
                  (o, n) -> n));
        }
      }
      Map<String, PromotionMaterialVO> promotionMaterialMap = Maps.newHashMap();
      if (!CollectionUtils.isEmpty(materialCodeSet)) {
        List<PromotionMaterialVO> materialList = promotionMaterialService.findByCodeList(
            Lists.newArrayList(materialCodeSet));
        if (!CollectionUtils.isEmpty(materialList)) {
          promotionMaterialMap = materialList.stream().collect(
              Collectors.toMap(PromotionMaterialVO::getMaterialCode, Function.identity(),
                  (o, n) -> n));
        }
      }

      // todo 方案预测 ->
      Map<String, ActivityPlanQuerySchemeForecastCashVo> schemeForecastDetailMap = Maps.newHashMap();
      if (!CollectionUtils.isEmpty(schemeForecastDetailCodeSet)) {
        ActivityPlanQuerySchemeForecastDto eventDto = new ActivityPlanQuerySchemeForecastDto();
        eventDto.setSchemeForecastDetailCodeList(Lists.newArrayList(schemeForecastDetailCodeSet));
        SerializableBiConsumer<ActivityPlanQuerySchemeForecastListener, ActivityPlanQuerySchemeForecastDto> findDetailListByConditions =
            ActivityPlanQuerySchemeForecastListener::findDetailListByConditions;
        ActivityPlanQuerySchemeForecastResponse eventResponse = (ActivityPlanQuerySchemeForecastResponse) this.nebulaNetEventClient.directPublish(
            eventDto, ActivityPlanQuerySchemeForecastListener.class, findDetailListByConditions);
        if (null != eventResponse && !CollectionUtils.isEmpty(eventResponse.getList())) {
          schemeForecastDetailMap = eventResponse.getList().stream().collect(
              Collectors.toMap(ActivityPlanQuerySchemeForecastCashVo::getDetailCode,
                  Function.identity(), (o, n) -> n));
        }
      }

      key = 0;
      List<AuditFeeDiffTrackDetailImportDto> newList = Lists.newArrayList();
      String currYearMonth = DateUtil.getDateStrByFormat(new Date(), DateUtil.DEFAULT_YEAR_MONTH);
      for (AuditFeeDiffTrackDetailImportDto importVo : importVos) {
        List<String> errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
        try {
          AuditFeeDiffTrackDetailImportDto itemDto = nebulaToolkitService.copyObjectByWhiteList(importVo, AuditFeeDiffTrackDetailImportDto.class, HashSet.class, ArrayList.class);

//          validateAndConvertDictData(dictMapMap, MDM_CUSTOMIZE_ORG, importVo.getRegion(), itemDto::setRegion, "区域");
//          validateAndConvertDictData(dictMapMap, ac_store_type, importVo.getAcStoreType(), itemDto::setAcStoreType, "AC分仓");
//          validateAndConvertDictData(dictMapMap, PURCHASE_METHOD, importVo.getBuyWay(), itemDto::setBuyWay, "购买方式");
//          validateAndConvertDictData(dictMapMap, audit_type, importVo.getWriteOffMethod(), itemDto::setWriteOffMethod, "核销方式");
//          validateAndConvertDictData(dictMapMap, firstChannelName, importVo.getFirstChannelCode(), itemDto::setFirstChannelCode, "一级营销渠道");
//          validateAndConvertDictData(dictMapMap, secondChannelCode, importVo.getSecondChannelCode(), itemDto::setSecondChannelCode, "二级营销渠道");
//          validateAndConvertDictData(dictMapMap, Total_quantity_or_not, importVo.getPublicOrNot(), itemDto::setPublicOrNot, "是否共用");
//          validateAndConvertDictData(dictMapMap, tpm_audit_form, importVo.getAuditForm(), itemDto::setAuditForm, "结案形式");
//          validateAndConvertDictData(dictMapMap, tpm_audit_type, importVo.getAuditType(), itemDto::setAuditType, "核销类型");
//          validateAndConvertDictData(dictMapMap, YES_OR_NO, importVo.getOnScheduleOrNot(), itemDto::setOnScheduleOrNot, "是否档期");
//          validateAndConvertDictData(dictMapMap, CITY_LEVEL, importVo.getCityLevel(), itemDto::setCityLevel, "城市等级");
//          if (!CollectionUtils.isEmpty(planTemplateMap)) {
//            String type = planTemplateMap.get(templateCode);
          //Validate.notBlank(type,"请用模版编码【"+templateCode+"】在数据字典plan_template_map中配置模版映射");

          if (StringUtils.isNotBlank(itemDto.getTerminalCode())) {
            Validate.notEmpty(terminalMap, "根据门店编码，未查询到任何门店信息");
            TerminalVo terminalVo = terminalMap.get(itemDto.getTerminalCode());
            Validate.notNull(terminalVo, "根据门店编码【" + itemDto.getTerminalCode() + "】未查询到门店信息");
            itemDto.setCustomerCode(
                terminalVo.getSellerCode() + itemDto.getSalesInstitutionErpCode()
                    + itemDto.getDistributionChannelCode() + "11");
            itemDto.setCustomerErpCode(terminalVo.getSellerCode());
          } else if (StringUtils.isNotBlank(itemDto.getCustomerCode())) {
            itemDto.setCustomerErpCode(itemDto.getCustomerCode());
            itemDto.setCustomerCode(itemDto.getCustomerCode() + itemDto.getSalesInstitutionErpCode()
                + itemDto.getDistributionChannelCode() + "11");
          }

          Validate.notBlank(importVo.getActivityBeginDateStr(), "活动开始时间不能为空！");
          Validate.notBlank(importVo.getActivityEndDateStr(), "活动结束时间不能为空！");
          Validate.isTrue(isFlag(importVo.getActivityBeginDateStr()), "活动开始时间格式错误！");
          Validate.isTrue(isFlag(importVo.getActivityEndDateStr()), "活动结束时间格式错误！");
          Validate.isTrue(importVo.getActivityBeginDateStr().substring(0, 7).equals(importVo.getActivityEndDateStr().substring(0, 7)),"活动开始/结束不允许跨月！");

          if (StringUtils.isNotEmpty(importVo.getOrderBeginDateStr())) {
            Validate.isTrue(isFlag(importVo.getOrderBeginDateStr()), "订单开始时间格式错误！");
          }
          if (StringUtils.isNotEmpty(importVo.getOrderEndDateStr())) {
            Validate.isTrue(isFlag(importVo.getOrderEndDateStr()), "订单结束时间格式错误！");
          }

          // 费用归属年月=活动开始时间年月，核销方式是事中的话，用订单开始时间作为费用归属年月
          // SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
          String feeYearMonth = importVo.getActivityBeginDateStr().substring(0, 7);
          if (WriteOffMethodEnum.THINGS.getCode().equals(importVo.getWriteOffMethod())
              && StringUtils.isNotEmpty(importVo.getOrderBeginDateStr())) {
            feeYearMonth = importVo.getOrderBeginDateStr().substring(0, 7);
          } else {
            // 事后活动，费用归属年月：活动所属年月和当前年月取最最近的年月
            if (currYearMonth.compareTo(feeYearMonth) > 0) {
              feeYearMonth = currYearMonth;
            }
          }
          itemDto.setFeeYearMonthStr(feeYearMonth);

          //活动分类
          List<String> codeList = new ArrayList<>();
          if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
            String[] codes = importVo.getActivityTypeCode().split(",");
            LinkedList<String> allNames = new LinkedList<>();
            for (String code : codes) {
              String activityTypeName = activityTypeMap.get(code);
              if (StringUtils.isEmpty(activityTypeName)) {
                throw new RuntimeException("活动分类[" + code + "]有误");
              } else {
                allNames.add(activityTypeName);
              }
            }
            itemDto.setActivityTypeCode(itemDto.getActivityTypeCode());
            itemDto.setActivityTypeName(String.join(",", allNames));
            codeList = Arrays.asList(codes);
          }

          //活动形式
          if (StringUtils.isNotEmpty(importVo.getActivityFormCode())) {
            String[] codes = importVo.getActivityFormCode().split(",");
            LinkedList<String> allNames = new LinkedList<>();
            ActivityFormVo activityFormVo = null;
            for (String code : codes) {
              activityFormVo = activityFormMap.get(code);
              if (null == activityFormVo) {
                throw new RuntimeException("活动形式[" + code + "]有误");
              } else {
                Validate.isTrue(codeList.contains(activityFormVo.getActivityTypeCode()),
                    "活动形式[" + code + "]不在当前活动分类中");
                allNames.add(activityFormVo.getActivityFormName());
              }
            }
            itemDto.setActivityFormCode(importVo.getActivityFormCode());
            itemDto.setActivityFormName(String.join(",", allNames));

            if (VerticalActivityTypeEnum.temporary_staff.getCode()
                .equals(activityFormVo.getVerticalActivityType())) {
              //活动形式下“垂直活动类型”为“临促人员活动”的活动做校验，临促人员的人员信息不允许维护。
//              if (StringUtils.isNotEmpty(importVo.getEmployeeCode()) || StringUtils.isNotEmpty(importVo.getEmployeeId())) {
//                throw new RuntimeException("临促人员的人员信息不允许维护");
//              }
            }
          }
          //档期日期
          if (StringUtils.isNotEmpty(importVo.getScheduleBeginDateStr())) {
            try {
              itemDto.setScheduleBeginDate(DateUtil.parseDate(importVo.getScheduleBeginDateStr(),
                  DateUtil.DEFAULT_YEAR_MONTH_DAY));
            } catch (Exception e) {
              log.error(e.getMessage());
              throw new IllegalArgumentException(
                  "档期开始日期[" + importVo.getScheduleBeginDateStr() + "]格式错误，请更改为yyyy-MM-dd");
            }
          }
          if (StringUtils.isNotEmpty(importVo.getScheduleEndDateStr())) {
            try {
              itemDto.setScheduleEndDate(DateUtil.parseDate(importVo.getScheduleEndDateStr(),
                  DateUtil.DEFAULT_YEAR_MONTH_DAY));
            } catch (Exception e) {
              log.error(e.getMessage());
              throw new IllegalArgumentException(
                  "档期结束日期[" + importVo.getScheduleEndDateStr() + "]格式错误，请更改为yyyy-MM-dd");
            }
          }

          //销售组织
          if (StringUtils.isNotEmpty(importVo.getActivityOrgCode())) {
            String salesOrgName = salesOrgMap.get(importVo.getActivityOrgCode());
            if (StringUtils.isEmpty(salesOrgName)) {
              throw new RuntimeException("销售组织[" + importVo.getActivityOrgCode() + "]有误");
            }
            itemDto.setActivityOrgName(salesOrgName);
          }

          if (StringUtils.isNotEmpty(importVo.getSystemCode())) {
            String customerRetailerName = customerRetailerMap.get(importVo.getSystemCode());
            if (StringUtils.isEmpty(customerRetailerName)) {
              throw new RuntimeException("零售商编码[" + importVo.getSystemCode() + "]有误");
            }
            itemDto.setSystemName(customerRetailerName);
          }
          if (StringUtils.isNotEmpty(importVo.getSystemName())) {
            String customerRetailerCode = systemMap.get(importVo.getSystemName());
            if (StringUtils.isEmpty(customerRetailerCode)) {
              throw new RuntimeException("零售商名称[" + importVo.getSystemName() + "]有误");
            }
            itemDto.setSystemCode(customerRetailerCode);
          }

          //核销条件（核销公式）
          if (StringUtils.isNotEmpty(importVo.getAuditConditionCode())) {
            AuditFormulaMainVo auditFormula = auditFormulaMap.get(importVo.getAuditConditionCode());
            if (auditFormula == null) {
              throw new RuntimeException("核销条件[" + importVo.getAuditConditionCode() + "]有误");
            }
            itemDto.setAuditConditionName(auditFormula.getAuditFormulaName());
          } else {
            Validate.isTrue(!TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(importVo.getAuditType()), "核销条件编码必填");
          }

          //门店
          if (StringUtils.isNotEmpty(importVo.getTerminalCode())) {
            TerminalVo terminalVo = terminalMap.get(importVo.getTerminalCode());
            if (null == terminalVo) {
              throw new RuntimeException("门店编码[" + importVo.getTerminalCode() + "]有误");
            }
            if (!EnableStatusEnum.ENABLE.getCode().equals(terminalVo.getEnableStatus())
                || !BooleanEnum.TRUE.getNumStr().equals(terminalVo.getTerminalState())) {
              throw new RuntimeException(
                  "方案中包含已被禁用、已关闭的门店，门店编码为" + importVo.getTerminalCode() + ",请校对后再提交");
            }
            //校验门店所属销售组织、AC分仓、区域、零售商、ac门店类型与方案填写内容是否一致，若方案字段销售组织、AC分仓、区域、零售商、ac门店类型字段为空，则跳过改字段校验
//                    if (!StringUtils.isEmpty(importVo.getActivityOrgCode())){
//                        if (!importVo.getActivityOrgCode().equals(terminalVo.getSalesOrgCode())){
//                            throw new RuntimeException("门店["+importVo.getTerminalCode()+"]不属于销售组织["+importVo.getActivityOrgCode()+"]有误");
//                        }
//                    }
//                    if (!StringUtils.isEmpty(itemDto.getAcWarehouseCode())){
//                        if (!itemDto.getAcWarehouseCode().equals(terminalVo.getPointsWarehouseCode())){
//                            throw new RuntimeException("门店["+importVo.getTerminalCode()+"]不属于AC分仓["+importVo.getAcWarehouseName()+"]");
//                        }
//                    }
            if (!StringUtils.isEmpty(itemDto.getRegion())) {
              if (!itemDto.getRegion().equals(terminalVo.getRegionCode())) {
                throw new RuntimeException(
                    "门店[" + importVo.getTerminalCode() + "]不属于区域[" + importVo.getRegion() + "]");
              }
            }
            if (!StringUtils.isEmpty(importVo.getSystemCode())) {
              if (!importVo.getSystemCode().equals(terminalVo.getCustomerRetailerCode())) {
                throw new RuntimeException(
                    "门店[" + importVo.getTerminalCode() + "]不属于零售商[" + importVo.getSystemCode()
                        + "]");
              }
            }
            if (!StringUtils.isEmpty(itemDto.getAcStoreType())) {
              if (!itemDto.getAcStoreType().equals(terminalVo.getTerminalTypeCode())) {
                throw new RuntimeException(
                    "门店[" + importVo.getTerminalCode() + "]AC门店类型不是[" + importVo.getAcStoreType()
                        + "]");
              }
            }
            itemDto.setTerminalName(terminalVo.getTerminalName());
          }
          if (StringUtils.isNotEmpty(importVo.getCustomerErpCode())) {
            String customerCode =
                importVo.getCustomerErpCode() + importVo.getSalesInstitutionErpCode()
                    + importVo.getDistributionChannelCode() + businessFormatCode;
            CustomerVo customerVo = customerMap.get(customerCode);
            if (null == customerVo) {
              throw new RuntimeException("客户[" + customerCode + "]有误");
            }
            itemDto.setCustomerCode(customerCode);
            itemDto.setCustomerName(customerVo.getCustomerName());
            itemDto.setCustomerErpCode(customerVo.getErpCode());
          }

          //品类
          if (StringUtils.isNotEmpty(importVo.getProductCategoryCode())) {
            String productLevelName = productCategoryMap.get(importVo.getProductCategoryCode());
            if (StringUtils.isEmpty(productLevelName)) {
              throw new RuntimeException("品类[" + importVo.getProductCategoryCode() + "]有误");
            }
            itemDto.setProductCategoryName(productLevelName);
          }

          //品项
          if (StringUtils.isNotEmpty(importVo.getProductItemCode())) {
            String productLevelName = productItemMap.get(importVo.getProductItemCode());
            if (StringUtils.isEmpty(productLevelName)) {
              throw new RuntimeException("品项[" + importVo.getProductItemCode() + "]有误");
            }
            itemDto.setProductItemName(productLevelName);
          }

          //品牌
          if (StringUtils.isNotEmpty(importVo.getProductBrandCode())) {
            String brandName = productBrandMap.get(importVo.getProductBrandCode());
            if (StringUtils.isEmpty(brandName)) {
              throw new RuntimeException("品牌[" + importVo.getProductBrandCode() + "]有误");
            }
            itemDto.setProductBrandName(brandName);
          }

          //产品
          if (StringUtils.isNotEmpty(importVo.getProductCode())) {
            String[] codes = importVo.getProductCode().split(",");
            LinkedList<String> allNames = new LinkedList<>();
            for (String code : codes) {
              ProductVo productVo = productMap.get(code);
              if (null == productVo) {
                throw new RuntimeException("产品编码[" + importVo.getProductCode() + "]有误");
              }
              itemDto.setProductUnit(productVo.getBaseUnit());
              allNames.add(productVo.getProductName());
            }
            itemDto.setProductName(String.join(",", allNames));
          }

          if (StringUtils.isNotEmpty(importVo.getContractCode())) {
            ActivityContractVo activityContractVo = contractVoMap.get(importVo.getContractCode());
            if (null == activityContractVo) {
              throw new RuntimeException("合同编码[" + importVo.getContractCode() + "]有误");
            }
            if (!ContractTypeEnum.SUPPLIER_CONTRACT.getCode()
                .equals(activityContractVo.getContractType())) {
              throw new RuntimeException("合同[" + importVo.getContractCode() + "]不是供应商合同");
            }
            if (StringUtils.isEmpty(activityContractVo.getSupplierCode())) {
              throw new RuntimeException("合同[" + importVo.getContractCode() + "]没有维护供应商");
            }
            itemDto.setSupplierCode(activityContractVo.getSupplierCode());
            itemDto.setSupplierName(activityContractVo.getSupplierName());
          }

          if (StringUtils.isNotEmpty(importVo.getMaterialCode())) {
            PromotionMaterialVO promotionMaterialVO = promotionMaterialMap.get(
                importVo.getMaterialCode());
            if (null == promotionMaterialVO) {
              throw new RuntimeException("物料编码[" + importVo.getMaterialCode() + "]有误");
            }
            itemDto.setMaterialName(promotionMaterialVO.getMaterialName());
          }

//          if (StringUtils.isNotEmpty(importVo.getContractCode()) && StringUtils.isNotEmpty(importVo.getMaterialCode())) {
//            Validate.notBlank(importVo.getMaterialQuantityStr(), "物料数量不能为空");
//            //有合同，有物料，有物料数据，查含税价格
//            ActivityContractMaterialDto activityContractMaterialDto = new ActivityContractMaterialDto();
//            activityContractMaterialDto.setContractNo(importVo.getContractCode());
//            activityContractMaterialDto.setMaterialCode(importVo.getMaterialCode());
//            BigDecimal materialQuantity = null;
//            try {
//              materialQuantity = new BigDecimal(importVo.getMaterialQuantityStr());
//            } catch (Exception e) {
//              log.error("", e);
//              throw new RuntimeException("物料数量[" + importVo.getMaterialQuantityStr() + "]格式有误!");
//            }
//            activityContractMaterialDto.setMaterialQuantity(materialQuantity.intValue());
//            ActivityContractMaterialVo contractMaterialVo = activityContractSdkService.getActivityContractMaterial(activityContractMaterialDto);
//            if (null == contractMaterialVo) {
//              throw new RuntimeException("未获取到合同[" + importVo.getContractCode() + "]物料[" + importVo.getMaterialCode() + "]数量[" + importVo.getMaterialQuantityStr() + "]匹配价格坎级");
//            }
//            if (null != contractMaterialVo.getMoney()) {
//              itemDto.setOriginalSupplyPriceStr(contractMaterialVo.getMoney().toString());
//            }
//          }

          //单件申请费用
          if (StringUtils.isNotEmpty(importVo.getSingleApplicationFeeStr())) {
            try {
              itemDto.setSingleApplicationFee(
                  new BigDecimal(importVo.getSingleApplicationFeeStr()));
            } catch (Exception e) {
              log.error("", e);
              throw new IllegalArgumentException(
                  "单件申请费用金额格式异常[" + importVo.getSingleApplicationFeeStr() + "]");
            }
          }
          //金额字符转化为数值放入对应字段
          if (StringUtils.isNotEmpty(importVo.getPriceStr())) {
            try {
              itemDto.setPrice(new BigDecimal(importVo.getPriceStr()));
            } catch (Exception e) {
              log.error("", e);
              throw new RuntimeException("陈列单价格式有误");
            }
          }
          if (StringUtils.isNotEmpty(importVo.getDisplayQuantityStr())) {
            try {
              itemDto.setDisplayQuantity(Integer.valueOf(importVo.getDisplayQuantityStr()));
            } catch (Exception e) {
              log.error("", e);
              throw new RuntimeException("陈列数量格式有误");
            }
          }
          if (StringUtils.isNotEmpty(importVo.getMonthlyPlannedQuantityStr())) {
            try {
              itemDto.setMonthlyPlannedQuantity(
                  new BigDecimal(importVo.getMonthlyPlannedQuantityStr()));
            } catch (Exception e) {
              log.error("", e);
              throw new RuntimeException("月度计划量格式有误");
            }
          }
          if (StringUtils.isNotEmpty(importVo.getSystemBorneAmountStr())) {
            try {
              itemDto.setSystemBorneAmount(
                  new BigDecimal(importVo.getSystemBorneAmountStr()).setScale(2,
                      RoundingMode.HALF_UP));
              itemDto.setSystemBorneAmountStr(itemDto.getSystemBorneAmount().toString());
            } catch (Exception e) {
              log.error("", e);
              throw new RuntimeException("系统承担金额格式有误");
            }
          }

          itemDto.setFeeDiffLedgerCode(importVo.getFeeDiffLedgerCode());
          itemDto.setUsedAmountStr(importVo.getUsedAmountStr());
          BigDecimal diffUseAmount = BigDecimal.ZERO;
          if (StringUtils.isNotEmpty(importVo.getFeeDiffLedgerCode())) {
            List<String> feeDiffLedgerCodeList = Arrays.asList(importVo.getFeeDiffLedgerCode().replace("，", ",").split(","));
            Validate.notBlank(importVo.getUsedAmountStr(), "差异使用金额" + importVo.getUsedAmountStr() + "不规范");
            List<String> useAmountStrList = Arrays.asList(importVo.getUsedAmountStr().replace("，", ",").split(","));
            List<BigDecimal> useAmountList = Lists.newArrayListWithCapacity(useAmountStrList.size());
            try {
              for (String useAmountStr : useAmountStrList) useAmountList.add(new BigDecimal(useAmountStr));
            } catch (Exception e) {
              throw new IllegalArgumentException("差异使用金额" + importVo.getUsedAmountStr() + "不规范");
            }
            Validate.isTrue(feeDiffLedgerCodeList.size() == useAmountList.size(), "差异费用追踪编码与金额对应错误");
            diffUseAmount = useAmountList.stream().reduce(BigDecimal.ZERO, BigDecimal::add);

            // 预算：差异台账
            itemDto.setAuditFeeDiffTrackDetailLedgerList(new ArrayList<>(feeDiffLedgerCodeList.size()));
            for (int m = 0; m < feeDiffLedgerCodeList.size(); m++) {
              String diffLedgerCode = feeDiffLedgerCodeList.get(m);
              BigDecimal useAmount = useAmountList.get(m);

              AuditFeeDiffLedgerVo diffLedgerVo = diffLedgerMap.get(diffLedgerCode);
              if (null == diffLedgerVo) {
                throw new RuntimeException("差异费用台账" + diffLedgerCode + "无对应数据");
              }
              Validate.isTrue(StringUtils.equals(businessFormatCode, diffLedgerVo.getBusinessFormatCode()), "差异费用台账" + diffLedgerCode + "业态不符");
              Validate.isTrue(StringUtils.equals(businessUnitCode, diffLedgerVo.getBusinessUnitCode()), "差异费用台账" + diffLedgerCode + "业务单元不符");
              Validate.isTrue(StringUtils.equals(importVo.getSystemCode(), diffLedgerVo.getRetailerCode()), "差异费用台账" + diffLedgerCode + "零售商不符");
              Validate.isTrue(StringUtils.equals(AuditStateEnum.CONFIRMED.getCode(), diffLedgerVo.getStatus()), "差异费用台账" + diffLedgerCode + "未确认");
              Validate.isTrue(diffLedgerVo.getBeRecoveredAmount() != null && diffLedgerVo.getBeRecoveredAmount().compareTo(BigDecimal.ZERO) != 0, "差异费用台账" + diffLedgerCode + "待追回金额不可用");

              Validate.isTrue(diffLedgerVo.getBeRecoveredAmount().compareTo(useAmount) >= 0, "差异费用台账" + diffLedgerCode + "可使用金额不足");
              AuditFeeDiffTrackDetailLedgerDto trackDetailLedgerDto = nebulaToolkitService.copyObjectByBlankList(diffLedgerVo, AuditFeeDiffTrackDetailLedgerDto.class, HashSet.class, ArrayList.class);
              trackDetailLedgerDto.setUsedAmount(useAmount);
              // 差异放入
              itemDto.getAuditFeeDiffTrackDetailLedgerList().add(trackDetailLedgerDto);
            }
          }

          try {
            itemDto.setFeeAmount(new BigDecimal(importVo.getFeeAmountStr()));
          } catch (Exception e) {
            throw new IllegalArgumentException("我方承担金额" + importVo.getFeeAmountStr() + "不规范");
          }
          //金额校验
          if (itemDto.getFeeAmount().compareTo(diffUseAmount) != 0) {
            throw new IllegalArgumentException("我方承担金额与差异费用使用金额的和不相等！");
          }

          // 期间促销金额=促销售价*期间促销件数
          if (StringUtils.isNotEmpty(importVo.getPromotionalPriceStr()) && StringUtils.isNotEmpty(importVo.getPeriodPromotionalNumberStr())) {
            try {
              BigDecimal promotionPriceTax = new BigDecimal(importVo.getPromotionPriceTaxStr());
              BigDecimal periodPromotionalNumber = new BigDecimal(importVo.getPeriodPromotionalNumberStr());
              itemDto.setPeriodPromotionalAmount(promotionPriceTax.multiply(periodPromotionalNumber));
              itemDto.setPeriodPromotionalAmountStr(itemDto.getPeriodPromotionalAmount().toString());
            } catch (Exception e) {
              log.error("", e);
              throw new IllegalArgumentException("期间促销金额计算有误!");
            }
          }

          newList.add(itemDto);
        } catch (RuntimeException e) {
          log.error("", e);
          errorList.add(e.getMessage());
        } catch (Exception e) {
          log.error(e.getMessage(), e);
          errorList.add(e.getMessage());
        } finally {
          key++;
        }
      }


      if (errorListMap.size() > 0) {
        log.error("===========================方案导入，错误信息" + JSON.toJSONString(errorListMap));
        for (Map.Entry<Integer, List<String>> entry : errorListMap.entrySet()) {
          List<String> value = entry.getValue();
          if (value.size() > 0) {
            errorMap.put(entry.getKey(), String.join(",", value));
          }
        }
      }

      if (errorMap.size() == 0 && !CollectionUtils.isEmpty(newList)) {
        log.info("差异费用追踪活动导入后的数据：{}", JSON.toJSONString(newList));

        List<AuditFeeDiffTrackDetailDto> list = (List<AuditFeeDiffTrackDetailDto>) nebulaToolkitService.copyCollectionByBlankList(
            newList, AuditFeeDiffTrackDetailImportDto.class, AuditFeeDiffTrackDetailDto.class, HashSet.class, ArrayList.class);

        log.info("差异费用追踪活动导入转换后的数据：{}", JSON.toJSONString(list));
        auditFeeDiffTrackDetailPageCacheHelper.importNewItem(String.valueOf(params.get("cacheKey")), list);
      }
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      String errorMsg = e.getMessage();
      if (StringUtils.isEmpty(e.getMessage())) {
        errorMsg = "数据处理失败！";
      }
      throw new IllegalArgumentException(errorMsg);
    }
    log.info("差异费用追踪活动导入完成");
    return errorMap;
  }

  public void validateAndConvertDictData(Map<String, Map<String, String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc) {
    if (StringUtils.isEmpty(dictValue) || dictMap.isEmpty()) {
      return;
    }
    String[] split = dictValue.split(",");
    List<String> form = Lists.newArrayList();
    for (String s : split) {
      Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
      String code = dictDataMap.get(s);
      form.add(code);
    }
    String dictCode = String.join(",", form);
    if (StringUtils.isEmpty(dictCode)) {
      throw new RuntimeException(desc + "[" + dictValue + "]有误");
    }
    setMethod.accept(dictCode);
  }

  /**
   * 时间格式判断
   *
   * @param currentTime
   * @return
   */
  private boolean isFlag(String currentTime) {
    DateTimeFormatter dtf = DateTimeFormatter.ofPattern(DateUtil.DEFAULT_YEAR_MONTH_DAY);
    boolean flag = true;
    try {
      dtf.parse(currentTime);
    } catch (Exception e) {
      log.error("", e);
      flag = false;
    }
    return flag;
  }

  @Override
  public Class<AuditFeeDiffTrackDetailImportVo> findCrmExcelVoClass() {
    return AuditFeeDiffTrackDetailImportVo.class;
  }

  @Override
  public Integer getBatchCount() {
    return 1000;
  }

  @Override
  public Integer getHeadTitleRowIndex() {
    return 0;
  }

  @Override
  public String getTemplateCode() {
    return "TPM_AUDIT_FEE_DIFF_TRACK_DETAIL_BASE";
  }

  @Override
  public String getTemplateName() {
    return "差异追踪-通用活动导入模板";
  }

  @Override
  public String getBusinessCode() {
    return "TPM_AUDIT_FEE_DIFF_TRACK_DETAIL_IMPORT";
  }

  @Override
  public String getBusinessName() {
    return "TPM-差异费用追踪活动导入";
  }
}
