package com.biz.crm.tpm.business.audit.fee.local.service.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.cost.center.sdk.constant.CostCenterConstant;
import com.biz.crm.mdm.business.dictionary.sdk.constant.DictConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.audit.fee.local.service.imports.vo.AuditFeeDiffDisposeImportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.*;

/**
 * @Description 差异费用处理导入
 * @Author YangWei
 * @Date 2023/2/2 下午4:17
 */
@Slf4j
@Component
public class IAuditFeeDiffDisposeImportProcess implements ImportProcess<AuditFeeDiffDisposeImportVo> {

    @Autowired(required = false)
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Resource
    private DictDataVoService dictDataVoService;

    @Resource
    private AuditFeeDiffDisposeVoService auditFeeDiffDisposeVoService;

    /**
     * 数据字典
     */
    private Map<String, List<DictDataVo>> dictMap = Maps.newHashMap();

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditFeeDiffDisposeImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        final Optional<AuditFeeDiffDisposeImportVo> first = data.values().stream().findFirst();
        if (!first.isPresent()) {
            return null;
        }
        try {
            //初始数据字典
            this.initDict();
            //校验
            AuditFeeDiffDisposeDto dto = this.validate(first.get());
            //导入保存
            this.auditFeeDiffDisposeVoService.importSave(dto);
        } catch (IllegalArgumentException e) {
            throw e;
        } catch (Exception e) {
            String error = ExceptionStackMsgUtil.stackMsg(e);
            log.error("差异费用处理导入异常:{}", error);
            throw new IllegalArgumentException("导入异常[" + error + "]");
        }
        return null;
    }

    /**
     * 初始数据字典
     * @param
     */
    private void initDict() {
        this.dictMap = this.dictDataVoService.findByDictTypeCodeList(
            Lists.newArrayList(AuditFeeConstants.MDM_BUSINESS_FORMAT
                , AuditFeeConstants.MDM_BUSINESS_UNIT, CostCenterConstant.TPM_EXPENSE_CENTER
                , CostCenterConstant.MDM_CUSTOMIZE_ORG));
    }

    /**
     * 校验
     * @param vo
     */
    private AuditFeeDiffDisposeDto validate(AuditFeeDiffDisposeImportVo vo) {
        //数据拷贝
        AuditFeeDiffDisposeDto dto =
            this.nebulaToolkitService.copyObjectByBlankList(
                vo, AuditFeeDiffDisposeDto.class, HashSet.class, ArrayList.class);
        //校验数据字典
        this.verifyDictCode(dto);
        return dto;
    }

    /**
     * 校验数据字典
     * @param dto
     */
    private void verifyDictCode(AuditFeeDiffDisposeDto dto) {

    }

    /**
     * 获取字典对应的value值
     *
     * @param dictValue
     * @param typeCode
     * @return
     */
    private String findDictValueOrCode(String dictValue, String typeCode) {
        DictDataVo dictDataVo = this.dictMap.get(typeCode).stream()
            .filter(a -> a.getDictValue().equals(dictValue) || a.getDictCode().equals(dictValue)).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty(dictDataVo)) {
            return dictDataVo.getDictCode();
        }
        return null;
    }

    @Override
    public Integer getBatchCount() {
        //一次处理1条
        return 1;
    }

    @Override
    public Class<AuditFeeDiffDisposeImportVo> findCrmExcelVoClass() {
        return AuditFeeDiffDisposeImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_AUDIT_FEE_DIFF_DISPOSE_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM-核销差异费用处理导入";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_AUDIT_FEE_DIFF_DISPOSE_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-核销差异费用处理导入";
    }

}