package com.biz.crm.tpm.business.audit.fee.local.service.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * POS活动核对导入vo
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-12-29 21:34
 */
@Data
@ApiModel(value = "AuditFeeCheckPosImportVo", description = "POS活动核对导入vo")
@CrmExcelImport(startRow = 1)
@EqualsAndHashCode(callSuper = true)
public class AuditFeeCheckPosImportVo extends CrmExcelVo {

    @ApiModelProperty("POS核对单号")
    @CrmExcelColumn("POS核对单号")
    private String matchCode;
    private boolean isMatch;

    @ApiModelProperty("POS汇总单号")
    @CrmExcelColumn("POS汇总单号")
    private String matchHeadCode;

    @ApiModelProperty("确认状态")
    private String matchStatus;

    @ApiModelProperty("匹配类型")
    private String matchType;

    @ApiModelProperty("业态")
    @CrmExcelColumn("业态")
    private String businessFormatCode;

    @ApiModelProperty("业务单元")
    @CrmExcelColumn("业务单元")
    private String businessUnitCode;

    @ApiModelProperty("销售机构编码")
    @CrmExcelColumn("销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("销售机构编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty("销售机构名称")
    @CrmExcelColumn("销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("业务区域")
    @CrmExcelColumn("区域")
    private String businessArea;

    @ApiModelProperty("系统编码")
    private String directCode;

    @ApiModelProperty("零售商编码")
    @CrmExcelColumn("零售商编码")
    private String customerRetailerCode;

    @ApiModelProperty("零售商名称")
    @CrmExcelColumn("零售商名称")
    private String customerRetailerName;

    @ApiModelProperty("系统名称")
    private String directName;

    @ApiModelProperty("省编码(门店管理-省)")
    private String provinceCode;

    @ApiModelProperty("省名称(门店管理-省)")
    @CrmExcelColumn("省份")
    private String provinceName;

    @ApiModelProperty("门店编码")
    @CrmExcelColumn("门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    @CrmExcelColumn("门店名称")
    private String terminalName;

    @ApiModelProperty("渠道编码")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    @CrmExcelColumn("渠道名称")
    private String channelName;

    @ApiModelProperty("产品编码")
    @CrmExcelColumn("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    @CrmExcelColumn("产品名称")
    private String productName;

    @ApiModelProperty("单位编码")
    private String unitCode;

    @ApiModelProperty("单位名称")
    @CrmExcelColumn("单位")
    private String unitName;

    @ApiModelProperty("数量")
    @CrmExcelColumn("数量")
    private String productNumberStr;
    private BigDecimal productNumber;

    @ApiModelProperty("年月")
    private String yearMonthLy;

    @ApiModelProperty("销售日期")
    @CrmExcelColumn("销售日期")
    private String salesDateStr;

    @ApiModelProperty("销售日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date salesDate;

    @ApiModelProperty("促销扣款")
    @CrmExcelColumn("促销扣款（元）")
    private String promotionDeductionStr;
    private BigDecimal promotionDeduction;

    @ApiModelProperty("分摊促销扣款")
    @CrmExcelColumn("分摊促销扣款（元）")
    private String sharePromotionDeductionStr;
    private BigDecimal sharePromotionDeduction;

    @ApiModelProperty("单件促销扣款")
    @CrmExcelColumn("单件促销扣款（元）")
    private String onePromotionDeductionStr;
    private BigDecimal onePromotionDeduction;

    @ApiModelProperty("活动细案编码")
    private String activityDetailCode;

    @ApiModelProperty("活动细案名称")
    private String activityDetailName;

    @ApiModelProperty("活动细案明细编码")
    @CrmExcelColumn("活动编码")
    private String activityDetailItemCode;
    private boolean isActivityDetailItem;

    @ApiModelProperty("活动细案明细名称")
    @CrmExcelColumn("活动名称")
    private String activityDetailItemName;

}
