package com.biz.crm.tpm.business.audit.fee.local.service.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @Description
 * @Author YangWei
 * @Date 2023/3/30 下午2:44
 */
@Getter
@Setter
@CrmExcelImport
@EqualsAndHashCode(callSuper = true)
public class AuditFeeDiffDisposeImportVo extends CrmExcelVo {

    /**
     * 差异费用处理名称
     */
    @ApiModelProperty(name = "feeDiffDisposeName", notes = "差异费用处理名称")
    @CrmExcelColumn(value = "*差异费用处理名称")
    private String feeDiffDisposeName;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "businessFormatCode", notes = "业态[数据字典:mdm_business_format]")
    @CrmExcelColumn(value = "*业态")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元[数据字典:mdm_business_unit]")
    @CrmExcelColumn(value = "*业务单元")
    private String businessUnitCode;

    /**
     * 差异费用处理说明
     */
    @ApiModelProperty(name = "diffFeeDisposeIllustrate", notes = "差异费用处理说明")
    @CrmExcelColumn(value = "差异费用处理说明")
    private BigDecimal diffFeeDisposeIllustrate;
}