package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.audit.fee.sdk.dto.AuditFeeReqDto;
import com.biz.crm.kms.business.audit.fee.sdk.service.cost.AuditFeeCostService;
import com.biz.crm.kms.business.audit.fee.sdk.vo.AuditFeeRespVo;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckCost;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckCostRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckCostDto;
import com.biz.crm.tpm.business.audit.fee.sdk.event.check.AuditFeeCheckCostEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckCostVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 核销费用核对关联费用单表(数据源至KMS)(AuditFeeCheckCost)表服务实现类
 *
 * @author makejava
 * @date 2022-11-14 17:32:58
 */
@Slf4j
@Service("auditFeeCheckCostService")
public class AuditFeeCheckCostVoServiceImpl implements AuditFeeCheckCostVoService {

    @Autowired(required = false)
    private AuditFeeCheckCostRepository auditFeeCheckCostRepository;
    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    /**
     * KMS数据拉取
     */
    @Autowired(required = false)
    private AuditFeeCostService auditFeeCostService;

    /**
     * 分页条件查询
     *
     * @param pageable 分页参数
     * @param dto 核销费用核对关联费用单查询dto
     * @return  核销费用核对关联费用单集合
     */
    @Override
    public Page<AuditFeeCheckCostVo> findByConditions(Pageable pageable, AuditFeeCheckCostDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckCostDto());
        Page<AuditFeeCheckCostVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditFeeCheckCostRepository.findByConditions(page, dto);
    }

    /**
     * 根据匹配单号查询 费用核对关联列表
     *
     * @param matchCode 匹配单号
     * @return 费用核对关联列表
     */
    @Override
    public List<AuditFeeCheckCostVo> findDetailByMatchCode(String matchCode) {
        if (StringUtils.isEmpty(matchCode)){
            return new ArrayList<>();
        }

        List<AuditFeeCheckCost> auditFeeCheckCosts = this.auditFeeCheckCostRepository.findDetailByMatchCode(matchCode);
        if (CollectionUtils.isEmpty(auditFeeCheckCosts)){
            return Lists.newArrayList();
        }
        return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(auditFeeCheckCosts,AuditFeeCheckCost.class,AuditFeeCheckCostVo.class,HashSet.class,ArrayList.class));
    }

    @Override
    public List<AuditFeeCheckCostVo> findDetailByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckCost> costVos = auditFeeCheckCostRepository.findByMatchCodes(matchCodes);
        if (CollectionUtils.isEmpty(costVos)) {
            return Lists.newArrayList();
        }
        return (List<AuditFeeCheckCostVo>) nebulaToolkitService.copyCollectionByWhiteList(costVos,AuditFeeCheckCost.class,AuditFeeCheckCostVo.class,HashSet.class,ArrayList.class);
    }

    @Override
    public List<String> findExistByCompanyCodes(List<String> companyCodes) {
        if (CollectionUtils.isEmpty(companyCodes)) {
            return Lists.newArrayList();
        }
        return auditFeeCheckCostRepository.findExistByCompanyCodes(companyCodes);
    }
}
