package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.prediction.AuditFeePredictionVo;
import com.biz.crm.tpm.business.audit.sdk.enumeration.DataSourceEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 核销费用核对关联细案表(AuditFeeCheckDetailPlan)表服务实现类
 *
 * @author makejava
 * @date 2022-12-06 14:27:06
 */
@Slf4j
@Service("auditFeeCheckDetailPlanService")
public class AuditFeeCheckDetailPlanVoServiceImpl implements AuditFeeCheckDetailPlanVoService {

    /**
     * 核销费用核对关联细案表(repository)
     */
    @Autowired
    private AuditFeeCheckDetailPlanRepository auditFeeCheckDetailPlanRepository;

    /**
     * 工具类
     */
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 扣费预测
     */
    @Autowired(required = false)
    private AuditFeePredictionService auditFeePredictionService;

    @Override
    public Page<AuditFeeCheckDetailPlanVo> findByConditions(Pageable pageable, AuditFeeCheckDetailPlanDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckDetailPlanDto());
        Page<AuditFeeCheckDetailPlanVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditFeeCheckDetailPlanRepository.findByConditions(page, dto);
    }

    /**
     * 按id查询详情
     *
     * @param id id
     * @return {@link AuditFeeCheckDetailPlanVo}
     */
    @Override
    public AuditFeeCheckDetailPlanVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        AuditFeeCheckDetailPlan auditFeeCheckDetailPlan = this.auditFeeCheckDetailPlanRepository.findById(id);
        if (auditFeeCheckDetailPlan == null) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(auditFeeCheckDetailPlan, AuditFeeCheckDetailPlanVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public Page<AuditFeeCheckDetailPlanVo> findDetailPlanByConditions(Pageable pageable, AuditFeePredictionDto dto) {
        Validate.notNull(dto, "参数对象不能为空");
        Validate.notNull(dto.getBusinessFormatCode(), "请传入业态");
        Validate.notNull(dto.getBusinessUnitCode(), "请传入业务单元");
        Validate.notNull(dto.getSystemCode(), "请传入零售商编码");
        return this.findDetailPlanByConditionsForImport(pageable, dto);
    }

    @Override
    public Page<AuditFeeCheckDetailPlanVo> findDetailPlanByConditionsForImport(Pageable pageable, AuditFeePredictionDto dto) {

        //分页获取扣费预测
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));

        // 取未完全结案细案数据
        dto.setWholeAudit(BooleanEnum.FALSE.getCapital());
        // 取未完全退回预算细案数据
        dto.setNoRollbackBudgetTagFlag(true);
        // 取可核销金额有值的
        dto.setCanAuditAmountNotNull(false);

        if (StringUtils.equals(BusinessUnitEnum.SON_COMPANY.getCode(), dto.getBusinessUnitCode())) {
            // 分子
            dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
            dto.setDataSource(DataSourceEnum.SON_ACTIVITY_DETAIL.getCode());
        } else {
            // 垂直
            dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            dto.setDataSource(DataSourceEnum.ACTIVITY_DETAIL.getCode());
        }
        // pos查询细案(无需排除匹配中数据)
        Boolean notPosSearch = dto.getNotPosSearch();
        if (notPosSearch != null && notPosSearch) {
            // 设置排除的活动编码集合
            List<String> noConfirmByDetailPlanItemCodeList = auditFeeCheckDetailPlanRepository.findNoConfirmByDetailPlanItemCodeList(null);
            if (CollectionUtils.isNotEmpty(noConfirmByDetailPlanItemCodeList)) {
                dto.setNotInDetailPlanItemCodes(noConfirmByDetailPlanItemCodeList);
            }
        }
        Page<AuditFeePredictionVo> auditFeePredictionVoPage = auditFeePredictionService.findByConditions(pageable, dto);

        return (Page<AuditFeeCheckDetailPlanVo>) auditFeePredictionVoPage.convert(e -> {
            AuditFeeCheckDetailPlanVo detailPlanVo = this.predictionConversionPlanItem(e);
            detailPlanVo.setId(null);
            return detailPlanVo;
        });
    }

    private AuditFeeCheckDetailPlanVo predictionConversionPlanItem(AuditFeePredictionVo itemVo) {
        AuditFeeCheckDetailPlan detailPlan = auditFeeCheckDetailPlanRepository.initOne();
        AuditFeeCheckDetailPlanVo feeCheckDetailPlanVo = nebulaToolkitService.copyObjectByWhiteList(detailPlan, AuditFeeCheckDetailPlanVo.class, HashSet.class, ArrayList.class);
        feeCheckDetailPlanVo.setDetailPlanItemCode(itemVo.getDetailPlanItemCode());
        feeCheckDetailPlanVo.setDetailPlanCode(itemVo.getDetailPlanCode());
        feeCheckDetailPlanVo.setDetailPlanName(itemVo.getDetailPlanName());
        feeCheckDetailPlanVo.setActivityBeginDate(itemVo.getActivityBeginDate());
        feeCheckDetailPlanVo.setActivityEndDate(itemVo.getActivityEndDate());
        feeCheckDetailPlanVo.setActivityYearMonth(DateUtil.format(itemVo.getActivityYearMonth(), "yyyy-MM"));
        feeCheckDetailPlanVo.setSystemCode(itemVo.getSystemCode());
        feeCheckDetailPlanVo.setSystemName(itemVo.getSystemName());
        feeCheckDetailPlanVo.setRegion(itemVo.getRegion());
        feeCheckDetailPlanVo.setRegionName(itemVo.getRegion());
        feeCheckDetailPlanVo.setProvinceCode(itemVo.getProvinceCode());
        feeCheckDetailPlanVo.setProvinceName(itemVo.getProvinceName());
        feeCheckDetailPlanVo.setActivityTypeCode(itemVo.getActivityTypeCode());
        feeCheckDetailPlanVo.setActivityTypeName(itemVo.getActivityTypeName());
        feeCheckDetailPlanVo.setActivityFormCode(itemVo.getActivityFormCode());
        feeCheckDetailPlanVo.setActivityFormName(itemVo.getActivityFormName());
        feeCheckDetailPlanVo.setAuditForm(itemVo.getAuditForm());
        feeCheckDetailPlanVo.setBuyWay(itemVo.getBuyWay());
        feeCheckDetailPlanVo.setCustomerCode(itemVo.getCustomerCode());
        feeCheckDetailPlanVo.setCustomerName(itemVo.getCustomerName());
        feeCheckDetailPlanVo.setTerminalCode(itemVo.getTerminalCode());
        feeCheckDetailPlanVo.setTerminalName(itemVo.getTerminalName());
        feeCheckDetailPlanVo.setProductCode(itemVo.getProductCode());
        feeCheckDetailPlanVo.setProductName(itemVo.getProductName());
        feeCheckDetailPlanVo.setScheduleName(itemVo.getScheduleName());
        feeCheckDetailPlanVo.setApplyAmount(itemVo.getApplyAmount());
        feeCheckDetailPlanVo.setPredictionAuditAmount(itemVo.getPredictionAuditAmount());
        feeCheckDetailPlanVo.setAlreadyAuditAmount(itemVo.getAlreadyAuditAmount());
        feeCheckDetailPlanVo.setCanAuditAmount(itemVo.getCanAuditAmount());
        feeCheckDetailPlanVo.setSalesInstitutionCode(itemVo.getSalesInstitutionCode());
        feeCheckDetailPlanVo.setSalesInstitutionName(itemVo.getSalesInstitutionName());
        feeCheckDetailPlanVo.setSingleApplicationFee(itemVo.getSingleApplicationFee());
        feeCheckDetailPlanVo.setRemark(itemVo.getRemark());
        return feeCheckDetailPlanVo;
    }

    /**
     * 创建批处理
     * 细案每次修改都是删除-新写入，直接将删除方法放在写入内部
     *
     * @param detailPlanVos 详细计划vos
     * @return {@link List}<{@link AuditFeeCheckDetailPlanVo}>
     */
    @Override
    public List<AuditFeeCheckDetailPlanVo> createBatch(List<AuditFeeCheckDetailPlanVo> detailPlanVos) {
        if (CollectionUtils.isEmpty(detailPlanVos)) {
            return new ArrayList<>();
        }

        // 先删除匹配上的细案
        List<String> matchCodeList = detailPlanVos.stream()
                .filter(k -> StringUtils.isNotEmpty(k.getAuditFeeCheckCode()))
                .map(AuditFeeCheckDetailPlanVo::getAuditFeeCheckCode)
                .filter(Objects::nonNull).collect(Collectors.toList());
        auditFeeCheckDetailPlanRepository.removeByMatchCodeList(matchCodeList);
        detailPlanVos.forEach(vo -> {
            vo.setTenantCode(TenantUtils.getTenantCode());
            vo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            vo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            vo.setId(UuidCrmUtil.general());
        });
        if (CollectionUtils.isEmpty(matchCodeList)) {
            // pos匹配活动，无分摊
            auditFeeCheckDetailPlanRepository.save(detailPlanVos);
        } else {
            // 费用核对 匹配活动，有分摊
            auditFeeCheckDetailPlanRepository.saveWithShare(detailPlanVos);
        }
        return detailPlanVos;
    }

    /**
     * 通过核销费用核对表扣费匹配单号获取数据
     *
     * @param matchCodes
     * @return
     */
    @Override
    public List<AuditFeeCheckDetailPlanVo> findByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckDetailPlan> planVos = auditFeeCheckDetailPlanRepository.findByMatchCodes(matchCodes);
        if (CollectionUtils.isEmpty(planVos)) {
            return Lists.newArrayList();
        }
        return (List<AuditFeeCheckDetailPlanVo>) nebulaToolkitService.copyCollectionByWhiteList(planVos, AuditFeeCheckDetailPlan.class, AuditFeeCheckDetailPlanVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public List<AuditFeeCheckDetailPlanVo> findByDetailItemCodes(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckDetailPlan> list = this.auditFeeCheckDetailPlanRepository.findByDetailPlanItemCodeList(itemCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List<AuditFeeCheckDetailPlanVo>) nebulaToolkitService.copyCollectionByWhiteList(list, AuditFeeCheckDetailPlan.class, AuditFeeCheckDetailPlanVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public List<AuditFeeCheckDetailPlanVo> findDetailByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckDetailPlan> list = this.auditFeeCheckDetailPlanRepository.findDetailByMatchCodes(matchCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List<AuditFeeCheckDetailPlanVo>) nebulaToolkitService.copyCollectionByWhiteList(list, AuditFeeCheckDetailPlan.class, AuditFeeCheckDetailPlanVo.class, HashSet.class, ArrayList.class);
    }
}
