package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDiff;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDiffShare;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckDiffRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckDiffShareRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDiffDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditStateEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDiffVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDiffVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 核销费用核对关联费用差异服务
 *
 * @author liyang
 * @date 2023/09/27
 */
@Slf4j
@Service
public class AuditFeeCheckDiffVoServiceImpl implements AuditFeeCheckDiffVoService {

  @Autowired(required = false)
  private AuditFeeCheckDiffRepository auditFeeCheckDiffRepository;

  @Autowired(required = false)
  private AuditFeeCheckDiffShareRepository auditFeeCheckDiffShareRepository;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;

  @Override
  public Page<AuditFeeCheckDiffVo> findByConditions(Pageable pageable, AuditFeeCheckDiffDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
    dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckDiffDto());
    Page<AuditFeeCheckDiffVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.auditFeeCheckDiffRepository.findByConditions(page, dto);
  }

  @Override
  public Page<AuditFeeCheckDiffVo> findDiffLedgerByConditions(Pageable pageable, AuditFeeCheckDiffDto dto) {
    Validate.notNull(dto, "参数对象不能为空");
    Validate.notNull(dto.getBusinessFormatCode(), "请传入业态");
    Validate.notNull(dto.getBusinessUnitCode(), "请传入业务单元");
    Validate.notNull(dto.getRetailerCode(), "请传入零售商编码");

    AuditFeeDiffLedgerDto diffLedgerDto = new AuditFeeDiffLedgerDto();
    BeanUtils.copyProperties(dto, diffLedgerDto);
    diffLedgerDto.setStatus(AuditStateEnum.CONFIRMED.getCode());
    diffLedgerDto.setBeRecoveredAmountNotZero(BooleanEnum.TRUE.getCapital());
    Page<AuditFeeDiffLedgerVo> diffLedgerVoPage = auditFeeDiffLedgerVoService.findByConditions(pageable, diffLedgerDto);

    // 转换成费用核对这边的差异台账数据
    Page<AuditFeeCheckDiffVo> checkDiffVoPage = new Page<>(diffLedgerVoPage.getCurrent(), diffLedgerVoPage.getSize(), diffLedgerVoPage.getTotal());
    if (CollectionUtils.isNotEmpty(diffLedgerVoPage.getRecords())) {
      checkDiffVoPage = (Page<AuditFeeCheckDiffVo>) diffLedgerVoPage.convert(e -> {
        AuditFeeCheckDiffVo checkDiffVo = nebulaToolkitService.copyObjectByWhiteList(e, AuditFeeCheckDiffVo.class, HashSet.class, ArrayList.class);
        checkDiffVo.setAuditFeeCheckDeductCode(null);
        return checkDiffVo;
      });
    }
    return checkDiffVoPage;
  }

  /**
   * 根据匹配单号查询 费用核对关联列表
   *
   * @param matchCode 匹配单号
   * @return 费用核对关联列表
   */
  @Override
  public List<AuditFeeCheckDiffVo> findDetailByMatchCode(String matchCode) {
    if (StringUtils.isEmpty(matchCode)) {
      return new ArrayList<>();
    }
    return auditFeeCheckDiffRepository.findDetailByMatchCode(matchCode);
  }

  @Override
  public void updateDelFlagByMatchCodes(List<String> matchCodes) {
    if (CollectionUtils.isEmpty(matchCodes)) {
      return;
    }
    this.auditFeeCheckDiffRepository.updateDelFlagByMatchCodes(matchCodes);
    this.auditFeeCheckDiffShareRepository.updateDelFlagByMatchCodes(matchCodes);
  }

  @Override
  public List<AuditFeeCheckDiffVo> createBatch(List<AuditFeeCheckDiffVo> checkDiffVos) {
    if (CollectionUtils.isEmpty(checkDiffVos)) {
      return new ArrayList<>();
    }
    ArrayList<AuditFeeCheckDiffShare> diffShares = new ArrayList<>();
    checkDiffVos.forEach(diffVo -> {
      diffVo.setId(UUID.randomUUID().toString().replace("-", ""));
      diffVo.setTenantCode(TenantUtils.getTenantCode());
      diffVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      diffVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());

      AuditFeeCheckDiffShare diffShare = new AuditFeeCheckDiffShare();
      diffShare.setId(UUID.randomUUID().toString().replace("-", ""));
      diffShare.setTenantCode(TenantUtils.getTenantCode());
      diffShare.setAuditFeeCheckDeductCode(diffVo.getAuditFeeCheckDeductCode());
      diffShare.setFeeDiffLedgerCode(diffVo.getFeeDiffLedgerCode());
      diffShare.setDeductAmount(diffVo.getDeductAmount());
      diffShares.add(diffShare);
    });
    Collection<AuditFeeCheckDiff> auditFeeCheckCosts = nebulaToolkitService.copyCollectionByWhiteList(
        checkDiffVos, AuditFeeCheckDiffVo.class, AuditFeeCheckDiff.class, HashSet.class,
        ArrayList.class);
    auditFeeCheckDiffRepository.saveBatch(auditFeeCheckCosts);
    auditFeeCheckDiffShareRepository.saveBatch(diffShares);
    return checkDiffVos;
  }
}
