package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPosHead;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosHeadRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeCheckPosHeadService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeCheckPosConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosHeadDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 核销费用核对POS汇总表 service 实现
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-11-06 19:47
 */
@Slf4j
@Service
public class AuditFeeCheckPosHeadServiceImpl implements AuditFeeCheckPosHeadService {

    @Autowired(required = false)
    private AuditFeeCheckPosHeadRepository auditFeeCheckPosHeadRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;


    /**
     * 新增
     *
     * @param dto
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-11-06 19:52
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void create(AuditFeeCheckPosHeadDto dto) {
        Assert.notNull(dto, "对象不能为空!");
        dto.setId(null);
        if (StringUtil.isEmpty(dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtil.isEmpty(dto.getMatchHeadCode())) {
            dto.setMatchHeadCode(generateCodeService.generateCode(AuditFeeCheckPosConstants.POS_HEAD_CODE, 1).get(0));
        }
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        AuditFeeCheckPosHead entity = nebulaToolkitService.copyObjectByWhiteList(dto, AuditFeeCheckPosHead.class, HashSet.class, ArrayList.class);
        auditFeeCheckPosHeadRepository.save(entity);
    }

    /**
     * 新增
     *
     * @param dtoList
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-11-06 19:52
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createList(List<AuditFeeCheckPosHeadDto> dtoList) {
        Assert.notEmpty(dtoList, "对象不能为空!");
        AtomicInteger index = new AtomicInteger(0);
        String tenantCode = TenantUtils.getTenantCode();
        dtoList.forEach(dto -> {
            dto.setId(null);
            dto.setTenantCode(tenantCode);
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            if (StringUtil.isEmpty(dto.getMatchHeadCode())) {
                index.getAndIncrement();
            }
        });
        if (index.get() > 0) {
            List<String> codeList = generateCodeService.generateCode(AuditFeeCheckPosConstants.POS_HEAD_CODE, index.get());
            dtoList.forEach(dto -> {
                if (StringUtil.isEmpty(dto.getMatchHeadCode())) {
                    dto.setMatchHeadCode(codeList.get(index.decrementAndGet()));
                }
            });
        }
        Collection<AuditFeeCheckPosHead> entityList = nebulaToolkitService.copyCollectionByWhiteList(dtoList,
                AuditFeeCheckPosHeadDto.class, AuditFeeCheckPosHead.class, HashSet.class, ArrayList.class);
        auditFeeCheckPosHeadRepository.saveBatch(entityList);

    }
}
