package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPosHead;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPosLedger;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosHeadRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosLedgerRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosHeadDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosHeadVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosHeadVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:核销费用核对POS表服务
 * @Author qiancheng
 * @Date 2023/5/29
 */
@Slf4j
@Service
public class AuditFeeCheckPosHeadVoServiceImpl implements AuditFeeCheckPosHeadVoService {

    @Autowired(required = false)
    private AuditFeeCheckPosHeadRepository auditFeeCheckPosHeadRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private AuditFeeCheckPosLedgerRepository auditFeeCheckPosLedgerRepository;

    @Autowired(required = false)
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;


    /**
     * 分页查询费用核对Pos数据
     *
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return 分页数据
     */
    @Override
    public Page<AuditFeeCheckPosHeadVo> findByConditions(Pageable pageable, AuditFeeCheckPosHeadDto dto) {
        return this.auditFeeCheckPosHeadRepository.findByConditions(pageable, dto);
    }


    /**
     * 根据id或者编码获取详情
     *
     * @param id
     * @param matchHeadCode
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-10-05 10:49
     */
    @Override
    public AuditFeeCheckPosHeadVo findByIdOrCode(String id, String matchHeadCode) {
        if (StringUtils.isEmpty(id)
                && StringUtils.isEmpty(matchHeadCode)) {
            return null;
        }

        AuditFeeCheckPosHead entity = this.auditFeeCheckPosHeadRepository.findByIdOrCode(id, matchHeadCode);
        if (Objects.isNull(entity)) {
            return null;
        }
        AuditFeeCheckPosHeadVo posHeadVo = nebulaToolkitService.copyObjectByWhiteList(entity, AuditFeeCheckPosHeadVo.class, HashSet.class, ArrayList.class);
        List<AuditFeeCheckPosLedger> posLedgerList = auditFeeCheckPosLedgerRepository.findByMatchHeadCode(entity.getMatchHeadCode());
        if (CollectionUtil.isNotEmpty(posLedgerList)) {
            Map<String, BigDecimal> decimalMap = posLedgerList.stream()
                    .filter(k -> StringUtils.isNotEmpty(k.getFeeDiffLedgerCode()))
                    .filter(k -> Objects.nonNull(k.getDeductAmount()))
                    .collect(Collectors.toMap(AuditFeeCheckPosLedger::getFeeDiffLedgerCode, AuditFeeCheckPosLedger::getDeductAmount, (n, o) -> n));
            if (CollectionUtil.isNotEmpty(decimalMap)) {
                List<AuditFeeDiffLedgerVo> diffLedgerVoList = auditFeeDiffLedgerVoService.findDetailByCodes(new ArrayList<>(decimalMap.keySet()));
                if (CollectionUtil.isNotEmpty(diffLedgerVoList)) {
                    diffLedgerVoList.forEach(item -> {
                        item.setDeductAmount(decimalMap.getOrDefault(item.getFeeDiffLedgerCode(), BigDecimal.ZERO));
                    });
                }
                posHeadVo.setLedgerVoList(diffLedgerVoList);
            }
        }
        return posHeadVo;

    }

}
