package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeCheckPosService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.PosMatchActTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosMatchActivityService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import liquibase.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.*;

/**
 * @Description:核销费用核对POS表服务
 * @Author qiancheng
 * @Date 2023/5/29
 */
@Slf4j
@Service
public class AuditFeeCheckPosServiceImpl implements AuditFeeCheckPosService {

    @Autowired(required = false)
    private AuditFeeCheckPosRepository auditFeeCheckPosRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;

    @Autowired(required = false)
    private AuditFeeCheckPosMatchActivityService auditFeeCheckPosMatchActivityService;

    /**
     * 更新数据
     *
     * @param dto
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-10-05 19:42
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(AuditFeeCheckPosDto dto) {
        this.baseValData(dto);
        if (StringUtil.isNotEmpty(dto.getActivityDetailItemCode())) {
            List<AuditFeeCheckDetailPlanVo> detailPlanVoList;
            AuditFeeCheckPosVo posVo = nebulaToolkitService.copyObjectByWhiteList(dto, AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class);
            if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
                SubComActivityDetailPlanItemVo detailPlanItemVo = subComActivityDetailPlanItemVoService.findDetailByItemCode(dto.getActivityDetailItemCode());
                Assert.notNull(detailPlanItemVo, "活动明细[" + dto.getActivityDetailItemCode() + "]不存在!");
                auditFeeCheckPosMatchActivityService.sonCompanyPosMatchActUpdateVo(posVo, detailPlanItemVo);
                detailPlanVoList = auditFeeCheckPosMatchActivityService.sonCompanyDetailPlanList(Collections.singletonList(detailPlanItemVo));
            } else {
                ActivityDetailPlanItemVo detailPlanItemVo = activityDetailPlanItemSdkService.getActivityDetailPlanItemByCode(dto.getActivityDetailItemCode());
                Assert.notNull(detailPlanItemVo, "活动明细[" + dto.getActivityDetailItemCode() + "]不存在!");
                auditFeeCheckPosMatchActivityService.verticalPosMatchActUpdateVo(posVo, detailPlanItemVo);
                detailPlanVoList = auditFeeCheckPosMatchActivityService.verticalDetailPlanList(Collections.singletonList(detailPlanItemVo));
            }
            posVo.setMatchActivityType(PosMatchActTypeEnum.MANUAL.getCode());
            auditFeeCheckPosMatchActivityService.saveResult(Collections.singletonList(posVo), detailPlanVoList);
        } else {
            this.cancelActMatchActivity(dto);
        }
    }

    /**
     * 数据基础验证
     *
     * @param dto
     */
    private void baseValData(AuditFeeCheckPosDto dto) {
        Assert.notNull(dto, "对象不能为空!");
        Assert.hasLength(dto.getId(), "ID不能为空!");
        Assert.hasLength(dto.getMatchCode(), "扣费匹配单号不能为空!");
        Assert.hasLength(dto.getBusinessUnitCode(), "业务单元编码不能为空!");
        BusinessUnitEnum unitEnum = BusinessUnitEnum.codeToEnum(dto.getBusinessUnitCode());
        Assert.notNull(unitEnum, "业务单元编码[" + dto.getBusinessUnitCode() + "]不合法!");
        if (StringUtil.isNotEmpty(dto.getFeeCheckMatchCode())) {
            dto.setIsMatchCost(BooleanEnum.TRUE.getCapital());
        } else {
            dto.setIsMatchCost(BooleanEnum.FALSE.getCapital());
        }
        dto.setActivityDetailItemCode(StringUtil.trimToEmpty(dto.getActivityDetailItemCode()));
        dto.setActivityDetailItemName(StringUtil.trimToEmpty(dto.getActivityDetailItemName()));
        dto.setActivityDetailCode(StringUtil.trimToEmpty(dto.getActivityDetailCode()));
        dto.setActivityDetailName(StringUtil.trimToEmpty(dto.getActivityDetailName()));
        dto.setCompanyCostCode(StringUtil.trimToEmpty(dto.getCompanyCostCode()));
        dto.setItemIndex(StringUtil.trimToEmpty(dto.getItemIndex()));
        dto.setMatchStatus(BooleanEnum.FALSE.getCapital());
        dto.setMatchTime(null);
        AuditFeeCheckPos entity = auditFeeCheckPosRepository.getById(dto.getId());
        Assert.notNull(entity, "数据不存在,请刷新重试!");
        Assert.isTrue(dto.getMatchCode().equals(entity.getMatchCode()), "扣费匹配单号不能修改!");
        if (BooleanEnum.TRUE.getCapital().equals(entity.getIsMatchCost())) {
            Assert.isTrue(entity.getActivityDetailItemCode().equals(dto.getActivityDetailItemCode()),
                    "POS核对单[" + entity.getMatchCode() + "]已关联费用核对["
                            + entity.getFeeCheckMatchCode() + "]，请先对费用核对操作取消匹配后再处理POS数据!");
        }
        Assert.isTrue(BooleanEnum.FALSE.getCapital().equals(entity.getMatchStatus()),
                "POS核对单[" + entity.getMatchCode() + "]已确认,不可编辑!");
    }

    /**
     * 取消匹配活动
     *
     * @param dto
     */
    private void cancelActMatchActivity(AuditFeeCheckPosDto dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        AuditFeeCheckPos entity = nebulaToolkitService.copyObjectByWhiteList(dto, AuditFeeCheckPos.class, HashSet.class, ArrayList.class);
        entity.setIsMatchActivity(BooleanEnum.FALSE.getCapital());
        //单件申请费用
        entity.setOneApplicationFee(BigDecimal.ZERO);
        //单件费用差异 = 单件促销扣款（元）- 单件申请费用（元）
        entity.setOneDiffAmount(BigDecimal.ZERO);
        //分摊促销扣款
        entity.setSharePromotionDeduction(BigDecimal.ZERO);
        //差异总费用
        entity.setTotalDiffAmount(BigDecimal.ZERO);
        entity.setTotalDiffFinalAmount(BigDecimal.ZERO);
        entity.setDiffType(auditFeeCheckPosMatchActivityService.oneDiffAmountGetDiffType(entity.getTotalDiffFinalAmount(), entity.getActivityDetailItemCode()));
        entity.setMatchActivityType(null);
        auditFeeCheckPosRepository.updateById(entity);
    }

    /**
     * 活动明细分页
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-10-05 23:04
     */
    @Override
    public Page<ActivityDetailPlanItemVo> findActivityDetailPlanItemPage(Pageable pageable, ActivityDetailPlanItemDto dto) {
        Assert.hasLength(dto.getBusinessFormatCode(), "业态不能为空!");
        Assert.hasLength(dto.getBusinessUnitCode(), "业务单元不能为空!");
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return activityDetailPlanItemSdkService.findByConditions(pageable, dto);
    }

    /**
     * 分子活动明细分页
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-10-05 23:04
     */
    @Override
    public Page<SubComActivityDetailPlanItemVo> findSubComActivityDetailPlanItemPage(Pageable pageable, SubComActivityDetailPlanItemDto dto) {
        Assert.hasLength(dto.getBusinessFormatCode(), "业态不能为空!");
        Assert.hasLength(dto.getBusinessUnitCode(), "业务单元不能为空!");
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return subComActivityDetailPlanItemVoService.findByConditions(pageable, dto);
    }
}
