package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.service.InvoiceExpenseSheetVoService;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.vo.InvoiceExpenseSheetVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPosLedger;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosLedgerRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeCheckPosHeadService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeCheckPosConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosHeadDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditDiffUseEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffLedgerOperationTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffLedgerDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosMatchActivityService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description:核销费用核对POS表服务
 * @Author qiancheng
 * @Date 2023/5/29
 */
@Slf4j
@Service
public class AuditFeeCheckPosVoServiceImpl implements AuditFeeCheckPosVoService {

    @Autowired(required = false)
    private AuditFeeCheckPosRepository auditFeeCheckPosRepository;

    @Autowired(required = false)
    private AuditFeeCheckPosLedgerRepository auditFeeCheckPosLedgerRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private AuditFeeCheckPosMatchActivityService auditFeeCheckPosMatchActivityService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;

    @Autowired(required = false)
    private InvoiceExpenseSheetVoService invoiceExpenseSheetVoService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;

    @Autowired(required = false)
    private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;

    @Autowired(required = false)
    private AuditFeeCheckPosHeadService auditFeeCheckPosHeadService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    /**
     * 分页查询费用核对Pos数据
     *
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return 分页数据
     */
    @Override
    public Page<AuditFeeCheckPosVo> findByConditions(Pageable pageable, AuditFeeCheckPosDto dto) {
        return this.auditFeeCheckPosRepository.findByConditions(pageable, dto);
    }


    /**
     * 新增更新
     *
     * @param auditFeeCheckPosVoList
     * @param salesDate
     * @param total
     * @param pageNum
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveOrUpdate(List<AuditFeeCheckPosVo> auditFeeCheckPosVoList, String salesDate, int total, Integer pageNum) {
        if (CollectionUtils.isEmpty(auditFeeCheckPosVoList)) {
            return;
        }
        //List<String> orderNumber = auditFeeCheckPosVoList.stream().map(AuditFeeCheckPosVo::getPosId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<AuditFeeCheckPos> existList = new ArrayList<>();//auditFeeCheckPosRepository.findByPosId(orderNumber);
        Map<String, AuditFeeCheckPos> existMap = existList.stream().collect(Collectors.toMap(AuditFeeCheckPos::getId, Function.identity()));
        for (AuditFeeCheckPosVo posVo : auditFeeCheckPosVoList) {
            /*AuditFeeCheckPos existPos = existMap.get(posVo.getPosId());
            if (!Objects.isNull(existPos)) {
                posVo.setId(existPos.getId());
            }*/
            posVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            posVo.setTenantCode(TenantUtils.getTenantCode());
        }
        Collection<AuditFeeCheckPos> posEntityList = nebulaToolkitService.copyCollectionByWhiteList(auditFeeCheckPosVoList, AuditFeeCheckPosVo.class, AuditFeeCheckPos.class, HashSet.class, ArrayList.class);

        try {
            auditFeeCheckPosRepository.saveOrUpdateBatch(posEntityList);
        } catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("费用核对保存pos数据失败！[日期:" + salesDate + ",总条数:" + total + ",当前页:" + pageNum + "]");
        }

    }

    /**
     * 通过匹配单号查数据
     *
     * @param matchCode
     * @return
     */
    @Override
    public List<AuditFeeCheckPosVo> findByMatchCode(String matchCode) {
        if (StringUtils.isBlank(matchCode)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckPos> list = auditFeeCheckPosRepository.findByMatchCode(matchCode);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List<AuditFeeCheckPosVo>) nebulaToolkitService.copyCollectionByWhiteList(list, AuditFeeCheckPos.class, AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public List<String> findExistByPosId(List<String> posIds) {
        if (CollectionUtils.isEmpty(posIds)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckPos> list = auditFeeCheckPosRepository.findByPosId(posIds);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list.stream().filter(p -> BooleanEnum.TRUE.getCapital().equals(p.getIsMatchCost())).map(AuditFeeCheckPos::getId).distinct().collect(Collectors.toList());
    }


    @Override
    public void updateStatusByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return;
        }
        auditFeeCheckPosRepository.updateStatusByMatchCodes(matchCodes);
    }

    @Override
    public void updateByIds(List<AuditFeeCheckPosVo> updatePosList) {
        if (CollectionUtils.isEmpty(updatePosList)) {
            return;
        }
        Collection<AuditFeeCheckPos> auditFeeCheckPos = nebulaToolkitService.copyCollectionByWhiteList(updatePosList, AuditFeeCheckPosVo.class, AuditFeeCheckPos.class, HashSet.class, ArrayList.class);
        auditFeeCheckPosRepository.updateBatchById(auditFeeCheckPos);
    }

    /**
     * 编辑备注
     *
     * @param dto
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateRemark(AuditFeeCheckPosDto dto) {
        Assert.notNull(dto, "参数对象不能为空!");
        String remark = dto.getRemark();
        Assert.hasLength(remark, "备注不能为空!");
        Assert.isTrue(remark.length() < 600, "备注不能超过600!");
        List<AuditFeeCheckPosVo> checkPosList = this.getIdsAndValData(dto);
        auditFeeCheckPosRepository.updateRemark(checkPosList.stream()
                .map(AuditFeeCheckPosVo::getId).collect(Collectors.toList()), remark);
    }

    /**
     * 取消匹配
     *
     * @param dto
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-10-03 14:39
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void cancelMatch(AuditFeeCheckPosDto dto) {
        Assert.notNull(dto, "参数对象不能为空!");
        List<AuditFeeCheckPosVo> checkPosList = this.getIdsAndValData(dto);
        checkPosList.forEach(item -> {
            Assert.isTrue(BooleanEnum.FALSE.getCapital().equals(item.getIsMatchCost()),
                    "POS核对单[" + item.getMatchCode() + "]已关联费用核对[" + item.getFeeCheckMatchCode() + "]，" +
                            "请先对费用核对操作取消匹配后再处理POS数据！");
            Assert.isTrue(BooleanEnum.FALSE.getCapital().equals(item.getMatchStatus()),
                    "POS核对单[" + item.getMatchCode() + "]已确认,不可取消匹配!");
            Assert.isTrue(BooleanEnum.TRUE.getCapital().equals(item.getIsMatchActivity()),
                    "POS核对单[" + item.getMatchCode() + "]未关联任何活动，不可取消匹配!");
            Assert.isTrue(BusinessUnitEnum.VERTICAL.getCode().equals(item.getBusinessUnitCode())
                            || BusinessUnitEnum.SON_COMPANY.getCode().equals(item.getBusinessUnitCode()),
                    "POS核对单[" + item.getMatchCode() + "]业务单元不合法，不可取消匹配!");

        });
        checkPosList.forEach(item -> {
            item.setMatchActivityType(null);
            if (BusinessUnitEnum.VERTICAL.getCode().equals(item.getBusinessUnitCode())) {
                auditFeeCheckPosMatchActivityService.verticalPosMatchActUpdateVo(item, null);
            } else if (BusinessUnitEnum.SON_COMPANY.getCode().equals(item.getBusinessUnitCode())) {
                auditFeeCheckPosMatchActivityService.sonCompanyPosMatchActUpdateVo(item, null);
            }
        });
        auditFeeCheckPosMatchActivityService.saveResult(checkPosList, null);
    }

    /**
     * 差异核对获取数据
     *
     * @param ids
     * @return java.util.List<com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-10-05 15:28
     */
    @Override
    public List<AuditFeeCheckPosVo> findDiffCheckDataList(List<String> ids) {
        Assert.notEmpty(ids, "请选择数据!");
        List<AuditFeeCheckPos> entityList = auditFeeCheckPosRepository.listByIds(ids);
        Assert.notEmpty(entityList, "选择的数据不存在,请刷新重试!");
        Assert.isTrue(entityList.size() == ids.size(), "查询到的数据条目不对,请刷新列表重试!");
        AtomicInteger index = new AtomicInteger(0);
        //业态+业务单元+区域+零售商+门店+产品
        entityList.forEach(item -> {
            index.getAndIncrement();
            Assert.isTrue(BooleanEnum.FALSE.getCapital().equals(item.getMatchStatus()), "第" + index.get() + "行已核对,不可重复核对!");
            item.setBusinessUnitCode(StringUtils.trim(item.getBusinessUnitCode()));
            item.setBusinessFormatCode(StringUtils.trim(item.getBusinessFormatCode()));
            item.setBusinessArea(StringUtils.trim(item.getBusinessArea()));
            item.setDirectCode(StringUtils.trim(item.getDirectCode()));
            item.setTerminalCode(StringUtils.trim(item.getTerminalCode()));
            item.setProductCode(StringUtils.trim(item.getProductCode()));
        });
        Collection<AuditFeeCheckPosVo> checkPosVos = nebulaToolkitService.copyCollectionByWhiteList(entityList, AuditFeeCheckPos.class, AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class);
        Map<String, List<AuditFeeCheckPosVo>> resultMap = checkPosVos.stream()
                .collect(Collectors.groupingBy(v -> v.getBusinessUnitCode() + v.getBusinessFormatCode() + v.getBusinessArea()
                        + v.getDirectCode() + v.getTerminalCode() + v.getProductCode()));
        List<AuditFeeCheckPosVo> result = new ArrayList<>();
        List<String> matchCodeList = new ArrayList<>();
        resultMap.forEach((key, list) -> {
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            List<String> itemIds = new ArrayList<>();
            List<String> matchCodeItemList = new ArrayList<>();
            Optional<AuditFeeCheckPosVo> posVoOptional = list.stream()
                    .filter(k -> Objects.nonNull(k.getSalesDate()))
                    .max(Comparator.comparing(AuditFeeCheckPosVo::getSalesDate));
            AuditFeeCheckPosVo vo = nebulaToolkitService.copyObjectByWhiteList(posVoOptional.orElse(list.get(0)),
                    AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class);
            vo.setId(key);
            vo.setRemark(null);
            AtomicReference<BigDecimal> totalDiffAmountTotal = new AtomicReference<>(BigDecimal.ZERO);
            AtomicReference<BigDecimal> totalDiffFinalAmountTotal = new AtomicReference<>(BigDecimal.ZERO);
            list.forEach(item -> {
                itemIds.add(item.getId());
                matchCodeItemList.add(item.getMatchCode());
                item.setTotalDiffAmount(Optional.ofNullable(item.getTotalDiffAmount()).orElse(BigDecimal.ZERO));
                totalDiffAmountTotal.set(totalDiffAmountTotal.get().add(item.getTotalDiffAmount()));
                item.setTotalDiffFinalAmount(Optional.ofNullable(item.getTotalDiffFinalAmount()).orElse(BigDecimal.ZERO));
                totalDiffFinalAmountTotal.set(totalDiffFinalAmountTotal.get().add(item.getTotalDiffFinalAmount()));
            });
            vo.setIds(itemIds);
            vo.setMatchCodes(matchCodeItemList);
            matchCodeList.addAll(matchCodeItemList);
            vo.setTotalDiffAmount(totalDiffAmountTotal.get());
            vo.setTotalDiffFinalAmount(totalDiffFinalAmountTotal.get());
            result.add(vo);
        });
        this.setDiffLedgerInfo(matchCodeList, result);
        return result;
    }

    /**
     * 设置差异费用台账 信息
     *
     * @param matchCodeList
     * @param result
     */
    private void setDiffLedgerInfo(List<String> matchCodeList, List<AuditFeeCheckPosVo> result) {
        if (CollectionUtil.isEmpty(matchCodeList)
                || CollectionUtil.isEmpty(result)) {
            return;
        }

        Map<String, AuditFeeDiffLedgerVo> ledgerVoMap = Maps.newHashMap();
        Map<String, String> feeDiffLedgerCodeMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(matchCodeList)) {
            List<AuditFeeCheckPosLedger> posLedgerList = auditFeeCheckPosLedgerRepository.findByMatchCodeList(matchCodeList);
            if (CollectionUtil.isNotEmpty(posLedgerList)) {
                feeDiffLedgerCodeMap.putAll(posLedgerList.stream()
                        .filter(k -> StringUtils.isNotEmpty(k.getMatchCode()))
                        .filter(k -> StringUtils.isNotEmpty(k.getFeeDiffLedgerCode()))
                        .collect(Collectors.toMap(AuditFeeCheckPosLedger::getMatchCode,
                                AuditFeeCheckPosLedger::getFeeDiffLedgerCode, (n, o) -> n)));
                if (CollectionUtil.isNotEmpty(feeDiffLedgerCodeMap)) {
                    List<AuditFeeDiffLedgerVo> ledgerVoList = auditFeeDiffLedgerVoService.findDetailByCodes(new ArrayList<>(feeDiffLedgerCodeMap.values()));
                    if (CollectionUtil.isNotEmpty(ledgerVoList)) {
                        ledgerVoMap.putAll(ledgerVoList.stream()
                                .filter(k -> StringUtils.isNotEmpty(k.getFeeDiffLedgerCode()))
                                .collect(Collectors.toMap(AuditFeeDiffLedgerVo::getFeeDiffLedgerCode, v -> v, (n, o) -> n)));
                    }
                }
            }
        }

        result.forEach(item -> {
            if (CollectionUtil.isNotEmpty(item.getMatchCodes())) {
                List<AuditFeeDiffLedgerVo> diffLedgerVoList = new ArrayList<>();
                item.getMatchCodes().stream()
                        .filter(feeDiffLedgerCodeMap::containsKey)
                        .forEach(matchCode -> {
                            diffLedgerVoList.add(ledgerVoMap.get(feeDiffLedgerCodeMap.get(matchCode)));
                        });
                item.setLedgerVoList(diffLedgerVoList);
            }

        });

    }

    /**
     * 暂存
     *
     * @param dtoList
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-11-04 10:56
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void tempSave(List<AuditFeeCheckPosDto> dtoList) {
        Assert.notEmpty(dtoList, "确认对象不能为空!");
        AtomicInteger index = new AtomicInteger(0);
        Map<String, String> differenceTypeMap = dictToolkitService.findMapByDictTypeCode(AuditFeeCheckPosConstants.DIFFERENCE_TYPE);
        Map<String, String> differentialUseMap = dictToolkitService.findMapByDictTypeCode(AuditFeeCheckPosConstants.DIFFERENTIAL_USE);
        List<String> ids = new ArrayList<>();
        List<AuditFeeCheckPosLedger> posLedgerList = new ArrayList<>();
        String tenantCode = TenantUtils.getTenantCode();
        dtoList.forEach(item -> {
            index.getAndIncrement();
            Assert.notEmpty(item.getIds(), "第" + index.get() + "行ID集合不能为空!");
            Assert.notEmpty(item.getMatchCodes(), "第" + index.get() + "行扣费匹配编码集合不能为空!");
            ids.addAll(item.getIds());
            if (StringUtils.isNotEmpty(item.getDiffType())) {
                Assert.isTrue(differenceTypeMap.containsKey(item.getDiffType()), "第" + index.get() +
                        "行差异类型[" + item.getDiffType() + "]不合法,未在数据字典[" + AuditFeeCheckPosConstants.DIFFERENCE_TYPE + "]中配置!");
            }
            if (StringUtils.isNotEmpty(item.getDiffUse())) {
                Assert.isTrue(differentialUseMap.containsKey(item.getDiffUse()), "第" + index.get() +
                        "行差异使用[" + item.getDiffUse() + "]不合法,未在数据字典[" + AuditFeeCheckPosConstants.DIFFERENTIAL_USE + "]中配置!");
                //差异类型未少扣费,差异使用未抵扣差异
                if (DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode().equals(item.getDiffType())
                        && AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode().equals(item.getDiffUse())
                        && CollectionUtil.isNotEmpty(item.getDiffLedgerVoList())) {
                    item.getDiffLedgerVoList().forEach(diffLedgerVo -> {
                        if (Objects.nonNull(diffLedgerVo)
                                && StringUtils.isNotEmpty(diffLedgerVo.getFeeDiffLedgerCode())) {
                            item.getMatchCodes().forEach(matchCode -> {
                                AuditFeeCheckPosLedger posLedger = new AuditFeeCheckPosLedger();
                                posLedger.setMatchCode(matchCode);
                                posLedger.setFeeDiffLedgerCode(diffLedgerVo.getFeeDiffLedgerCode());
                                posLedger.setDeductAmount(diffLedgerVo.getDeductAmount());
                                posLedger.setTenantCode(tenantCode);
                                posLedger.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                                posLedger.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                                posLedgerList.add(posLedger);
                            });
                        }
                    });
                }
            }
        });
        List<AuditFeeCheckPos> entityList = auditFeeCheckPosRepository.listByIds(ids);
        Assert.notEmpty(entityList, "选择的数据不存在,请刷新重试!");
        Assert.isTrue(entityList.size() == ids.size(), "查询到的数据条目不对,请刷新列表重试!");
        index.set(0);
        List<String> matchCodeList = new ArrayList<>();
        entityList.forEach(item -> {
            index.getAndIncrement();
            matchCodeList.add(item.getMatchCode());
            Assert.isTrue(!BooleanEnum.TRUE.getCapital().equals(item.getMatchStatus()), "第" + index.get() + "行已核对,不可重复核对!");
        });
        auditFeeCheckPosLedgerRepository.removeByMatchCodeList(matchCodeList);
        dtoList.forEach(item -> {
            item.setMatchStatus(BooleanEnum.FALSE.getCapital());
            auditFeeCheckPosRepository.updateFeeCheckPos(item);
        });
        if (CollectionUtil.isNotEmpty(posLedgerList)) {
            auditFeeCheckPosLedgerRepository.saveBatch(posLedgerList);
        }
    }

    /**
     * 确认匹配
     *
     * @param dtoList
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-10-05 09:51
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sureMatch(List<AuditFeeCheckPosDto> dtoList) {
        Assert.notEmpty(dtoList, "确认对象不能为空!");
        AtomicInteger index = new AtomicInteger(0);
        this.baseValData(dtoList);
        List<String> ids = new ArrayList<>();
        List<AuditFeeCheckPosLedger> posLedgerList = new ArrayList<>();
        List<AuditFeeDiffLedgerDto> diffLedgerDtoList = new ArrayList<>();
        List<AuditFeeDiffLedgerDeductionDto> deductionDtoList = new ArrayList<>();
        List<AuditFeeCheckPosHeadDto> posHeadDtoList = new ArrayList<>();
        dtoList.forEach(item -> {
            ids.addAll(item.getIds());
        });
        List<AuditFeeCheckPos> entityList = auditFeeCheckPosRepository.listByIds(ids);
        Assert.notEmpty(entityList, "选择的数据不存在,请刷新重试!");
        Assert.isTrue(entityList.size() == ids.size(), "查询到的数据条目不对,请刷新列表重试!");
        index.set(0);
        List<String> matchCodeList = new ArrayList<>();
        entityList.forEach(item -> {
            Assert.isTrue(!BooleanEnum.TRUE.getCapital().equals(item.getMatchStatus()), "第" + index.get() + "行已核对,不可重复核对!");
            index.getAndIncrement();
            matchCodeList.add(item.getMatchCode());
        });
        index.set(0);
        this.buildDataList(dtoList, posLedgerList, diffLedgerDtoList, deductionDtoList, posHeadDtoList);
        auditFeeCheckPosLedgerRepository.removeByMatchCodeList(matchCodeList);
        if (CollectionUtil.isNotEmpty(posLedgerList)) {
            auditFeeCheckPosLedgerRepository.saveBatch(posLedgerList);
        }
        if (CollectionUtil.isNotEmpty(posHeadDtoList)) {
            auditFeeCheckPosHeadService.createList(posHeadDtoList);
        }
        dtoList.forEach(item -> {
            auditFeeCheckPosRepository.updateFeeCheckPos(item);
        });
        //多扣款时生成差异费用台账
        if (CollectionUtil.isNotEmpty(diffLedgerDtoList)) {
            diffLedgerDtoList.forEach(diffLedgerDto -> {
                auditFeeDiffLedgerVoService.create(diffLedgerDto);
            });
        }
        //少扣款且抵扣差异时扣减关联的差异费用 台账数据
        if (CollectionUtil.isNotEmpty(deductionDtoList)) {
            List<String> feeDiffLedgerCodeList = deductionDtoList.stream()
                    .filter(k -> StringUtil.isNotEmpty(k.getFeeDiffLedgerCode()))
                    .map(AuditFeeDiffLedgerDeductionDto::getFeeDiffLedgerCode).distinct().collect(Collectors.toList());
            boolean lockSuccess = auditFeeDiffLedgerLockService.lock(feeDiffLedgerCodeList, TimeUnit.MINUTES, 3);
            Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
            try {
                if (CollectionUtil.isNotEmpty(deductionDtoList)) {
                    deductionDtoList.forEach(deductionDto -> {
                        auditFeeDiffLedgerVoService.useAmount(deductionDto);
                    });
                }
            } finally {
                auditFeeDiffLedgerLockService.unlock(feeDiffLedgerCodeList);
            }
        }
    }

    /**
     * 构建数据
     *
     * @param dtoList
     * @param posLedgerList
     * @param diffLedgerDtoList
     * @param deductionDtoList
     * @param posHeadDtoList
     */
    private void buildDataList(List<AuditFeeCheckPosDto> dtoList, List<AuditFeeCheckPosLedger> posLedgerList,
                               List<AuditFeeDiffLedgerDto> diffLedgerDtoList, List<AuditFeeDiffLedgerDeductionDto> deductionDtoList,
                               List<AuditFeeCheckPosHeadDto> posHeadDtoList) {
        if (CollectionUtil.isEmpty(dtoList)) {
            return;
        }
        AtomicInteger index = new AtomicInteger(0);
        String tenantCode = TenantUtils.getTenantCode();
        List<String> codeList = generateCodeService.generateCode(AuditFeeCheckPosConstants.POS_HEAD_CODE, dtoList.size());
        AbstractCrmUserIdentity crmUserIdentity = loginUserService.getAbstractLoginUser();
        String realName = crmUserIdentity.getRealName();
        String account = crmUserIdentity.getAccount();
        Date nowDate = new Date();
        dtoList.forEach(item -> {
            item.setMatchStatus(BooleanEnum.TRUE.getCapital());
            AuditFeeCheckPosHeadDto posHeadDto = nebulaToolkitService.copyObjectByWhiteList(item, AuditFeeCheckPosHeadDto.class,
                    HashSet.class, ArrayList.class);
            posHeadDto.setId(null);
            posHeadDto.setCreateAccount(account);
            posHeadDto.setCreateName(realName);
            posHeadDto.setCreateTime(nowDate);
            posHeadDto.setModifyAccount(account);
            posHeadDto.setModifyName(realName);
            posHeadDto.setModifyTime(nowDate);
            posHeadDto.setMatchHeadCode(codeList.get(index.getAndIncrement()));
            String[] yearMonthArray = posHeadDto.getYearMonthLy().split("-");
            posHeadDto.setYear(yearMonthArray[0]);
            posHeadDto.setMonth(yearMonthArray[1]);
            posHeadDtoList.add(posHeadDto);
            item.setMatchHeadCode(posHeadDto.getMatchHeadCode());
            if (DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode().equals(item.getDiffType())
                    || DiffTypeEnum.MORE_DEDUCTION_HAD_DEDUCTION.getCode().equals(item.getDiffType())) {
                AuditFeeDiffLedgerDto diffLedgerDto = new AuditFeeDiffLedgerDto();
                diffLedgerDto.setAuditFeeCheckCode(posHeadDto.getMatchHeadCode());
                diffLedgerDto.setBusinessFormatCode(posHeadDto.getBusinessFormatCode());
                diffLedgerDto.setBusinessUnitCode(posHeadDto.getBusinessUnitCode());
                diffLedgerDto.setFeeYearMonth(posHeadDto.getYearMonthLy());
                diffLedgerDto.setYear(posHeadDto.getYear());
                diffLedgerDto.setMonth(posHeadDto.getMonth());
                diffLedgerDto.setDiffAmount(posHeadDto.getTotalDiffFinalAmount());

                diffLedgerDto.setBusinessAreaCode(posHeadDto.getBusinessArea());
                diffLedgerDto.setRetailerCode(posHeadDto.getCustomerRetailerCode());
                diffLedgerDto.setRetailerName(posHeadDto.getCustomerRetailerName());
                diffLedgerDto.setDeliveryPartyCode(posHeadDto.getTerminalCode());
                diffLedgerDto.setDeliveryPartyName(posHeadDto.getTerminalName());

                diffLedgerDto.setDataSource(DiffLedgerDataSourceEnum.POS_COLLATE.getCode());
                diffLedgerDtoList.add(diffLedgerDto);
            }
            //差异类型未少扣费,差异使用未抵扣差异
            else if (DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode().equals(item.getDiffType())) {
                if (AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode().equals(item.getDiffUse())) {
                    item.getDiffLedgerVoList().forEach(diffLedgerVo -> {
                        AuditFeeDiffLedgerDeductionDto deductionDto = new AuditFeeDiffLedgerDeductionDto();
                        deductionDto.setFeeDiffLedgerCode(diffLedgerVo.getFeeDiffLedgerCode());
                        deductionDto.setRecoveredAmount(diffLedgerVo.getDeductAmount());
                        deductionDto.setBusinessCode(posHeadDto.getMatchHeadCode());
                        deductionDto.setResaleCommercialCode(posHeadDto.getCustomerRetailerCode());
                        deductionDto.setResaleCommercialName(posHeadDto.getCustomerRetailerName());
                        deductionDto.setTerminalCode(posHeadDto.getTerminalCode());
                        deductionDto.setTerminalName(posHeadDto.getTerminalName());
                        deductionDto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.DEDUCTION_AMOUNT.getCode());
                        deductionDto.setOperatorAccount(account);
                        deductionDto.setOperatorName(realName);
                        deductionDto.setRecoveredTime(nowDate);
                        deductionDto.setDataSource(DiffLedgerDataSourceEnum.POS_COLLATE.getCode());
                        deductionDtoList.add(deductionDto);
                        item.getMatchCodes().forEach(matchCode -> {
                            AuditFeeCheckPosLedger posLedger = new AuditFeeCheckPosLedger();
                            posLedger.setMatchHeadCode(posHeadDto.getMatchHeadCode());
                            posLedger.setMatchCode(matchCode);
                            posLedger.setFeeDiffLedgerCode(diffLedgerVo.getFeeDiffLedgerCode());
                            posLedger.setDeductAmount(diffLedgerVo.getDeductAmount());
                            posLedger.setTenantCode(tenantCode);
                            posLedger.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                            posLedger.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                            posLedger.setRemark(item.getRemark());
                            posLedgerList.add(posLedger);
                        });
                    });
                }
            }
        });
    }

    /**
     * 基础验证数据
     *
     * @param dtoList
     */
    private void baseValData(List<AuditFeeCheckPosDto> dtoList) {
        Assert.notEmpty(dtoList, "确认对象不能为空!");
        AtomicInteger index = new AtomicInteger(0);
        Map<String, String> differenceTypeMap = dictToolkitService.findMapByDictTypeCode(AuditFeeCheckPosConstants.DIFFERENCE_TYPE);
        Map<String, String> differentialUseMap = dictToolkitService.findMapByDictTypeCode(AuditFeeCheckPosConstants.DIFFERENTIAL_USE);
        dtoList.forEach(item -> {
            index.getAndIncrement();
            Assert.notEmpty(item.getIds(), "第" + index.get() + "行ID集合不能为空!");
            if (StringUtils.isNotEmpty(item.getRemark())) {
                Assert.isTrue(item.getRemark().length() < 100, "第" + index.get() + "行备注最大长度为100!");
            }
            Assert.notEmpty(item.getMatchCodes(), "第" + index.get() + "行扣费匹配编码集合不能为空!");
            Assert.notNull(item.getSalesDate(), "第" + index.get() + "行销售日期不能为空!");
            Assert.hasLength(item.getSalesDateStr(), "第" + index.get() + "行销售日期不能为空!");
            Assert.hasLength(item.getYearMonthLy(), "第" + index.get() + "行销售日期不能为空!");
            Assert.notNull(item.getTotalDiffFinalAmount(), "第" + index.get() + "行差异金额[totalDiffFinalAmount]不能为空!");
            Assert.hasLength(item.getDiffType(), "第" + index.get() + "行差异类型不能为空!");
            Assert.isTrue(differenceTypeMap.containsKey(item.getDiffType()), "第" + index.get() +
                    "行差异类型[" + item.getDiffType() + "]不合法,未在数据字典[" + AuditFeeCheckPosConstants.DIFFERENCE_TYPE + "]中配置!");
            if (DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode().equals(item.getDiffType())) {
                Assert.hasLength(item.getDiffUse(), "第" + index.get() + "行差异使用不能为空!");
                Assert.isTrue(differentialUseMap.containsKey(item.getDiffUse()), "第" + index.get() +
                        "行差异使用[" + item.getDiffUse() + "]不合法,未在数据字典[" + AuditFeeCheckPosConstants.DIFFERENTIAL_USE + "]中配置!");
                //差异类型未少扣费,差异使用未抵扣差异
                if (AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode().equals(item.getDiffUse())) {
                    Assert.notEmpty(item.getDiffLedgerVoList(), "第" + index.get() + "行,差异类型[" +
                            differenceTypeMap.get(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode()) +
                            "]差异使用[" + differentialUseMap.get(AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode()) +
                            "]时,差异费用不能为空!");
                    AtomicReference<BigDecimal> deductAmountAtomic = new AtomicReference<>(BigDecimal.ZERO);
                    item.getDiffLedgerVoList().forEach(diffLedgerVo -> {
                        Assert.notNull(diffLedgerVo, "第" + index.get() + "行,差异类型[" +
                                differenceTypeMap.get(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode()) +
                                "]差异使用[" + differentialUseMap.get(AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode()) +
                                "]时,费用对象为空!");
                        Assert.hasLength(diffLedgerVo.getFeeDiffLedgerCode(), "第" + index.get() + "行,差异类型[" +
                                differenceTypeMap.get(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode()) +
                                "]差异使用[" + differentialUseMap.get(AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode()) +
                                "]时,差异费用编码不能为空!");
                        Assert.notNull(diffLedgerVo.getDeductAmount(), "第" + index.get() + "行关联的差异费用["
                                + diffLedgerVo.getFeeDiffLedgerCode() + "]抵扣金额[deductAmount]不能为空!");
                        Assert.isTrue(diffLedgerVo.getDeductAmount().compareTo(BigDecimal.ZERO) > 0,
                                "第" + index.get() + "行关联的差异费用[" + diffLedgerVo.getFeeDiffLedgerCode() + "]抵扣金额必须大于0!");
                        deductAmountAtomic.set(deductAmountAtomic.get().add(diffLedgerVo.getDeductAmount()));
                    });
                    Assert.isTrue(item.getTotalDiffFinalAmount().abs().compareTo(deductAmountAtomic.get().abs()) == 0,
                            "抵扣金额汇总的绝对值必须等于差异确认金额的绝对值");
                }
            }
        });
    }


    /**
     * 根据id或者编码获取详情
     *
     * @param id
     * @param matchCode
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-10-05 10:49
     */
    @Override
    public AuditFeeCheckPosVo findByIdOrCode(String id, String matchCode) {
        if (StringUtils.isEmpty(id)
                && StringUtils.isEmpty(matchCode)) {
            return null;
        }

        AuditFeeCheckPos entity = this.auditFeeCheckPosRepository.findByIdOrCode(id, matchCode);
        if (Objects.isNull(entity)) {
            return null;
        }
        AuditFeeCheckPosVo vo = nebulaToolkitService.copyObjectByWhiteList(entity, AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class);
        if (BooleanEnum.TRUE.getCapital().equals(vo.getIsMatchActivity())
                && StringUtils.isNotEmpty(vo.getActivityDetailCode())) {
            if (BusinessUnitEnum.SON_COMPANY.getCode().equals(vo.getBusinessUnitCode())) {
                SubComActivityDetailPlanVo subComPlanVo = subComActivityDetailPlanVoService.findDetailByPlanCode(vo.getActivityDetailCode());
                if (Objects.nonNull(subComPlanVo)) {
                    List<SubComActivityDetailPlanItemVo> itemList = new ArrayList<>();
                    if (StringUtils.isNotEmpty(vo.getActivityDetailItemCode())) {
                        subComPlanVo.getItemList().forEach(item -> {
                            if (vo.getActivityDetailItemCode().equals(item.getConstituentDetailPlanItemCode())) {
                                itemList.add(item);
                            }
                        });
                    }
                    subComPlanVo.setItemList(itemList);
                    vo.setSubComPlanVo(subComPlanVo);
                }
            } else if (BusinessUnitEnum.VERTICAL.getCode().equals(vo.getBusinessUnitCode())) {
                Collection<String> detailPlanCodes = new ArrayList<>();
                detailPlanCodes.add(vo.getActivityDetailCode());
                List<ActivityDetailPlanVo> planVoList = activityDetailPlanSdkService.findByCodes(detailPlanCodes);
                if (CollectionUtil.isNotEmpty(planVoList)) {
                    ActivityDetailPlanVo planVo = planVoList.get(0);
                    if (StringUtils.isNotEmpty(vo.getActivityDetailItemCode())) {
                        ActivityDetailPlanItemVo planItemVo = activityDetailPlanItemSdkService.getActivityDetailPlanItemByCode(vo.getActivityDetailItemCode());
                        if (Objects.nonNull(planItemVo)) {
                            List<ActivityDetailPlanItemVo> planItemVoList = new ArrayList<>();
                            planItemVoList.add(planItemVo);
                            planVo.setActivityDetailPlanItemList(planItemVoList);
                        }
                    }
                    vo.setPlanVo(planVo);
                }

            }
        }

        if (BooleanEnum.TRUE.getCapital().equals(vo.getIsMatchCost())
                && StringUtils.isNotEmpty(vo.getCompanyCostCode())) {
            Integer itemIndex = null;
            if (StringUtils.isNotEmpty(vo.getItemIndex())) {
                itemIndex = Integer.valueOf(vo.getItemIndex());
            }
            InvoiceExpenseSheetVo sheetVo = invoiceExpenseSheetVoService.findByCode(vo.getCompanyCostCode(), itemIndex);
            if (Objects.nonNull(sheetVo)) {
                if (StringUtils.isEmpty(vo.getItemIndex())) {
                    sheetVo.setProductList(null);
                }
                vo.setSheetVo(sheetVo);
            }
        }

        return vo;

    }

    /**
     * 获取ID或者ID集合 验证数据合法性
     *
     * @param dto
     * @return
     */
    private List<AuditFeeCheckPosVo> getIdsAndValData(AuditFeeCheckPosDto dto) {
        List<String> ids = Optional.ofNullable(dto.getIds()).orElse(new ArrayList<>());
        if (StringUtils.isNotEmpty(dto.getId())) {
            ids.add(dto.getId());
        }
        Assert.notEmpty(ids, "参数[id/ids]不能同时为空!");
        List<AuditFeeCheckPos> checkPosList = auditFeeCheckPosRepository.listByIds(ids);
        Assert.notEmpty(checkPosList, "数据不存在,请刷新列表重试!");
        Assert.isTrue(checkPosList.size() == ids.size(), "查询到的数据条目不对,请刷新列表重试!");
        return (List<AuditFeeCheckPosVo>) nebulaToolkitService.copyCollectionByWhiteList(checkPosList, AuditFeeCheckPos.class,
                AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class);

    }

    /**
     * pos匹配活动
     *
     * @param dto
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void matchActivity(AuditFeeCheckPosDto dto) {
        Assert.notNull(dto, "参数不能为空！");
        Assert.notEmpty(dto.getIds(), "参请选择数据！");
        List<AuditFeeCheckPos> posList = this.auditFeeCheckPosRepository.listByIds(dto.getIds());
        Assert.notEmpty(posList, "选择的数据不存在,请刷新重试！");
        List<AuditFeeCheckPosVo> posVoList = (List<AuditFeeCheckPosVo>) nebulaToolkitService.copyCollectionByWhiteList(posList, AuditFeeCheckPos.class, AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class);
        log.info("POS匹配活动,POS条数:{}", posList.size());
        AbstractCrmUserIdentity abstractLoginUser = loginUserService.getAbstractLoginUser();
        auditFeeCheckPosMatchActivityService.posMatchActivityAsync(dto, posVoList, abstractLoginUser);
    }
}
