package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckSelectDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/6/15
 */
@Service
@Slf4j
public class AuditFeeCheckServiceImpl implements AuditFeeCheckService {

    @Autowired(required = false)
    private AuditFeeCheckVoService auditFeeCheckVoService;

    /**
     * 分页条件查询
     *
     * @param pageable 分页对象
     * @param dto  核销费用核对查询DTO
     * @return  核销费用核对列表
     */
    @Override
    public Page<AuditFeeCheckVo> findByConditionsForEct(Pageable pageable, AuditFeeCheckSelectDto dto) {
        return auditFeeCheckVoService.findByConditionsForEct(pageable,dto);
    }
}
