package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.audit.fee.sdk.enums.AuditFeeMatchStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheck;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckCost;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckCostRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async.GenerateAuditFeeCheckCostAsync;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async.GenerateAuditFeeCheckCostAsyncHelper;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async.GenerateAuditFeeCheckMatchFeeAsync;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.auditFeeVerifyDecide.AuditFeeVerifyDecideDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckSelectDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeMatchDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.log.AuditFeeCheckLogEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditDiffUseEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffLedgerOperationTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeVerifyDecideSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditStateEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.ConditionsEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffLedgerDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchResultEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchStatusEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.event.check.AuditFeeCheckLogEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckCostVoCacheService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckCostVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoCacheService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDiffVoCacheService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDiffVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeVerifyDecideService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.DeductionMatchingTemplateTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.FeeAccordingEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.TpmDeductionMatchingTemplateEnums;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateAllowanceService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateAllowanceVo;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDiffVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.prediction.AuditFeePredictionVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.service.TpmDeductionDetailMappingService;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingRelationActivityConfigVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * 核销费用核对主表(AuditFeeCheck)表服务实现类
 *
 * @author makejava
 * @date 2022-11-14 16:56:08
 */
@Slf4j
@Service("auditFeeCheckService")
public class AuditFeeCheckVoServiceImpl implements AuditFeeCheckVoService {

    /**
     * 核销费用核对主表(repository)
     */
    @Autowired(required = false)
    private AuditFeeCheckRepository auditFeeCheckRepository;

    /**
     * 核销差异费用台账(AuditFeeDiffLedger)表服务接口
     */
    @Autowired(required = false)
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;

    /**
     * 核销差异费用台账(AuditFeeDiffLedgerLock)表服务加锁接口
     */
    @Autowired(required = false)
    private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;

    /**
     * 费用核对关联细案(AuditFeeCheckDetailPlan)表缓存服务接口
     */
    @Autowired(required = false)
    private AuditFeeCheckDetailPlanVoCacheService auditFeeCheckDetailPlanVoCacheService;

    /**
     * 费用核对关联费用单(AuditFeeCheckCost)表缓存服务接口
     */
    @Autowired(required = false)
    private AuditFeeCheckCostVoCacheService auditFeeCheckCostVoCacheService;

    /**
     * 费用核对关联差异费用(AuditFeeCheckDiff)表缓存服务接口
     */
    @Autowired(required = false)
    private AuditFeeCheckDiffVoCacheService auditFeeCheckDiffVoCacheService;

    /**
     * 费用核对关联费用单Service
     */
    @Autowired(required = false)
    private AuditFeeCheckCostVoService auditFeeCheckCostVoService;

    /**
     * 费用核对关联费用单Repository
     */
    @Autowired(required = false)
    private AuditFeeCheckCostRepository auditFeeCheckCostRepository;

    /**
     * 费用核对关联差异费用Service
     */
    @Autowired(required = false)
    private AuditFeeCheckDiffVoService auditFeeCheckDiffVoService;

    /**
     * 费用核对关联细案Service
     */
    @Autowired(required = false)
    private AuditFeeCheckDetailPlanVoService auditFeeCheckDetailPlanVoService;

    /**
     * 工具类
     */
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 监听器客户端
     */
    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    /**
     * redis服务
     */
    @Autowired(required = false)
    private RedisLockService redisLockService;

    /**
     * 扣费核定服务
     */
    @Autowired(required = false)
    private AuditFeeVerifyDecideService auditFeeVerifyDecideService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 扣费匹配模板Service
     */
    @Autowired(required = false)
    private TpmDeductionMatchingTemplateService deductionMatchingTemplateService;

    /**
     * 商超扣费映射Service
     */
    @Autowired(required = false)
    private TpmDeductionDetailMappingService deductionDetailMappingService;

    /**
     * 活动细案预测
     * */
    @Autowired(required = false)
    private AuditFeePredictionService auditFeePredictionService;


    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Resource(shareable = false)
    private AuditFeeCheckDetailPlanRepository auditFeeCheckDetailPlanRepository;

    @Autowired(required = false)
    private TpmDeductionMatchingTemplateAllowanceService tpmDeductionMatchingTemplateAllowanceService;

    @Autowired(required = false)
    private GenerateAuditFeeCheckCostAsync generateAuditFeeCheckCostAsync;

    @Autowired(required = false)
    private GenerateAuditFeeCheckMatchFeeAsync generateAuditFeeCheckMatchFeeAsync;

    @Autowired(required = false)
    private GenerateAuditFeeCheckCostAsyncHelper generateAuditFeeCheckCostAsyncHelper;

    @Autowired(required = false)
    private AuditFeeCheckPosRepository auditFeeCheckPosRepository;

    /**
     * 分页条件查询
     *
     * @param pageable
     *            分页对象
     * @param dto
     *            核销费用核对查询DTO
     * @return 核销费用核对列表
     */
    @Override
    public Page<AuditFeeCheckVo> findByConditions(Pageable pageable, AuditFeeCheckDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckDto());
        Page<AuditFeeCheckVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditFeeCheckRepository.findByConditions(page, dto);
    }

    /**
     * 按id查询详情
     *
     * @param id
     *            主键
     * @return 核销费用核对VO对象
     */
    @Override
    public AuditFeeCheckVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        AuditFeeCheck auditFeeCheck = this.auditFeeCheckRepository.findById(id);
        if (auditFeeCheck == null) {
            return null;
        }
        AuditFeeCheckVo auditFeeCheckVo = nebulaToolkitService.copyObjectByWhiteList(auditFeeCheck, AuditFeeCheckVo.class, HashSet.class, ArrayList.class);
        auditFeeCheckVo.setCacheKey(UUID.randomUUID().toString().replace("-", ""));
        return auditFeeCheckVo;
    }

    /**
     * 更新
     *
     * @param auditFeeCheckVo
     *            核销费用核对查询VO对象
     * @return 更新后核销费用核对查询VO对象
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public AuditFeeCheckVo update(AuditFeeCheckVo auditFeeCheckVo, boolean cleanCache) {
        log.info("费用核对保存");
        long a = System.currentTimeMillis();

        Validate.notNull(auditFeeCheckVo.getId(), "修改时ID不能为空");
        String cacheKey = auditFeeCheckVo.getCacheKey();
        Validate.notNull(cacheKey, "cacheKey缺失");
        String currentId = auditFeeCheckVo.getId();
        AuditFeeCheck entity = auditFeeCheckRepository.findById(currentId);
        Validate.notNull(entity, "修改信息不存在");
        Validate.isTrue(!StringUtils.equals(BooleanEnum.TRUE.getCapital(), entity.getIsConfirm()),"已确认的数据不能编辑");
        AuditFeeCheckVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(entity, AuditFeeCheckVo.class, HashSet.class, ArrayList.class);

        AuditFeeCheck feeCheck = this.nebulaToolkitService.copyObjectByWhiteList(auditFeeCheckVo, AuditFeeCheck.class, HashSet.class, ArrayList.class);
        this.auditFeeCheckRepository.updateById(feeCheck);
        log.info("主数据保存：{}", System.currentTimeMillis() - a);

        String matchCode = feeCheck.getMatchCode();

        // 将缓存中的细案关联数据 覆盖到数据库
        auditFeeCheckDetailPlanRepository.updateDelFlagByMatchCodes(Lists.newArrayList(matchCode));
        List<AuditFeeCheckDetailPlanVo> detailPlanCacheList = auditFeeCheckDetailPlanVoCacheService.findCacheList(cacheKey);
        if (CollectionUtils.isNotEmpty(detailPlanCacheList)) {
            detailPlanCacheList.forEach(detailPlanVo -> detailPlanVo.setAuditFeeCheckCode(matchCode));
            auditFeeCheckDetailPlanVoService.createBatch(detailPlanCacheList);
            detailPlanCacheList.clear();
        }
        log.info("细案保存：{}", System.currentTimeMillis() - a);

        // 将缓存中的费用关联数据 覆盖到数据库
        List<String> dbCostCodes = auditFeeCheckCostRepository.findCompanyCostCodeByMatchCodes(Lists.newArrayList(matchCode));
        log.info("1234567890-cost-save-get-db：{}", System.currentTimeMillis() - a);
        List<AuditFeeCheckCostVo> costVos = auditFeeCheckCostVoCacheService.findCacheList(cacheKey);
        log.info("1234567890-cost-save-get-param：{}", System.currentTimeMillis() - a);

        List<AuditFeeCheckCost> newCosts = new ArrayList<>();
        List<String> newCostCodes = new ArrayList<>();
        List<String> deleteCostCodes = null;
        if (CollectionUtils.isNotEmpty(costVos)) {
            // 查当前核对数据 模板，映射
            TpmDeductionMatchingTemplateVo templateVo = deductionMatchingTemplateService.findByCode(feeCheck.getMatchTemplateCode());
            Validate.notNull(templateVo, "核对数据模板缺失");
            TpmDeductionDetailMappingVo mappingVo = deductionDetailMappingService.findByCode(templateVo.getApplyMappingCode());
            Validate.notNull(mappingVo, "核对数据模板映射缺失");
            log.info("1234567890-cost-save-prepare：{}", System.currentTimeMillis() - a);

            List<String> paramCostCodes = new ArrayList<>();
            // 没有MD5Key的全部新增，存在MD5Key的[不做修改]，另找出需要删除的数据
            for (AuditFeeCheckCostVo costVo : costVos) {
                paramCostCodes.add(costVo.getCompanyCostCode());
                if (costVo.getMd5UniqueKey() == null) {
                    // 新增的。原本数据没有，或者唯一编码是空的（删除又选上，会丢失MD5Key）
                    AuditFeeCheckCost cost = new AuditFeeCheckCost();
                    BeanUtils.copyProperties(costVo, cost);
                    cost.setId(null);
                    cost.setAuditFeeCheckCode(matchCode);
                    cost.setTenantCode(TenantUtils.getTenantCode());
                    cost.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    cost.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    newCosts.add(cost);
                    newCostCodes.add(cost.getCompanyCostCode());

                    generateAuditFeeCheckCostAsync.generateCostSummaryUnique(cost, templateVo, mappingVo);
                }
            }
            log.info("1234567890-cost-save-make-up-new：{}", System.currentTimeMillis() - a);
            costVos.clear();
            deleteCostCodes = dbCostCodes.stream().filter(e -> !paramCostCodes.contains(e)).collect(Collectors.toList());
        }
        log.info("1234567890-cost-save-start：{}", System.currentTimeMillis() - a);
        auditFeeCheckCostRepository.updateDelFlagByMatchCodes(deleteCostCodes, matchCode);

        log.info("1234567890-cost-save-clean：{}", System.currentTimeMillis() - a);
        if (CollectionUtils.isNotEmpty(newCosts)) {
            auditFeeCheckCostRepository.saveBatch(newCosts);
            newCosts.clear();
        }
        log.info("1234567890-cost-save-over：{}", System.currentTimeMillis() - a);

        // 如果没确认差异 将缓存中的费用差异关联数据 覆盖到数据库
        if (!BooleanEnum.TRUE.getCapital().equals(auditFeeCheckVo.getIsConfirmDiff())) {
            // 差异使用为 ’抵扣差异‘，保存差异费用信息
            if (AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode().equals(auditFeeCheckVo.getDiffUse())) {
                // 先删除
                auditFeeCheckDiffVoService.updateDelFlagByMatchCodes(Lists.newArrayList(matchCode));
                List<AuditFeeCheckDiffVo> diffVoCacheList = auditFeeCheckDiffVoCacheService.findCacheList(cacheKey);
                if (CollectionUtils.isNotEmpty(diffVoCacheList)) {
                    // 关联号码在抵扣字段
                    diffVoCacheList.forEach(diffVo -> diffVo.setAuditFeeCheckDeductCode(matchCode));
                    auditFeeCheckDiffVoService.createBatch(diffVoCacheList);
                    diffVoCacheList.clear();
                    log.info("差异保存内容：{}", diffVoCacheList);
                }
            }
        }
        log.info("差异保存：{}", System.currentTimeMillis() - a);

        // 发送修改通知
        AuditFeeCheckLogEventDto logEventDto = new AuditFeeCheckLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditFeeCheckVo);
        SerializableBiConsumer<AuditFeeCheckLogEventListener, AuditFeeCheckLogEventDto> onUpdate = AuditFeeCheckLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditFeeCheckLogEventListener.class, onUpdate);
        log.info("event通知：{}", System.currentTimeMillis() - a);

        if (cleanCache) {
            // 最后集中清理缓存，保证数据回滚安全
            auditFeeCheckDetailPlanVoCacheService.clearCache(cacheKey);
            auditFeeCheckCostVoCacheService.clearCache(cacheKey);
            auditFeeCheckDiffVoCacheService.clearCache(cacheKey);
        }
        return auditFeeCheckVo;
    }

    /**
     * 启用批处理
     *
     * @param ids
     *            id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeCheckRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    /**
     * 禁用批处理
     *
     * @param ids
     *            主键列表
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeCheckRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    /**
     * 逻辑删除
     *
     * @param ids
     *            主键列表
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDelFlagByIds(List<String> ids) {
        Validate.notEmpty(ids, "id集合不能为空");
        List<AuditFeeCheck> feeChecks = this.auditFeeCheckRepository.findByIds(ids);
        Validate.notEmpty(feeChecks, "选择的数据不存在");
        List<String> matchedMatchCodeList = feeChecks.stream().filter(e -> MatchStatusEnum.MATCHED.getCode().equals(e.getMatchStatus())).map(AuditFeeCheck::getMatchCode).filter(Objects::nonNull).collect(Collectors.toList());
        Validate.isTrue(CollectionUtils.isEmpty(matchedMatchCodeList),String.join(",", matchedMatchCodeList) + "匹配状态为已匹配，不可删除");
        log.info("费用核对逻辑删除-开始");
        for (AuditFeeCheck feeCheck : feeChecks) {
            if (StringUtils.equals(feeCheck.getIsConfirm(),BooleanEnum.TRUE.getCapital())){
                throw new IllegalArgumentException("匹配单["+ feeCheck.getMatchCode() +"]已确认不可以删除");
            }
            if (StringUtils.equals(feeCheck.getIsConfirmDiff(),BooleanEnum.TRUE.getCapital())){
                throw new IllegalArgumentException("匹配单["+ feeCheck.getMatchCode() +"]差异费用已确认不可以删除");
            }
        }
        List<String> matchCodes = feeChecks.stream().map(AuditFeeCheck::getMatchCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(matchCodes)) return;
        // 确认差异/确认 的数据都不能回退
        generateAuditFeeCheckCostAsyncHelper.deleteByMatchCodes(matchCodes);
    }


    @Override
    public void manualMatchFee(AuditFeeMatchDto auditFeeMatchDto) {
        Validate.notNull(auditFeeMatchDto, "请传入参数");
        List<String> idList = auditFeeMatchDto.getIdList();
        Validate.notEmpty(idList, "请传入id集合");
        List<AuditFeeCheck> list = auditFeeCheckRepository.findByIds(idList);
        Validate.notEmpty(list, "请传入参数");
        List<String> matchedCodes = new ArrayList<>();
        List<String> confirmDiffCodes = new ArrayList<>();
        for (AuditFeeCheck feeCheck : list) {
            if (MatchStatusEnum.MATCHED.getCode().equals(feeCheck.getMatchStatus())) matchedCodes.add(feeCheck.getMatchCode());
            if (BooleanEnum.TRUE.getCapital().equals(feeCheck.getIsConfirm()) || BooleanEnum.TRUE.getCapital().equals(feeCheck.getIsConfirmDiff())) confirmDiffCodes.add(feeCheck.getMatchCode());
        }
        Validate.isTrue(CollectionUtils.isEmpty(matchedCodes), String.join(",", matchedCodes) + "已匹配，请先取消匹配");
        Validate.isTrue(CollectionUtils.isEmpty(confirmDiffCodes), String.join(",", confirmDiffCodes) + "已确认差异，无法再次匹配");

        String lockKey = this.getClass().getName() + ":" + auditFeeMatchDto.hashCode();
        try {
            Validate.isTrue(redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 10), "匹配忙碌，请重试");
            this.matchFee(auditFeeMatchDto);
        } catch (Exception e) {
            log.error("任务执行失败{}", e.getMessage());
            e.printStackTrace();
        } finally {
            redisLockService.unlock(lockKey);
        }
    }

    /**
     * 费用-活动匹配
     *
     * @param auditFeeMatchDto
     *            费用核对匹配dto
     */
    @Override
    public void matchFee(AuditFeeMatchDto auditFeeMatchDto) {
        log.info("费用核对匹配-开始");
        // 记录已匹配但未确认的细案编码
        Set<String> usedActivityDetailPlanItemCodeSet = Sets.newHashSet();
        // 模板
        Map<String,TpmDeductionMatchingTemplateVo> templateMap = Maps.newHashMap();
        // 映射
        Map<String,TpmDeductionDetailMappingVo> mappingVoMap = Maps.newHashMap();
        Map<String, SalesOrgVo> salesOrgVoMap = Maps.newHashMap();
        // 活动配置
        Set<String> activityFormCodes = Sets.newHashSet();

        // --------1 获取费用核对主表数据
        AuditFeeCheckDto dto = new AuditFeeCheckDto();
        dto.setMatchStatus(MatchStatusEnum.WAIT_MATCH.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setMatchCode(auditFeeMatchDto.getMatchCode());
        dto.setMatchCodes(auditFeeMatchDto.getMatchCodes());
        dto.setIdList(auditFeeMatchDto.getIdList());
        // 确认的数据不能重新匹配
        dto.setIsConfirm(BooleanEnum.FALSE.getCapital());
        dto.setIsConfirmDiff(BooleanEnum.FALSE.getCapital());

        log.info("费用核对匹配-筛选条件:{}", JSON.toJSONString(dto));
        // 设置页码只有>=1时才页码设置有效
        Page<AuditFeeCheckVo> page = new Page<>(AuditFeeConstants.PAGE_NUM, AuditFeeConstants.PAGE_SIZE);
        // 设置首页的前一页
        page.setCurrent(0);
        List<AuditFeeCheckVo> feeCheckList;
        // 按页循环
        do {
            page.setCurrent(page.getCurrent() + 1);
            page = this.auditFeeCheckRepository.findByConditions(page, dto);
            if (page == null) break;
            feeCheckList = page.getRecords();
            if (CollectionUtils.isEmpty(feeCheckList)) continue;

            log.info("费用核对匹配-页码:{} 批次数量:{}", page.getCurrent(), feeCheckList.size());

            // --------2 获取对应的模板、映射、销售组织数据，组装为map，供后面使用
            Set<String> templateCodes = feeCheckList.stream().map(AuditFeeCheckVo::getMatchTemplateCode).filter(Objects::nonNull).collect(Collectors.toSet());
            //获取模板数据组装为map
            TpmDeductionMatchingTemplateDto templateDto = new TpmDeductionMatchingTemplateDto();
            templateDto.setCodeList(Lists.newArrayList(templateCodes));
            List<TpmDeductionMatchingTemplateVo> templateVos = deductionMatchingTemplateService.findAllListByConditions(templateDto);
            templateCodes.clear();
            if(CollectionUtils.isNotEmpty(templateVos)){
                templateVos.forEach(e -> templateMap.put(e.getCode(), e));
            }
            log.info("费用核对匹配-页码:{} 模板map:{}", page.getCurrent(), JSON.toJSONString(templateMap));

            //获取映射数据map
            List<TpmDeductionDetailMappingVo> mappingVos = this.deductionDetailMappingService.findByCodes(Lists.newArrayList(templateMap.values().stream().map(TpmDeductionMatchingTemplateVo::getApplyMappingCode).filter(Objects::nonNull).collect(Collectors.toSet())));
            if(CollectionUtils.isNotEmpty(mappingVos)){
                mappingVos.forEach(e -> mappingVoMap.put(e.getCode(), e));
                mappingVos.clear();
            }
            log.info("费用核对匹配-页码:{} 映射数据map:{}", page.getCurrent(), JSON.toJSONString(mappingVoMap));

            //销售组织map构建
            List<String> salesOrgCodeList = feeCheckList.stream().map(AuditFeeCheckVo::getSalesOrgCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<SalesOrgVo> salesOrgVoList = salesOrgVoService.findBySalesOrgCodesPost(salesOrgCodeList);
            salesOrgCodeList.clear();
            if(CollectionUtils.isNotEmpty(salesOrgVoList)){
                salesOrgVoList.forEach(e -> salesOrgVoMap.put(e.getSalesOrgCode(), e));
                salesOrgVoList.clear();
            }
            log.info("费用核对匹配-页码:{} 销售组织map:{}", page.getCurrent(), JSON.toJSONString(salesOrgVoMap));

            // --------3 遍历待匹配的核对数据
            for(AuditFeeCheckVo feeCheckVo : feeCheckList) {
                // 本费用核对集合 匹配到的细案
                List<AuditFeeCheckDetailPlanVo> batchFeeCheckDetailPlanVoList = Lists.newArrayList();
                // 本费用核对集合 匹配到的扣费预测（细案）
                List<AuditFeePredictionVo> auditFeePredictionVoList = new ArrayList<>();

                log.info("费用核对匹配-开始匹配编码:{}", feeCheckVo.getMatchCode());

                // 匹配模板
                TpmDeductionMatchingTemplateVo templateVo = templateMap.get(feeCheckVo.getMatchTemplateCode());
                if(templateVo == null){
                    feeCheckVo.setRemark("未匹配原因：未查询到匹配模板");
                    log.info("费用核对匹配-编码:{}未查询到匹配模板", feeCheckVo.getMatchCode());
                    continue;
                }

                // 匹配容差
                TpmDeductionMatchingTemplateAllowanceVo allowanceVo = null;
                String feeMatchingCondition = templateVo.getFeeMatchingCondition();
                List<TpmDeductionMatchingTemplateAllowanceVo> feeAllowances = templateVo.getFeeAllowances();
                log.info("费用单匹配活动-费用匹配条件设置:{}", JSON.toJSONString(feeMatchingCondition));
                log.info("费用单匹配活动-费用容差集合:{}", JSON.toJSONString(feeAllowances));
                if (feeMatchingCondition.contains(ConditionsEnum.AREA_CODE.getCode())) {
                    for (TpmDeductionMatchingTemplateAllowanceVo feeAllowance : feeAllowances) {
                        if (StringUtils.isBlank(feeAllowance.getApplyBusinessAreaCode())) {
                            // 配置空/空字符串，匹配上
                            allowanceVo = feeAllowance;
                            break;
                        } else {
                            // 配置为明确区域代码，且核对数据上区域不为空/空字符串，配置区域包含核对数据区域，匹配上
                            if (StringUtils.isNotBlank(feeCheckVo.getAreaCode())
                                && feeAllowance.getApplyBusinessAreaCode()
                                .contains(feeCheckVo.getAreaCode())) {
                                allowanceVo = feeAllowance;
                                break;
                            }
                        }
                    }
                } else {
                    allowanceVo = feeAllowances.get(0);
                }
                log.info("费用单匹配活动-匹配的费用容差:{}", JSON.toJSONString(allowanceVo));
                if(allowanceVo == null){
                    feeCheckVo.setRemark("未匹配原因：未查询到容差匹配模板");
                    log.info("费用核对匹配-编码:{}未查询到容差匹配模板", feeCheckVo.getMatchCode());
                    continue;
                }

                // 商超映射
                TpmDeductionDetailMappingVo mappingVo = mappingVoMap.get(templateVo.getApplyMappingCode());
                if(mappingVo == null){
                    feeCheckVo.setRemark("未匹配原因：未查询到商超映射");
                    log.info("费用核对匹配-编码:{}未查询到商超映射", feeCheckVo.getMatchCode());
                    continue;
                }

                // 活动配置，来自映射
                if(CollectionUtils.isNotEmpty(mappingVo.getDeductionDetailMappingRelationActivityConfigList())){
                    Set<String> activityFormCodeSet = mappingVo.getDeductionDetailMappingRelationActivityConfigList().stream().map(TpmDeductionDetailMappingRelationActivityConfigVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toSet());
                    // 记录活动形式code
                    activityFormCodes.addAll(activityFormCodeSet);
                }
                log.info("费用核对匹配-编码:{}活动形式{}", feeCheckVo.getMatchCode(), JSON.toJSONString(activityFormCodes));

                String deductionMatchingTemplateType = templateVo.getDeductionMatchingTemplateType();
                if (DeductionMatchingTemplateTypeEnum.DETAIL_FEE_SETATEMENT.getCode().equals(deductionMatchingTemplateType)) {
                    log.info("费用核对匹配-编码:{}无POS", feeCheckVo.getMatchCode());
                    // 细案-费用单-结算单，匹配活动
                    String businessUnitCode = feeCheckVo.getBusinessUnitCode();
                    // 仅分子/垂直进行活动匹配
                    if(StringUtils.equals(BusinessUnitEnum.VERTICAL.getCode(), businessUnitCode) || StringUtils.equals(BusinessUnitEnum.SON_COMPANY.getCode(), businessUnitCode)) {
                        // 查询扣费预测
                        auditFeePredictionVoList = this.findAuditFeePredictionVoList(feeCheckVo, templateVo, mappingVo, allowanceVo, activityFormCodes, salesOrgVoMap);
                        if (CollectionUtils.isNotEmpty(auditFeePredictionVoList)) {
                            log.info("费用核对匹配-编码:{}无POS 查询预测的数量：{}", feeCheckVo.getMatchCode(), auditFeePredictionVoList.size());
                            // 过滤出可用活动
                            auditFeePredictionVoList = this.filterInvalidPlan(auditFeePredictionVoList, usedActivityDetailPlanItemCodeSet);
                            if (CollectionUtils.isNotEmpty(auditFeePredictionVoList)) {
                                log.info("费用核对匹配-编码:{}无POS 可用的预测数量：{}", feeCheckVo.getMatchCode(), auditFeePredictionVoList.size());
                                // 细案处理数据处理
                                List<AuditFeeCheckDetailPlanVo> thisCheckMatchedDetailPlanVos = this.detailPlanHandle(feeCheckVo, auditFeePredictionVoList);
                                batchFeeCheckDetailPlanVoList.addAll(thisCheckMatchedDetailPlanVos);
                            }
                        }
                    }
                } else if (DeductionMatchingTemplateTypeEnum.DETAIL_POS_FEE_DETAIL_FEE_SETATEMENT.getCode().equals(deductionMatchingTemplateType)) {
                    log.info("费用核对匹配-编码:{}有POS", feeCheckVo.getMatchCode());
                    // 细案-POS-费用单-结算单，匹配pos
                    List<AuditFeeCheckPos> posMatchedList = generateAuditFeeCheckMatchFeeAsync.matchFeePos(feeCheckVo, templateVo, allowanceVo, loginUserService.getAbstractLoginUser());

                    if (CollectionUtils.isNotEmpty(posMatchedList)) {
                        log.info("费用核对匹配-编码:{}有POS 匹配到的pos数量:{}", feeCheckVo.getMatchCode(), posMatchedList.size());
                        List<String> activityDetailItemCodeList = posMatchedList.stream().map(AuditFeeCheckPos::getActivityDetailItemCode).filter(Objects::nonNull).collect(Collectors.toList());
                        // 根据pos关联的 活动细案明细编码，查询扣费预测的活动
                        auditFeePredictionVoList = this.findAuditFeePredictionVoListByPos(feeCheckVo, activityDetailItemCodeList);
                        if (CollectionUtils.isNotEmpty(auditFeePredictionVoList)) {
                            log.info("费用核对匹配-编码:{}有POS 查询预测的数量:{}", feeCheckVo.getMatchCode(), auditFeePredictionVoList.size());
                            // 过滤出可用活动
                            auditFeePredictionVoList = this.filterInvalidPlan(auditFeePredictionVoList, usedActivityDetailPlanItemCodeSet);
                            if (CollectionUtils.isNotEmpty(auditFeePredictionVoList)) {
                                log.info("费用核对匹配-编码:{}有POS 可用的预测数量:{}", feeCheckVo.getMatchCode(), auditFeePredictionVoList.size());
                                // 细案处理数据处理
                                List<AuditFeeCheckDetailPlanVo> thisCheckMatchedDetailPlanVos = this.detailPlanHandle(feeCheckVo, auditFeePredictionVoList);

                                batchFeeCheckDetailPlanVoList.addAll(thisCheckMatchedDetailPlanVos);
                                List<String> thisCheckMatchedDetailPlanVoCodes = thisCheckMatchedDetailPlanVos.stream().map(AuditFeeCheckDetailPlanVo::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList());
                                // 处理完成，更新pos单数据，是否已匹配
                                posMatchedList = posMatchedList.stream().filter(e -> thisCheckMatchedDetailPlanVoCodes.contains(e.getActivityDetailItemCode())).collect(Collectors.toList());
                                generateAuditFeeCheckMatchFeeAsync.updateRelatePos(feeCheckVo, posMatchedList);
                            }
                        }
                    }
                }

                // 完成一个核对的匹配，保存，清理缓存
                // 更新核对数据
                if (MatchStatusEnum.MATCHED.getCode().equals(feeCheckVo.getMatchStatus())) {
                    // 未匹配上会在备注填写原因，匹配上应该清除掉
                    feeCheckVo.setRemark("");
                }
                AuditFeeCheck feeCheck = nebulaToolkitService.copyObjectByBlankList(feeCheckVo, AuditFeeCheck.class, HashSet.class, ArrayList.class);
                this.auditFeeCheckRepository.updateById(feeCheck);

                //保存细案数据
                this.auditFeeCheckDetailPlanRepository.saveWithShare(batchFeeCheckDetailPlanVoList);
                usedActivityDetailPlanItemCodeSet.addAll(batchFeeCheckDetailPlanVoList.stream().map(AuditFeeCheckDetailPlanVo::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList()));
                batchFeeCheckDetailPlanVoList.clear();
                auditFeePredictionVoList.clear();
                // 记录到本次匹配用到的细案编码
            }
            feeCheckList.clear();

            // 清理容器
            salesOrgVoMap.clear();
            mappingVoMap.clear();
            templateMap.clear();

        } while (page.hasNext());

        log.info("费用核对匹配-结束");
    }

    /**
     * 根据匹配上的pos所匹配上的 活动细案明细编码 查询扣费预测
     * @param feeCheckVo
     * @param detailPlanItemCodeList
     * @return
     */
    public List<AuditFeePredictionVo> findAuditFeePredictionVoListByPos(AuditFeeCheckVo feeCheckVo, List<String> detailPlanItemCodeList) {
        if (CollectionUtils.isEmpty(detailPlanItemCodeList)) return new ArrayList<>(0);
        AuditFeePredictionDto queryDto = new AuditFeePredictionDto();
        queryDto.setDetailPlanItemCodes(detailPlanItemCodeList);

        log.info(feeCheckVo.getMatchCode()+"费用核对匹配pos活动查询扣费预测,筛选条件:{}", queryDto);
        Pageable pageable = PageRequest.of(0, AuditFeeConstants.PAGE_SIZE);

        Page<AuditFeePredictionVo> page;
        List<AuditFeePredictionVo> auditFeePredictionVoList = Lists.newArrayList();
        do {
            pageable = pageable.next();
            page = auditFeePredictionService.findByConditions(pageable, queryDto);
            if (page == null) break;
            // 分摊需要将匹配到的细案数据加载到内存，无法分页状态下分摊
            if (CollectionUtils.isNotEmpty(page.getRecords())) auditFeePredictionVoList.addAll(page.getRecords());
        } while (page.hasNext());
        return auditFeePredictionVoList;
    }

    /**
     * 活动匹配：普通费用单 查询扣费预测数据
     * @param feeCheckVo
     * @param templateVo
     * @param mappingVo
     * @param allowanceVo
     * @param activityFormCodes
     * @param salesOrgVoMap
     * @return
     */
    public List<AuditFeePredictionVo> findAuditFeePredictionVoList(AuditFeeCheckVo feeCheckVo,
        TpmDeductionMatchingTemplateVo templateVo,
        TpmDeductionDetailMappingVo mappingVo,
        TpmDeductionMatchingTemplateAllowanceVo allowanceVo,
        Set<String> activityFormCodes,
        Map<String, SalesOrgVo> salesOrgVoMap) {

        // 匹配维度：业态+业务单元+销售机构（非必填）+零售商+客户（非必填）+购买方式（非必填）+关联活动形式+费用单匹配条件+费用单适用区域
        AuditFeePredictionDto queryDto = new AuditFeePredictionDto();
        queryDto.setBusinessFormatCode(feeCheckVo.getBusinessFormatCode());
        queryDto.setBusinessUnitCode(feeCheckVo.getBusinessUnitCode());
        // 销售组织编码
        queryDto.setSalesInstitutionCode(mappingVo.getSalesInstitutionErpCode());
        // 零售商编码
        queryDto.setSystemCode(feeCheckVo.getCustomerRetailerCode());
        // 客户
        if (StringUtils.isNotEmpty(templateVo.getApplyBusinessCustomerCode())) {
            queryDto.setCustomerCode(templateVo.getApplyBusinessCustomerCode());
        } else {
            // 商超映射 找不到客户编码，拼接一个
            SalesOrgVo salesOrgVo = salesOrgVoMap.get(feeCheckVo.getSalesOrgCode());
            queryDto.setCustomerCode(feeCheckVo.getCustomerErpCode() + salesOrgVo.getErpCode() + AuditFeeConstants.VERTICAL_CHANNEL_CODE + templateVo.getBusinessFormatCode());
        }
        queryDto.setBuyWay(mappingVo.getBuyWay());
        queryDto.setActivityFormCodes(new ArrayList<>(activityFormCodes));

        if(StringUtils.isNotEmpty(templateVo.getFeeMatchingCondition())){
            String[] conditions = templateVo.getFeeMatchingCondition().split(",");
            for(String condition : conditions){
                ConditionsEnum conditionsEnum = ConditionsEnum.codeToEnum(condition);
                if (ConditionsEnum.EMPTY.equals(conditionsEnum)) continue;
                switch (conditionsEnum){
                    case PRODUCT_CODE:
                        queryDto.setProductCode(feeCheckVo.getProductCode());
                        break;
                    case TERMINAL_CODE:
                        queryDto.setTerminalCode(feeCheckVo.getTerminalCode());
                        break;
                    case YEAR_MONTH:
                        if (feeCheckVo.getOrderYearMonth() != null) {
                            String timeAllowanceType = allowanceVo.getTimeAllowanceType();
                            if (timeAllowanceType == null){
                                log.error("模板时间容差类型配置错误;");
                                break;
                            }
                            // 年月需要考虑容差，但是时间类型必须为月 ,APPOINT_DATE类型不需要TimeAllowanceUnit、timeAllowanceValue
                            if (!TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(allowanceVo.getTimeAllowanceType())
                                && !TpmDeductionMatchingTemplateEnums.AllowanceUnit.MONTH.getValue().equals(allowanceVo.getTimeAllowanceUnit())) {
                                log.error("适用范围日期类型异常");
                                break;
                            }
                            Integer timeAllowanceValue = allowanceVo.getTimeAllowanceValue();
                            if (!TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(allowanceVo.getTimeAllowanceType()) && timeAllowanceValue == null) {
                                log.error("模板时间容差值配置错误;");
                                break;
                            }
                            boolean isAddUp = BooleanEnum.TRUE.getCapital().equals(feeCheckVo.getIsAddUp());
                            // 计算日期范围，累计标识true不设置开始时间
                            Date orderDate = feeCheckVo.getOrderDate();
                            if (TpmDeductionMatchingTemplateEnums.AllowanceType.POSITIVE.getValue().equals(allowanceVo.getTimeAllowanceType())) {
                                // 向未来加月并设置月末
                                if (!isAddUp) queryDto.setActivityEndDateStart(generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, 0, true));
                                queryDto.setActivityEndDateEnd(generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, timeAllowanceValue, false));
                            } else if (TpmDeductionMatchingTemplateEnums.AllowanceType.POSITIVE_POINT.getValue().equals(timeAllowanceType)) {
                                // 向未来加月并设置起始时间为目标月
                                if (!isAddUp) queryDto.setActivityEndDateStart(generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, timeAllowanceValue, true));
                                queryDto.setActivityEndDateEnd(generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, timeAllowanceValue, false));
                            } else if (TpmDeductionMatchingTemplateEnums.AllowanceType.NEGATIVE.getValue().equals(allowanceVo.getTimeAllowanceType())) {
                                // 向历史加月并设置月初
                                if (!isAddUp) queryDto.setActivityEndDateStart(generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, - timeAllowanceValue, true));
                                queryDto.setActivityEndDateEnd(generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, 0, false));
                            } else if (TpmDeductionMatchingTemplateEnums.AllowanceType.NEGATIVE_POINT.getValue().equals(timeAllowanceType)) {
                                // 向历史加月并设置起始时间为目标月
                                if (!isAddUp) queryDto.setActivityEndDateStart(generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, - timeAllowanceValue, true));
                                queryDto.setActivityEndDateEnd(generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, - timeAllowanceValue, false));
                            } else if (TpmDeductionMatchingTemplateEnums.AllowanceType.INTEGER.getValue().equals(allowanceVo.getTimeAllowanceType())) {
                                // 向未来，历史加月并设置起始时间为目标月
                                if (!isAddUp) queryDto.setActivityEndDateStart(generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, - timeAllowanceValue, true));
                                queryDto.setActivityEndDateEnd(generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, timeAllowanceValue, false));
                            } else if (TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(allowanceVo.getTimeAllowanceType())) {
                                // 指定区间
                                if (allowanceVo.getBeginDate() == null || allowanceVo.getEndDate() == null) {
                                    log.info("模板时间容差指定区间配置错误;");
                                    break;
                                }
                                if (!isAddUp) queryDto.setActivityEndDateStart(generateAuditFeeCheckMatchFeeAsync.adjustMonth(DateUtil.parseDate(allowanceVo.getBeginDate()+"-01"), 0, true));
                                queryDto.setActivityEndDateEnd(generateAuditFeeCheckMatchFeeAsync.adjustMonth(DateUtil.parseDate(allowanceVo.getEndDate()+"-01"), 0, false));
                            } else {
                                break;
                            }
                        }
                        break;
                    case PROVINCE:
                        queryDto.setProvinceCode(feeCheckVo.getProvinceCode());
                        break;
                    case AREA_CODE:
                        queryDto.setRegion(feeCheckVo.getAreaCode());
                        break;
                    case SCHEDULE:
                        queryDto.setScheduleName(feeCheckVo.getSlotDateName());
                    case FEE_CODE:
                        break;
                    case CHANNEL:
                        // 映射上有渠道，费用没有，这里不用渠道进行匹配
//                        queryDto.setChannelCode(mappingVo.getChannelCode());
                    case ACTIVITY_FORM_DESC:
                        queryDto.setActivityFormDesc(feeCheckVo.getActivityFormDesc());
                    default:
                        break;
                }
            }
        }
        // 设置一些过滤状态 取未完全结案细案数据、取未完全退回预算细案数据
        // 取未完全结案细案数据
        queryDto.setWholeAudit(BooleanEnum.FALSE.getCapital());
        // 取未完全退回预算细案数据
        queryDto.setNoRollbackBudgetTagFlag(true);

        log.info(feeCheckVo.getMatchCode()+"费用核对匹配活动查询扣费预测,筛选条件:{}", JSON.toJSONString(queryDto));
        Pageable pageable = PageRequest.of(0, AuditFeeConstants.PAGE_SIZE);

        Page<AuditFeePredictionVo> page;
        List<AuditFeePredictionVo> auditFeePredictionVoList = Lists.newArrayList();
        do {
            pageable = pageable.next();
            page = auditFeePredictionService.findByConditions(pageable, queryDto);
            if (page == null) break;
            if (CollectionUtils.isNotEmpty(page.getRecords())) auditFeePredictionVoList.addAll(page.getRecords());
        } while (page.hasNext());
        return auditFeePredictionVoList;
    }

    /**
     * 过滤出扣费预测中可用活动
     * @param auditFeePredictionVoList
     * @param usedActivityDetailPlanItemCodeSet
     * @return
     */
    public List<AuditFeePredictionVo> filterInvalidPlan(List<AuditFeePredictionVo> auditFeePredictionVoList, Set<String> usedActivityDetailPlanItemCodeSet) {
        // 使用所有查询到的细案编码，作为参数查询核对关联数据中，已匹配但未确认的细案编码，即不可用活动
        List<String> planItemVoCodeAllList = auditFeePredictionVoList.stream().map(AuditFeePredictionVo::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> usedDetailPlanItemCodes = auditFeeCheckDetailPlanRepository.findNoConfirmByDetailPlanItemCodeList(planItemVoCodeAllList);
        // 记录已匹配但未确认的细案编码
        if(CollectionUtils.isNotEmpty(usedDetailPlanItemCodes)){
            usedActivityDetailPlanItemCodeSet.addAll(usedDetailPlanItemCodes);
        }
        // 未匹配/匹配且确定的活动编码
        auditFeePredictionVoList = auditFeePredictionVoList.stream().filter(o -> !usedActivityDetailPlanItemCodeSet.contains(o.getDetailPlanItemCode())).collect(Collectors.toList());
        return auditFeePredictionVoList;
    }

    /**
     * 单个费用核对 匹配到的细案数据处理（垂直/分子）
     * @param feeCheckVo 费用核对主数据
     * @param auditFeePredictionVoList 查询到的扣费预测数据（要转细案）
     */
    private List<AuditFeeCheckDetailPlanVo> detailPlanHandle(AuditFeeCheckVo feeCheckVo, List<AuditFeePredictionVo> auditFeePredictionVoList) {
        log.info("费用核对匹配活动-开始处理匹配到的活动");
        // 这个费用额核对匹配到的未分摊的活动
        List<AuditFeeCheckDetailPlanVo> thisCheckDetailPlanVos = new ArrayList<>();
        //查找到的细案数据，在这里进行汇总
        for (AuditFeePredictionVo predictDetailPlanVo : auditFeePredictionVoList) {
            // 可核销费用为null 不使用该细案
            if (predictDetailPlanVo.getCanAuditAmount() == null) continue;

            AuditFeeCheckDetailPlan detailPlan = auditFeeCheckDetailPlanRepository.initOne();
            AuditFeeCheckDetailPlanVo feeCheckDetailPlanVo = nebulaToolkitService.copyObjectByWhiteList(detailPlan, AuditFeeCheckDetailPlanVo.class, HashSet.class, ArrayList.class);
            feeCheckDetailPlanVo.setAuditFeeCheckCode(feeCheckVo.getMatchCode());
            feeCheckDetailPlanVo.setDetailPlanItemCode(predictDetailPlanVo.getDetailPlanItemCode());
            feeCheckDetailPlanVo.setDetailPlanCode(predictDetailPlanVo.getDetailPlanCode());
            feeCheckDetailPlanVo.setDetailPlanName(predictDetailPlanVo.getDetailPlanName());
            feeCheckDetailPlanVo.setActivityBeginDate(predictDetailPlanVo.getActivityBeginDate());
            feeCheckDetailPlanVo.setActivityEndDate(predictDetailPlanVo.getActivityEndDate());
            feeCheckDetailPlanVo.setActivityYearMonth(com.biz.crm.mn.common.base.util.DateUtil.format(predictDetailPlanVo.getActivityYearMonth(), "yyyy-MM"));
            feeCheckDetailPlanVo.setSystemCode(predictDetailPlanVo.getSystemCode());
            feeCheckDetailPlanVo.setSystemName(predictDetailPlanVo.getSystemName());
            feeCheckDetailPlanVo.setRegion(predictDetailPlanVo.getRegion());
            feeCheckDetailPlanVo.setRegionName(predictDetailPlanVo.getRegion());
            feeCheckDetailPlanVo.setProvinceCode(predictDetailPlanVo.getProvinceCode());
            feeCheckDetailPlanVo.setProvinceName(predictDetailPlanVo.getProvinceName());
            feeCheckDetailPlanVo.setActivityTypeCode(predictDetailPlanVo.getActivityTypeCode());
            feeCheckDetailPlanVo.setActivityTypeName(predictDetailPlanVo.getActivityTypeName());
            feeCheckDetailPlanVo.setActivityFormCode(predictDetailPlanVo.getActivityFormCode());
            feeCheckDetailPlanVo.setActivityFormName(predictDetailPlanVo.getActivityFormName());
            feeCheckDetailPlanVo.setAuditForm(predictDetailPlanVo.getAuditForm());
            feeCheckDetailPlanVo.setBuyWay(predictDetailPlanVo.getBuyWay());
            feeCheckDetailPlanVo.setCustomerCode(predictDetailPlanVo.getCustomerCode());
            feeCheckDetailPlanVo.setCustomerName(predictDetailPlanVo.getCustomerName());
            feeCheckDetailPlanVo.setTerminalCode(predictDetailPlanVo.getTerminalCode());
            feeCheckDetailPlanVo.setTerminalName(predictDetailPlanVo.getTerminalName());
            feeCheckDetailPlanVo.setProductCode(predictDetailPlanVo.getProductCode());
            feeCheckDetailPlanVo.setProductName(predictDetailPlanVo.getProductName());
            feeCheckDetailPlanVo.setScheduleName(predictDetailPlanVo.getScheduleName());
            feeCheckDetailPlanVo.setApplyAmount(predictDetailPlanVo.getApplyAmount());
            feeCheckDetailPlanVo.setPredictionAuditAmount(predictDetailPlanVo.getPredictionAuditAmount());
            feeCheckDetailPlanVo.setAlreadyAuditAmount(predictDetailPlanVo.getAlreadyAuditAmount());
            feeCheckDetailPlanVo.setCanAuditAmount(predictDetailPlanVo.getCanAuditAmount());
            feeCheckDetailPlanVo.setSalesInstitutionCode(predictDetailPlanVo.getSalesInstitutionCode());
            feeCheckDetailPlanVo.setSalesInstitutionName(predictDetailPlanVo.getSalesInstitutionName());
            feeCheckDetailPlanVo.setRemark(predictDetailPlanVo.getRemark());
            feeCheckDetailPlanVo.setActivityFormDesc(predictDetailPlanVo.getActivityFormDesc());
            // 查询到的都算匹配上了
            thisCheckDetailPlanVos.add(feeCheckDetailPlanVo);
        }
        // 执行分摊逻辑
        thisCheckDetailPlanVos = this.detailPlanShare(feeCheckVo, thisCheckDetailPlanVos);
        return thisCheckDetailPlanVos;
    }

    /**
     * 匹配任务
     */
    @Override
    public void matchJob() {
        loginUserService.refreshAuthentication(null);
        boolean lock = true;
        String lockKey = DateUtil.format(new Date(), com.biz.crm.mn.common.base.util.DateUtil.DEFAULT_YEAR_MONTH_DAY);
        try {
            lock = this.lock(lockKey);
            this.matchFee(new AuditFeeMatchDto());
        } catch (Exception e) {
            log.error("任务执行失败{}", e.getMessage());
            e.printStackTrace();
        } finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    /**
     * 抽取核对数据
     * @param auditFeeMatchDto
     */
    @Override
    public void pullKmsData(AuditFeeMatchDto auditFeeMatchDto) {
        Validate.notNull(auditFeeMatchDto,"传入数据空");
        Validate.notNull(auditFeeMatchDto.getMatchTemplateCode(),"传入匹配模板编码空");
        //先获取到模板信息
        TpmDeductionMatchingTemplateDto tpmDeductionMatchingTemplateDto = new TpmDeductionMatchingTemplateDto();
        tpmDeductionMatchingTemplateDto.setCodeList(Lists.newArrayList(auditFeeMatchDto.getMatchTemplateCode()));
        List<TpmDeductionMatchingTemplateVo> templateList = deductionMatchingTemplateService.findAllListByConditions(tpmDeductionMatchingTemplateDto);
        Validate.notEmpty(templateList,"未查询到模板信息！["+auditFeeMatchDto.getMatchTemplateCode()+"]");
        TpmDeductionMatchingTemplateVo feeMatchTemplate = templateList.get(0);
        log.info("拉取使用的模板信息:{}", JSON.toJSONString(feeMatchTemplate));
        AbstractCrmUserIdentity abstractLoginUser = loginUserService.getAbstractLoginUser();

        //费用单 | Pos
        if(DeductionMatchingTemplateTypeEnum.DETAIL_FEE_SETATEMENT.getCode().equals(feeMatchTemplate.getDeductionMatchingTemplateType())
            || DeductionMatchingTemplateTypeEnum.DETAIL_POS_FEE_DETAIL_FEE_SETATEMENT.getCode().equals(feeMatchTemplate.getDeductionMatchingTemplateType())){
            generateAuditFeeCheckCostAsync.generateForCostOrderAsync(auditFeeMatchDto, feeMatchTemplate, abstractLoginUser);
        } else {
            log.info("模板不合适");
            throw new IllegalArgumentException("模板不合适");
        }
    }

    /**
     * 抽数定时任务
     */
    @Override
    public void pullKmsDataAndMatchTask() {
        log.info("拉取费用单任务 执行开始");
        loginUserService.refreshAuthentication(null);
        boolean lock = true;
        String lockKey = DateUtil.format(new Date(), com.biz.crm.mn.common.base.util.DateUtil.DEFAULT_YEAR_MONTH_DAY);
        try {
            lock = this.lock(lockKey);

            // 回退所有待确认的数据
            this.backAllToBeConfirmed();

            // 分页获取所有启用的模板
            TpmDeductionMatchingTemplateDto templateDto = new TpmDeductionMatchingTemplateDto();
            // 限定模板
            List<String> templateTypeList = Lists.newArrayList(DeductionMatchingTemplateTypeEnum.DETAIL_FEE_SETATEMENT.getCode(), DeductionMatchingTemplateTypeEnum.DETAIL_POS_FEE_DETAIL_FEE_SETATEMENT.getCode());
            // 暂时不管业态业务单元
            templateDto.setDeductionMatchingTemplateTypeList(templateTypeList);
            templateDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            templateDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            List<TpmDeductionMatchingTemplateVo> templateVoList = deductionMatchingTemplateService.findAllListByConditions(templateDto);

            log.info("拉取费用单任务 预计执行模板数量:{}", templateVoList.size());
            // 抽取上个月的数据
            AuditFeeMatchDto auditFeeMatchDto = new AuditFeeMatchDto();
            // 默认时间范围[前两月,当前时间]
            DateTime lastTwoMonth = DateUtil.offsetMonth(new DateTime(), -2);
            auditFeeMatchDto.setStartTime(DateUtil.beginOfMonth(lastTwoMonth));
            auditFeeMatchDto.setEndTime(new DateTime());
            AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();
            if (CollectionUtils.isNotEmpty(templateVoList)) {
                for (TpmDeductionMatchingTemplateVo templateVo : templateVoList) {
                    // 考虑到KMS单接口慢，暂不用异步
                    try {
                        generateAuditFeeCheckCostAsync.generateForCostOrder(auditFeeMatchDto, templateVo, loginUser);
                    } catch (Exception e) {
                        log.error("模板:{} 名称:{} 拉取费用单 执行失败:{}", templateVo.getCode(), templateVo.getName(), e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        } catch (Exception e) {
            log.error("费用抓单任务 执行失败:{}", e.getMessage());
            e.printStackTrace();
        } finally {
            if (lock) {
                this.unLock(lockKey);
            }
            log.info("拉取费用单任务 执行完成");
        }

        log.info("拉取费用单任务 抓取完毕，开始匹配");
        // 同步处理完，进行匹配，不用定时任务去匹配。手动拉取模板，需要手动匹配。
        this.matchFee(new AuditFeeMatchDto());
    }

    @Transactional(rollbackFor = Exception.class, propagation = Propagation.NOT_SUPPORTED)
    public void backAllToBeConfirmed() {
        Pageable pageable = PageRequest.of(1, 800);
        Page<String> page = null;
        AuditFeeCheckDto dto = new AuditFeeCheckDto();
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setIsConfirmDiff(BooleanEnum.FALSE.getCapital());
        dto.setIsConfirm(BooleanEnum.FALSE.getCapital());
        log.info("=====>    拉取费用单任务 历史数据回退 start    <=====");
        do {
            page = this.auditFeeCheckRepository.findNotConfirmedDiffPage(pageable, dto);
            pageable = pageable.next();
            log.info("=====>    拉取费用单任务 历史数据回退 [{}/{}]    <=====", page.getCurrent(), page.getPages());
            if (CollectionUtil.isEmpty(page.getRecords())) {
                return;
            }
            // 确认差异/确认 的数据都不能回退
            generateAuditFeeCheckCostAsyncHelper.deleteByMatchCodes(page.getRecords());
        } while (page.hasNext() && pageable.getPageNumber() > 10000);
        log.info("=====>    拉取费用单任务 历史数据回退 end    <=====");

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void confirm(AuditFeeCheckVo auditFeeCheckVo) {
        log.info("费用核对确认");
        // 约定传入全部字段
        Validate.notNull(auditFeeCheckVo, "提交确认的数据不能为空");
        long a = System.currentTimeMillis();

        Validate.isTrue(MatchStatusEnum.MATCHED.getCode().equals(auditFeeCheckVo.getMatchStatus()),"数据未匹配，不能进行确认!");
        AuditFeeCheck auditFeeCheck = auditFeeCheckRepository.findById(auditFeeCheckVo.getId());
        Validate.isTrue(StringUtils.equals(BooleanEnum.FALSE.getCapital(), auditFeeCheck.getIsConfirm()), "数据已确认,请检查!!!");
        log.info("主数据查询：{}", System.currentTimeMillis() - a);

        // 保存到数据库
        this.update(auditFeeCheckVo, false);
        log.info("数据保存：{}", System.currentTimeMillis() - a);

        // 未确认差异的，执行确认差异 生成差异费用台账
        if (!BooleanEnum.TRUE.getCapital().equals(auditFeeCheck.getIsConfirmDiff())) {
            this.confirmDiff(auditFeeCheckVo);
            // 确认差异方法修改了部分字段，copy回来
            BeanUtils.copyProperties(auditFeeCheckVo, auditFeeCheck);
            log.info("确认差异：{}", System.currentTimeMillis() - a);
        }

        // 执行确认逻辑
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        log.info("确认人线程信息：{}", JSON.toJSONString(loginUser));
        auditFeeCheck.setIsConfirm(BooleanEnum.TRUE.getCapital());
        auditFeeCheck.setConfirmDate(new Date());
        auditFeeCheck.setConfirmUserAccount(loginUser.getAccount());
        auditFeeCheck.setConfirmUserName(loginUser.getRealName());
        this.auditFeeCheckRepository.updateById(auditFeeCheck);
        log.info("确认数据保存：{}", System.currentTimeMillis() - a);

        // 如果对应模块的扣费依据维护的“费单&结算单”，则点击确认后按照活动维度生成对应的扣费核定数据
        List<AuditFeeVerifyDecideDto> verifyDecideDtoArrayList = new ArrayList<>();
        //  查模板
        TpmDeductionMatchingTemplateVo templateVo = deductionMatchingTemplateService.findByCode(auditFeeCheck.getMatchTemplateCode());
        Validate.notNull(templateVo,"未查询到模板信息！["+ auditFeeCheck.getMatchTemplateCode() +"]");
        log.info("查询模板：{}", System.currentTimeMillis() - a);
        if (FeeAccordingEnum.FEE_INVOICE.getCode().equals(templateVo.getFeeAccording())) {
            // 查询关联活动，每条生成扣费核定
            List<AuditFeeCheckDetailPlanVo> detailPlanList = auditFeeCheckDetailPlanRepository.findDetailPlanByMatchCode(auditFeeCheck.getMatchCode());
            Validate.notNull(templateVo,"未查询到关联活动！");
            for (AuditFeeCheckDetailPlanVo detailPlanVo : detailPlanList) {
                AuditFeeVerifyDecideDto verifyDecideDto = new AuditFeeVerifyDecideDto();
                verifyDecideDto.setActivityDetailItemCode(detailPlanVo.getDetailPlanItemCode());
                verifyDecideDto.setActivityDetailCode(detailPlanVo.getDetailPlanCode());
                verifyDecideDto.setActivityDetailName(detailPlanVo.getDetailPlanName());
                verifyDecideDto.setTerminalCode(detailPlanVo.getTerminalCode());
                verifyDecideDto.setTerminalName(detailPlanVo.getTerminalName());
                verifyDecideDto.setProductCode(detailPlanVo.getProductCode());
                verifyDecideDto.setProductName(detailPlanVo.getProductName());
                verifyDecideDto.setAuditFeeCheckCode(auditFeeCheck.getMatchCode());
                verifyDecideDto.setBusinessFormatCode(auditFeeCheck.getBusinessFormatCode());
                verifyDecideDto.setBusinessUnitCode(auditFeeCheck.getBusinessUnitCode());
                verifyDecideDto.setAreaCode(detailPlanVo.getRegion());
                verifyDecideDto.setCustomerRetailerCode(auditFeeCheck.getCustomerRetailerCode());
                verifyDecideDto.setCustomerRetailerName(auditFeeCheck.getCustomerRetailerName());
                verifyDecideDto.setVerifyDecideAmount(detailPlanVo.getThisAuditAmount());
                verifyDecideDto.setSalesInstitutionErpCode(detailPlanVo.getSalesInstitutionCode());
                verifyDecideDto.setSalesInstitutionName(detailPlanVo.getSalesInstitutionName());
                verifyDecideDto.setAuditWay(detailPlanVo.getAuditForm());
                verifyDecideDto.setCustomerCode(detailPlanVo.getCustomerCode());
                verifyDecideDto.setCustomerName(detailPlanVo.getCustomerName());
                verifyDecideDto.setWholeAudit(BooleanEnum.FALSE.getCapital());
                verifyDecideDto.setSource(AuditFeeVerifyDecideSourceEnum.COST.getCode());
                verifyDecideDtoArrayList.add(verifyDecideDto);
            }

            auditFeeVerifyDecideService.createBatch(verifyDecideDtoArrayList);
            log.info("生成扣费核定：{}", System.currentTimeMillis() - a);
        }

        // 给费用单/pos打上确认标记，放在这里，在此feign调用失败时，可以回滚前面的DB操作
        generateAuditFeeCheckCostAsyncHelper.updateKMSStatus(auditFeeCheckCostRepository.findCompanyCostCodeByMatchCodes(Lists.newArrayList(auditFeeCheckVo.getMatchCode())), AuditFeeMatchStatusEnum.CONFIRM.getCode());

        // 最后清理缓存
        String cacheKey = auditFeeCheckVo.getCacheKey();
        auditFeeCheckDetailPlanVoCacheService.clearCache(cacheKey);
        auditFeeCheckCostVoCacheService.clearCache(cacheKey);
        auditFeeCheckDiffVoCacheService.clearCache(cacheKey);
        log.info("清理缓存：{}", System.currentTimeMillis() - a);
    }

    /**
     * 确认差异
     * @param auditFeeCheckVo 核销费用核对查询VO对象
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void confirmDiff(AuditFeeCheckVo auditFeeCheckVo) {
        log.info("费用核对确认差异：{}", auditFeeCheckVo);

        Validate.notNull(auditFeeCheckVo, "传入核对数据不能为空");
        String diffType = auditFeeCheckVo.getDiffType();
        Validate.notNull(diffType, "差异类型不能为空");
        if (DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode().equals(diffType)) {
            // 少扣款需要选择 差异使用
            Validate.notNull(auditFeeCheckVo.getDiffUse(), "请先选择差异使用");
        }
        Validate.isTrue(!BooleanEnum.TRUE.getCapital().equals(auditFeeCheckVo.getIsConfirmDiff()), "差异已被确认！");
        Validate.isTrue(!BooleanEnum.TRUE.getCapital().equals(auditFeeCheckVo.getIsConfirm()), "核对数据已确认！");

        // 查询匹配上的活动，生成差异费用台账用
        List<AuditFeeCheckDetailPlanVo> detailPlanVos = null;
        if (auditFeeCheckVo.getCacheKey() != null) {
            detailPlanVos = auditFeeCheckDetailPlanVoCacheService.findCacheList(auditFeeCheckVo.getCacheKey());
        } else {
            detailPlanVos = auditFeeCheckDetailPlanRepository.findDetailPlanByMatchCode(auditFeeCheckVo.getMatchCode());
        }
        AuditFeeCheckDetailPlanVo detailPlanVo = CollectionUtils.isNotEmpty(detailPlanVos) ? detailPlanVos.get(detailPlanVos.size() - 1) : null;

        // 判断是否生成差异费用台账
        /*  ①IF差异类型=多扣款，生成差异台账；
            ②IF差异类型=少扣款且差异使用=抵扣差异，抵扣历史差异台账；
            ③IF差异类型=少扣款且差异使用=待扣费，不处理差异台账；
            ④IF差异类型=少扣款且差异使用=少扣费释放，不处理差异台账；
            ⑤IF差异类型=无差异，不处理差异台账；
         */
        // 多扣款,生成差异台账
        if (DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode().equals(diffType) || DiffTypeEnum.MORE_DEDUCTION_HAD_DEDUCTION.getCode().equals(diffType)) {
            // 调用台账生成接口
            AuditFeeDiffLedgerDto ledgerDto = new AuditFeeDiffLedgerDto();
            ledgerDto.setAuditFeeCheckCode(auditFeeCheckVo.getMatchCode());
            ledgerDto.setFeeYearMonth(DateUtil.format(auditFeeCheckVo.getOrderYearMonth(), DatePattern.NORM_MONTH_PATTERN));
            if (Objects.nonNull(ledgerDto.getFeeYearMonth())){
                String[] yearMonthArray = ledgerDto.getFeeYearMonth().split("-");
                ledgerDto.setYear(yearMonthArray[0]);
                ledgerDto.setMonth(yearMonthArray[1]);
            }
            ledgerDto.setBusinessFormatCode(auditFeeCheckVo.getBusinessFormatCode());
            ledgerDto.setBusinessUnitCode(auditFeeCheckVo.getBusinessUnitCode());
            ledgerDto.setStatus(AuditStateEnum.WAIT_CONFIRM.getCode());
            ledgerDto.setRetailerCode(auditFeeCheckVo.getCustomerRetailerCode());
            ledgerDto.setRetailerName(auditFeeCheckVo.getCustomerRetailerName());
            ledgerDto.setBusinessAreaCode(auditFeeCheckVo.getAreaCode());
            ledgerDto.setBusinessAreaName(auditFeeCheckVo.getAreaCode());
            ledgerDto.setSoldToPartyCode(auditFeeCheckVo.getCustomerErpCode());
            ledgerDto.setSoldToPartyName(auditFeeCheckVo.getCustomerName());
            ledgerDto.setSalesOrgCode(auditFeeCheckVo.getSalesOrgCode());
            ledgerDto.setSalesOrgName(auditFeeCheckVo.getSalesOrgName());
//            ledgerDto.setIsEffectStatement(BooleanEnum.TRUE.getCapital());
            ledgerDto.setDiffAmount(auditFeeCheckVo.getDiffConfirmAmount());
            ledgerDto.setRemark(auditFeeCheckVo.getRemark());
            ledgerDto.setDataSource(DiffLedgerDataSourceEnum.FEE_COLLATE.getCode());
            // 匹配上活动就从最后一条活动中取值传递
            if (detailPlanVo != null) {
                ledgerDto.setDeliveryPartyCode(detailPlanVo.getTerminalCode());
                ledgerDto.setDeliveryPartyName(detailPlanVo.getTerminalName());
                ledgerDto.setSoldToPartyCode(detailPlanVo.getCustomerCode());
                ledgerDto.setSoldToPartyName(detailPlanVo.getCustomerName());
                ledgerDto.setActivitiesType(detailPlanVo.getActivityTypeCode());
                ledgerDto.setActivitiesTypeName(detailPlanVo.getActivityTypeName());
                ledgerDto.setActivity_form_code(detailPlanVo.getActivityFormCode());
                ledgerDto.setActivity_form_name(detailPlanVo.getActivityFormName());
            }
            auditFeeDiffLedgerVoService.create(ledgerDto);
        }
        // 差异类型=少扣款,且差异使用=抵扣差异,抵扣差异台账
        if (DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode().equals(diffType)) {
            String diffUse = auditFeeCheckVo.getDiffUse();
            if (AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode().equals(diffUse)) {
                // 取出缓存中关联的差异费用台账
                String cacheKey = auditFeeCheckVo.getCacheKey();
                List<AuditFeeCheckDiffVo> diffVoList = auditFeeCheckDiffVoCacheService.findCacheList(cacheKey);
                Validate.notEmpty(diffVoList, "未选择差异费用台账，请先进行差异抵扣");
                // 校验单条数据扣减正确性
                List<String> notEnoughDeductCodeList = new ArrayList<>();
                BigDecimal deductAmountTotal = BigDecimal.ZERO;
                for (AuditFeeCheckDiffVo diffVo : diffVoList) {
                    String feeDiffLedgerCode = diffVo.getFeeDiffLedgerCode();
                    Validate.notNull(diffVo.getBeRecoveredAmount(), "所选差异数据["+ feeDiffLedgerCode +"]待追回金额不能为空");
                    Validate.notNull(diffVo.getDeductAmount(), "所选差异数据[" + feeDiffLedgerCode + "]本次抵扣金额不能为空");
                    // 检查待追回金额大于本次抵扣金额
                    if (diffVo.getBeRecoveredAmount().compareTo(diffVo.getDeductAmount()) < 0) {
                        // 不够扣减
                        notEnoughDeductCodeList.add(feeDiffLedgerCode);
                    }
                    deductAmountTotal = deductAmountTotal.add(diffVo.getDeductAmount());
                }
                // 存在不足扣减数据
                Validate.isTrue(CollectionUtils.isEmpty(notEnoughDeductCodeList), "所选差异数据[" + String.join(",", notEnoughDeductCodeList) + "]不足抵扣");
                // 扣减台账要求相等
                Validate.isTrue(deductAmountTotal.compareTo(auditFeeCheckVo.getDiffConfirmAmount().abs()) == 0, "抵扣金额之和必须与差异确认金额绝对值相等");

                List<String> feeDiffLedgerCodeList = diffVoList.stream().peek(e -> e.setAuditFeeCheckDeductCode(auditFeeCheckVo.getMatchCode()))
                    .map(AuditFeeCheckDiffVo::getFeeDiffLedgerCode).filter(Objects::nonNull).collect(Collectors.toList());

                // 删除数据库关联台账，存储缓存的台账
                auditFeeCheckDiffVoService.updateDelFlagByMatchCodes(Lists.newArrayList(auditFeeCheckVo.getMatchCode()));
                auditFeeCheckDiffVoService.createBatch(diffVoList);
                log.info("差异保存内容：{}", diffVoList);

                // 扣减台账
                Validate.isTrue(auditFeeDiffLedgerLockService.lock(feeDiffLedgerCodeList, TimeUnit.MINUTES, 1), "扣减差异费用台账失败，请重试");
                for (AuditFeeCheckDiffVo diffVo : diffVoList) {
                    // 调用差异抵扣接口写入差异台账
                    AuditFeeDiffLedgerDeductionDto ledgerDto = new AuditFeeDiffLedgerDeductionDto();
                    ledgerDto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.DEDUCTION_AMOUNT.getCode());
                    ledgerDto.setFeeDiffLedgerCode(diffVo.getFeeDiffLedgerCode());
                    ledgerDto.setBusinessCode(auditFeeCheckVo.getMatchCode());
                    ledgerDto.setRecoveredAmount(diffVo.getDeductAmount());
                    AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();
                    ledgerDto.setOperatorAccount(loginUser.getAccount());
                    ledgerDto.setOperatorName(loginUser.getRealName());
                    ledgerDto.setRemark(auditFeeCheckVo.getRemark());
                    ledgerDto.setResaleCommercialCode(auditFeeCheckVo.getCustomerRetailerCode());
                    ledgerDto.setResaleCommercialName(auditFeeCheckVo.getCustomerRetailerName());
                    // 匹配上活动就从最后一条活动中取值传递
                    if (detailPlanVo != null) {
                        ledgerDto.setTerminalCode(detailPlanVo.getTerminalCode());
                        ledgerDto.setTerminalName(detailPlanVo.getTerminalName());
                        ledgerDto.setActivityFormCode(detailPlanVo.getActivityFormCode());
                        ledgerDto.setActivityFormName(detailPlanVo.getActivityFormName());
                        ledgerDto.setActivityTypeCode(detailPlanVo.getActivityTypeCode());
                        ledgerDto.setActivityTypeName(detailPlanVo.getActivityTypeName());
                    }
                    ledgerDto.setDataSource(DiffLedgerDataSourceEnum.FEE_COLLATE.getCode());
                    auditFeeDiffLedgerVoService.useAmount(ledgerDto);
                }
                auditFeeDiffLedgerLockService.unlock(feeDiffLedgerCodeList);
            }
        }
        auditFeeCheckVo.setIsConfirmDiff(BooleanEnum.TRUE.getCapital());
        AuditFeeCheck auditFeeCheck = new AuditFeeCheck();
        BeanUtils.copyProperties(auditFeeCheckVo, auditFeeCheck);
        auditFeeCheckRepository.updateById(auditFeeCheck);
    }

    /**
     * 根据页面调整计算差异
     * @param auditFeeCheckVo 核销费用核对查询VO对象
     * @return
     */
    @Override
    public AuditFeeCheckVo compute(AuditFeeCheckVo auditFeeCheckVo) {
        // 实时计算：费用含税金额sum-细案剩余可结案金额sum
        Validate.notNull(auditFeeCheckVo, "传入核对数据不能为空");
        Validate.notNull(auditFeeCheckVo.getId(), "传入核对数据ID不能为空");
        Validate.isTrue(!BooleanEnum.TRUE.getCapital().equals(auditFeeCheckVo.getIsConfirm()), "核对数据已确认！");
        Validate.notNull(auditFeeCheckVo.getCacheKey(), "数据缓存失败！");

        // 因为是否累计，计算得到的细案预结案金额不同，所以运行一次细案分摊获取准确的 细案预结案金额

        // 费用含税金额
        List<AuditFeeCheckCostVo> costCacheList = auditFeeCheckCostVoCacheService.findCacheList(auditFeeCheckVo.getCacheKey());
        BigDecimal costAmountTotal = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(costCacheList)) {
            costAmountTotal = costCacheList.stream().map(AuditFeeCheckCostVo::getDeductionAmountTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        auditFeeCheckVo.setCostDeductionAmount(costAmountTotal);
        // 重新分摊
        this.detailPlanReshare(auditFeeCheckVo);

        return auditFeeCheckVo;
    }

    /**
     * 取消匹配
     *
     * @param id
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void cancelingMatch(String id) {
        Validate.notNull(id, "ids不能为空");
        AuditFeeCheck feeCheck = this.auditFeeCheckRepository.findById(id);
        Validate.notNull(feeCheck, "数据不存在");
        Validate.isTrue(MatchStatusEnum.MATCHED.getCode().equals(feeCheck.getMatchStatus()), "该数据未匹配成功,不能取消,请检查!!!");
        Validate.isTrue(!BooleanEnum.TRUE.getCapital().equals(feeCheck.getIsConfirm()), "该数据已确认,不能取消,请检查!!!");
        Validate.isTrue(!BooleanEnum.TRUE.getCapital().equals(feeCheck.getIsConfirmDiff()), "该数据已确认差异,不能取消,请检查!!!");

        feeCheck.setMatchStatus(MatchStatusEnum.WAIT_MATCH.getCode());
        feeCheck.setMatchResult(StringUtils.EMPTY);
        feeCheck.setIsAddUp(StringUtils.EMPTY);
        feeCheck.setRemark(StringUtils.EMPTY);
        feeCheck.setActivityPreAuditAmount(BigDecimal.ZERO);
        feeCheck.setCostDetailDiffAmount(feeCheck.getCostDeductionAmount());
        feeCheck.setDiffConfirmAmount(feeCheck.getCostDetailDiffAmount());
        // 重新计算差异类型，默认为 多扣款无批复
        feeCheck.setDiffType(DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode());
        feeCheck.setDiffUse(null);
        this.auditFeeCheckRepository.updateById(feeCheck);
        // 移除匹配产生的其他关联
        generateAuditFeeCheckCostAsyncHelper.cancelByMatchCodes(Lists.newArrayList(feeCheck.getMatchCode()));
    }

    /**
     * 设置备注
     *
     * @param id
     *            主键id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateNote(String id, String note) {
        Validate.notEmpty(id, "主键ID不能为空");
        AuditFeeCheck auditFeeCheck = this.auditFeeCheckRepository.findById(id);
        Validate.notNull(auditFeeCheck, "数据不存在");
        if (StringUtils.isBlank(note)) note = "";
        Validate.isTrue(note.length() <= 400, "备注超长");
        Validate.isTrue(!BooleanEnum.TRUE.getCapital().equals(auditFeeCheck.getIsConfirm()), "确认后的数据不允许修改备注");
        auditFeeCheck.setRemark(note);
        this.auditFeeCheckRepository.updateById(auditFeeCheck);
    }

    /**
     * 按年月日加锁
     *
     * @param yearMonthDay
     * @return boolean
     * @author huojia
     * @date 2022/12/6 21:52
     **/
    public boolean lock(String yearMonthDay) {
        if (StringUtils.isEmpty(yearMonthDay)) {
            throw new RuntimeException("费用核对job执行失败，日期不能为空！");
        }
        return this.redisLockService.tryLock(AuditFeeConstants.AUDIT_FEE_JOB + yearMonthDay, TimeUnit.HOURS, 12);
    }

    /**
     * 按年月日解锁
     *
     * @param yearMonthDay
     * @author huojia
     * @date 2022/12/6 21:52
     **/
    public void unLock(String yearMonthDay) {
        if (StringUtils.isEmpty(yearMonthDay)) {
            throw new RuntimeException("费用核对job执行失败，日期不能为空！");
        }
        redisLockService.unlock(AuditFeeConstants.AUDIT_FEE_JOB + yearMonthDay);
    }

    /**
     * 抽取方案核对台账数据
     * @param dto
     * @return
     */
    @Override
    public List<AuditFeeCheckVo> getPlanCheckAccountData(AuditFeeCheckDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheck> list = this.auditFeeCheckRepository.getPlanCheckAccountData(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckVo> auditFeeCheckVos = (List<AuditFeeCheckVo>) nebulaToolkitService.copyCollectionByWhiteList(list, AuditFeeCheck.class, AuditFeeCheckVo.class, HashSet.class, ArrayList.class);

        auditFeeCheckVos.forEach(feeCheckVo -> {
            feeCheckVo.setCosts(this.auditFeeCheckCostVoService.findDetailByMatchCode(feeCheckVo.getMatchCode()));
            feeCheckVo.setAuditFeeCheckDetailPlans(this.auditFeeCheckDetailPlanRepository.findDetailPlanByMatchCode(feeCheckVo.getMatchCode()));
            feeCheckVo.setMappingCode(this.auditFeeCheckRepository.findMappingCode(feeCheckVo.getMatchCode()));
        });
        return auditFeeCheckVos;
    }

    /**
     * 通过扣费匹配单号查询数据详情
     * @param matchCodes
     * @return
     */
    @Override
    public List<AuditFeeCheckVo> getByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheck> feeCheckList = this.auditFeeCheckRepository.findByMatchCodes(matchCodes);
        if (CollectionUtils.isEmpty(feeCheckList)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckVo> auditFeeCheckVos = (List<AuditFeeCheckVo>) nebulaToolkitService.copyCollectionByWhiteList(feeCheckList, AuditFeeCheck.class, AuditFeeCheckVo.class, HashSet.class, ArrayList.class);
        auditFeeCheckVos.forEach(auditFeeCheckVo -> {
            auditFeeCheckVo.setCosts(this.auditFeeCheckCostVoService.findDetailByMatchCode(auditFeeCheckVo.getMatchCode()));
            auditFeeCheckVo.setAuditFeeCheckDetailPlans(this.auditFeeCheckDetailPlanRepository.findDetailPlanByMatchCode(auditFeeCheckVo.getMatchCode()));
        });
        return auditFeeCheckVos;
    }

    @Override
    public void updateAuditCheckStatus(List<String> auditCheckCodes) {
        if (CollectionUtils.isEmpty(auditCheckCodes)){
            return;
        }

        int count = this.auditFeeCheckDetailPlanRepository.getCountByAuditCode(auditCheckCodes);
        if (count == 0){
            return;
        }
        this.auditFeeCheckDetailPlanRepository.updateStatusByAuditCodes(auditCheckCodes);
    }

    @Override
    public Page<AuditFeeCheckVo> findByConditionsForEct(Pageable pageable, AuditFeeCheckSelectDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckSelectDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Date currentDate = new Date();
        if (StringUtils.isBlank(dto.getStartDate()) || StringUtils.isBlank(dto.getEndDate())) {
            dto.setStartDate(com.biz.crm.mn.common.base.util.DateUtil.format(currentDate, com.biz.crm.mn.common.base.util.DateUtil.DEFAULT_YEAR_MONTH_DAY));
            dto.setEndDate(com.biz.crm.mn.common.base.util.DateUtil.format(currentDate, com.biz.crm.mn.common.base.util.DateUtil.DEFAULT_YEAR_MONTH_DAY));
        }
        Page<AuditFeeCheckVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<AuditFeeCheckVo> result = this.auditFeeCheckRepository.findByConditionsForEct(page, dto);
        if (CollectionUtils.isEmpty(result.getRecords())) {
            return result;
        }
        List<AuditFeeCheckVo> feeList = result.getRecords();
        List<String> matchCodes = feeList.stream().map(AuditFeeCheckVo::getMatchCode).distinct().collect(Collectors.toList());
//        List<AuditFeeCheckStatementVo> statementList = this.auditFeeCheckStatementVoService.findDetailByMatchCodes(matchCodes);
//        Map<String, List<AuditFeeCheckStatementVo>> statementMap = statementList.stream().collect(Collectors.groupingBy(AuditFeeCheckStatementVo::getAuditFeeCheckCode));
        List<AuditFeeCheckCostVo> costList = this.auditFeeCheckCostVoService.findDetailByMatchCodes(matchCodes);
        Map<String, List<AuditFeeCheckCostVo>> costMap = costList.stream().collect(Collectors.groupingBy(AuditFeeCheckCostVo::getAuditFeeCheckCode));
        List<AuditFeeCheckDetailPlanVo> detailPlanList = this.auditFeeCheckDetailPlanVoService.findByMatchCodes(matchCodes);
        Map<String, List<AuditFeeCheckDetailPlanVo>> detailPlanMap = detailPlanList.stream().collect(Collectors.groupingBy(AuditFeeCheckDetailPlanVo::getAuditFeeCheckCode));
        feeList.forEach(fee -> {
            String matchCode = fee.getMatchCode();
//            if (statementMap != null) {
//                List<AuditFeeCheckStatementVo> auditFeeCheckStatementVos = statementMap.get(matchCode);
//                fee.setStatements(auditFeeCheckStatementVos);
//            }
            if (costMap != null) {
                List<AuditFeeCheckCostVo> auditFeeCheckCostVos = costMap.get(matchCode);
                fee.setCosts(auditFeeCheckCostVos);
            }
            if (detailPlanMap != null) {
                List<AuditFeeCheckDetailPlanVo> auditFeeCheckDetailPlanVos = detailPlanMap.get(matchCode);
                fee.setAuditFeeCheckDetailPlans(auditFeeCheckDetailPlanVos);
            }
        });
        
        return result.setRecords(feeList);
    }

    /**
     * pos-细案费用汇总更新
     *
     *
     * @param update
     * @param matchCode
     * @return
     */
    @Override
    public void posActivityAmountSummary(boolean update, AuditFeeCheckVo auditFeeCheckVo, String matchCode) {
        Validate.notBlank(matchCode,"扣费匹配单号不能为空!");
        if (Objects.isNull(auditFeeCheckVo)) {
            AuditFeeCheck auditFeeCheck = this.auditFeeCheckRepository.findByMatchCode(matchCode);
            auditFeeCheckVo = nebulaToolkitService.copyObjectByWhiteList(auditFeeCheck,AuditFeeCheckVo.class,HashSet.class,ArrayList.class);
        }
        List<AuditFeeCheckDetailPlan> detailPlanList = this.auditFeeCheckDetailPlanRepository.findDetailByMatchCode(matchCode);
        if (CollectionUtils.isEmpty(detailPlanList)) {
            return;
        }
        List<AuditFeeCheckPosVo> posList = new ArrayList<>();
        posList = posList.stream().filter(p -> !StringUtils.isBlank(p.getActivityDetailItemCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(posList)) {
            return;
        }
        List<AuditFeeCheckCostVo> costList = this.auditFeeCheckCostVoService.findDetailByMatchCode(matchCode);
        if (CollectionUtils.isEmpty(costList)) {
            return;
        }

        BigDecimal promotionDeduction = posList.stream().map(AuditFeeCheckPosVo::getPromotionDeduction).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal deductionAmountTax = costList.stream().map(AuditFeeCheckCostVo::getDeductionAmountTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal diffTotalAmount = deductionAmountTax.subtract(promotionDeduction);
        //已处理金额
        BigDecimal hadDiffAmount = BigDecimal.ZERO;
        for (int i = 0 ; i < posList.size() ; i++){

            AuditFeeCheckPosVo pos = posList.get(i);
            //单条pos的金额占费用单金额比例
            BigDecimal div1 = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(diffTotalAmount) != 0 ) {
                div1 = NumberUtil.div(pos.getPromotionDeduction(), diffTotalAmount);
            }
            //单条pos分摊金额
            BigDecimal mul = BigDecimal.ZERO;
            if ((i + 1) == posList.size()){
                mul = NumberUtil.sub(diffTotalAmount,hadDiffAmount);
            }else {
                mul = NumberUtil.mul(div1, diffTotalAmount).setScale(2, BigDecimal.ROUND_HALF_UP);
                hadDiffAmount = hadDiffAmount.add(mul);
            }
            //每单pos的分摊促销扣款
            pos.setSharePromotionDeduction(mul);

            BigDecimal oneDiffAmount = Optional.ofNullable(pos.getOneDiffAmount()).orElse(BigDecimal.ZERO);
            BigDecimal productNumber = Optional.ofNullable(pos.getProductNumber()).orElse(BigDecimal.ZERO);
            //每单pos的差异总费用
            pos.setTotalDiffAmount(oneDiffAmount.multiply(productNumber).add(mul));
        }

        Map<String, AuditFeeCheckPosVo> posToActivityVoMap = posList.stream().collect(Collectors.toMap(AuditFeeCheckPosVo::getId, Function.identity()));
        detailPlanList.forEach(plan -> {
            AuditFeeCheckPosVo posVo = posToActivityVoMap.get(plan.getDetailPlanItemCode());
            plan.setAuditFeeCheckShareAmount(posVo.getPromotionDeduction().add(posVo.getSharePromotionDeduction()));
        });

        if (!Objects.isNull(auditFeeCheckVo)) {
            auditFeeCheckVo.setCostDetailDiffAmount(diffTotalAmount);
        }
        if (update) {
            this.updatePosAuditAmount(auditFeeCheckVo,posList,detailPlanList);
        }

    }

    @Transactional(rollbackFor = Exception.class)
    public void updatePosAuditAmount(AuditFeeCheckVo auditFeeCheckVo, List<AuditFeeCheckPosVo> posList, List<AuditFeeCheckDetailPlan> detailPlanList) {
        if (!Objects.isNull(auditFeeCheckVo)){
            AuditFeeCheck auditFeeCheck = nebulaToolkitService.copyObjectByWhiteList(auditFeeCheckVo, AuditFeeCheck.class, HashSet.class, ArrayList.class);
            this.auditFeeCheckRepository.updateById(auditFeeCheck);
        }
        if (!CollectionUtils.isEmpty(posList)) {
            List<AuditFeeCheckPos> posEntitys = (List<AuditFeeCheckPos>) nebulaToolkitService.copyCollectionByWhiteList(posList, AuditFeeCheckPosVo.class, AuditFeeCheckPos.class, HashSet.class, ArrayList.class);
            this.auditFeeCheckPosRepository.updateBatchById(posEntitys);
        }
        if (!CollectionUtils.isEmpty(detailPlanList)) {
            this.auditFeeCheckDetailPlanRepository.updateBatchById(detailPlanList);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveExpensesDeductResult(List<AuditFeeCheckVo> feeCheckVoList, List<AuditFeeCheckDetailPlanVo> feeCheckDetailPlanVoList) {
        if (!CollectionUtils.isEmpty(feeCheckVoList)) {
            Collection<AuditFeeCheck> auditFeeChecks = nebulaToolkitService.copyCollectionByWhiteList(feeCheckVoList, AuditFeeCheckVo.class, AuditFeeCheck.class, HashSet.class, ArrayList.class);
            this.auditFeeCheckRepository.updateBatchById(auditFeeChecks);
        }
        if (!CollectionUtils.isEmpty(feeCheckDetailPlanVoList)) {
            Collection<AuditFeeCheckDetailPlan> feeCheckDetailPlanVos = nebulaToolkitService.copyCollectionByWhiteList(feeCheckDetailPlanVoList, AuditFeeCheckDetailPlanVo.class, AuditFeeCheckDetailPlan.class, HashSet.class, ArrayList.class);
            this.auditFeeCheckDetailPlanRepository.updateBatchById(feeCheckDetailPlanVos);
        }

    }

    @Override
    public List<String> findDetailPlanItemCodeByCost(Set<String> deductionCodeList) {
        List<String> detailPLanItemCodeList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(deductionCodeList)) {
            // 查核对数据
            List<String> matchCodeList = auditFeeCheckCostRepository.findMatchCodesByCostCode(Lists.newArrayList(deductionCodeList));
            // 过滤未确认的
            List<String> confirmedMatchCodeList = auditFeeCheckRepository.findConfirmedByMatchCodes(matchCodeList);
            // 查关联的活动细案
            detailPLanItemCodeList = auditFeeCheckDetailPlanRepository.findDetailPlanItemCodeByMatchCodes(confirmedMatchCodeList);
        }
        return detailPLanItemCodeList;
    }

    @Override
    public void detailPlanReshare(AuditFeeCheckVo feeCheckVo) {
        Validate.notNull(feeCheckVo, "数据不能为空");
        Validate.notNull(feeCheckVo.getId(), "匹配数据ID不能为空");
        String cacheKey = feeCheckVo.getCacheKey();
        Validate.notNull(cacheKey, "cacheKey不能为空");

        if (feeCheckVo.getIsAddUp() == null || feeCheckVo.getBusinessUnitCode() == null ) {
            AuditFeeCheck auditFeeCheck = auditFeeCheckRepository.findById(feeCheckVo.getId());
            feeCheckVo.setIsConfirm(auditFeeCheck.getIsConfirm());
            feeCheckVo.setIsConfirmDiff(auditFeeCheck.getIsConfirmDiff());
            feeCheckVo.setIsAddUp(auditFeeCheck.getIsAddUp());
            feeCheckVo.setBusinessUnitCode(auditFeeCheck.getBusinessUnitCode());
        }

        String diffType = feeCheckVo.getDiffType();
        String diffUse = feeCheckVo.getDiffUse();
        BigDecimal diffConfirmAmount = feeCheckVo.getDiffConfirmAmount();

        List<AuditFeeCheckDetailPlanVo> detailPlanVoList = auditFeeCheckDetailPlanVoCacheService.findCacheList(cacheKey);
        // 执行分摊逻辑
        detailPlanVoList = this.detailPlanShare(feeCheckVo, detailPlanVoList);

        // 手动分摊不影响差异类型、使用、确认金额，应该以页面传入的为准
        feeCheckVo.setDiffType(diffType);
        feeCheckVo.setDiffUse(diffUse);
        feeCheckVo.setDiffConfirmAmount(diffConfirmAmount);

        if (CollectionUtils.isNotEmpty(detailPlanVoList)) {
            // 清理参与分摊的数据缓存
//            List<String> detailPlanItemCodeList = detailPlanVoList.stream().map(AuditFeeCheckDetailPlanVo::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList());
//            this.auditFeeCheckDetailPlanVoCacheService.deleteCacheList(cacheKey, detailPlanItemCodeList);
            // 参与分摊的数据放回缓存
            this.auditFeeCheckDetailPlanVoCacheService.addItemCache(cacheKey, detailPlanVoList);
        }
    }

    /**
     * 细案分摊逻辑
     * @param feeCheckVo
     * @param detailPlanVoList
     * @return 参与分摊的活动，累计情况分摊完成就结束，会丢失多余的活动；非累计情况全都保留，后续分摊金额为0
     */
    private List<AuditFeeCheckDetailPlanVo> detailPlanShare(AuditFeeCheckVo feeCheckVo, List<AuditFeeCheckDetailPlanVo> detailPlanVoList) {
        // 费用单金额
        BigDecimal costDeductionAmount = Optional.ofNullable(feeCheckVo.getCostDeductionAmount()).orElse(BigDecimal.ZERO);
        // 待核销金额缺口
        BigDecimal needBeAuditAmount = costDeductionAmount;

        if (CollectionUtils.isEmpty(detailPlanVoList)) {
            // 活动为空，更新费用单-细案差异金额
            feeCheckVo.setCostDetailDiffAmount(costDeductionAmount);
            feeCheckVo.setActivityPreAuditAmount(BigDecimal.ZERO);
            feeCheckVo.setMatchStatus(MatchStatusEnum.WAIT_MATCH.getCode());
            feeCheckVo.setDiffType(DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode());
            return detailPlanVoList;
        }

        // 按编码排序，分摊需要这个顺序
        detailPlanVoList = detailPlanVoList.stream().sorted(Comparator.comparing(AuditFeeCheckDetailPlanVo::getDetailPlanItemCode)).collect(Collectors.toList());

        for (int i = 0; i < detailPlanVoList.size(); i++) {
            AuditFeeCheckDetailPlanVo feeCheckDetailPlanVo = detailPlanVoList.get(i);
            Validate.notNull(feeCheckDetailPlanVo.getCanAuditAmount(), "明细编码" + feeCheckDetailPlanVo.getDetailPlanItemCode() + "可核销金额数据错误");
            // 当前可结案金额
            BigDecimal canAuditAmount = feeCheckDetailPlanVo.getCanAuditAmount();

            // 金额分摊到细案
            // 本次分摊金额
            BigDecimal auditFeeCheckShareAmount = BigDecimal.ZERO;

            if (needBeAuditAmount.compareTo(BigDecimal.ZERO) > 0) {
                // 待核销金额缺口 > 0，需要继续扣减细案
                // 剩余待核销金额缺口 = 待核销金额缺口 - 当前可结案金额
                BigDecimal remainNeedBeAuditAmount = needBeAuditAmount.subtract(canAuditAmount);
                int i1 = remainNeedBeAuditAmount.compareTo(BigDecimal.ZERO);
                // 剩余待核销金额缺口 >= 0，可结案金额直接设置到分摊金额
                if (i1 >= 0) {
                    auditFeeCheckShareAmount = canAuditAmount;
                }
                // 剩余待核销金额缺口 < 0，分摊部分，未完全分摊
                if (i1 < 0) {
                    auditFeeCheckShareAmount = needBeAuditAmount;
                }

                // 分摊金额维持两位精度
                auditFeeCheckShareAmount = auditFeeCheckShareAmount.setScale(2, RoundingMode.HALF_UP);
                // 细案明细分摊加到明细表上
                feeCheckDetailPlanVo.setAuditFeeCheckShareAmount(auditFeeCheckShareAmount);

                // 到了最后一条细案，仍未完成缺口补全，将剩余缺口补充到最后一条细案中，即将未完成的费用全部分摊到当前细案的分摊金额中(活动少了)
                if (i + 1 == detailPlanVoList.size() && remainNeedBeAuditAmount.compareTo(BigDecimal.ZERO) > 0) {
                    feeCheckDetailPlanVo.setAuditFeeCheckShareAmount(remainNeedBeAuditAmount.add(feeCheckDetailPlanVo.getAuditFeeCheckShareAmount()));
                    remainNeedBeAuditAmount = BigDecimal.ZERO;
                }
                // 待分摊=本次分摊后还需分摊的部分
                needBeAuditAmount = remainNeedBeAuditAmount;
            } else {
                // 待核销金额缺口 <= 0，不扣减细案
                feeCheckDetailPlanVo.setAuditFeeCheckShareAmount(BigDecimal.ZERO);
            }

            // 计算待补录金额（元）= 已核销金额（元）+本次扣费金额（元）-申请金额（元）,大于0才有用
            BigDecimal toBeSupplementedAmount = Optional.ofNullable(feeCheckDetailPlanVo.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO)
                .add(feeCheckDetailPlanVo.getAuditFeeCheckShareAmount())
                .subtract(Optional.ofNullable(feeCheckDetailPlanVo.getApplyAmount()).orElse(BigDecimal.ZERO));
            if (toBeSupplementedAmount.compareTo(BigDecimal.ZERO) > 0) {
                feeCheckDetailPlanVo.setToBeSupplementedAmount(toBeSupplementedAmount);
            }
            if (BusinessUnitEnum.VERTICAL.getCode().equals(feeCheckVo.getBusinessUnitCode())) {
                // 计算本次核销金额（元）= （申请金额-已核销金额）与本次扣费金额二者中的较小值 (垂直)
                BigDecimal subtract = Optional.ofNullable(feeCheckDetailPlanVo.getApplyAmount()).orElse(BigDecimal.ZERO)
                    .subtract(Optional.ofNullable(feeCheckDetailPlanVo.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO));
                feeCheckDetailPlanVo.setThisAuditAmount(subtract.compareTo(feeCheckDetailPlanVo.getAuditFeeCheckShareAmount()) < 0 ? subtract : feeCheckDetailPlanVo.getAuditFeeCheckShareAmount());
            } else {
                feeCheckDetailPlanVo.setThisAuditAmount(feeCheckDetailPlanVo.getAuditFeeCheckShareAmount());
            }

            // 累计的情况，分摊完成就退出，不管后续的细案（累计，活动多了）。非累计要遍历完查到的细案，不会有break
            if (StringUtils.equals(BooleanEnum.TRUE.getCapital(), feeCheckVo.getIsAddUp())) {
                // 待核销金额缺口已补全，后续细案不再扣减
                if (needBeAuditAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    break;
                }
            }
        }
        // 部分细案未使用到，过滤掉
        detailPlanVoList = detailPlanVoList.stream().filter(e -> e.getAuditFeeCheckShareAmount() != null).collect(Collectors.toList());

        // 更新费用核对主数据 细案预结算金额
        BigDecimal canAuditAmountTotal = detailPlanVoList.stream().map(AuditFeeCheckDetailPlanVo::getCanAuditAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("本次匹配到的活动的总可结案金额-累计:{}", canAuditAmountTotal);
        feeCheckVo.setActivityPreAuditAmount(canAuditAmountTotal);

        // 确定差异类型
        feeCheckVo.setCostDetailDiffAmount(costDeductionAmount.subtract(feeCheckVo.getActivityPreAuditAmount()));
        int diffAmount = costDeductionAmount.compareTo(feeCheckVo.getActivityPreAuditAmount());
        feeCheckVo.setMatchResult(diffAmount == 0 ? MatchResultEnum.NO_DIFFERENCE.getCode() : MatchResultEnum.HAVE_DIFFERENCE.getCode());
        // 如果没确认，更新费用单差异金额
        if (!BooleanEnum.TRUE.getCapital().equals(feeCheckVo.getIsConfirmDiff())) {
            if (diffAmount == 0) {
                feeCheckVo.setDiffType(DiffTypeEnum.NO_DIFF.getCode());
            }
            if (diffAmount > 0) {
                feeCheckVo.setDiffType(DiffTypeEnum.MORE_DEDUCTION_HAD_DEDUCTION.getCode());
            }
            if (diffAmount < 0) {
                feeCheckVo.setDiffType(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode());
            }
            // 默认为“费单-细案差异”金额
            feeCheckVo.setDiffConfirmAmount(feeCheckVo.getCostDetailDiffAmount());
        }
        feeCheckVo.setMatchStatus(MatchStatusEnum.MATCHED.getCode());
        return detailPlanVoList;
    }
}
