package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeVerifyDecide;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeVerifyDecideRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.auditFeeVerifyDecide.AuditFeeVerifyDecideDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeVerifyDecideSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.IsPushEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeVerifyDecideService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.auditFeeVerifyDecide.AuditFeeVerifyDecideVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AutoAuditDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.*;
import com.biz.crm.tpm.business.audit.sdk.event.AuditEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 扣费核定(AuditFeeVerifyDecide)表服务实现类
 *
 * @author makejava
 * @date 2022-11-14 16:56:08
 */
@Slf4j
@Service
public class AuditFeeVerifyDecideServiceImpl implements AuditFeeVerifyDecideService {

    @Autowired(required = false)
    private AuditFeeVerifyDecideRepository auditFeeVerifyDecideRepository;

    //费用核对管理活动
    @Autowired(required = false)
    private AuditFeeCheckDetailPlanRepository auditFeeCheckDetailPlanRepository;

    //结算核对管理活动
    @Autowired(required = false)
    private AuditFeeSettlementCheckDetailPlanRepository auditFeeSettlementCheckDetailPlanRepository;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    /**
     * 核销监听器
     */
    @Autowired(required = false)
    private AuditEventListener auditEventListener;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Override
    public Page<AuditFeeVerifyDecideVo> findByConditions(Pageable pageable, AuditFeeVerifyDecideDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeVerifyDecideDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (AuditFeeConstants.NATIONWIDE.equals(dto.getAreaCode())) {
            dto.setAreaCode(null);
        }
        Page<AuditFeeVerifyDecideVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<AuditFeeVerifyDecideVo> result = this.auditFeeVerifyDecideRepository.findByConditions(page, dto);
        if (CollectionUtils.isEmpty(result.getRecords())) {
            return result;
        }
        List<String> productCodes = result.getRecords().stream().map(AuditFeeVerifyDecideVo::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String,ProductVo> productVoMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(productCodes)) {
            List<ProductVo> productVoList = productVoService.findByCodes(productCodes);
            if (!CollectionUtils.isEmpty(productVoList)) {
                productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
            }
        }
        Map<String, List<AuditFeeVerifyDecideVo>> recordsMap = result.getRecords().stream().collect(Collectors.groupingBy(AuditFeeVerifyDecideVo::getSource));
        for (String key : recordsMap.keySet()) {
            List<AuditFeeVerifyDecideVo> valueList = recordsMap.get(key);
            if (CollectionUtils.isEmpty(valueList)) {
                continue;
            }
            List<String> activityItemCodes = valueList.stream().map(AuditFeeVerifyDecideVo::getActivityDetailItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());

            if (AuditFeeVerifyDecideSourceEnum.COST.getCode().equals(key)) {
                Map<String, AuditFeeVerifyDecideVo> decideVoMap = valueList.stream().collect(Collectors.toMap(a -> a.getActivityDetailItemCode()+a.getAuditFeeCheckCode(), Function.identity(), (v1, v2) -> v2));

                List<AuditFeeCheckDetailPlanVo> costActivityItemList = auditFeeCheckDetailPlanRepository.findActivityAndShareByActivityItemCodes(activityItemCodes);
                Map<String, AuditFeeCheckDetailPlanVo> costActivityItemMap = costActivityItemList.stream().collect(Collectors.toMap(a -> a.getDetailPlanItemCode()+a.getAuditFeeCheckCode(), Function.identity(), (v1, v2) -> v2));
                this.buildDataByCost(decideVoMap,costActivityItemMap,productVoMap);
            }

            if (AuditFeeVerifyDecideSourceEnum.STATEMENT.getCode().equals(key)) {
                Map<String, AuditFeeVerifyDecideVo> decideVoMap = valueList.stream().filter(f -> AuditFeeVerifyDecideSourceEnum.STATEMENT.getCode().equals(f.getSource())).collect(Collectors.toMap(a -> a.getActivityDetailItemCode()+a.getAuditFeeCheckCode(), Function.identity(), (v1, v2) -> v2));

                List<AuditFeeSettlementCheckDetailPlanVo> statementActivityItemList = auditFeeSettlementCheckDetailPlanRepository.findActivityAndShareByActivityItemCodes(activityItemCodes);
                Map<String, AuditFeeSettlementCheckDetailPlanVo> statementActivityItemMap = statementActivityItemList.stream().collect(Collectors.toMap(a -> a.getDetailPlanItemCode()+a.getCode(), Function.identity(), (v1, v2) -> v2));
                this.buildDataByStatement(decideVoMap,statementActivityItemMap,productVoMap);
            }
        }

        return result;
    }

    private void buildDataByStatement(Map<String, AuditFeeVerifyDecideVo> decideVoMap, Map<String, AuditFeeSettlementCheckDetailPlanVo> statementActivityItemMap, Map<String, ProductVo> productVoMap) {
        if (CollectionUtils.isEmpty(decideVoMap) || CollectionUtils.isEmpty(statementActivityItemMap)) {
            return;
        }
        statementActivityItemMap.forEach((k,v) ->{
            if (Objects.isNull(v)) {
                return;
            }
            AuditFeeVerifyDecideVo auditFeeVerifyDecideVo = decideVoMap.get(k);
            if (Objects.isNull(auditFeeVerifyDecideVo)) {
                return;
            }
            auditFeeVerifyDecideVo.setFeeAmount(v.getApplyAmount());
            auditFeeVerifyDecideVo.setActivityPreAuditAmount(v.getPredictionAuditAmount());
            auditFeeVerifyDecideVo.setAlreadyAuditAmount(v.getAlreadyAuditAmount());
            if (!CollectionUtils.isEmpty(productVoMap)) {
                ProductVo productVo = productVoMap.get(v.getProductCode());
                if (!Objects.isNull(productVo)) {
                    auditFeeVerifyDecideVo.setProductBrandCode(productVo.getProductBrandCode());
                    auditFeeVerifyDecideVo.setProductBrandName(productVo.getProductBrandName());
                    auditFeeVerifyDecideVo.setProductCategoryCode(productVo.getProductCategoryCode());
                    auditFeeVerifyDecideVo.setProductCategoryName(productVo.getProductCategoryName());
                    auditFeeVerifyDecideVo.setProductItemCode(productVo.getProductLevelCode());
                    auditFeeVerifyDecideVo.setProductItemCode(productVo.getProductLevelName());
                }
            }
        });
    }

    private void buildDataByCost(Map<String, AuditFeeVerifyDecideVo> decideVoMap, Map<String, AuditFeeCheckDetailPlanVo> costActivityItemMap, Map<String, ProductVo> productVoMap) {
        if (CollectionUtils.isEmpty(decideVoMap) || CollectionUtils.isEmpty(costActivityItemMap)) {
            return;
        }
        costActivityItemMap.forEach((k,v) ->{
            if (Objects.isNull(v)) {
                return;
            }
            AuditFeeVerifyDecideVo auditFeeVerifyDecideVo = decideVoMap.get(k);
            if (Objects.isNull(auditFeeVerifyDecideVo)) {
                return;
            }
            auditFeeVerifyDecideVo.setFeeAmount(v.getApplyAmount());
            auditFeeVerifyDecideVo.setActivityPreAuditAmount(v.getPredictionAuditAmount());
            auditFeeVerifyDecideVo.setAlreadyAuditAmount(v.getAlreadyAuditAmount());
            //auditFeeVerifyDecideVo.setVerifyDecideAmount(v.getAuditFeeCheckShareAmount());
            if (!CollectionUtils.isEmpty(productVoMap)) {
                ProductVo productVo = productVoMap.get(v.getProductCode());
                if (!Objects.isNull(productVo)) {
                    auditFeeVerifyDecideVo.setProductBrandCode(productVo.getProductBrandCode());
                    auditFeeVerifyDecideVo.setProductBrandName(productVo.getProductBrandName());
                    auditFeeVerifyDecideVo.setProductCategoryCode(productVo.getProductCategoryCode());
                    auditFeeVerifyDecideVo.setProductCategoryName(productVo.getProductCategoryName());
                    auditFeeVerifyDecideVo.setProductItemCode(productVo.getProductLevelCode());
                    auditFeeVerifyDecideVo.setProductItemCode(productVo.getProductLevelName());
                }
            }
        });
    }

    @Override
    public void createBatch(List<AuditFeeVerifyDecideDto> decideList) {
        if(CollectionUtils.isEmpty(decideList)){
            return;
        }
        Collection<AuditFeeVerifyDecide> list = this.nebulaToolkitService.copyCollectionByBlankList(decideList, AuditFeeVerifyDecideDto.class, AuditFeeVerifyDecide.class, HashSet.class, ArrayList.class);
        list.forEach(e -> {
            Validate.notBlank(e.getSource(),"来源不能为空！");
            Validate.notBlank(e.getActivityDetailItemCode(),"细案明细编码不能为空");
            e.setId(UUID.randomUUID().toString().replace("-", ""));
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            e.setTenantCode(TenantUtils.getTenantCode());
            e.setIsPush(IsPushEnum.WAIT.getCode());
        });
        this.auditFeeVerifyDecideRepository.saveBatch(list);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateWholeAudit(AuditFeeVerifyDecideDto dto) {
        Validate.notNull(dto,"参数不能为空！");
        Validate.notEmpty(dto.getIdList(),"请选择要编辑的参数！");
        Validate.notBlank(dto.getWholeAudit(),"是否完全结案不能为空！");
        if (!(YesOrNoEnum.YES.getCode().equals(dto.getWholeAudit()) || YesOrNoEnum.NO.getCode().equals(dto.getWholeAudit()))) {
            throw new IllegalArgumentException("是否完全结案值错误");
        }
        List<AuditFeeVerifyDecide> verifyDecideList = this.auditFeeVerifyDecideRepository.listByIds(dto.getIdList());
        Validate.notEmpty(verifyDecideList,"选择的数据不存在！");
        this.auditFeeVerifyDecideRepository.updateWholeAudit(dto.getIdList(),dto.getWholeAudit());
    }

    @Override
    public Page<AuditFeeVerifyDecideVo> pushAuditQuery(Pageable pageable, AuditFeeVerifyDecideDto dto) {
        Validate.notNull(dto,"参数不能为空！");
        Validate.notBlank(dto.getBusinessFormatCode(),"业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(),"业务单元不能为空！");
        Validate.notBlank(dto.getSalesInstitutionErpCode(),"销售机构编码不能为空！");
        Validate.notBlank(dto.getSalesInstitutionName(),"销售机构名称不能为空！");
        Validate.notBlank(dto.getAuditWay(),"结案形式不能为空！");
        Validate.notBlank(dto.getAreaCode(),"区域不能为空！");
        dto.setIsPushNot(IsPushEnum.SUCCESS.getCode());
        return this.findByConditions(pageable,dto);
    }

    @Override
    public void pushAudit(AuditFeeVerifyDecideDto dto) {
        this.pushAuditValidation(dto);
        boolean nationwide = false;
        if (AuditFeeConstants.NATIONWIDE.equals(dto.getAreaCode())) {
            nationwide = true;
            dto.setAreaCode(null);
        }
        List<AuditFeeVerifyDecideVo> willPushDataList = this.findWillPushAuditData(dto);
        Validate.notEmpty(willPushDataList,"需要下推核销单的数据不能为空！");
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();

        Map<String, List<AuditFeeVerifyDecideVo>> willPushDataMap = willPushDataList.stream().collect(Collectors.groupingBy(AuditFeeVerifyDecideVo::getActivityDetailItemCode));
        Validate.notEmpty(willPushDataMap.keySet(),"选择的扣费核定中的活动编码为空！");
        List<ActivityDetailPlanItemVo> activityDetailPlanItemList = activityDetailPlanItemSdkService.findByItemCodes(new ArrayList<>(willPushDataMap.keySet()));
        Validate.notEmpty(activityDetailPlanItemList,"未找到活动信息！");
        Validate.isTrue(willPushDataMap.keySet().size() == activityDetailPlanItemList.size(),"数据不匹配！选择的扣费核定中的活动编码（共:"+willPushDataMap.keySet().size()+"条，找到的活动详情（共:"+activityDetailPlanItemList.size()+"条。");

        log.info("下推核销单,开始组装数据");
        AutoAuditDto auditDto = new AutoAuditDto();
        HashMap<String,List<String>> auditFeeCheckCodeMap = new HashMap<>();

        List<AuditCustomerDetailDto> auditCustomerDetailList = new ArrayList<>(activityDetailPlanItemList.size() + 10);
        if (BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())){
            auditDto.setDataSource(DataSourceEnum.ACTIVITY_DETAIL.getCode());
        }else if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())){
            auditDto.setDataSource(DataSourceEnum.SON_ACTIVITY_DETAIL.getCode());
        }
        auditDto.setRegionCode(nationwide ? AuditFeeConstants.NATIONWIDE : dto.getAreaCode());
        auditDto.setAuditName(dto.getAuditName());
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        auditDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        auditDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        auditDto.setIsCollection(Boolean.TRUE);
        auditDto.setSaveType("");
        auditDto.setCompanyCode(dto.getSalesInstitutionErpCode());
        auditDto.setCompanyName(dto.getSalesInstitutionName());
        auditDto.setWhetherSpeciallyApproved(YesOrNoEnum.NO.getCode());
        auditDto.setWhetherPay(BooleanEnum.FALSE.getCapital());
        auditDto.setRemark(dto.getRemark());

        BigDecimal thisEndCaseTaxTotalAmount = BigDecimal.ZERO;
        BigDecimal discountTaxTotalAmount = BigDecimal.ZERO;
        BigDecimal discountTotalAmount = BigDecimal.ZERO;
        BigDecimal auditTaxTotalAmount = BigDecimal.ZERO;
        BigDecimal auditTotalAmount = BigDecimal.ZERO;

        for (ActivityDetailPlanItemVo detailPlanItemVo : activityDetailPlanItemList) {
            AuditCustomerDetailDto customerDetailDto = this.buildAuditCustomerDetail(loginUser,detailPlanItemVo);
            List<AuditFeeVerifyDecideVo> auditFeeVerifyDecideVos = willPushDataMap.get(detailPlanItemVo.getDetailPlanItemCode());
            if (!CollectionUtils.isEmpty(auditFeeVerifyDecideVos)) {

                //用来活动细案编码+核对编码 确定本次更新的是那些扣费核定，推送后更新状态使用。
                List<String> auditFeeCheckCodes = auditFeeVerifyDecideVos.stream().map(AuditFeeVerifyDecideVo::getAuditFeeCheckCode).filter(Objects::nonNull).collect(Collectors.toList());
                auditFeeCheckCodeMap.put(detailPlanItemVo.getDetailPlanItemCode(),auditFeeCheckCodes);

                //本次结案金额
                BigDecimal verifyDecideAmount = auditFeeVerifyDecideVos.stream().map(AuditFeeVerifyDecideVo::getVerifyDecideAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                customerDetailDto.setThisAuditAmount(verifyDecideAmount);
                thisEndCaseTaxTotalAmount = thisEndCaseTaxTotalAmount.add(verifyDecideAmount);

                //是否完全结案
                String wholeAuditYes = auditFeeVerifyDecideVos.stream().map(AuditFeeVerifyDecideVo::getWholeAudit).filter(e -> Objects.nonNull(e) && BooleanEnum.TRUE.getCapital().equals(e)).findFirst().orElse("");
                if (StringUtils.isBlank(wholeAuditYes)) {
                    String wholeAuditNo = auditFeeVerifyDecideVos.stream().map(AuditFeeVerifyDecideVo::getWholeAudit).filter(e -> Objects.nonNull(e) && BooleanEnum.FALSE.getCapital().equals(e)).findFirst().orElse("");
                    if (StringUtils.isBlank(wholeAuditNo)) {
                        //默认为 ’是‘
                        customerDetailDto.setWholeAudit(BooleanEnum.TRUE.getCapital());
                    }else {
                        customerDetailDto.setWholeAudit(BooleanEnum.FALSE.getCapital());
                    }
                }else {
                    customerDetailDto.setWholeAudit(BooleanEnum.TRUE.getCapital());
                }
                customerDetailDto.setIsDeductionFeePool(BooleanEnum.FALSE.getCapital());
                //结案形式为折扣，折扣税率0，折扣金额含税=折扣金额未税=申请金额
                if(EndCaseFormEnum.DISCOUNT.getCode().equals(customerDetailDto.getEndCaseForm())){
                    customerDetailDto.setDiscountTaxRate("0");
                    BigDecimal thisAuditAmount = Optional.ofNullable(customerDetailDto.getThisAuditAmount()).orElse(BigDecimal.ZERO);
                    customerDetailDto.setDiscountTaxAmount(thisAuditAmount);
                    customerDetailDto.setDiscountAmount(thisAuditAmount);
                    discountTaxTotalAmount = discountTaxTotalAmount.add(thisAuditAmount);
                    discountTotalAmount = discountTotalAmount.add(thisAuditAmount);
                }
                //结案形式为报销，报销税率0，报销金额含税=报销金额未税=申请金额
                if(EndCaseFormEnum.REIMBURSE.getCode().equals(customerDetailDto.getEndCaseForm())){
                    customerDetailDto.setReimburseTaxRate("0");
                    BigDecimal thisAuditAmount = Optional.ofNullable(customerDetailDto.getThisAuditAmount()).orElse(BigDecimal.ZERO);
                    customerDetailDto.setReimburseTaxAmount(thisAuditAmount);
                    customerDetailDto.setReimburseAmount(thisAuditAmount);
                    auditTaxTotalAmount = auditTaxTotalAmount.add(thisAuditAmount);
                    auditTotalAmount = auditTotalAmount.add(thisAuditAmount);
                }
            }

            auditCustomerDetailList.add(customerDetailDto);
        }

        auditDto.setThisEndCaseTaxTotalAmount(thisEndCaseTaxTotalAmount);
        auditDto.setDiscountTaxTotalAmount(discountTaxTotalAmount);
        auditDto.setDiscountTotalAmount(discountTotalAmount);
        auditDto.setAuditTaxTotalAmount(auditTaxTotalAmount);
        auditDto.setAuditTotalAmount(auditTotalAmount);

        auditDto.setCacheKey(UUID.randomUUID().toString().replace("-", ""));
        auditDto.setAuditCustomerDetailList(auditCustomerDetailList);

        //推送
        AuditDto resultDto = null;
        try {
            log.info("下推核销单,开始推送");
            log.info("下推核销单,auditDto:{}", JSONObject.toJSONString(auditDto));
            //推送
            resultDto = auditEventListener.autoAudit(auditDto);
            if (!Objects.isNull(resultDto) && StringUtils.isNotBlank(resultDto.getAuditCode())) {
                log.info("下推核销单,推送成功,更新推送结果");
                this.updatePushAuditResult(resultDto,auditFeeCheckCodeMap,IsPushEnum.SUCCESS.getCode());
            }else {
                throw new RuntimeException("下推核销单,推送失败!");
            }
        } catch (Exception e) {
            log.info("下推核销单,推送失败,更新推送结果");
            e.printStackTrace();
            this.updatePushAuditResult(resultDto,auditFeeCheckCodeMap,IsPushEnum.FAIL.getCode());
            throw e;
        }

    }

    @Transactional(rollbackFor = Exception.class)
    public void updatePushAuditResult(AuditDto resultDto,HashMap<String,List<String>> auditFeeCheckCodeMap, String status) {
        if (Objects.isNull(resultDto) || CollectionUtils.isEmpty(resultDto.getAuditCustomerDetailList())) {
            log.info("下推核销单,为空,无需更新推送结果");
            return;
        }
        if (CollectionUtils.isEmpty(auditFeeCheckCodeMap)) {
            log.info("下推核销单,更新状态时,核对单号为空！");
            return;
        }
        for (AuditCustomerDetailDto customerDetailDto : resultDto.getAuditCustomerDetailList()) {
            List<String> auditFeeCheckCodes = auditFeeCheckCodeMap.get(customerDetailDto.getActivityDetailCode());
            customerDetailDto.setAuditFeeCheckCodes(auditFeeCheckCodes);
        }
        this.auditFeeVerifyDecideRepository.updatePushAuditResult(resultDto.getAuditCustomerDetailList(),resultDto.getAuditCode(),status);
    }


    private List<AuditFeeVerifyDecideVo> findWillPushAuditData(AuditFeeVerifyDecideDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<AuditFeeVerifyDecideVo> list = this.auditFeeVerifyDecideRepository.findWillPushAuditData(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public void pushAuditValidation(AuditFeeVerifyDecideDto decideDto){
        Validate.notNull(decideDto,"推送数据不能为空");
        Validate.notBlank(decideDto.getBusinessFormatCode(),"业态不能为空");
        Validate.notBlank(decideDto.getBusinessUnitCode(),"业务单元不能为空");
        Validate.notBlank(decideDto.getAreaCode(),"区域不能为空！");
        Validate.notBlank(decideDto.getAuditName(),"核销名称不能为空");
        Validate.notBlank(decideDto.getBusinessFormatCode(),"业态不能为空");
        Validate.notBlank(decideDto.getBusinessUnitCode(),"业务单元不能为空");
        Validate.notBlank(decideDto.getSalesInstitutionErpCode(),"销售机构编码不能为空");
        Validate.notBlank(decideDto.getAuditWay(),"结案形式不能为空");
    }

    private AuditCustomerDetailDto buildAuditCustomerDetail(AbstractCrmUserIdentity loginUser, ActivityDetailPlanItemVo itemVo) {
        if (Objects.isNull(itemVo)) {
            return null;
        }
        AuditCustomerDetailDto dto = new AuditCustomerDetailDto();
        dto.setRegion(itemVo.getRegion());
        dto.setActivityDetailCode(itemVo.getDetailPlanItemCode());
        dto.setActivityCode(itemVo.getDetailPlanCode());
        dto.setActivityName(itemVo.getDetailPlanName());
        dto.setActivityFormCode(itemVo.getActivityFormCode());
        dto.setActivityFormName(itemVo.getActivityFormName());
        dto.setActivityTypeCode(itemVo.getActivityTypeCode());
        dto.setActivityTypeName(itemVo.getActivityTypeName());
        dto.setActivityBeginTime(itemVo.getActivityBeginDate());
        dto.setActivityEndTime(itemVo.getActivityEndDate());
        dto.setSystemCode(itemVo.getSystemCode());
        dto.setSystemName(itemVo.getSystemName());
        dto.setCustomerCode(itemVo.getCustomerCode());
        dto.setCustomerErpCode(itemVo.getCustomerErpCode());
        dto.setCustomerName(itemVo.getCustomerName());
        dto.setDistributionChannelCode(itemVo.getDistributionChannelCode());
        dto.setDistributionChannelName(itemVo.getDistributionChannelName());
        dto.setSalesInstitutionErpCode(itemVo.getSalesInstitutionErpCode());
        dto.setSalesOrgName(itemVo.getActivityOrgName());
        dto.setSalesOrgCode(itemVo.getActivityOrgCode());
        dto.setStoreCode(itemVo.getTerminalCode());
        dto.setStoreName(itemVo.getTerminalName());
        dto.setApplyAmount(itemVo.getFeeAmount());
        dto.setAuditAmount(itemVo.getAuditAmount());
        dto.setCustomerSupplierType(CustomerSupplierTypeEnum.CUSTOMER.getValue());
        dto.setAuditConditionCode(itemVo.getWriteOffMethod());
        dto.setEndCaseCustomerCode(itemVo.getCustomerCode());
        dto.setEndCaseCustomerName(itemVo.getCustomerName());
        dto.setEndCaseForm(itemVo.getAuditForm());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTaxQuota(BigDecimal.ZERO);
        dto.setAlreadyAuditAmount(itemVo.getAlreadyAuditAmount());
        dto.setCreateTime(new Date());
        if (!Objects.isNull(loginUser)) {
            dto.setCreateName(loginUser.getUsername());
            dto.setCreateAccount(loginUser.getAccount());
        }

        return dto;
    }

    @Override
    public void updateStatusByAudit(List<String> auditCodeList, List<String> auditDetailCodeList) {
        if (CollectionUtils.isEmpty(auditCodeList) && CollectionUtils.isEmpty(auditDetailCodeList)) {
            return;
        }
        this.auditFeeVerifyDecideRepository.updateStatusByAudit(auditCodeList,auditDetailCodeList,TenantUtils.getTenantCode());
    }
}
