package com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.WriteOffMethodEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeCheckPosConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.PosMatchActTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosMatchActivityService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.AuditFeeCheckActivityAmountSummaryVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Slf4j
@Component
public class AuditFeeCheckPosMatchActivityServiceImpl implements AuditFeeCheckPosMatchActivityService {

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DetailedForecastService detailedForecastService;

    @Autowired(required = false)
    private AuditFeeCheckPosRepository auditFeeCheckPosRepository;

    @Autowired(required = false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;

    @Autowired(required = false)
    private AuditFeeCheckDetailPlanVoService auditFeeCheckDetailPlanVoService;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;

    /**
     * POS匹活动 异步
     *
     * @param dto
     * @param posList
     * @param abstractLoginUser
     */
    @Override
    @Async("auditFeeMatchThread")
    public void posMatchActivityAsync(AuditFeeCheckPosDto dto, List<AuditFeeCheckPosVo> posList, AbstractCrmUserIdentity abstractLoginUser) {
        loginUserService.refreshAuthentication(abstractLoginUser);
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckPosDto());
        posMatchActivity(dto, posList);
    }

    /**
     * POS匹活动
     *
     * @param dto
     * @param posList
     */
    @Override
    public void posMatchActivity(AuditFeeCheckPosDto dto, List<AuditFeeCheckPosVo> posList) {
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckPosDto());
        log.info("=====>    POS匹配活动 组装数据 start    <=====");
        List<AuditFeeCheckPosVo> posVoList = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(posList)) {
            posVoList.addAll(posList);
        }
        if (StringUtils.isNotEmpty(dto.getMatchCode())) {
            List<AuditFeeCheckPos> list = auditFeeCheckPosRepository.findByMatchCode(dto.getMatchCode());
            if (CollectionUtil.isNotEmpty(list)) {
                List<AuditFeeCheckPosVo> matchCodePostList = (List<AuditFeeCheckPosVo>) nebulaToolkitService.copyCollectionByWhiteList(list, AuditFeeCheckPos.class, AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class);
                if (CollectionUtil.isNotEmpty(matchCodePostList)) {
                    posVoList.addAll(matchCodePostList);
                }
            }
        }

        if (CollectionUtil.isEmpty(posVoList)) {
            return;
        }
        //过滤已匹配活动的pos
        List<AuditFeeCheckPosVo> posVos = posVoList.stream()
                .filter(pos -> StringUtils.isBlank(pos.getActivityDetailItemCode())
                        || !BooleanEnum.TRUE.getCapital().equals(pos.getIsMatchActivity())
                        || StringUtils.isNotEmpty(pos.getTerminalCode()))
                .collect(Collectors.toList());
        log.info("=====>    POS匹配活动 组装数据[{}]条 end    <=====", posVos.size());
        if (CollectionUtils.isEmpty(posVos)) {
            return;
        }
        log.info("=====>    垂直POS匹配活动 start    <=====");
        this.verticalPosMatchActivity(posVoList);
        log.info("=====>    垂直POS匹配活动 end    <=====");
        log.info("=====>    分子POS匹配活动 start   <=====");
        this.sonCompanyPosMatchActivity(posVoList);
        log.info("=====>    分子POS匹配活动 end   <=====");

    }

    /**
     * 垂直活动匹配
     *
     * @param posVoList
     */
    private void verticalPosMatchActivity(List<AuditFeeCheckPosVo> posVoList) {
        if (CollectionUtil.isEmpty(posVoList)) {
            return;
        }
        List<AuditFeeCheckPosVo> resultVoList = posVoList.stream()
                .filter(k -> BusinessUnitEnum.VERTICAL.getCode().equals(k.getBusinessUnitCode()))
                .filter(k -> StringUtils.isNotEmpty(k.getTerminalCode()))
                .filter(k -> StringUtils.isNotEmpty(k.getProductCode()))
                .filter(k -> Objects.nonNull(k.getSalesDate()))
                .collect(Collectors.toList());
        if (CollectionUtil.isEmpty(resultVoList)) {
            return;
        }
        Map<String, List<AuditFeeCheckPosVo>> listMap = resultVoList.stream()
                .collect(Collectors.groupingBy(AuditFeeCheckPosVo::getTerminalCode));
        listMap.forEach((terminalCode, list) -> {
            AuditFeeCheckPosVo posHeadVo = list.get(0);
            List<String> productList = list.stream()
                    .map(AuditFeeCheckPosVo::getProductCode)
                    .distinct().collect(Collectors.toList());
            Page<ActivityDetailPlanItemVo> planItemVoPage = null;
            List<ActivityDetailPlanItemVo> planItemVoList = null;
            //垂直查活动细案
            ActivityDetailPlanItemDto czQueryDto = new ActivityDetailPlanItemDto();
            czQueryDto.setBusinessFormatCode(posHeadVo.getBusinessFormatCode());
            czQueryDto.setBusinessUnitCode(posHeadVo.getBusinessUnitCode());
            czQueryDto.setTerminalCode(terminalCode);
            czQueryDto.setIncludeProductCodeList(productList);
            czQueryDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            czQueryDto.setIsTimeAsc(BooleanEnum.TRUE.getCapital());
            czQueryDto.setWriteOffMethod(WriteOffMethodEnum.AFTER_THE_EVENT.getCode());
            Pageable pageable = PageRequest.of(1, AuditFeeConstants.PAGE_SIZE);
            do {
                planItemVoPage = activityDetailPlanItemSdkService.findByConditions(pageable, czQueryDto);
                log.info("=====>    POS匹配垂直活动[{}/{}]    <====", planItemVoPage.getCurrent(), planItemVoPage.getPages());
                if (CollectionUtil.isEmpty(planItemVoPage.getRecords())) {
                    return;
                }
                pageable = pageable.next();
                planItemVoList = planItemVoPage.getRecords();
                List<AuditFeeCheckPosVo> updatePosList = new ArrayList<>();
                List<ActivityDetailPlanItemVo> updateDetailPlanList = new ArrayList<>();
                for (AuditFeeCheckPosVo posVo : list) {
                    log.info("=====>    POS匹配活动[{}]    <====", posVo.getMatchCode());
                    //已匹配的 或 门店、产品、销售日期任意为空的pos不匹配活动。
                    if (StringUtils.isNotEmpty(posVo.getActivityDetailCode())
                            || StringUtils.isNotEmpty(posVo.getActivityDetailItemCode())
                            || BooleanEnum.TRUE.getCapital().equals(posVo.getIsMatchActivity())
                            || StringUtils.isBlank(posVo.getTerminalCode())
                            || StringUtils.isBlank(posVo.getProductCode())
                            || StringUtils.isBlank(posVo.getChannelName())
                            || Objects.isNull(posVo.getSalesDate())) {
                        continue;
                    }
                    //零售商+单店+单品+单日+渠道匹配一条活动
                    ActivityDetailPlanItemVo planItemVo = this.verticalPosMatchAct(posVo, planItemVoList);
                    if (Objects.isNull(planItemVo)) {
                        log.info("垂直POS未匹配到活动POS信息[{}]", JSON.toJSONString(posVo));
                        log.info("垂直POS未匹配到活动活动信息{}", JSON.toJSONString(planItemVoList));
                        continue;
                    }
                    this.verticalPosMatchActUpdateVo(posVo, planItemVo);
                    posVo.setMatchActivityType(PosMatchActTypeEnum.AUTO.getCode());
                    //添加已匹配集合中。
                    updatePosList.add(posVo);
                    planItemVo.setMatchCode(posVo.getMatchCode());
                    updateDetailPlanList.add(planItemVo);
                }
                if (CollectionUtil.isNotEmpty(updateDetailPlanList)) {
                    List<AuditFeeCheckDetailPlanVo> detailPlanVoList = this.verticalDetailPlanList(updateDetailPlanList);
                    updateDetailPlanList.stream()
                            .filter(ActivityDetailPlanItemBase::isSingleBatch).forEach(item -> {
                        activityDetailPlanItemSdkService.useProductNumber(item);
                    });
                    this.saveResult(updatePosList, detailPlanVoList);
                }
                //判断是否所有已匹配
                AuditFeeCheckPosVo notMatchPos = resultVoList.stream()
                        .filter(p -> StringUtils.isBlank(p.getActivityDetailItemCode()))
                        .findAny().orElse(null);
                if (Objects.isNull(notMatchPos)) {
                    return;
                }
            } while (planItemVoPage.hasNext());
        });
    }

    /**
     * 垂直POS匹配活动后更新数据
     *
     * @param posVo
     * @param planItemVo
     * @return
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-11-04 16:30
     */
    @Override
    public void verticalPosMatchActUpdateVo(AuditFeeCheckPosVo posVo, ActivityDetailPlanItemVo planItemVo) {
        if (Objects.isNull(posVo)) {
            return;
        }
        planItemVo = Optional.ofNullable(planItemVo).orElse(new ActivityDetailPlanItemVo());
        posVo.setActivityDetailCode(planItemVo.getDetailPlanCode());
        posVo.setActivityDetailName(planItemVo.getDetailPlanName());
        posVo.setActivityDetailItemCode(planItemVo.getDetailPlanItemCode());
        posVo.setActivityDetailItemName(planItemVo.getDetailPlanName());

        //数量
        BigDecimal productNumber = Optional.ofNullable(posVo.getProductNumber()).orElse(BigDecimal.ZERO);
        planItemVo.setPeriodPromotionalNumberUse(productNumber.intValue());
        BigDecimal promotionDeduction = Optional.ofNullable(posVo.getPromotionDeduction()).orElse(BigDecimal.ZERO);
        BigDecimal onePromotionDeduction = Optional.ofNullable(posVo.getOnePromotionDeduction()).orElse(BigDecimal.ZERO);
        if (BigDecimal.ZERO.compareTo(productNumber) != 0
                && BigDecimal.ZERO.compareTo(onePromotionDeduction) == 0) {
            onePromotionDeduction = promotionDeduction.divide(productNumber, 4, BigDecimal.ROUND_HALF_UP);
            posVo.setOnePromotionDeduction(onePromotionDeduction);
        }

        //单件申请费用
        BigDecimal oneApplicationFee = Optional.ofNullable(planItemVo.getSingleApplicationFee()).orElse(BigDecimal.ZERO);
        posVo.setOneApplicationFee(oneApplicationFee);
        //单件费用差异 = 单件促销扣款（元）- 单件申请费用（元）
        BigDecimal oneDiffAmount = onePromotionDeduction.subtract(oneApplicationFee);
        posVo.setOneDiffAmount(oneDiffAmount);
        //分摊促销扣款
        BigDecimal sharePromotionDeduction = Optional.ofNullable(posVo.getSharePromotionDeduction()).orElse(BigDecimal.ZERO);
        posVo.setSharePromotionDeduction(sharePromotionDeduction);
        //差异总费用
        posVo.setTotalDiffAmount(oneDiffAmount.multiply(productNumber).add(sharePromotionDeduction));
        posVo.setTotalDiffFinalAmount(posVo.getTotalDiffAmount());

        posVo.setDiffType(this.oneDiffAmountGetDiffType(posVo.getTotalDiffFinalAmount(), posVo.getActivityDetailItemCode()));

        //在拉取POS数据时因为还未匹配活动默认为 : 多扣款无批复
        if (StringUtils.isEmpty(posVo.getActivityDetailItemCode())) {
            posVo.setIsMatchActivity(BooleanEnum.FALSE.getCapital());
        } else {
            posVo.setIsMatchActivity(BooleanEnum.TRUE.getCapital());
        }
    }

    /**
     * 根据单间费用差异金额获取差异类型
     *
     * @param amount
     * @param activityDetailItemCode
     * @return java.lang.String
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-12-21 21:12
     */
    @Override
    public String oneDiffAmountGetDiffType(BigDecimal amount, String activityDetailItemCode) {
        //1、多扣款无批复:未匹配上活动且差异总费用>0
        //2、多扣款有批复:匹配上活动且差异总费用>0
        //3、少扣款无批复:未匹配上活动且差异总费用<0
        //4、少扣款有批复:匹配上活动且差异总费用<0
        //5、无差异: 匹配上活动且差异总费用为0，或者未匹配上活动且差异总费用
        if (Objects.isNull(amount)
                || BigDecimal.ZERO.compareTo(amount) == 0) {
            return DiffTypeEnum.NO_DIFF.getCode();
        }
        if (StringUtil.isNotEmpty(activityDetailItemCode)) {
            //2、多扣款有批复:匹配上活动且差异总费用>0
            //4、少扣款有批复:匹配上活动且差异总费用<0
            if (BigDecimal.ZERO.compareTo(amount) < 0) {
                return DiffTypeEnum.MORE_DEDUCTION_HAD_DEDUCTION.getCode();
            } else if (BigDecimal.ZERO.compareTo(amount) > 0) {
                return DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode();
            }
        } else {
            //1、多扣款无批复:未匹配上活动且差异总费用>0
            //3、少扣款无批复:未匹配上活动且差异总费用<0
            if (BigDecimal.ZERO.compareTo(amount) < 0) {
                return DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode();
            } else if (BigDecimal.ZERO.compareTo(amount) > 0) {
                return DiffTypeEnum.LESS_DEDUCTION_NO_DEDUCTION.getCode();
            }
        }

        return "-1";
    }

    /**
     * POS垂直匹配活动
     *
     * @param posVo
     * @param planItemVoList
     * @return
     */
    private ActivityDetailPlanItemVo verticalPosMatchAct(AuditFeeCheckPosVo posVo, List<ActivityDetailPlanItemVo> planItemVoList) {
        if (CollectionUtil.isEmpty(planItemVoList)
                || Objects.isNull(posVo)) {
            return null;
        }
        // 1、按业态、业务单元、零售商、单店、渠道名称、单品、单日维度自动匹配活动
        // 1.1活动如果未关闭，活动时间直接取活动开始日期-活动结束日期； 零售商渠道非全渠道:区分渠道
        // 1.2活动如果已关闭，活动时间取活动开始日期-活动关闭日期;  零售商渠道非全渠道:区分渠道
        // 1.3活动如果未关闭，活动时间直接取活动开始日期-活动结束日期； 全渠道:则匹配POS时不区分渠道
        // 1.4活动如果已关闭，活动时间取活动开始日期-活动关闭日期;  全渠道:则匹配POS时不区分渠道

        ActivityDetailPlanItemVo detailPlanItemVo = null;
        //1.1活动如果未关闭，活动时间直接取活动开始日期-活动结束日期； 零售商渠道非全渠道:区分渠道
        List<ActivityDetailPlanItemVo> planItemVoNewList = planItemVoList.stream()
                .filter(k -> !AuditFeeCheckPosConstants.ALL_CHANNEL_NAME.equals(k.getRetailerChannel()))
                .filter(k -> BooleanEnum.FALSE.getCapital().equals(k.getIsClose()))
                .filter(k -> Objects.nonNull(k.getSingleApplicationFee()))
                .filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode())
                        && posVo.getProductCode().equals(item.getProductCode())
                        && posVo.getChannelName().equals(item.getRetailerChannel())
                        && posVo.getSalesDate().compareTo(item.getActivityBeginDate()) >= 0
                        && posVo.getSalesDate().compareTo(item.getActivityEndDate()) <= 0)
                .collect(Collectors.toList());
        detailPlanItemVo = this.getDetailPlanVo(planItemVoNewList);
        if (Objects.nonNull(detailPlanItemVo)) {
            return detailPlanItemVo;
        }

        // 1.2活动如果已关闭，活动时间取活动开始日期-活动关闭日期;  零售商渠道非全渠道:区分渠道
        planItemVoNewList = planItemVoList.stream()
                .filter(k -> !AuditFeeCheckPosConstants.ALL_CHANNEL_NAME.equals(k.getRetailerChannel()))
                .filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getIsClose()))
                .filter(k -> Objects.nonNull(k.getCloseDate()))
                .filter(k -> Objects.nonNull(k.getSingleApplicationFee()))
                .filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode())
                        && posVo.getProductCode().equals(item.getProductCode())
                        && posVo.getChannelName().equals(item.getRetailerChannel())
                        && posVo.getSalesDate().compareTo(item.getActivityBeginDate()) >= 0
                        && posVo.getSalesDate().compareTo(item.getCloseDate()) <= 0)
                .collect(Collectors.toList());
        detailPlanItemVo = this.getDetailPlanVo(planItemVoNewList);
        if (Objects.nonNull(detailPlanItemVo)) {
            return detailPlanItemVo;
        }

        // 1.3活动如果未关闭，活动时间直接取活动开始日期-活动结束日期； 全渠道:则匹配POS时不区分渠道
        planItemVoNewList = planItemVoList.stream()
                .filter(k -> AuditFeeCheckPosConstants.ALL_CHANNEL_NAME.equals(k.getRetailerChannel()))
                .filter(k -> BooleanEnum.FALSE.getCapital().equals(k.getIsClose()))
                .filter(k -> Objects.nonNull(k.getSingleApplicationFee()))
                .filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode())
                        && posVo.getProductCode().equals(item.getProductCode())
                        && posVo.getSalesDate().compareTo(item.getActivityBeginDate()) >= 0
                        && posVo.getSalesDate().compareTo(item.getActivityEndDate()) <= 0)
                .collect(Collectors.toList());
        detailPlanItemVo = this.getDetailPlanVo(planItemVoNewList);
        if (Objects.nonNull(detailPlanItemVo)) {
            return detailPlanItemVo;
        }

        //1.4活动如果已关闭，活动时间取活动开始日期-活动关闭日期;  全渠道:则匹配POS时不区分渠道
        planItemVoNewList = planItemVoList.stream()
                .filter(k -> AuditFeeCheckPosConstants.ALL_CHANNEL_NAME.equals(k.getRetailerChannel()))
                .filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getIsClose()))
                .filter(k -> Objects.nonNull(k.getCloseDate()))
                .filter(k -> Objects.nonNull(k.getSingleApplicationFee()))
                .filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode())
                        && posVo.getProductCode().equals(item.getProductCode())
                        && posVo.getSalesDate().compareTo(item.getActivityBeginDate()) >= 0
                        && posVo.getSalesDate().compareTo(item.getCloseDate()) <= 0)
                .collect(Collectors.toList());
        return this.getDetailPlanVo(planItemVoNewList);
    }

    private ActivityDetailPlanItemVo getDetailPlanVo(List<ActivityDetailPlanItemVo> planItemVoNewList) {
        if (CollectionUtil.isEmpty(planItemVoNewList)) {
            return null;
        }
        planItemVoNewList.sort(Comparator.comparing(ActivityDetailPlanItemVo::getSingleApplicationFee).reversed());
        ActivityDetailPlanItemVo detailPlanItemVo = null;
        if (planItemVoNewList.size() > 1) {
            for (ActivityDetailPlanItemVo itemVo : planItemVoNewList) {
                if (Objects.isNull(itemVo.getPeriodPromotionalNumberUse())
                        || (Objects.nonNull(itemVo.getPeriodPromotionalNumber())
                        && itemVo.getPeriodPromotionalNumber().compareTo(itemVo.getPeriodPromotionalNumberUse()) > 0)) {
                    itemVo.setSingleBatch(true);
                    detailPlanItemVo = itemVo;
                    break;
                }
            }
            if (Objects.isNull(detailPlanItemVo)) {
                detailPlanItemVo = planItemVoNewList.get(planItemVoNewList.size() - 1);
            }
        } else {
            detailPlanItemVo = planItemVoNewList.get(0);
        }
        return detailPlanItemVo;
    }

    /**
     * 垂直活动 核销费用核对关联细案
     *
     * @param detailPlanItemVoList
     */
    @Override
    public List<AuditFeeCheckDetailPlanVo> verticalDetailPlanList(List<ActivityDetailPlanItemVo> detailPlanItemVoList) {
        List<AuditFeeCheckDetailPlanVo> result = new ArrayList<>();
        //垂直-细案汇总
        if (CollectionUtil.isEmpty(detailPlanItemVoList)) {
            return result;
        }
        //查找到的细案数据，在这里进行汇总
        //取活动细案预测数据的预结案金额进行汇总
        AuditFeeCheckActivityAmountSummaryVo summaryVo = detailPlanItemAmountSummaryForVertical(detailPlanItemVoList);
        List<DetailedForecastVo> detailedForecastVoList = summaryVo.getDetailedForecastVoList();
        List<String> detailPlanCodeList = detailPlanItemVoList.stream()
                .map(ActivityDetailPlanItemVo::getDetailPlanCode)
                .distinct().collect(Collectors.toList());
        if (CollectionUtil.isEmpty(detailPlanCodeList)) {
            return result;
        }
        List<ActivityDetailPlanVo> detailPlanVoList = activityDetailPlanSdkService.findByCodes(detailPlanCodeList);

        BigDecimal activityPreAuditAmount = BigDecimal.ZERO;
        for (ActivityDetailPlanItemVo detailPlanVo : detailPlanItemVoList) {
            Optional<DetailedForecastVo> detailedForecastVo = detailedForecastVoList.stream()
                    .filter(o -> detailPlanVo.getDetailPlanItemCode().equals(o.getActivityDetailItemCode()))
                    .findAny();
            Optional<ActivityDetailPlanVo> planVo = detailPlanVoList.stream()
                    .filter(o -> detailPlanVo.getDetailPlanCode().equals(o.getDetailPlanCode())).findAny();
            AuditFeeCheckDetailPlanVo feeCheckDetailPlanVo = new AuditFeeCheckDetailPlanVo();
            //1若先费用单匹pos，pos后匹活动,则pos上’matchCode‘有值。
            feeCheckDetailPlanVo.setAuditFeeCheckCode(detailPlanVo.getMatchCode());
            //2若先pos匹活动，费单后匹pos，则通过‘posId’将对应‘matchCode’赋给pos已匹配了的活动
            feeCheckDetailPlanVo.setPosId(detailPlanVo.getPosId());

            feeCheckDetailPlanVo.setDetailPlanItemCode(detailPlanVo.getDetailPlanItemCode());
            feeCheckDetailPlanVo.setDetailPlanCode(detailPlanVo.getDetailPlanCode());
            feeCheckDetailPlanVo.setActivityBeginDate(detailPlanVo.getActivityBeginDate());
            feeCheckDetailPlanVo.setActivityEndDate(detailPlanVo.getActivityEndDate());
            feeCheckDetailPlanVo.setActivityTypeCode(detailPlanVo.getActivityTypeCode());
            feeCheckDetailPlanVo.setActivityTypeName(detailPlanVo.getActivityTypeName());
            feeCheckDetailPlanVo.setActivityFormCode(detailPlanVo.getActivityFormCode());
            feeCheckDetailPlanVo.setActivityFormName(detailPlanVo.getActivityFormName());
            feeCheckDetailPlanVo.setTerminalCode(detailPlanVo.getTerminalCode());
            feeCheckDetailPlanVo.setTerminalName(detailPlanVo.getTerminalName());
            feeCheckDetailPlanVo.setProductCode(detailPlanVo.getProductCode());
            feeCheckDetailPlanVo.setProductName(detailPlanVo.getProductName());
            feeCheckDetailPlanVo.setSystemCode(detailPlanVo.getSystemCode());
            feeCheckDetailPlanVo.setSystemName(detailPlanVo.getSystemName());
            feeCheckDetailPlanVo.setRegion(detailPlanVo.getRegion());
            feeCheckDetailPlanVo.setWriteOffMethod(detailPlanVo.getWriteOffMethod());
            feeCheckDetailPlanVo.setAuditForm(detailPlanVo.getAuditForm());
            feeCheckDetailPlanVo.setDetailPlanCode(detailPlanVo.getDetailPlanCode());
            feeCheckDetailPlanVo.setActivityYearMonth(DateUtil.format(detailPlanVo.getFeeYearMonth(), "yyyy-MM"));
            feeCheckDetailPlanVo.setRemark(detailPlanVo.getRemark());
            feeCheckDetailPlanVo.setIsPos(BooleanEnum.TRUE.getCapital());
            detailPlanVo.setPeriodPromotionalNumber(Optional.ofNullable(detailPlanVo.getPeriodPromotionalNumber()).orElse(0));
            feeCheckDetailPlanVo.setApplyAmount(detailPlanVo.getTotalFeeAmount());
            detailedForecastVo.ifPresent(o -> feeCheckDetailPlanVo.setPredictionAuditAmount(o.getEstimatedWriteOffAmount()));
            planVo.ifPresent(o -> feeCheckDetailPlanVo.setDetailPlanName(o.getDetailPlanName()));
            BigDecimal alreadyAuditAmount = Optional.ofNullable(detailPlanVo.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO);
            feeCheckDetailPlanVo.setAlreadyAuditAmount(alreadyAuditAmount);
            BigDecimal preAuditAmount = Optional.ofNullable(feeCheckDetailPlanVo.getPredictionAuditAmount()).orElse(BigDecimal.ZERO);
            //剩余可结案金额=预结案金额-已结案金额
            feeCheckDetailPlanVo.setCanAuditAmount(preAuditAmount.subtract(alreadyAuditAmount));
            activityPreAuditAmount = activityPreAuditAmount.add(feeCheckDetailPlanVo.getCanAuditAmount());
            feeCheckDetailPlanVo.setAuditFeeCheckShareAmount(feeCheckDetailPlanVo.getAuditFeeCheckShareAmount());

            result.add(feeCheckDetailPlanVo);
        }
        return result;
    }

    /**
     * 分子活动匹配
     *
     * @param posVoList
     */
    private void sonCompanyPosMatchActivity(List<AuditFeeCheckPosVo> posVoList) {
        if (CollectionUtil.isEmpty(posVoList)) {
            return;
        }
        List<AuditFeeCheckPosVo> resultVoList = posVoList.stream()
                .filter(k -> BusinessUnitEnum.SON_COMPANY.getCode().equals(k.getBusinessUnitCode()))
                .filter(k -> StringUtils.isNotEmpty(k.getTerminalCode()))
                .filter(k -> StringUtils.isNotEmpty(k.getProductCode()))
                .filter(k -> Objects.nonNull(k.getSalesDate()))
                .collect(Collectors.toList());
        if (CollectionUtil.isEmpty(resultVoList)) {
            return;
        }

        Map<String, List<AuditFeeCheckPosVo>> listMap = resultVoList.stream()
                .collect(Collectors.groupingBy(AuditFeeCheckPosVo::getTerminalCode));
        SubComActivityDetailPlanItemDto fzQueryDto = new SubComActivityDetailPlanItemDto();
        listMap.forEach((terminalCode, list) -> {
            List<String> productList = list.stream()
                    .map(AuditFeeCheckPosVo::getProductCode)
                    .distinct().collect(Collectors.toList());
            AuditFeeCheckPosVo posHeadVo = list.get(0);
            Page<SubComActivityDetailPlanItemVo> planItemVoPage = null;
            List<SubComActivityDetailPlanItemVo> fzPlanItemVoList = null;
            fzQueryDto.setBusinessFormatCode(posHeadVo.getBusinessFormatCode());
            fzQueryDto.setBusinessUnitCode(posHeadVo.getBusinessUnitCode());
            fzQueryDto.setTerminalCode(terminalCode);
            fzQueryDto.setProductCodeList(productList);
            fzQueryDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            Pageable pageable = PageRequest.of(1, AuditFeeConstants.PAGE_SIZE);
            do {
                planItemVoPage = subComActivityDetailPlanItemVoService.findByConditions(pageable, fzQueryDto);
                if (Objects.isNull(planItemVoPage) ||
                        CollectionUtil.isEmpty(planItemVoPage.getRecords())) {
                    return;
                }
                pageable = pageable.next();
                fzPlanItemVoList = planItemVoPage.getRecords();
                List<AuditFeeCheckPosVo> updatePosList = new ArrayList<>();
                List<SubComActivityDetailPlanItemVo> updateDetailPlanList = new ArrayList<>();
                for (AuditFeeCheckPosVo posVo : list) {
                    //已匹配的 或 门店、产品、销售日期任意为空的pos不匹配活动。
                    if (StringUtils.isNotEmpty(posVo.getActivityDetailItemCode())
                            || BooleanEnum.TRUE.getCapital().equals(posVo.getIsMatchActivity())
                            || StringUtils.isBlank(posVo.getTerminalCode())
                            || StringUtils.isBlank(posVo.getProductCode())
                            || Objects.isNull(posVo.getSalesDate())) {
                        continue;
                    }
                    //零售商+单店+单品+单日+渠道匹配一条活动
                    SubComActivityDetailPlanItemVo activityVo = this.sonCompanyPosMatchAct(posVo, fzPlanItemVoList);
                    if (Objects.isNull(activityVo)) {
                        log.info("分子POS未匹配到活动POS信息[{}]", JSON.toJSONString(posVo));
                        log.info("分子POS未匹配到活动活动信息{}", JSON.toJSONString(fzPlanItemVoList));
                        continue;
                    }
                    this.sonCompanyPosMatchActUpdateVo(posVo, activityVo);
                    posVo.setMatchActivityType(PosMatchActTypeEnum.AUTO.getCode());
                    //添加已匹配集合中。
                    updatePosList.add(posVo);
                    activityVo.setMatchCode(posVo.getMatchCode());
                    updateDetailPlanList.add(activityVo);
                }
                if (CollectionUtil.isNotEmpty(updateDetailPlanList)) {
                    List<AuditFeeCheckDetailPlanVo> detailPlanVoList = this.sonCompanyDetailPlanList(updateDetailPlanList);
                    updateDetailPlanList.stream()
                            .filter(SubComActivityDetailPlanItemVo::isSingleBatch)
                            .forEach(item -> {
                                subComActivityDetailPlanItemVoService.useProductNumber(item);
                            });
                    this.saveResult(updatePosList, detailPlanVoList);
                }
                //判断所有pos是否已匹配
                AuditFeeCheckPosVo notMatchPos = list.stream()
                        .filter(p -> StringUtils.isBlank(p.getActivityDetailItemCode())
                                || BooleanEnum.FALSE.getCapital().equals(p.getIsMatchActivity())).findAny().orElse(null);
                if (Objects.isNull(notMatchPos)) {
                    return;
                }
            }
            while (planItemVoPage.hasNext());
        });

    }


    /**
     * 分子POS匹配活动后更新数据
     *
     * @param posVo
     * @param planItemVo
     * @return
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-11-04 16:30
     */
    @Override
    public void sonCompanyPosMatchActUpdateVo(AuditFeeCheckPosVo posVo, SubComActivityDetailPlanItemVo planItemVo) {
        if (Objects.isNull(posVo)) {
            return;
        }
        planItemVo = Optional.ofNullable(planItemVo).orElse(new SubComActivityDetailPlanItemVo());
        posVo.setActivityDetailCode(planItemVo.getConstituentDetailPlanCode());
        posVo.setActivityDetailName(planItemVo.getConstituentDetailPlanName());
        posVo.setActivityDetailItemCode(planItemVo.getConstituentDetailPlanItemCode());
        posVo.setActivityDetailItemName(planItemVo.getConstituentDetailPlanName());
        //数量
        BigDecimal productNumber = Optional.ofNullable(posVo.getProductNumber()).orElse(BigDecimal.ZERO);
        planItemVo.setPromoteSalesUse(productNumber);
        BigDecimal promotionDeduction = Optional.ofNullable(posVo.getPromotionDeduction()).orElse(BigDecimal.ZERO);
        BigDecimal onePromotionDeduction = Optional.ofNullable(posVo.getOnePromotionDeduction()).orElse(BigDecimal.ZERO);
        if (BigDecimal.ZERO.compareTo(productNumber) != 0
                && BigDecimal.ZERO.compareTo(onePromotionDeduction) == 0) {
            onePromotionDeduction = promotionDeduction.divide(productNumber, 4, BigDecimal.ROUND_HALF_UP);
            posVo.setOnePromotionDeduction(onePromotionDeduction);
        }

        //单件申请费用
        BigDecimal oneApplicationFee = Optional.ofNullable(planItemVo.getSingleEstimatedCost()).orElse(BigDecimal.ZERO);
        posVo.setOneApplicationFee(oneApplicationFee);
        //单件费用差异 = 单件促销扣款（元）- 单件申请费用（元）
        BigDecimal oneDiffAmount = onePromotionDeduction.subtract(oneApplicationFee);
        posVo.setOneDiffAmount(oneDiffAmount);
        //分摊促销扣款
        BigDecimal sharePromotionDeduction = Optional.ofNullable(posVo.getSharePromotionDeduction()).orElse(BigDecimal.ZERO);
        posVo.setSharePromotionDeduction(sharePromotionDeduction);
        //差异总费用
        posVo.setTotalDiffAmount(oneDiffAmount.multiply(productNumber).add(sharePromotionDeduction));
        posVo.setTotalDiffFinalAmount(posVo.getTotalDiffAmount());

        posVo.setDiffType(this.oneDiffAmountGetDiffType(posVo.getTotalDiffFinalAmount(), posVo.getActivityDetailItemCode()));
        //在拉取POS数据时因为还未匹配活动默认为 : 多扣款无批复
        if (StringUtils.isEmpty(posVo.getActivityDetailItemCode())) {
            posVo.setIsMatchActivity(BooleanEnum.FALSE.getCapital());
        } else {
            posVo.setIsMatchActivity(BooleanEnum.TRUE.getCapital());
        }
    }


    /**
     * 分子活动 核销费用核对关联细案
     *
     * @param posVo
     * @param fzPlanItemVoList
     */
    private SubComActivityDetailPlanItemVo sonCompanyPosMatchAct(AuditFeeCheckPosVo posVo, List<SubComActivityDetailPlanItemVo> fzPlanItemVoList) {

        if (CollectionUtil.isEmpty(fzPlanItemVoList)
                || Objects.isNull(posVo)) {
            return null;
        }
        // 1、按业态、业务单元、零售商、单店、渠道名称、单品、单日维度自动匹配活动
        // 1.1活动如果未关闭，活动时间直接取活动开始日期-活动结束日期； 零售商渠道非全渠道:区分渠道
        // 1.2活动如果已关闭，活动时间取活动开始日期-活动关闭日期;  零售商渠道非全渠道:区分渠道
        // 1.3活动如果未关闭，活动时间直接取活动开始日期-活动结束日期； 全渠道:则匹配POS时不区分渠道
        // 1.4活动如果已关闭，活动时间取活动开始日期-活动关闭日期;  全渠道:则匹配POS时不区分渠道
        SubComActivityDetailPlanItemVo detailPlanItemVo = null;
        //1.1活动如果未关闭，活动时间直接取活动开始日期-活动结束日期； 零售商渠道非全渠道:区分渠道
        List<SubComActivityDetailPlanItemVo> planItemVoNewList = fzPlanItemVoList.stream()
                .filter(k -> !AuditFeeCheckPosConstants.ALL_CHANNEL_NAME.equals(k.getDistributionChannelName()))
                .filter(k -> BooleanEnum.FALSE.getCapital().equals(k.getCloseTag()))
                .filter(k -> Objects.nonNull(k.getSingleEstimatedCost()))
                .filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode())
                        && posVo.getProductCode().equals(item.getProductCode())
                        && posVo.getChannelName().equals(item.getDistributionChannelName())
                        && posVo.getSalesDate().compareTo(item.getActivityBeginTime()) >= 0
                        && posVo.getSalesDate().compareTo(item.getActivityEndTime()) <= 0)
                .collect(Collectors.toList());
        detailPlanItemVo = this.getSubComDetailPlanVo(planItemVoNewList);
        if (Objects.nonNull(detailPlanItemVo)) {
            return detailPlanItemVo;
        }

        // 1.2活动如果已关闭，活动时间取活动开始日期-活动关闭日期;  零售商渠道非全渠道:区分渠道
        planItemVoNewList = fzPlanItemVoList.stream()
                .filter(k -> !AuditFeeCheckPosConstants.ALL_CHANNEL_NAME.equals(k.getDistributionChannelName()))
                .filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getCloseTag()))
                .filter(k -> Objects.nonNull(k.getCloseDate()))
                .filter(k -> Objects.nonNull(k.getSingleEstimatedCost()))
                .filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode())
                        && posVo.getProductCode().equals(item.getProductCode())
                        && posVo.getChannelName().equals(item.getDistributionChannelName())
                        && posVo.getSalesDate().compareTo(item.getActivityBeginTime()) >= 0
                        && posVo.getSalesDate().compareTo(item.getCloseDate()) <= 0)
                .collect(Collectors.toList());
        detailPlanItemVo = this.getSubComDetailPlanVo(planItemVoNewList);
        if (Objects.nonNull(detailPlanItemVo)) {
            return detailPlanItemVo;
        }
        // 1.3活动如果未关闭，活动时间直接取活动开始日期-活动结束日期； 全渠道:则匹配POS时不区分渠道
        planItemVoNewList = fzPlanItemVoList.stream()
                .filter(k -> AuditFeeCheckPosConstants.ALL_CHANNEL_NAME.equals(k.getDistributionChannelName()))
                .filter(k -> BooleanEnum.FALSE.getCapital().equals(k.getCloseTag()))
                .filter(k -> Objects.nonNull(k.getSingleEstimatedCost()))
                .filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode())
                        && posVo.getProductCode().equals(item.getProductCode())
                        && posVo.getSalesDate().compareTo(item.getActivityBeginTime()) >= 0
                        && posVo.getSalesDate().compareTo(item.getActivityEndTime()) <= 0)
                .collect(Collectors.toList());
        detailPlanItemVo = this.getSubComDetailPlanVo(planItemVoNewList);
        if (Objects.nonNull(detailPlanItemVo)) {
            return detailPlanItemVo;
        }
        //1.4活动如果已关闭，活动时间取活动开始日期-活动关闭日期;  全渠道:则匹配POS时不区分渠道
        planItemVoNewList = fzPlanItemVoList.stream()
                .filter(k -> AuditFeeCheckPosConstants.ALL_CHANNEL_NAME.equals(k.getDistributionChannelName()))
                .filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getCloseTag()))
                .filter(k -> Objects.nonNull(k.getCloseDate()))
                .filter(k -> Objects.nonNull(k.getSingleEstimatedCost()))
                .filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode())
                        && posVo.getProductCode().equals(item.getProductCode())
                        && posVo.getSalesDate().compareTo(item.getActivityBeginTime()) >= 0
                        && posVo.getSalesDate().compareTo(item.getCloseDate()) <= 0)
                .collect(Collectors.toList());
        return this.getSubComDetailPlanVo(planItemVoNewList);
    }

    private SubComActivityDetailPlanItemVo getSubComDetailPlanVo(List<SubComActivityDetailPlanItemVo> planItemVoNewList) {
        if (CollectionUtil.isEmpty(planItemVoNewList)) {
            return null;
        }
        planItemVoNewList.sort(Comparator.comparing(SubComActivityDetailPlanItemVo::getSingleEstimatedCost).reversed());
        SubComActivityDetailPlanItemVo detailPlanItemVo = null;
        if (planItemVoNewList.size() > 1) {
            for (SubComActivityDetailPlanItemVo itemVo : planItemVoNewList) {
                if (Objects.isNull(itemVo.getPromoteSalesUse())
                        || (Objects.nonNull(itemVo.getPromoteSales())
                        && itemVo.getPromoteSales().compareTo(itemVo.getPromoteSalesUse()) > 0)) {
                    itemVo.setSingleBatch(true);
                    detailPlanItemVo = itemVo;
                    break;
                }
            }
            if (Objects.isNull(detailPlanItemVo)) {
                detailPlanItemVo = planItemVoNewList.get(planItemVoNewList.size() - 1);
            }
        } else {
            detailPlanItemVo = planItemVoNewList.get(0);
        }
        return detailPlanItemVo;
    }

    /**
     * 分子活动 核销费用核对关联细案
     *
     * @param detailPlanItemVoList
     */
    @Override
    public List<AuditFeeCheckDetailPlanVo> sonCompanyDetailPlanList(List<SubComActivityDetailPlanItemVo> detailPlanItemVoList) {
        List<AuditFeeCheckDetailPlanVo> result = new ArrayList<>();
        if (CollectionUtil.isEmpty(detailPlanItemVoList)) {
            return result;
        }
        //分子细案汇总
        log.info("pos匹配活动20");
        AuditFeeCheckActivityAmountSummaryVo summaryVo = fzDetailPlanItemAmountSummaryForVertical(detailPlanItemVoList);
        List<DetailedForecastVo> detailedForecastVoList = summaryVo.getDetailedForecastVoList();
        for (SubComActivityDetailPlanItemVo fzDetailPlanVo : detailPlanItemVoList) {
            //TODO 数据填充并保存
            Optional<DetailedForecastVo> detailedForecastVo = detailedForecastVoList.stream()
                    .filter(o -> fzDetailPlanVo.getConstituentDetailPlanItemCode()
                            .equals(o.getActivityDetailItemCode())).findAny();
            AuditFeeCheckDetailPlanVo feeCheckDetailPlanVo = new AuditFeeCheckDetailPlanVo();
            feeCheckDetailPlanVo.setDetailPlanItemCode(fzDetailPlanVo.getConstituentDetailPlanItemCode());
            feeCheckDetailPlanVo.setDetailPlanCode(fzDetailPlanVo.getConstituentDetailPlanCode());
            feeCheckDetailPlanVo.setDetailPlanName(fzDetailPlanVo.getConstituentDetailPlanName());
            feeCheckDetailPlanVo.setActivityYearMonth(DateUtil.format(fzDetailPlanVo.getFeeYearMonth(), "yyyy-MM"));
            feeCheckDetailPlanVo.setActivityBeginDate(fzDetailPlanVo.getActivityBeginTime());
            feeCheckDetailPlanVo.setActivityEndDate(fzDetailPlanVo.getActivityEndTime());
            feeCheckDetailPlanVo.setActivityTypeCode(fzDetailPlanVo.getActivityType());
            feeCheckDetailPlanVo.setActivityTypeName(fzDetailPlanVo.getActivityTypeName());
            feeCheckDetailPlanVo.setActivityFormCode(fzDetailPlanVo.getActivityFormCode());
            feeCheckDetailPlanVo.setActivityFormName(fzDetailPlanVo.getActivityFormName());
            feeCheckDetailPlanVo.setTerminalCode(fzDetailPlanVo.getTerminalCode());
            feeCheckDetailPlanVo.setTerminalName(fzDetailPlanVo.getTerminalName());
            feeCheckDetailPlanVo.setProductCode(fzDetailPlanVo.getProductCode());
            feeCheckDetailPlanVo.setProductName(fzDetailPlanVo.getProductName());
            feeCheckDetailPlanVo.setSystemCode(fzDetailPlanVo.getResaleCommercialCode());
            feeCheckDetailPlanVo.setSystemName(fzDetailPlanVo.getResaleCommercialName());
            feeCheckDetailPlanVo.setWriteOffMethod(fzDetailPlanVo.getAuditType());
            feeCheckDetailPlanVo.setAuditForm(fzDetailPlanVo.getAuditForm());
            feeCheckDetailPlanVo.setApplyAmount(fzDetailPlanVo.getTotalCost());
            feeCheckDetailPlanVo.setIsPos(BooleanEnum.TRUE.getCapital());

            detailedForecastVo.ifPresent(o -> {
                feeCheckDetailPlanVo.setPredictionAuditAmount(o.getEstimatedWriteOffAmount());
                feeCheckDetailPlanVo.setAuditFeeCheckShareAmount(o.getEstimatedWriteOffAmount());
            });
            detailedForecastVo.ifPresent(o -> feeCheckDetailPlanVo.setPredictionAuditAmount(o.getEstimatedWriteOffAmount()));

            feeCheckDetailPlanVo.setApplyAmount(fzDetailPlanVo.getTotalCost());
            feeCheckDetailPlanVo.setDetailPlanName(fzDetailPlanVo.getConstituentDetailPlanName());
            BigDecimal alreadyAuditAmount = Optional.ofNullable(fzDetailPlanVo.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO);
            feeCheckDetailPlanVo.setAlreadyAuditAmount(alreadyAuditAmount);
            BigDecimal preAuditAmount = Optional.ofNullable(feeCheckDetailPlanVo.getPredictionAuditAmount()).orElse(BigDecimal.ZERO);
            //剩余可结案金额=预结案金额-已结案金额
            feeCheckDetailPlanVo.setCanAuditAmount(preAuditAmount.subtract(alreadyAuditAmount));
            feeCheckDetailPlanVo.setPredictionAuditAmount(feeCheckDetailPlanVo.getPredictionAuditAmount());
            result.add(feeCheckDetailPlanVo);
        }

        return result;
    }


    /**
     * 匹配活动后 更新数据
     *
     * @param updatePosList
     * @param detailPlanVos
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-11-04 16:41
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveResult(List<AuditFeeCheckPosVo> updatePosList, List<AuditFeeCheckDetailPlanVo> detailPlanVos) {
        if (CollectionUtil.isNotEmpty(updatePosList)) {
            log.info("POS匹配活动24");
            Collection<AuditFeeCheckPos> auditFeeCheckPos = nebulaToolkitService.copyCollectionByWhiteList(updatePosList,
                    AuditFeeCheckPosVo.class, AuditFeeCheckPos.class, HashSet.class, ArrayList.class);
            auditFeeCheckPosRepository.updateBatchById(auditFeeCheckPos);
        }
        if (CollectionUtil.isNotEmpty(detailPlanVos)) {
            log.info("POS匹配活动23");
            auditFeeCheckDetailPlanVoService.createBatch(detailPlanVos);
        }
    }


    /**
     * 垂直活动明细金额数据汇总
     *
     * @param detailPlanItemList
     * @return com.biz.crm.tpm.business.audit.fee.sdk.vo.AuditFeeCheckActivityAmountSummaryVo
     * @author jiangyin
     * @date 2023/3/29 10:36
     */
    private AuditFeeCheckActivityAmountSummaryVo detailPlanItemAmountSummaryForVertical(List<ActivityDetailPlanItemVo> detailPlanItemList) {
        AuditFeeCheckActivityAmountSummaryVo result = new AuditFeeCheckActivityAmountSummaryVo();
        result.setTotalEstimateWriteOffAmount(BigDecimal.ZERO);
        result.setTotalFeeAmount(BigDecimal.ZERO);
        result.setDetailedForecastVoList(Collections.emptyList());
        if (CollectionUtil.isEmpty(detailPlanItemList)) {
            return result;
        }
        result.setTotalFeeAmount(detailPlanItemList.stream()
                .filter(k -> Objects.nonNull(k.getTotalFeeAmount()))
                .map(ActivityDetailPlanItemVo::getTotalFeeAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add));
        Set<String> detailPlanItemCodeSet = detailPlanItemList.stream()
                .filter(k -> StringUtils.isNotEmpty(k.getDetailPlanItemCode()))
                .map(ActivityDetailPlanItemVo::getDetailPlanItemCode)
                .collect(Collectors.toSet());
        if (CollectionUtil.isEmpty(detailPlanItemCodeSet)) {
            return result;
        }
        List<DetailedForecastVo> detailedForecastVoList = detailedForecastService.findByActivityDetailItemCode(detailPlanItemCodeSet);
        if (CollectionUtil.isEmpty(detailedForecastVoList)) {
            return result;
        }
        result.setTotalEstimateWriteOffAmount(detailedForecastVoList.stream()
                .filter(k -> Objects.nonNull(k.getEstimatedWriteOffAmount()))
                .map(DetailedForecastVo::getEstimatedWriteOffAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add));
        result.setDetailedForecastVoList(detailedForecastVoList);
        return result;

    }

    /**
     * 分子活动明细金额数据汇总
     *
     * @param detailPlanItemList
     * @return com.biz.crm.tpm.business.audit.fee.sdk.vo.AuditFeeCheckActivityAmountSummaryVo
     * @author jiangyin
     * @date 2023/3/29 10:36
     */
    private AuditFeeCheckActivityAmountSummaryVo fzDetailPlanItemAmountSummaryForVertical(List<SubComActivityDetailPlanItemVo> detailPlanItemList) {
        AuditFeeCheckActivityAmountSummaryVo result = new AuditFeeCheckActivityAmountSummaryVo();
        result.setTotalEstimateWriteOffAmount(BigDecimal.ZERO);
        result.setTotalFeeAmount(BigDecimal.ZERO);
        result.setDetailedForecastVoList(Collections.emptyList());
        if (CollectionUtil.isEmpty(detailPlanItemList)) {
            return result;
        }
        result.setTotalFeeAmount(detailPlanItemList.stream()
                .filter(k -> Objects.nonNull(k.getTotalCost()))
                .map(SubComActivityDetailPlanItemVo::getTotalCost)
                .reduce(BigDecimal.ZERO, BigDecimal::add));

        Set<String> detailPlanItemCodeSet = detailPlanItemList.stream()
                .filter(k -> StringUtils.isNotEmpty(k.getConstituentDetailPlanItemCode()))
                .map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode)
                .collect(Collectors.toSet());
        if (CollectionUtil.isEmpty(detailPlanItemCodeSet)) {
            return result;
        }
        List<DetailedForecastVo> detailedForecastVoList = detailedForecastService.findByActivityDetailItemCode(detailPlanItemCodeSet);
        if (CollectionUtil.isEmpty(detailedForecastVoList)) {
            return result;
        }
        result.setTotalEstimateWriteOffAmount(detailedForecastVoList.stream()
                .filter(k -> Objects.nonNull(k.getEstimatedWriteOffAmount()))
                .map(DetailedForecastVo::getEstimatedWriteOffAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add));

        result.setDetailedForecastVoList(detailedForecastVoList);
        return result;

    }

}
