package com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckCostRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.ConditionsEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.DeductionMatchingTemplateTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.TpmDeductionMatchingTemplateEnums;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.TpmDeductionMatchingTemplateEnums.AllowanceType;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateAllowanceVo;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Slf4j
@Component
public class GenerateAuditFeeCheckMatchFeeAsync {

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private AuditFeeCheckPosRepository auditFeeCheckPosRepository;

    @Autowired(required = false)
    private AuditFeeCheckCostRepository auditFeeCheckCostRepository;

    /**
     * 费用单匹配pos，扣费分摊 处理完成后再更新pos
     *
     * @param feeCheckVo
     * @param templateMap
     * @param allowanceVoMap
     * @param abstractLoginUser
     */
//    @Async
    @Transactional(rollbackFor = Exception.class)
    public List<AuditFeeCheckPos> matchFeePos(AuditFeeCheckVo feeCheckVo, TpmDeductionMatchingTemplateVo templateVo,
                         TpmDeductionMatchingTemplateAllowanceVo allowanceVo,
                         AbstractCrmUserIdentity abstractLoginUser) {

        log.info("费单匹POS 核对数据:{} 模板：{} 容差：{}", feeCheckVo, templateVo, allowanceVo);
        loginUserService.refreshAuthentication(abstractLoginUser);

        log.info("费单匹pos2");
        String failReasonStr = "";
        // 检查金额
        BigDecimal costDeductionAmount = feeCheckVo.getCostDeductionAmount();
        if (costDeductionAmount == null) {
            failReasonStr = failReasonStr.concat("聚合数据费用含税金额空;");
        }
        if (Objects.isNull(templateVo) || StringUtils.isBlank(templateVo.getFeeMatchingCondition())) {
            failReasonStr = failReasonStr.concat("模板或模板匹配条件空;");
        }
        if (!DeductionMatchingTemplateTypeEnum.DETAIL_POS_FEE_DETAIL_FEE_SETATEMENT.getCode().equals(templateVo.getDeductionMatchingTemplateType())){
            failReasonStr = failReasonStr.concat("模板类型非pos;");
        }
        log.info("费单匹pos3");
        // 获取下模板容差
        if (Objects.isNull(allowanceVo)) {
            failReasonStr = failReasonStr.concat("模板容差空;");
        }

        // 业态+业务单元+销售机构（非必填）+零售商+客户（非必填）+购买方式（非必填）+关联活动形式+费用单匹配条件+费用单适用区域
        AuditFeeCheckPosDto posQueryDto = new AuditFeeCheckPosDto();
        posQueryDto.setBusinessFormatCode(feeCheckVo.getBusinessFormatCode());
        posQueryDto.setBusinessUnitCode(feeCheckVo.getBusinessUnitCode());
        // 销售组织编码
        posQueryDto.setSalesInstitutionCode(feeCheckVo.getSalesOrgCode());
        // 零售商编码
        posQueryDto.setCustomerRetailerCode(feeCheckVo.getCustomerRetailerCode());
        // 客户
//        if (StringUtils.isNotEmpty(templateVo.getApplyBusinessCustomerCode())) {
//          posQueryDto.setCustomerCode(templateVo.getApplyBusinessCustomerCode());
//        } else {
//          // 商超映射 找不到客户编码，拼接一个
//          SalesOrgVo salesOrgVo = salesOrgVoMap.get(feeCheck.getSalesOrgCode());
//          posQueryDto.setCustomerCode(feeCheck.getCustomerErpCode() + salesOrgVo.getErpCode() + AuditFeeConstants.VERTICAL_CHANNEL_CODE + templateVo.getBusinessFormatCode());
//        }
//      posQueryDto.setBuyWay(mappingVo.getBuyWay());
        
        
        posQueryDto.setIsMatchCost(BooleanEnum.FALSE.getCapital());
        posQueryDto.setIsMatchActivity(BooleanEnum.TRUE.getCapital());
        posQueryDto.setTenantCode(TenantUtils.getTenantCode());

        /*  检查扣费匹配模板上的匹配规则，核对主数据auditFeeCheck参数是否都有，没有就更新关联的所有费用单：未匹配POS原因为参数缺失
            另外关联的费用单规则字段应该是一样的，因为在拉取费用单阶段，就是按这个规则聚合的数据，故所有关联费用单规则字段值是一致的
            pos数据匹配上也只关联费用核对主数据matchCode，不写入(关联)费用单编码及行号
        */
        String[] conditions = templateVo.getFeeMatchingCondition().split(",");
        StringBuilder falseReason = new StringBuilder();
        for(String condition : conditions){
            ConditionsEnum conditionsEnum = ConditionsEnum.codeToEnum(condition);
            if (ConditionsEnum.EMPTY.equals(conditionsEnum)) continue;
            switch (conditionsEnum){
                case PRODUCT_CODE:
                    if (!StringUtils.isBlank(feeCheckVo.getProductCode())) {
                        posQueryDto.setProductCode(feeCheckVo.getProductCode());
                    }else {
                        falseReason.append("产品编码为空;");
                    }
                    break;
                case TERMINAL_CODE:
                    if (!StringUtils.isBlank(feeCheckVo.getTerminalCode())) {
                        posQueryDto.setTerminalCode(feeCheckVo.getTerminalCode());
                    }else {
                        falseReason.append("送达方编码/门店编码;");
                    }
                    break;
                case YEAR_MONTH:
                    if (feeCheckVo.getOrderYearMonth() == null ) {
                        falseReason.append("单据日期为空;");
                    } else {
                        //月需要考虑容差
                        if (!TpmDeductionMatchingTemplateEnums.AllowanceUnit.MONTH.getValue().equals(allowanceVo.getTimeAllowanceUnit())) {
                            falseReason.append("时间容差单位错误;");
                            break;
                        }
                        //计算日期范围
                        String timeAllowanceType = allowanceVo.getTimeAllowanceType();
                        Integer timeAllowanceValue = allowanceVo.getTimeAllowanceValue();
                        if (timeAllowanceType == null || timeAllowanceValue == null){
                            falseReason.append("模板时间容差配置错误;");
                            break;
                        }
                        Date orderDate = feeCheckVo.getOrderDate();
                        if (TpmDeductionMatchingTemplateEnums.AllowanceType.POSITIVE.getValue().equals(timeAllowanceType)) {
                            // 向未来加月并设置月末
                            posQueryDto.setSalesDateBegin(this.adjustMonth(orderDate, 0, true));
                            posQueryDto.setSalesDateEnd(this.adjustMonth(orderDate, timeAllowanceValue, false));
                        } else if (TpmDeductionMatchingTemplateEnums.AllowanceType.POSITIVE_POINT.getValue().equals(timeAllowanceType)) {
                            // 向未来加月并设置起始时间为目标月
                            posQueryDto.setSalesDateBegin(this.adjustMonth(orderDate, timeAllowanceValue, true));
                            posQueryDto.setSalesDateEnd(this.adjustMonth(orderDate, timeAllowanceValue, false));
                        } else if (TpmDeductionMatchingTemplateEnums.AllowanceType.NEGATIVE.getValue().equals(timeAllowanceType)) {
                            // 向历史加月并设置月初
                            posQueryDto.setSalesDateBegin(this.adjustMonth(orderDate, - timeAllowanceValue, true));
                            posQueryDto.setSalesDateEnd(this.adjustMonth(orderDate, 0, false));
                        } else if (TpmDeductionMatchingTemplateEnums.AllowanceType.NEGATIVE_POINT.getValue().equals(timeAllowanceType)) {
                            // 向历史加月并设置起始时间为目标月
                            posQueryDto.setSalesDateBegin(this.adjustMonth(orderDate, - timeAllowanceValue, true));
                            posQueryDto.setSalesDateEnd(this.adjustMonth(orderDate, - timeAllowanceValue, false));
                        } else if (TpmDeductionMatchingTemplateEnums.AllowanceType.INTEGER.getValue().equals(timeAllowanceType)) {
                            // 向未来，历史加月并设置起始时间为目标月
                            posQueryDto.setSalesDateBegin(this.adjustMonth(orderDate, - timeAllowanceValue, true));
                            posQueryDto.setSalesDateEnd(this.adjustMonth(orderDate, timeAllowanceValue, false));
                        } else {
                            falseReason.append("时间容差类型错误;");
                        }
                    }
                    break;
                case PROVINCE:
                    if (!StringUtils.isBlank(feeCheckVo.getProvinceCode())) {
                        posQueryDto.setProvinceCode(feeCheckVo.getProvinceCode());
                    }else {
                        falseReason.append("省编码为空;");
                    }
                    break;
                case AREA_CODE:
                    if (!StringUtils.isBlank(feeCheckVo.getAreaCode())) {
                        posQueryDto.setBusinessArea(feeCheckVo.getAreaCode());
                    }else {
                        falseReason.append("区域编码为空;");
                    }
                    break;
                case SCHEDULE:
                    // pos无档期，配置了匹配不上
                case FEE_CODE:
                case CHANNEL:
                    // 费用无渠道，配置了匹配不上
                default:
                    break;
            }
        }
        String paramLackWithConditionStr = falseReason.toString();
        if (paramLackWithConditionStr.length() > 0) {
            failReasonStr = failReasonStr.concat(paramLackWithConditionStr);
        }

        log.info("费单匹pos4");

        // 查询pos活动，查出来多少就匹配上多少
        PageRequest pageRequest = PageRequest.of(0, 1000);
        Page<AuditFeeCheckPosVo> posPage;
        List<AuditFeeCheckPosVo> posRecords = new ArrayList<>();
        do {
            pageRequest = pageRequest.next();
            posPage = auditFeeCheckPosRepository.findByConditions(pageRequest, posQueryDto);
            if (posPage == null) break;
            posRecords.addAll(posPage.getRecords());
        } while (posPage.hasNext());
        log.info("查询到pos数量：{}", posRecords.size());


        BigDecimal posAmountTotal = BigDecimal.ZERO;
        List<AuditFeeCheckPos> validPosRecords = new ArrayList<>();
        if (CollectionUtils.isEmpty(posRecords)) {
            failReasonStr = failReasonStr.concat("根据模板规则未查找到对应pos;");
        } else {
            for (AuditFeeCheckPosVo posVo : posRecords) {
                // 金额为空的数据不要
                if (posVo.getPromotionDeduction() == null || posVo.getActivityDetailItemCode() == null) continue;
                posAmountTotal = posAmountTotal.add(posVo.getPromotionDeduction());

                AuditFeeCheckPos pos = new AuditFeeCheckPos();
                BeanUtils.copyProperties(posVo, pos);
                validPosRecords.add(pos);
            }
            if (BigDecimal.ZERO.equals(posAmountTotal)) {
                // 要作为除数，不可为0
                failReasonStr = failReasonStr.concat("pos数据金额和为0无法分摊;");
            }
        }
        log.info("过滤后有金额有细案的pos数量：{}", validPosRecords.size());

        if (StringUtils.isNotBlank(failReasonStr)) {
            // 更新失败原因
            auditFeeCheckCostRepository.updatePosRemarkByMatchCodeList(Lists.newArrayList(feeCheckVo.getMatchCode()), failReasonStr);
            return new ArrayList<>(0);
        }
        return validPosRecords;
    }

    /**
     * 更新pos信息
     * @param posMatchedAndUsedList 关联的细案参与分摊的pos
     */
    public void updateRelatePos(AuditFeeCheckVo feeCheckVo, List<AuditFeeCheckPos> posMatchedAndUsedList) {
        if (CollectionUtils.isEmpty(posMatchedAndUsedList)) return;

        // 分摊金额，差异放入最后一条
        BigDecimal posAmountTotal = posMatchedAndUsedList.stream().map(AuditFeeCheckPos::getPromotionDeduction).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 分摊金额=(costAmountTotal - posAmountTotal)/posAmountTotal * posAmount
        BigDecimal feePosDifference = feeCheckVo.getCostDeductionAmount().subtract(posAmountTotal);
        // 匹配且分摊细案的pos数据【促销扣款金额和】为0，比率直接为0
        BigDecimal rate = posAmountTotal.compareTo(BigDecimal.ZERO) != 0 ? feePosDifference.divide(posAmountTotal, 6, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        // 修改状态
        BigDecimal shareTotal = BigDecimal.ZERO;
        for (AuditFeeCheckPos pos : posMatchedAndUsedList) {
            BigDecimal shareByRate = pos.getPromotionDeduction().multiply(rate).setScale(2, RoundingMode.HALF_UP);
            shareTotal = shareTotal.add(shareByRate);
            
            pos.setSharePromotionDeduction(shareByRate);
            pos.setIsMatchCost(BooleanEnum.TRUE.getCapital());
            pos.setFeeCheckMatchCode(feeCheckVo.getMatchCode());
        }
        // 被分摊金额 与各分摊金额和的差异，由精度产生，放到最后一个pos上
        BigDecimal accuracyDifference = feePosDifference.subtract(shareTotal);
        if (accuracyDifference.compareTo(BigDecimal.ZERO) != 0) {
            AuditFeeCheckPos lastPos = posMatchedAndUsedList.get(posMatchedAndUsedList.size() - 1);
            lastPos.setSharePromotionDeduction(lastPos.getSharePromotionDeduction().add(accuracyDifference).setScale(2, RoundingMode.HALF_UP));
        }

        auditFeeCheckPosRepository.updateBatchById(posMatchedAndUsedList);
        auditFeeCheckPosRepository.computeTotalDiffAmount(posMatchedAndUsedList.stream().map(AuditFeeCheckPos::getId).filter(Objects::nonNull).collect(Collectors.toList()));
        // 匹配上了，清空cost未匹配上的备注
        auditFeeCheckCostRepository.cleanPosMatchRemarkByMatchCodes(Lists.newArrayList(feeCheckVo.getMatchCode()));
    }

    /**
     * 月浮动及起始天
     * @param date
     * @param span
     * @param begin 是否月初
     * @return
     */
    public String adjustMonth(Date date, Integer span, boolean begin) {
        DateTime adjustedDate = DateUtil.offsetMonth(date, span);
        DateTime headOrTail;
        if (begin) headOrTail = DateUtil.beginOfDay(DateUtil.beginOfMonth(adjustedDate));
        else headOrTail = DateUtil.endOfDay(DateUtil.endOfMonth(adjustedDate));
        return DateUtil.format(headOrTail,"yyyy-MM-dd HH:mm:ss");
    }
}
