package com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async;

import com.biz.crm.kms.business.audit.fee.sdk.dto.AuditFeeReqDto;
import com.biz.crm.kms.business.audit.fee.sdk.service.cost.AuditFeeCostService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

/**
 * 异步更新KMS
 * @author liyang
 * @date 2023/12/01
 */
@Slf4j
@Component
public class KMSFeeUpdateAsync {

  /**
   * KMS数据
   */
  @Autowired(required = false)
  private AuditFeeCostService auditFeeCostService;

  @Async
  public void updateKMSStatusAsync(AuditFeeReqDto reqDto){
    auditFeeCostService.updateStatus(reqDto);
  }
}
