package com.biz.crm.tpm.business.audit.fee.local.service.internal.dispose;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeDetail;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeLedgerItem;
import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeDetailRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeLedgerItemRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerItemDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeLedgerItemVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeDetailVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeLedgerItemVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigProductRatioDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2022/12/8 11:19
 */
@Component
public class AuditFeeDiffDisposeDetailPageCacheHelper extends MnPageCacheHelper<AuditFeeDiffDisposeDetailVo, AuditFeeDiffDisposeDetailDto> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private AuditFeeDiffDisposeDetailRepository auditFeeDiffDisposeDetailRepository;

    @Autowired(required = false)
    private AuditFeeDiffDisposeLedgerItemRepository auditFeeDiffDisposeLedgerItemRepository;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public String getCacheKeyPrefix() {
        return AuditFeeConstants.AUDIT_FEE_DIFF_DISPOSE_CACHE_KEY;
    }

    @Override
    public Class<AuditFeeDiffDisposeDetailDto> getDtoClass() {
        return AuditFeeDiffDisposeDetailDto.class;
    }

    @Override
    public Class<AuditFeeDiffDisposeDetailVo> getVoClass() {
        return AuditFeeDiffDisposeDetailVo.class;
    }

    /**
     * 从数据库查询初始化数据
     * @param dto
     * @param cacheKey
     * @return {@link List}<{@link AuditFeeDiffDisposeDetailDto}>
     */
    @Override
    public List<AuditFeeDiffDisposeDetailDto> findDtoListFromRepository(AuditFeeDiffDisposeDetailDto dto, String cacheKey) {
        if(!StringUtils.hasText(dto.getFeeDiffDisposeCode())){
            return Lists.newArrayList();
        }
        Assert.hasText(cacheKey, "cacheKey不能为空");
        String[] split = cacheKey.split(":");
        String templateCode = split[1];
        Assert.hasText(templateCode, "模版编码不能为空");
        dto.setTemplateConfigCode(templateCode);
        //查询明细
        List<AuditFeeDiffDisposeDetail> entities = this.auditFeeDiffDisposeDetailRepository
            .findByFeeDiffDisposeCode(dto);
        List<AuditFeeDiffDisposeDetailDto> detailDtos =
            (List<AuditFeeDiffDisposeDetailDto>) this.nebulaToolkitService
                .copyCollectionByWhiteList(entities, AuditFeeDiffDisposeDetail.class,
                    AuditFeeDiffDisposeDetailDto.class, LinkedHashSet.class, ArrayList.class);
        //查询差异费用明细
        List<AuditFeeDiffDisposeLedgerItem> ledgerItems = this.auditFeeDiffDisposeLedgerItemRepository
            .findByFeeDiffDisposeCode(dto);
        List<AuditFeeDiffDisposeLedgerItemDto> ledgerItemDtos =
            (List<AuditFeeDiffDisposeLedgerItemDto>) this.nebulaToolkitService
                .copyCollectionByWhiteList(ledgerItems, AuditFeeDiffDisposeLedgerItem.class,
                    AuditFeeDiffDisposeLedgerItemDto.class, LinkedHashSet.class, ArrayList.class);
        //根据明细编码分组
        Map<String, List<AuditFeeDiffDisposeLedgerItemDto>> ledgerMap = ledgerItemDtos.stream()
            .collect(Collectors.groupingBy(AuditFeeDiffDisposeLedgerItemDto::getDetailPlanItemCode));
        detailDtos.forEach(o -> {
            o.setLedgerItems(ledgerMap.get(o.getDetailPlanItemCode()));
        });
        if(!CollectionUtils.isEmpty(detailDtos)){
            //获取缓存key
            String redisCacheIdKey = getRedisCacheIdKey(cacheKey);
            String redisCacheDataKey = getRedisCacheDataKey(cacheKey);
            Map<String, AuditFeeDiffDisposeDetailDto> ratioDtoMap = detailDtos.stream()
                .collect(Collectors.toMap(AuditFeeDiffDisposeDetailDto::getId, Function.identity()));
            //保存到缓存中
            redisService.lPushAll(redisCacheIdKey, this.getExpireTime(), ratioDtoMap.keySet().toArray());
            redisTemplate.opsForHash().putAll(redisCacheDataKey, ratioDtoMap);
            redisService.expire(redisCacheDataKey, this.getExpireTime());
        }
        return detailDtos;
    }

    /**
     * 是否初始化数据到缓存，默认为true
     * @param
     * @return {@link boolean}
     */
    @Override
    public boolean initToCacheFromRepository() {
        return false;
    }

    /**
     * 新增数据
     * @param cacheKey
     * @param itemList
     * @return {@link List}<{@link BudgetCalConfigProductRatioDto}>
     */
    @Override
    public List<AuditFeeDiffDisposeDetailDto> newItem(String cacheKey, List<AuditFeeDiffDisposeDetailDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        //获取已缓存的数据
        List<Object> idList = redisService.lRange(redisCacheIdKey, 0, -1);
        //过滤掉已经存在的数据
        List<AuditFeeDiffDisposeDetailDto> newList = itemList.stream()
            .filter(item -> !idList.contains(item.getId())).collect(Collectors.toList());
        if(newList.size() == 0){
            AuditFeeDiffDisposeDetailDto detailDto = new AuditFeeDiffDisposeDetailDto();
            detailDto.setId(UuidCrmUtil.general());
            detailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            detailDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detailDto.setTenantCode(TenantUtils.getTenantCode());
            newList.add(detailDto);
        }
        return newList;
    }

    /**
     * 更新数据
     */
    public void updateItem(String cacheKey,List<AuditFeeDiffDisposeDetailDto> itemList){

    }

    /**
     * 复制数据
     * @param cacheKey
     * @param itemList
     * @return {@link List}<{@link AuditFeeDiffDisposeDetailDto}>
     */
    @Override
    public List<AuditFeeDiffDisposeDetailDto> copyItem(String cacheKey, List<AuditFeeDiffDisposeDetailDto> itemList) {
        List<AuditFeeDiffDisposeDetailDto> newList = (List<AuditFeeDiffDisposeDetailDto>) this.nebulaToolkitService
            .copyCollectionByBlankList(itemList, AuditFeeDiffDisposeDetailDto.class,
                AuditFeeDiffDisposeDetailDto.class, HashSet.class, ArrayList.class);
        for (AuditFeeDiffDisposeDetailDto newItem : newList) {
            newItem.setId(UuidCrmUtil.general());
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTenantCode(TenantUtils.getTenantCode());
        }
        return newList;
    }

    /**
     * 获取唯一key
     * @param dto
     * @return {@link Object}
     */
    @Override
    public Object getDtoKey(AuditFeeDiffDisposeDetailDto dto) {
        return dto.getId();
    }

    /**
     * 获取是否选中状态
     * @param dto
     * @return {@link String}
     */
    @Override
    public String getCheckedStatus(AuditFeeDiffDisposeDetailDto dto) {
        return dto.getChecked();
    }

    /**
     * 导入数据存入缓存
     * @param cacheKey
     * @param dto
     */
    public void importSave(String cacheKey, AuditFeeDiffDisposeDetailDto dto) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        dto.setId(UuidCrmUtil.general());
        //获取已缓存的数据
        List<Object> idList = redisService.lRange(redisCacheIdKey, 0, -1);
        //判断是否已经存在
        if(!idList.contains(dto.getId())){
            //缓存ID
            Object[] newIdArr = {dto.getId()};
            redisService.lPushAll(redisCacheIdKey, this.getExpireTime(),newIdArr );
        }

        //导入新增数据
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());

        //缓存数据
        Map<Object, AuditFeeDiffDisposeDetailDto> ratioDtoMap = Maps.newHashMap();
        ratioDtoMap.put(dto.getId(), dto);

        redisTemplate.opsForHash().putAll(redisCacheDataKey, ratioDtoMap);
        redisService.expire(redisCacheDataKey, this.getExpireTime());
    }
}
