package com.biz.crm.tpm.business.audit.fee.local.service.internal.dispose;

import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeDetail;
import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeDetailRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeDiffDisposeDetailService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @Description
 * @Author YangWei
 * @Date 2023/3/29 下午4:01
 */
@Slf4j
@Service("auditFeeDiffDisposeDetailService")
public class AuditFeeDiffDisposeDetailServiceImpl implements AuditFeeDiffDisposeDetailService {

    @Autowired(required = false)
    private AuditFeeDiffDisposeDetailRepository auditFeeDiffDisposeDetailRepository;

    /**
     * 差异费用处理编码查询明细信息
     * @param feeDiffDisposeCode
     * @return {@link List}<{@link AuditFeeDiffDisposeDetail}>
     */
    @Override
    public List<AuditFeeDiffDisposeDetail> findByFeeDiffDisposeCode(String feeDiffDisposeCode) {
        AuditFeeDiffDisposeDetailDto detailDto = new AuditFeeDiffDisposeDetailDto();
        detailDto.setFeeDiffDisposeCode(feeDiffDisposeCode);
        return auditFeeDiffDisposeDetailRepository.findByFeeDiffDisposeCode(detailDto);
    }

    /**
     * 批量保存
     * @param details
     */
    @Override
    public void batchUpdateById(List<AuditFeeDiffDisposeDetail> details) {
        this.auditFeeDiffDisposeDetailRepository.updateBatchById(details);
    }

    /**
     * 根据差异费用处理编码逻辑删除
     *
     * @param feeDifDisposeCodes
     */
    @Override
    public void updateDelFlagByFeeDiffDisposeCode(List<String> feeDifDisposeCodes) {
        if (CollectionUtils.isEmpty(feeDifDisposeCodes)) {
            return;
        }
        this.auditFeeDiffDisposeDetailRepository.deleteByDiffDisposeCodes(feeDifDisposeCodes);
    }
}