package com.biz.crm.tpm.business.audit.fee.local.service.internal.dispose;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeLedger;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeDetail;
import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeDetailRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerItemDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.log.AuditFeeDiffDisposeDetailLogEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.event.dispose.AuditFeeDiffDisposeDetailEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.event.log.AuditFeeDiffDisposeDetailLogEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeLedgerVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeDetailVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanConstant;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import static com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants.AUDIT_FEE_DIFF_LEDGER_CACHE_KEY;

/**
 * 核销差异费用处理明细(AuditFeeDiffDisposeDetail)表服务实现类
 *
 * @author liuyifan
 * @date 2022-12-24 13:56:10
 */
@Slf4j
@Service("auditFeeDiffDisposeDetailVoService")
public class AuditFeeDiffDisposeDetailVoServiceImpl extends MnPageCacheServiceImpl<AuditFeeDiffDisposeDetailVo, AuditFeeDiffDisposeDetailDto> implements AuditFeeDiffDisposeDetailVoService {

    @Autowired(required = false)
    private AuditFeeDiffDisposeDetailRepository auditFeeDiffDisposeDetailRepository;

    @Autowired(required = false)
    private List<AuditFeeDiffDisposeDetailEventListener> eventListeners;

    @Autowired(required = false)
    private MnPageCacheHelper<AuditFeeDiffDisposeDetailVo, AuditFeeDiffDisposeDetailDto> helper;


    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private RedisService redisService;


    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired
    private AuditFeeDiffDisposeLedgerVoService auditFeeDiffDisposeBudgetVoService;

    @Override
    public Page<AuditFeeDiffDisposeDetailVo> findByConditions(Pageable pageable, AuditFeeDiffDisposeDetailDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffDisposeDetailDto());
        Page<AuditFeeDiffDisposeDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditFeeDiffDisposeDetailRepository.findByConditions(page, dto);
    }

    @Override
    public AuditFeeDiffDisposeDetailVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        AuditFeeDiffDisposeDetail auditFeeDiffDisposeDetail = this.auditFeeDiffDisposeDetailRepository.findById(id);
        if (auditFeeDiffDisposeDetail == null) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(auditFeeDiffDisposeDetail, AuditFeeDiffDisposeDetailVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    @Transactional
    public AuditFeeDiffDisposeDetailVo create(AuditFeeDiffDisposeDetailVo auditFeeDiffDisposeDetailVo) {
        this.createValidation(auditFeeDiffDisposeDetailVo);
        auditFeeDiffDisposeDetailVo.setTenantCode(TenantUtils.getTenantCode());
        auditFeeDiffDisposeDetailVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        auditFeeDiffDisposeDetailVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());

        AuditFeeDiffDisposeDetail auditFeeDiffDisposeDetail = nebulaToolkitService.copyObjectByWhiteList(auditFeeDiffDisposeDetailVo, AuditFeeDiffDisposeDetail.class, HashSet.class, ArrayList.class);
        this.auditFeeDiffDisposeDetailRepository.saveOrUpdate(auditFeeDiffDisposeDetail);

        auditFeeDiffDisposeDetailVo.setId(auditFeeDiffDisposeDetail.getId());

        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditFeeDiffDisposeDetailEventListener auditFeeDiffDisposeDetailEventListener : eventListeners) {
                auditFeeDiffDisposeDetailEventListener.onCreate(auditFeeDiffDisposeDetailVo);
            }
        }

        // 发送通知
        AuditFeeDiffDisposeDetailLogEventDto logEventDto = new AuditFeeDiffDisposeDetailLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditFeeDiffDisposeDetailVo);
        SerializableBiConsumer<AuditFeeDiffDisposeDetailLogEventListener, AuditFeeDiffDisposeDetailLogEventDto> onCreate =
                AuditFeeDiffDisposeDetailLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, AuditFeeDiffDisposeDetailLogEventListener.class, onCreate);
        return auditFeeDiffDisposeDetailVo;
    }

    @Override
    @Transactional
    public AuditFeeDiffDisposeDetailVo update(AuditFeeDiffDisposeDetailVo auditFeeDiffDisposeDetailVo) {
        this.updateValidation(auditFeeDiffDisposeDetailVo);
        String currentId = auditFeeDiffDisposeDetailVo.getId();
        AuditFeeDiffDisposeDetail current = auditFeeDiffDisposeDetailRepository.findById(currentId);
        current = Validate.notNull(current, "修改信息不存在");
        AuditFeeDiffDisposeDetailVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(current, AuditFeeDiffDisposeDetailVo.class, HashSet.class, ArrayList.class);


        this.auditFeeDiffDisposeDetailRepository.saveOrUpdate(current);
        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditFeeDiffDisposeDetailEventListener auditFeeDiffDisposeDetailEventListener : eventListeners) {
                auditFeeDiffDisposeDetailEventListener.onUpdate(oldVo, auditFeeDiffDisposeDetailVo);
            }
        }

        // 发送修改通知
        AuditFeeDiffDisposeDetailLogEventDto logEventDto = new AuditFeeDiffDisposeDetailLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditFeeDiffDisposeDetailVo);
        SerializableBiConsumer<AuditFeeDiffDisposeDetailLogEventListener, AuditFeeDiffDisposeDetailLogEventDto> onUpdate =
                AuditFeeDiffDisposeDetailLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditFeeDiffDisposeDetailLogEventListener.class, onUpdate);
        return auditFeeDiffDisposeDetailVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffDisposeDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffDisposeDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffDisposeDetailRepository.updateDelFlagByIds(ids);
    }

    @Override
    public List<AuditFeeDiffDisposeDetailVo> findDetailByDiffDisposeCode(String feeDiffDisposeCode) {
        if (StringUtils.isEmpty(feeDiffDisposeCode)) {
            return Lists.newArrayList();
        }
        List<AuditFeeDiffDisposeDetail> auditFeeDiffDisposeDetails = this.auditFeeDiffDisposeDetailRepository.findDetailByDiffDisposeCode(feeDiffDisposeCode);
        if (CollectionUtils.isEmpty(auditFeeDiffDisposeDetails)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(auditFeeDiffDisposeDetails, AuditFeeDiffDisposeDetail.class, AuditFeeDiffDisposeDetailVo.class, HashSet.class, ArrayList.class));
    }

    @Override
    public List<AuditFeeDiffDisposeLedgerVo> findBudgetByCacheKey(String cacheKey) {
        List<AuditFeeDiffDisposeDetailDto> diffDisDtoList = this.findCacheList(cacheKey);
        if (CollectionUtils.isEmpty(diffDisDtoList)){
            return  Lists.newArrayList();
        }
        List<AuditFeeDiffDisposeLedgerItemDto> ledgerItemDtoList = new ArrayList<>(diffDisDtoList.size()*2);
        diffDisDtoList.forEach(disDto -> {
            if (!CollectionUtils.isEmpty(disDto.getLedgerItems())) {
                ledgerItemDtoList.addAll(disDto.getLedgerItems());
            }
        });
        Map<String, List<AuditFeeDiffDisposeLedgerItemDto>> ledgerItemDtoMap = ledgerItemDtoList.stream().collect(Collectors.groupingBy(k -> k.getFeeDiffLedgerCode() + k.getFeeYearMonth()));
        List<AuditFeeDiffDisposeLedgerVo> ledgerVoList = new ArrayList<>(ledgerItemDtoMap.keySet().size());
        ledgerItemDtoMap.forEach((k,v) -> {
            if (!CollectionUtils.isEmpty(v)) {
                AuditFeeDiffDisposeLedgerVo ledgerVo = new AuditFeeDiffDisposeLedgerVo();
                ledgerVo.setFeeDiffLedgerCode(v.get(0).getFeeDiffLedgerCode());
                ledgerVo.setFeeYearMonth(v.get(0).getFeeYearMonth());
                BigDecimal thisUseAmount = v.stream().map(AuditFeeDiffDisposeLedgerItemDto::getThisUseAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                ledgerVo.setThisUseAmount(thisUseAmount);
                BigDecimal beRecoveredAmount = v.stream().map(AuditFeeDiffDisposeLedgerItemDto::getBeRecoveredAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                ledgerVo.setBeRecoveredAmount(beRecoveredAmount);
                ledgerVoList.add(ledgerVo);
            }
        });
/*        Map<String, AuditFeeDiffDisposeLedgerVo> ledgerMap = Maps.newHashMap();
        //总的申请金额
        AtomicReference<BigDecimal> thisUseAmountAtomic = new AtomicReference<>(BigDecimal.ZERO);
        //构建
        diffDisDtoList.forEach(detail -> {
            List<AuditFeeDiffDisposeLedgerItemDto> ledgerItems = detail.getLedgerItems();
            if(!org.springframework.util.CollectionUtils.isEmpty(ledgerItems)){
                ledgerItems.forEach(item -> {
                    AuditFeeDiffDisposeLedgerVo ledgerVo = ledgerMap.get(item.getFeeDiffLedgerCode());
                    if(ObjectUtils.isEmpty(ledgerVo)){
                        ledgerVo = new AuditFeeDiffDisposeLedgerVo();
                    }
                    thisUseAmountAtomic.set(thisUseAmountAtomic.get().add(item.getThisUseAmount()));
                    ledgerVo.setFeeDiffLedgerCode(item.getFeeDiffLedgerCode());
                    ledgerVo.setFeeYearMonth(item.getFeeYearMonth());
                    ledgerVo.setThisUseAmount(Optional.ofNullable(ledgerVo.getThisUseAmount())
                        .orElse(BigDecimal.ZERO).add(item.getThisUseAmount()));
                    ledgerVo.setBeRecoveredAmount(item.getBeRecoveredAmount());
                    ledgerMap.put(item.getFeeDiffLedgerCode(), ledgerVo);
                });
            }
        });
        ledgerMap.forEach((k, v) -> {
            v.setDisposeFeeAmount(thisUseAmountAtomic.get());
        });*/
        return ledgerVoList;
    }


    /**
     * 根据差异费用处理编码逻辑删除差异费用处理明细数据
     *
     * @param feeDiffDisposeCode 费用差异处理编码
     */
    @Override
    public void deleteByAuditFeeDiffDisposeCode(String feeDiffDisposeCode) {
        Validate.notNull(feeDiffDisposeCode, "差异费用处理编码不能为空");
        this.auditFeeDiffDisposeDetailRepository.deleteByDiffDisposeCode(feeDiffDisposeCode);
    }

    /**
     * 获取redis缓存key
     *
     * @param cacheKey 前端传过来的key
     * @return redis的缓存key
     */
    private String getRedisCacheKey(String cacheKey) {
        return AUDIT_FEE_DIFF_LEDGER_CACHE_KEY + cacheKey;
    }


    private void createValidation(AuditFeeDiffDisposeDetailVo auditFeeDiffDisposeDetailVo) {
        // TODO 具体实现
        this.validation(auditFeeDiffDisposeDetailVo);
    }

    private void updateValidation(AuditFeeDiffDisposeDetailVo auditFeeDiffDisposeDetailVo) {
        // TODO 具体实现
        this.validation(auditFeeDiffDisposeDetailVo);
    }

    private void validation(AuditFeeDiffDisposeDetailVo auditFeeDiffDisposeDetailVo) {
        // TODO 具体实现
    }

    /**
     * 保存明细
     * @param detailDtos
     */
    @Override
    public void saveBatch(String feeDiffDisposeCode, List<AuditFeeDiffDisposeDetailDto> detailDtos) {
        Assert.notEmpty(detailDtos, "明细不能为空");
        //删除
        this.deleteByAuditFeeDiffDisposeCode(feeDiffDisposeCode);
        //
        List<AuditFeeDiffDisposeDetail> details = (List<AuditFeeDiffDisposeDetail>) this.nebulaToolkitService
            .copyCollectionByBlankList(detailDtos, AuditFeeDiffDisposeDetailDto.class, AuditFeeDiffDisposeDetail.class, HashSet.class, ArrayList.class);
        details.forEach(o -> {
            o.setFeeDiffDisposeCode(feeDiffDisposeCode);
            o.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            o.setTenantCode(TenantUtils.getTenantCode());
            o.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        this.auditFeeDiffDisposeDetailRepository.saveOrUpdateBatch(details);
    }
}
