package com.biz.crm.tpm.business.audit.fee.local.service.internal.dispose;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeLedger;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeLedgerItem;
import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeLedgerItemRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeLedgerRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerItemDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.log.AuditFeeDiffDisposeLedgerLogEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.event.dispose.AuditFeeDiffDisposeLedgerEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.event.log.AuditFeeDiffDisposeLedgerLogEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeLedgerItemVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeDetailVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeLedgerItemVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeLedgerVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 核销差异费用处理预算汇总信息(AuditFeeDiffDisposeLedger)表服务实现类
 *
 * @author liuyifan
 * @date 2022-12-24 13:55:44
 */
@Slf4j
@Service("auditFeeDiffDisposeLedgerItemVoService")
public class AuditFeeDiffDisposeLedgerItemVoServiceImpl implements AuditFeeDiffDisposeLedgerItemVoService {

    @Autowired(required = false)
    private AuditFeeDiffDisposeLedgerItemRepository auditFeeDiffDisposeLedgerItemRepository;

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 逻辑删除差异费用处理预算编码
     *
     * @param feeDiffDisposeCode 差异费用处理编码
     */
    @Override
    public void deleteByAuditFeeDiffDisposeCode(String feeDiffDisposeCode) {
        Validate.notBlank(feeDiffDisposeCode,"feeDiffDisposeCode 不能为空");
        this.auditFeeDiffDisposeLedgerItemRepository.deleteByAuditFeeDiffDisposeCode(feeDiffDisposeCode);
    }

    /**
     * 保存关联的差异费用台帐
     * @param feeDiffDisposeCode
     * @param details
     */
    @Override
    public void saveBatch(String feeDiffDisposeCode, List<AuditFeeDiffDisposeDetailDto> details) {
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        //删除所有
        this.deleteByAuditFeeDiffDisposeCode(feeDiffDisposeCode);

        List<AuditFeeDiffDisposeLedgerItem> ledgerItemList = new ArrayList<>();
        for (AuditFeeDiffDisposeDetailDto detail : details) {
            if (CollectionUtils.isEmpty(detail.getLedgerItems())) {
                continue;
            }
            detail.getLedgerItems().forEach(ledger -> {
                ledger.setId(null);
                ledger.setDetailPlanItemCode(detail.getDetailPlanItemCode());
                ledger.setFeeDiffDisposeCode(feeDiffDisposeCode);
                ledger.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                ledger.setTenantCode(TenantUtils.getTenantCode());
                ledger.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                AuditFeeDiffDisposeLedgerItem ledgerItem = nebulaToolkitService.copyObjectByWhiteList(ledger, AuditFeeDiffDisposeLedgerItem.class, HashSet.class, ArrayList.class);
                ledgerItemList.add(ledgerItem);
            });
        }
        this.auditFeeDiffDisposeLedgerItemRepository.saveBatch(ledgerItemList);
    }

    /**
     * 根据差异费用处理编码逻辑删除
     *
     * @param feeDifDisposeCodes
     */
    @Override
    public void updateDelFlagByFeeDiffDisposeCode(List<String> feeDifDisposeCodes) {
        if (CollectionUtils.isEmpty(feeDifDisposeCodes)) {
            return;
        }
        this.auditFeeDiffDisposeLedgerItemRepository.updateDelFlagByFeeDiffDisposeCodes(feeDifDisposeCodes);
    }
}
