package com.biz.crm.tpm.business.audit.fee.local.service.internal.dispose;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeLedger;
import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeLedgerRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.log.AuditFeeDiffDisposeLedgerLogEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.event.dispose.AuditFeeDiffDisposeLedgerEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.event.log.AuditFeeDiffDisposeLedgerLogEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeLedgerVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeDetailVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 核销差异费用处理预算汇总信息(AuditFeeDiffDisposeLedger)表服务实现类
 *
 * @author liuyifan
 * @date 2022-12-24 13:55:44
 */
@Slf4j
@Service("auditFeeDiffDisposeLedgerVoService")
public class AuditFeeDiffDisposeLedgerVoServiceImpl implements AuditFeeDiffDisposeLedgerVoService {

    @Autowired(required = false)
    private AuditFeeDiffDisposeLedgerRepository auditFeeDiffDisposeLedgerRepository;

    @Autowired(required = false)
    private List<AuditFeeDiffDisposeLedgerEventListener> eventListeners;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;

    @Override
    public Page<AuditFeeDiffDisposeLedgerVo> findByConditions(Pageable pageable, AuditFeeDiffDisposeLedgerDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffDisposeLedgerDto());
        Page<AuditFeeDiffDisposeLedgerVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditFeeDiffDisposeLedgerRepository.findByConditions(page, dto);
    }

    @Override
    public AuditFeeDiffDisposeLedgerVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        AuditFeeDiffDisposeLedger auditFeeDiffDisposeBudget = this.auditFeeDiffDisposeLedgerRepository.findById(id);
        if (auditFeeDiffDisposeBudget == null) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(auditFeeDiffDisposeBudget, AuditFeeDiffDisposeLedgerVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    @Transactional
    public AuditFeeDiffDisposeLedgerVo create(AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo) {
        this.createValidation(auditFeeDiffDisposeBudgetVo);
        auditFeeDiffDisposeBudgetVo.setTenantCode(TenantUtils.getTenantCode());
        auditFeeDiffDisposeBudgetVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        auditFeeDiffDisposeBudgetVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());

        AuditFeeDiffDisposeLedger auditFeeDiffDisposeBudget = nebulaToolkitService.copyObjectByWhiteList(auditFeeDiffDisposeBudgetVo, AuditFeeDiffDisposeLedger.class, HashSet.class, ArrayList.class);
        this.auditFeeDiffDisposeLedgerRepository.saveOrUpdate(auditFeeDiffDisposeBudget);

        auditFeeDiffDisposeBudgetVo.setId(auditFeeDiffDisposeBudget.getId());

        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditFeeDiffDisposeLedgerEventListener auditFeeDiffDisposeBudgetEventListener : eventListeners) {
                auditFeeDiffDisposeBudgetEventListener.onCreate(auditFeeDiffDisposeBudgetVo);
            }
        }

        // 发送通知
        AuditFeeDiffDisposeLedgerLogEventDto logEventDto = new AuditFeeDiffDisposeLedgerLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditFeeDiffDisposeBudgetVo);
        SerializableBiConsumer<AuditFeeDiffDisposeLedgerLogEventListener, AuditFeeDiffDisposeLedgerLogEventDto> onCreate =
                AuditFeeDiffDisposeLedgerLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, AuditFeeDiffDisposeLedgerLogEventListener.class, onCreate);
        return auditFeeDiffDisposeBudgetVo;
    }

    @Override
    @Transactional
    public AuditFeeDiffDisposeLedgerVo update(AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo) {
        this.updateValidation(auditFeeDiffDisposeBudgetVo);
        String currentId = auditFeeDiffDisposeBudgetVo.getId();
        AuditFeeDiffDisposeLedger current = auditFeeDiffDisposeLedgerRepository.findById(currentId);
        current = Validate.notNull(current, "修改信息不存在");
        AuditFeeDiffDisposeLedgerVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(current, AuditFeeDiffDisposeLedgerVo.class, HashSet.class, ArrayList.class);


        this.auditFeeDiffDisposeLedgerRepository.saveOrUpdate(current);
        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditFeeDiffDisposeLedgerEventListener auditFeeDiffDisposeBudgetEventListener : eventListeners) {
                auditFeeDiffDisposeBudgetEventListener.onUpdate(oldVo,auditFeeDiffDisposeBudgetVo);
            }
        }

        // 发送修改通知
        AuditFeeDiffDisposeLedgerLogEventDto logEventDto = new AuditFeeDiffDisposeLedgerLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditFeeDiffDisposeBudgetVo);
        SerializableBiConsumer<AuditFeeDiffDisposeLedgerLogEventListener, AuditFeeDiffDisposeLedgerLogEventDto> onUpdate =
                AuditFeeDiffDisposeLedgerLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditFeeDiffDisposeLedgerLogEventListener.class, onUpdate);
        return auditFeeDiffDisposeBudgetVo;
    }




    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffDisposeLedgerRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffDisposeLedgerRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffDisposeLedgerRepository.updateDelFlagByIds(ids);
    }


    @Override
    public List<AuditFeeDiffDisposeLedgerVo> getBudgetsByFeeDetails(List<AuditFeeDiffDisposeDetailVo> details) {

        List<AuditFeeDiffLedgerVo> auditFeeDiffLedgerVos = null;
        if (CollectionUtils.isNotEmpty(details)){
            Set<String> ledgerCodes = details.stream().map(x -> x.getFeeDiffLedgerCode()).filter(Objects::nonNull).collect(Collectors.toSet());
            auditFeeDiffLedgerVos = this.auditFeeDiffLedgerVoService.findDetailByCodes(Lists.newArrayList(ledgerCodes));
        }
        if (CollectionUtils.isNotEmpty(auditFeeDiffLedgerVos)){
            Map<String, BigDecimal> amountMap = details.stream().collect(Collectors.toMap(AuditFeeDiffDisposeDetailVo::getFeeDiffLedgerCode, AuditFeeDiffDisposeDetailVo::getFeeAmount));

            List<AuditFeeDiffDisposeLedgerVo> auditFeeDiffDisposeBudgetVos = new ArrayList<>(auditFeeDiffLedgerVos.size());
            auditFeeDiffLedgerVos.forEach(auditFeeDiffLedgerVo -> {
                AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo =   new AuditFeeDiffDisposeLedgerVo();
                auditFeeDiffDisposeBudgetVo.setFeeDiffLedgerCode(auditFeeDiffLedgerVo.getFeeDiffLedgerCode());
                auditFeeDiffDisposeBudgetVo.setFeeYearMonth(auditFeeDiffLedgerVo.getFeeYearMonth());
                auditFeeDiffDisposeBudgetVo.setThisUseAmount(amountMap.get(auditFeeDiffLedgerVo.getFeeDiffLedgerCode()));
                auditFeeDiffDisposeBudgetVos.add(auditFeeDiffDisposeBudgetVo);
            });
            return auditFeeDiffDisposeBudgetVos;
        }
        return Lists.newArrayList();
    }


    @Override
    public List<AuditFeeDiffDisposeLedgerVo> findDetailByDiffDisposeCode(String feeDiffDisposeCode) {
        if (StringUtils.isEmpty(feeDiffDisposeCode)){
            return Lists.newArrayList();
        }
        List<AuditFeeDiffDisposeLedger> auditFeeDiffDisposeBudgets = this.auditFeeDiffDisposeLedgerRepository.findDetailByDiffDisposeCode(feeDiffDisposeCode);
        if (CollectionUtils.isEmpty(auditFeeDiffDisposeBudgets)){
            return Lists.newArrayList();
        }
        return (List<AuditFeeDiffDisposeLedgerVo>) nebulaToolkitService.copyCollectionByWhiteList(auditFeeDiffDisposeBudgets,AuditFeeDiffDisposeLedger.class,AuditFeeDiffDisposeLedgerVo.class,HashSet.class,ArrayList.class);

    }

    /**
     * 逻辑删除差异费用处理预算编码
     *
     * @param feeDiffDisposeCode 差异费用处理编码
     */
    @Override
    public void deleteByAuditFeeDiffDisposeCode(String feeDiffDisposeCode) {
        Validate.notBlank(feeDiffDisposeCode,"feeDiffDisposeCode 不能为空");
        this.auditFeeDiffDisposeLedgerRepository.deleteByAuditFeeDiffDisposeCode(feeDiffDisposeCode);
    }

    private void createValidation(AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo) {
        // TODO 具体实现
        this.validation(auditFeeDiffDisposeBudgetVo);
    }

    private void updateValidation(AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo) {
        // TODO 具体实现
        this.validation(auditFeeDiffDisposeBudgetVo);
    }

    private void validation(AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo) {
        // TODO 具体实现
    }

    /**
     * 保存汇总
     * @param feeDiffDisposeCode
     * @param budgets
     */
    @Override
    public void saveBatch(String feeDiffDisposeCode, List<AuditFeeDiffDisposeLedgerDto> budgets) {
        if(org.springframework.util.CollectionUtils.isEmpty(budgets)){
            return;
        }
        //删除所有
        this.deleteByAuditFeeDiffDisposeCode(feeDiffDisposeCode);
        //
        budgets.forEach(o -> {
            o.setFeeDiffDisposeCode(feeDiffDisposeCode);
            o.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            o.setTenantCode(TenantUtils.getTenantCode());
            o.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        List<AuditFeeDiffDisposeLedger> diffDisposeBudgets = (List<AuditFeeDiffDisposeLedger>) this.nebulaToolkitService
            .copyCollectionByBlankList(budgets, AuditFeeDiffDisposeLedgerDto.class, AuditFeeDiffDisposeLedger.class, HashSet.class, ArrayList.class);
        this.auditFeeDiffDisposeLedgerRepository.saveBatch(diffDisposeBudgets);
    }

    /**
     * 根据差异费用处理编码逻辑删除
     *
     * @param feeDifDisposeCodes
     */
    @Override
    public void updateDelFlagByFeeDiffDisposeCode(List<String> feeDifDisposeCodes) {
        if (CollectionUtils.isEmpty(feeDifDisposeCodes)) {
            return;
        }
        this.auditFeeDiffDisposeLedgerRepository.updateDelFlagByFeeDiffDisposeCodes(feeDifDisposeCodes);
    }
}
