package com.biz.crm.tpm.business.audit.fee.local.service.internal.dispose;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDispose;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeDetail;
import com.biz.crm.tpm.business.audit.fee.local.helper.AuditFeeDiffDisposeHelper;
import com.biz.crm.tpm.business.audit.fee.local.helper.AuditFeeDiffLedgerHelper;
import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeDiffDisposeDetailService;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeDiffLedgerService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditCheckEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.*;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.WhereFromEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.event.check.AuditFeeCheckEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.event.dispose.AuditFeeDiffDisposeEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeLedgerItemVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeDetailVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeTemplateVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * 核销差异费用处理(AuditFeeDiffDispose)表服务实现类
 *
 * @author liuyifan
 * @date 2022-12-24 13:54:27
 */
@Slf4j
@Service("auditFeeDiffDisposeVoService")
public class AuditFeeDiffDisposeVoServiceImpl implements AuditFeeDiffDisposeVoService {

    @Autowired(required = false)
    private AuditFeeDiffDisposeRepository auditFeeDiffDisposeRepository;

    @Autowired
    private AuditFeeDiffDisposeDetailPageCacheHelper auditFeeDiffDisposeDetailPageCacheHelper;

    @Autowired(required = false)
    private List<AuditFeeDiffDisposeEventListener> eventListeners;

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired
    private AuditFeeDiffDisposeDetailVoService auditFeeDiffDisposeDetailVoService;

    @Autowired(required = false)
    private AuditFeeDiffDisposeDetailService auditFeeDiffDisposeDetailService;

    @Autowired
    private AuditFeeDiffDisposeLedgerVoService auditFeeDiffDisposeBudgetVoService;

    @Autowired(required = false)
    private ProcessBatchBusinessService processBatchBusinessService;

    @Autowired(required = false)
    private ProcessBusinessService processBusinessService;

    @Resource
    private AuditFeeDiffDisposeHelper auditFeeDiffDisposeHelper;

    @Resource
    private AuditFeeDiffDisposeLedgerItemVoService auditFeeDiffDisposeLedgerItemVoService;

    @Autowired(required = false)
    private AuditFeeDiffLedgerHelper auditFeeDiffLedgerHelper;

    @Autowired(required = false)
    private AuditFeeDiffLedgerService auditFeeDiffLedgerService;

    @Autowired(required = false)
    private AuditFeeDiffDisposeLedgerVoService auditFeeDiffDisposeLedgerVoService;

    @Override
    public Page<AuditFeeDiffDisposeVo> findByConditions(Pageable pageable, AuditFeeDiffDisposeDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffDisposeDto());
        Page<AuditFeeDiffDisposeVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditFeeDiffDisposeRepository.findByConditions(page, dto);
    }

    @Override
    public AuditFeeDiffDisposeVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        AuditFeeDiffDispose auditFeeDiffDispose = this.auditFeeDiffDisposeRepository.findById(id);
        if (auditFeeDiffDispose == null) {
            return null;
        }
        AuditFeeDiffDisposeVo auditFeeDiffDisposeVo = nebulaToolkitService.copyObjectByWhiteList(auditFeeDiffDispose, AuditFeeDiffDisposeVo.class, HashSet.class, ArrayList.class);
        this.fullDetail(auditFeeDiffDisposeVo);
        return auditFeeDiffDisposeVo;
    }

    /**
     * 完整细节
     *
     * @param auditFeeDiffDisposeVo 核销差异费用处理Vo
     */
    private void fullDetail(AuditFeeDiffDisposeVo auditFeeDiffDisposeVo){
        auditFeeDiffDisposeVo.setLedgers(this.auditFeeDiffDisposeBudgetVoService.findDetailByDiffDisposeCode(auditFeeDiffDisposeVo.getFeeDiffDisposeCode()));
        List<AuditFeeDiffDisposeDetailVo> detailVos = this.auditFeeDiffDisposeDetailVoService.findDetailByDiffDisposeCode(auditFeeDiffDisposeVo.getFeeDiffDisposeCode());
        Map<String, String> templateMap = detailVos.stream().filter(x-> x.getTemplateConfigCode() != null)
            .collect(Collectors.toMap(AuditFeeDiffDisposeDetailVo::getTemplateConfigCode,
                AuditFeeDiffDisposeDetailVo::getTemplateConfigName));
        if (MapUtil.isNotEmpty(templateMap)){
            List<AuditFeeDiffDisposeTemplateVo> templateVos = new ArrayList<>(templateMap.size());
            templateMap.forEach((k,v)->{
                AuditFeeDiffDisposeTemplateVo auditFeeDiffDisposeTemplateVo = new AuditFeeDiffDisposeTemplateVo();
                auditFeeDiffDisposeTemplateVo.setTemplateConfigCode(k);
                auditFeeDiffDisposeTemplateVo.setTemplateConfigName(v);
                templateVos.add(auditFeeDiffDisposeTemplateVo);
            });
            auditFeeDiffDisposeVo.setTemplates(templateVos);
        }
    }

    /**
     * 新增
     * @param cacheKey
     * @param dto
     * @return {@link AuditFeeDiffDisposeVo}
     */
    @Override
    public AuditFeeDiffDisposeVo create(String cacheKey, AuditFeeDiffDisposeDto dto) {
        this.auditFeeDiffDisposeHelper.verifyEmpty(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        dto.setWhereFrom(WhereFromEnum.MANUAL.getCode());
        dto.setFeeDiffDisposeCode(this.auditFeeDiffDisposeHelper.generateCode());
        dto.setFeeDiffDisposeCode(dto.getFeeDiffDisposeCode());
        //明细信息
        this.auditFeeDiffDisposeHelper.buildDetails(cacheKey, dto);
        Validate.notEmpty(dto.getDetails(),"细案内容不能为空！");
        //台帐编码集合 构建明细时校验的台账不能为空
        List<String> feeDiffLedgerCodes = Lists.newArrayList();
        dto.getDetails().forEach(detail -> {
            String feeDiffLedgerCode = detail.getFeeDiffLedgerCode();
            if(!StringUtils.isBlank(feeDiffLedgerCode)){
                feeDiffLedgerCodes.addAll(Arrays.asList(feeDiffLedgerCode.split(",")));
            }
        });
        //加锁
        boolean lock = true;
        try {
            lock = this.auditFeeDiffLedgerHelper.batchTryLock(feeDiffLedgerCodes, TimeUnit.SECONDS, 30);
            if(lock){
                //保存数据信息
                this.saveOrUpdate(dto);
                //提交审批
                if (!Objects.isNull(dto.getProcessBusiness())) {
                    this.submitBatchProcessAfterCreate(dto,dto.getProcessBusiness());
                }
            }
        }finally {
            if (lock) {
                this.auditFeeDiffLedgerHelper.batchUnLock(feeDiffLedgerCodes);
            }
        }
        //crud监听事件
        /*if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditFeeDiffDisposeEventListener auditFeeDiffDisposeEventListener : eventListeners) {
                auditFeeDiffDisposeEventListener.onCreate(auditFeeDiffDisposeVo);
            }
        }*/

        /*this.commitProcess(auditFeeDiffDisposeVo);
        auditFeeDiffDispose.setProcessStatus(auditFeeDiffDisposeVo.getProcessStatus());
        this.auditFeeDiffDisposeRepository.saveOrUpdate(auditFeeDiffDispose);*/

        // 发送通知
        /*AuditFeeDiffDisposeLogEventDto logEventDto = new AuditFeeDiffDisposeLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditFeeDiffDisposeVo);
        SerializableBiConsumer<AuditFeeDiffDisposeLogEventListener, AuditFeeDiffDisposeLogEventDto> onCreate =
                AuditFeeDiffDisposeLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, AuditFeeDiffDisposeLogEventListener.class, onCreate);
        return auditFeeDiffDisposeVo;*/
        return null;
    }


    private void submitBatchProcessAfterCreate(AuditFeeDiffDisposeDto dto,ProcessBusinessDto processBusiness) {

        Validate.notNull(processBusiness,"审批流对象不能为空");
        Validate.notNull(dto,"不存在的实例对象");
        Validate.isTrue(ProcessStatusEnum.PREPARE.getDictCode().equals(dto.getProcessStatus())
                || ProcessStatusEnum.RECOVER.getDictCode().equals(dto.getProcessStatus())
                || ProcessStatusEnum.REJECT.getDictCode().equals(dto.getProcessStatus()),"只有待提交,追回,驳回状态的可以提交审批！");
        String uuid = UUID.randomUUID().toString().replace("-", "");
        processBusiness.setBusinessNo(uuid);
        processBusiness.setBusinessCode(AuditFeeConstants.AUDIT_FEE_DIFF_DISPOSE_PROCESS_CODE);
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString(dto));
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);

        dto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        dto.setProcessNo(processBusinessVo.getProcessNo());
        this.auditFeeDiffDisposeRepository.updateProcessStatusByCode(dto);
    }

    /**
     * 最终保存数据信息
     * @param dto
     */
    @Transactional(rollbackFor = Exception.class)
    public void saveOrUpdate(AuditFeeDiffDisposeDto dto) {

        dto.setWhereFrom(WhereFromEnum.MANUAL.getCode());
        AuditFeeDiffDispose auditFeeDiffDispose = nebulaToolkitService
            .copyObjectByWhiteList(dto, AuditFeeDiffDispose.class, HashSet.class, ArrayList.class);
        this.auditFeeDiffDisposeRepository.save(auditFeeDiffDispose);
        this.auditFeeDiffDisposeDetailVoService.saveBatch(dto.getFeeDiffDisposeCode(), dto.getDetails());
        //保存关联的差异费用台帐
        this.auditFeeDiffDisposeLedgerItemVoService.saveBatch(dto.getFeeDiffDisposeCode(),dto.getDetails());
        //保存汇总
        this.auditFeeDiffDisposeBudgetVoService.saveBatch(dto.getFeeDiffDisposeCode(), dto.getLedgers());
        //处理台帐信息
        this.auditFeeDiffLedgerService.handle(dto.getFeeDiffDisposeCode(), dto.getLedgerItems());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AuditFeeDiffDisposeVo update(String cacheKey, AuditFeeDiffDisposeDto dto) {
        Assert.hasText(dto.getId(), "主键ID不能为空");
        AuditFeeDiffDispose oldEntity = this.auditFeeDiffDisposeRepository.findById(dto.getId());
        this.auditFeeDiffDisposeHelper.verifyEmpty(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        dto.setFeeDiffDisposeCode(oldEntity.getFeeDiffDisposeCode());
        //明细信息
        this.auditFeeDiffDisposeHelper.buildDetails(cacheKey, dto);
        //台帐编码集合
        List<String> feeDiffLedgerCodes = Lists.newArrayList();
        if (CollectionUtils.isEmpty(dto.getDetails())){
            //保存数据信息
            this.saveOrUpdate(dto);
        }else {
            dto.getDetails().forEach(detail -> {
                String feeDiffLedgerCode = detail.getFeeDiffLedgerCode();
                if(org.springframework.util.StringUtils.hasText(feeDiffLedgerCode)){
                    feeDiffLedgerCodes.addAll(Arrays.asList(feeDiffLedgerCode.split(",")));
                }
            });
            //加锁
            boolean lock = true;
            try {
                lock = this.auditFeeDiffLedgerHelper.batchTryLock(feeDiffLedgerCodes, TimeUnit.SECONDS, 30);
                if(lock){
                    //保存数据信息
                    this.saveOrUpdate(dto);
                }
            }finally {
                if (lock) {
                    this.auditFeeDiffLedgerHelper.batchUnLock(feeDiffLedgerCodes);
                }
            }
        }

        //crud监听事件
        /*if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditFeeDiffDisposeEventListener auditFeeDiffDisposeEventListener : eventListeners) {
                auditFeeDiffDisposeEventListener.onUpdate(oldVo,auditFeeDiffDisposeVo);
            }
        }*/

        //逻辑删除之前的数据
        /*this.auditFeeDiffDisposeDetailVoService.deleteByAuditFeeDiffDisposeCode(auditFeeDiffDisposeVo.getFeeDiffDisposeCode());
        this.auditFeeDiffDisposeBudgetVoService.deleteByAuditFeeDiffDisposeCode(auditFeeDiffDisposeVo.getFeeDiffDisposeCode());
        this.saveOtherInfo(cacheKey, auditFeeDiffDisposeVo);*/


        // 发送修改通知
        /*AuditFeeDiffDisposeLogEventDto logEventDto = new AuditFeeDiffDisposeLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditFeeDiffDisposeVo);
        SerializableBiConsumer<AuditFeeDiffDisposeLogEventListener, AuditFeeDiffDisposeLogEventDto> onUpdate =
                AuditFeeDiffDisposeLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditFeeDiffDisposeLogEventListener.class, onUpdate);
        return auditFeeDiffDisposeVo;*/
        return null;
    }


    /**
     * 保存其他信息
     *
     * @param cacheKey              缓存键
     * @param auditFeeDiffDisposeVo 差异费用处理vo
     */
    private void saveOtherInfo(String cacheKey,AuditFeeDiffDisposeVo auditFeeDiffDisposeVo){
        //保存对应的明细列表
        List<AuditFeeDiffDisposeDetailVo> disposeDetails = new ArrayList<>();
        if (StrUtil.isNotEmpty(cacheKey)){
            List<AuditFeeDiffDisposeDetailDto> detailVoServiceCacheList = this.auditFeeDiffDisposeDetailVoService.findCacheList(cacheKey);
            disposeDetails = Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(detailVoServiceCacheList,AuditFeeDiffDisposeDetailDto.class,AuditFeeDiffDisposeDetailVo.class,HashSet.class,ArrayList.class));
            this.auditFeeDiffDisposeDetailVoService.clearCache(cacheKey);
        }else {
            disposeDetails  = auditFeeDiffDisposeVo.getDetails();
        }


        if (CollectionUtils.isNotEmpty(disposeDetails)){
            for (AuditFeeDiffDisposeDetailVo disposeDetailVo : disposeDetails) {
                disposeDetailVo.setFeeDiffDisposeCode(auditFeeDiffDisposeVo.getFeeDiffDisposeCode());
                this.auditFeeDiffDisposeDetailVoService.create(disposeDetailVo);
            }
        }

        //保存对应的预算列表
        if (CollectionUtils.isNotEmpty(auditFeeDiffDisposeVo.getLedgers())){
            auditFeeDiffDisposeVo.getLedgers().forEach(auditFeeDiffDisposeBudgetVo -> {
                auditFeeDiffDisposeBudgetVo.setFeeDiffDisposeCode(auditFeeDiffDisposeVo.getFeeDiffDisposeCode());
                auditFeeDiffDisposeBudgetVoService.create(auditFeeDiffDisposeBudgetVo);
            });

        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffDisposeRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffDisposeRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        List<AuditFeeDiffDispose> diffDis = this.auditFeeDiffDisposeRepository.findByIds(ids);
        Validate.notEmpty(diffDis,"要删除是数据不存在！");
        diffDis.forEach( diff -> {
            if (ProcessStatusEnum.PASS.getDictCode().equals(diff.getProcessStatus())
                    || ProcessStatusEnum.COMMIT.getDictCode().equals(diff.getProcessStatus())) {
                throw new IllegalArgumentException(diff.getFeeDiffDisposeName()+diff.getFeeDiffDisposeCode()+"已审批或审批中，不可删除！");
            }
        });
        List<String> feeDifDisposeCodes = diffDis.stream().map(AuditFeeDiffDispose::getFeeDiffDisposeCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        this.auditFeeDiffDisposeDetailService.updateDelFlagByFeeDiffDisposeCode(feeDifDisposeCodes);
        this.auditFeeDiffDisposeLedgerItemVoService.updateDelFlagByFeeDiffDisposeCode(feeDifDisposeCodes);
        this.auditFeeDiffDisposeLedgerVoService.updateDelFlagByFeeDiffDisposeCode(feeDifDisposeCodes);
        this.auditFeeDiffDisposeRepository.updateDelFlagByIds(ids);
        //更新费用核对
        List<String> matchCodes = diffDis.stream().map(AuditFeeDiffDispose::getMatchCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        AuditCheckEventDto eventDto = new AuditCheckEventDto();
        eventDto.setMatchCodes(matchCodes);
        SerializableBiConsumer<AuditFeeCheckEventListener, AuditCheckEventDto> diffDisposeDeleted = AuditFeeCheckEventListener::diffDisposeDeleted;
        nebulaNetEventClient.publish(eventDto, AuditFeeCheckEventListener.class, diffDisposeDeleted);
    }

    /**
     * 根据处理编码查询差异处理详情
     *
     * @param businessNo 业务编码
     * @return {@link AuditFeeDiffDisposeVo}
     */
    @Override
    public AuditFeeDiffDisposeVo findDetailByDisposeCode(String businessNo) {
        Validate.notNull(businessNo, "businessNo不能为空");
        AuditFeeDiffDispose auditFeeDiffDispose = this.auditFeeDiffDisposeRepository.findDetailByDisposeCode(businessNo);
        if (Objects.isNull(auditFeeDiffDispose)) {
            return null;
        }

        AuditFeeDiffDisposeVo auditFeeDiffDisposeVo = nebulaToolkitService.copyObjectByWhiteList(auditFeeDiffDispose, AuditFeeDiffDisposeVo.class, HashSet.class, ArrayList.class);
        this.fullDetail(auditFeeDiffDisposeVo);
        return auditFeeDiffDisposeVo;
    }

    @Override
    public void submitBatchProcess(AuditFeeDiffDisposeProcessDto auditFeeDiffDisposeProcessDto) {
        if (Objects.isNull(auditFeeDiffDisposeProcessDto)){
            return;
        }
        Validate.notNull(auditFeeDiffDisposeProcessDto.getProcessBusiness(),"审批流对象不能为空");
        List<AuditFeeDiffDispose> auditFeeDiffDisposes = this.auditFeeDiffDisposeRepository.findByIds(auditFeeDiffDisposeProcessDto.getIds());
        Validate.notEmpty(auditFeeDiffDisposes,"不存在的实例对象");
        auditFeeDiffDisposes.forEach(auditFeeDiffDispose -> {
            Validate.isTrue(ProcessStatusEnum.PREPARE.getDictCode().equals(auditFeeDiffDispose.getProcessStatus())
                    || ProcessStatusEnum.RECOVER.getDictCode().equals(auditFeeDiffDispose.getProcessStatus())
            || ProcessStatusEnum.REJECT.getDictCode().equals(auditFeeDiffDispose.getProcessStatus()),"只有待提交,追回,驳回状态的可以提交审批！");
        });
        ProcessBusinessDto processBusiness = auditFeeDiffDisposeProcessDto.getProcessBusiness();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        processBusiness.setBusinessNo(uuid);
        processBusiness.setBusinessNoList(auditFeeDiffDisposes.stream().map(AuditFeeDiffDispose::getFeeDiffDisposeCode).filter(Objects::nonNull).collect(Collectors.toList()));
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString(auditFeeDiffDisposeProcessDto));
        processBusiness.setBusinessCode(AuditFeeConstants.AUDIT_FEE_DIFF_DISPOSE_PROCESS_CODE);
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);

        auditFeeDiffDisposes.forEach(auditFeeDiffDispose -> {
            auditFeeDiffDispose.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            auditFeeDiffDispose.setProcessNo(processBusinessVo.getProcessNo());
        });
       this.auditFeeDiffDisposeRepository.updateBatchById(auditFeeDiffDisposes);
    }

    /**
     * 关联差异费用
     * @param dto
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void correlation(AuditFeeDiffDisposeCorrelationDto dto) {
        Validate.notNull(dto,"请求对象不能为空");
        Validate.notEmpty(dto.getId(),"差异费用处理主建id不能为空");
        Validate.notEmpty(dto.getLedgerItems(),"差异费用集合不能为空");
        AuditFeeDiffDispose dispose = this.auditFeeDiffDisposeRepository.findById(dto.getId());
        Assert.notNull(dispose, "未查询到数据信息");
        Assert.isTrue(WhereFromEnum.AUTOMATIC.getCode().equals(dispose.getWhereFrom()), "非自动生成数据");
        //查询明细信息
        List<AuditFeeDiffDisposeDetail> disposeDetails = this.auditFeeDiffDisposeDetailService
            .findByFeeDiffDisposeCode(dispose.getFeeDiffDisposeCode());
        Assert.notEmpty(disposeDetails, "没有明细信息");
        AuditFeeDiffDisposeDetail auditFeeDiffDisposeDetail = disposeDetails.get(0);
        //申请金额汇总
        AtomicReference<BigDecimal> thisUseAmountAtomic = new AtomicReference<>(BigDecimal.ZERO);
        //费用台帐编码
        List<String> feeDiffLedgerCodes = Lists.newArrayList();
        dto.getLedgerItems().forEach(o -> {
            o.setDetailPlanItemCode(auditFeeDiffDisposeDetail.getDetailPlanItemCode());
            o.setFeeDiffDisposeCode(dispose.getFeeDiffDisposeCode());
            o.setThisUseAmount(o.getBeRecoveredAmount());
            thisUseAmountAtomic.set(thisUseAmountAtomic.get().add(o.getThisUseAmount()));
            feeDiffLedgerCodes.add(o.getFeeDiffLedgerCode());
        });
        auditFeeDiffDisposeDetail.setThisUseAmount(thisUseAmountAtomic.get());
        auditFeeDiffDisposeDetail.setFeeDiffLedgerCode(String.join("," ,feeDiffLedgerCodes));
        dispose.setDisposeFeeAmount(thisUseAmountAtomic.get());
        //保存数据信息
        this.auditFeeDiffDisposeRepository.updateById(dispose);
        this.auditFeeDiffDisposeDetailService.batchUpdateById(Lists.newArrayList(auditFeeDiffDisposeDetail));
        //this.auditFeeDiffDisposeLedgerItemVoService.saveBatch(dispose.getFeeDiffDisposeCode(), dto.getLedgerItems());
    }

    /**
     * 提交审批
     *
     * @param auditFeeDiffDisposeVo 差异费用处理vo
     */
    private void commitProcess(AuditFeeDiffDisposeVo auditFeeDiffDisposeVo){
        if (auditFeeDiffDisposeVo.getProcessBusiness() == null){
            return;
        }
        //扣减预算

        ProcessBusinessDto processBusiness = auditFeeDiffDisposeVo.getProcessBusiness();
        processBusiness.setBusinessNo(auditFeeDiffDisposeVo.getFeeDiffDisposeCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString(auditFeeDiffDisposeVo));
        processBusiness.setBusinessCode(AuditFeeConstants.AUDIT_FEE_DIFF_DISPOSE_PROCESS_CODE);
        this.processBusinessService.processStart(processBusiness);
        auditFeeDiffDisposeVo.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
    }

    private void createValidation(AuditFeeDiffDisposeVo auditFeeDiffDisposeVo) {
        // TODO 具体实现
        /*this.validation(auditFeeDiffDisposeVo);
        String ruleCode = StringUtils.join(AuditFeeConstants.AUDIT_FEE_DIFF_DISPOSE, DateFormatUtils.format(new Date(), "yyyyMMdd"));
        String code = this.generateCodeService.generateCode(ruleCode, 1, 8, 999, TimeUnit.DAYS).get(0);
        auditFeeDiffDisposeVo.setFeeDiffDisposeCode(code);*/
    }

    private void updateValidation(AuditFeeDiffDisposeVo auditFeeDiffDisposeVo) {
        // TODO 具体实现
        this.validation(auditFeeDiffDisposeVo);
    }

    private void validation(AuditFeeDiffDisposeVo auditFeeDiffDisposeVo) {
        // TODO 具体实现
    }

    /**
     * 自动生成 (明细直接复制细案的)
     * @param dto
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void autoCreate(AuditFeeDiffDisposeDto dto) {
        this.auditFeeDiffDisposeHelper.verifyEmpty(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        AuditFeeDiffDispose auditFeeDiffDispose = nebulaToolkitService
            .copyObjectByWhiteList(dto, AuditFeeDiffDispose.class, HashSet.class, ArrayList.class);
        auditFeeDiffDispose.setWhereFrom(WhereFromEnum.AUTOMATIC.getCode());
        dto.setFeeDiffDisposeCode(this.auditFeeDiffDisposeHelper.generateCode());
        auditFeeDiffDispose.setFeeDiffDisposeCode(dto.getFeeDiffDisposeCode());
        this.auditFeeDiffDisposeRepository.save(auditFeeDiffDispose);
        //保存明细
        this.auditFeeDiffDisposeHelper.buildDetails(null, dto);
        this.auditFeeDiffDisposeDetailVoService.saveBatch(dto.getFeeDiffDisposeCode(), dto.getDetails());
    }

    /**
     * 导入保存
     * @param dto
     */
    @Override
    public void importSave(AuditFeeDiffDisposeDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        AuditFeeDiffDispose auditFeeDiffDispose = nebulaToolkitService
            .copyObjectByWhiteList(dto, AuditFeeDiffDispose.class, HashSet.class, ArrayList.class);
        auditFeeDiffDispose.setWhereFrom(WhereFromEnum.MANUAL.getCode());
        dto.setFeeDiffDisposeCode(this.auditFeeDiffDisposeHelper.generateCode());
        auditFeeDiffDispose.setFeeDiffDisposeCode(dto.getFeeDiffDisposeCode());
        this.auditFeeDiffDisposeRepository.save(auditFeeDiffDispose);
    }
}
