package com.biz.crm.tpm.business.audit.fee.local.service.internal.ledger;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.fee.local.entity.ledger.AuditFeeDiffLedgerDeduction;
import com.biz.crm.tpm.business.audit.fee.local.repository.ledger.AuditFeeDiffLedgerDeductionRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.log.AuditFeeDiffLedgerDeductionLogEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.event.ledger.AuditFeeDiffLedgerDeductionEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.event.log.AuditFeeDiffLedgerDeductionLogEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerDeductionVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerDeductionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 核销差异费用扣减明细(AuditFeeDiffLedgerDeduction)表服务实现类
 *
 * @author liuyifan
 * @date 2022-12-22 15:32:17
 */
@Slf4j
@Service("auditFeeDiffLedgerDeductionService")
public class AuditFeeDiffLedgerDeductionVoServiceImpl implements AuditFeeDiffLedgerDeductionVoService {

    @Autowired(required = false)
    private AuditFeeDiffLedgerDeductionRepository auditFeeDiffLedgerDeductionRepository;

    @Autowired(required = false)
    private List<AuditFeeDiffLedgerDeductionEventListener> eventListeners;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<AuditFeeDiffLedgerDeductionVo> findByConditions(Pageable pageable, AuditFeeDiffLedgerDeductionDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffLedgerDeductionDto());
        Page<AuditFeeDiffLedgerDeductionVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditFeeDiffLedgerDeductionRepository.findByConditions(page, dto);
    }

    @Override
    public AuditFeeDiffLedgerDeductionVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        AuditFeeDiffLedgerDeduction auditFeeDiffLedgerDeduction = this.auditFeeDiffLedgerDeductionRepository.findById(id);
        if (auditFeeDiffLedgerDeduction == null) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(auditFeeDiffLedgerDeduction, AuditFeeDiffLedgerDeductionVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AuditFeeDiffLedgerDeductionVo create(AuditFeeDiffLedgerDeductionVo auditFeeDiffLedgerDeductionVo) {
        this.createValidation(auditFeeDiffLedgerDeductionVo);
        auditFeeDiffLedgerDeductionVo.setTenantCode(TenantUtils.getTenantCode());
        auditFeeDiffLedgerDeductionVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        auditFeeDiffLedgerDeductionVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());

        AuditFeeDiffLedgerDeduction auditFeeDiffLedgerDeduction = nebulaToolkitService.copyObjectByWhiteList(auditFeeDiffLedgerDeductionVo, AuditFeeDiffLedgerDeduction.class, HashSet.class, ArrayList.class);
        this.auditFeeDiffLedgerDeductionRepository.saveOrUpdate(auditFeeDiffLedgerDeduction);

        auditFeeDiffLedgerDeductionVo.setId(auditFeeDiffLedgerDeduction.getId());

        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditFeeDiffLedgerDeductionEventListener auditFeeDiffLedgerDeductionEventListener : eventListeners) {
                auditFeeDiffLedgerDeductionEventListener.onCreate(auditFeeDiffLedgerDeductionVo);
            }
        }

        // 发送通知
        AuditFeeDiffLedgerDeductionLogEventDto logEventDto = new AuditFeeDiffLedgerDeductionLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditFeeDiffLedgerDeductionVo);
        SerializableBiConsumer<AuditFeeDiffLedgerDeductionLogEventListener, AuditFeeDiffLedgerDeductionLogEventDto> onCreate =
                AuditFeeDiffLedgerDeductionLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, AuditFeeDiffLedgerDeductionLogEventListener.class, onCreate);
        return auditFeeDiffLedgerDeductionVo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AuditFeeDiffLedgerDeductionVo update(AuditFeeDiffLedgerDeductionVo auditFeeDiffLedgerDeductionVo) {
        this.updateValidation(auditFeeDiffLedgerDeductionVo);
        String currentId = auditFeeDiffLedgerDeductionVo.getId();
        AuditFeeDiffLedgerDeduction current = auditFeeDiffLedgerDeductionRepository.findById(currentId);
        current = Validate.notNull(current, "修改信息不存在");
        AuditFeeDiffLedgerDeductionVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(current, AuditFeeDiffLedgerDeductionVo.class, HashSet.class, ArrayList.class);


        this.auditFeeDiffLedgerDeductionRepository.saveOrUpdate(current);
        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditFeeDiffLedgerDeductionEventListener auditFeeDiffLedgerDeductionEventListener : eventListeners) {
                auditFeeDiffLedgerDeductionEventListener.onUpdate(oldVo,auditFeeDiffLedgerDeductionVo);
            }
        }

        // 发送修改通知
        AuditFeeDiffLedgerDeductionLogEventDto logEventDto = new AuditFeeDiffLedgerDeductionLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditFeeDiffLedgerDeductionVo);
        SerializableBiConsumer<AuditFeeDiffLedgerDeductionLogEventListener, AuditFeeDiffLedgerDeductionLogEventDto> onUpdate =
                AuditFeeDiffLedgerDeductionLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditFeeDiffLedgerDeductionLogEventListener.class, onUpdate);
        return auditFeeDiffLedgerDeductionVo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffLedgerDeductionRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffLedgerDeductionRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffLedgerDeductionRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(AuditFeeDiffLedgerDeductionVo auditFeeDiffLedgerDeductionVo) {
        // TODO 具体实现
        this.validation(auditFeeDiffLedgerDeductionVo);
    }

    private void updateValidation(AuditFeeDiffLedgerDeductionVo auditFeeDiffLedgerDeductionVo) {
        // TODO 具体实现
        this.validation(auditFeeDiffLedgerDeductionVo);
    }

    private void validation(AuditFeeDiffLedgerDeductionVo auditFeeDiffLedgerDeductionVo) {
        // TODO 具体实现
    }
}
