package com.biz.crm.tpm.business.audit.fee.local.service.internal.ledger;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

import static com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants.AUDIT_FEE_CHECK_DIFF_TRACK_LEDGER_USE_AMOUNT;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/10/5
 */
@Service
@Slf4j
public class AuditFeeDiffLedgerLockServiceImpl implements AuditFeeDiffLedgerLockService {

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Override
    public boolean lock(String code, TimeUnit timeUnit, int time) {
        Validate.notBlank(code,"差异费用台账加锁失败，编码不能为空!");
        return this.lock(Collections.singletonList(code), timeUnit, time);
    }

    @Override
    public boolean lock(List<String> codeList, TimeUnit timeUnit, int time) {
        Validate.notEmpty(codeList,"差异费用台账加锁失败，编码不能为空!");
        if (Objects.isNull(timeUnit)) {
            timeUnit = TimeUnit.MINUTES;
        }
        if (time < 1) {
            time = 3;
        }
        return redisLockService.batchLock(AUDIT_FEE_CHECK_DIFF_TRACK_LEDGER_USE_AMOUNT, codeList,
                timeUnit, time);
    }

    @Override
    public void unlock(String code) {
        if (StringUtils.isEmpty(code)) {
            return;
        }
        this.unlock(Collections.singletonList(code));
    }

    @Override
    public void unlock(List<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            return;
        }
        redisLockService.batchUnLock(AUDIT_FEE_CHECK_DIFF_TRACK_LEDGER_USE_AMOUNT, codeList);

    }
}
