package com.biz.crm.tpm.business.audit.fee.local.service.internal.ledger;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.audit.fee.local.entity.ledger.AuditFeeDiffLedgerPlan;
import com.biz.crm.tpm.business.audit.fee.local.repository.ledger.AuditFeeDiffLedgerPlanRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.log.AuditFeeDiffLedgerPlanLogEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.event.ledger.AuditFeeDiffLedgerPlanEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.event.log.AuditFeeDiffLedgerPlanLogEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeDetailVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanConstant;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants.AUDIT_FEE_DIFF_LEDGER_CACHE_KEY;

/**
 * 核销差异费用台账计划明细(AuditFeeDiffLedgerPlan)表服务实现类
 *
 * @author liuyifan
 * @date 2022-12-22 15:30:37
 */
@Slf4j
@Service("auditFeeDiffLedgerPlanService")
public class AuditFeeDiffLedgerPlanVoServiceImpl extends MnPageCacheServiceImpl<AuditFeeDiffLedgerPlanVo, AuditFeeDiffLedgerPlanDto> implements AuditFeeDiffLedgerPlanVoService{

    @Autowired(required = false)
    private AuditFeeDiffLedgerPlanRepository auditFeeDiffLedgerPlanRepository;

    @Autowired(required = false)
    private List<AuditFeeDiffLedgerPlanEventListener> eventListeners;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<AuditFeeDiffLedgerPlanVo> findByConditions(Pageable pageable, AuditFeeDiffLedgerPlanDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffLedgerPlanDto());
        Page<AuditFeeDiffLedgerPlanVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditFeeDiffLedgerPlanRepository.findByConditions(page, dto);
    }

    @Override
    public AuditFeeDiffLedgerPlanVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        AuditFeeDiffLedgerPlan auditFeeDiffLedgerPlan = this.auditFeeDiffLedgerPlanRepository.findById(id);
        if (auditFeeDiffLedgerPlan == null) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(auditFeeDiffLedgerPlan, AuditFeeDiffLedgerPlanVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AuditFeeDiffLedgerPlanVo create(AuditFeeDiffLedgerPlanDto dto) {
        Assert.hasText(dto.getFeeDiffLedgerCode(), "差异费用台帐编码不能为空");
        Assert.hasText(dto.getCacheKey(), "缓存key不能为空");
        List<AuditFeeDiffLedgerPlanDto> planDtos = this.findCacheList(dto.getCacheKey());
        Assert.notEmpty(planDtos, "为查询到缓存信息");
        //删除
        this.auditFeeDiffLedgerPlanRepository.deleteByFeeDiffLedgerCode(dto.getFeeDiffLedgerCode());
        List<AuditFeeDiffLedgerPlan> ledgerPlans =
            (List<AuditFeeDiffLedgerPlan>) this.nebulaToolkitService
                .copyCollectionByWhiteList(planDtos, AuditFeeDiffLedgerPlanDto.class,
                    AuditFeeDiffLedgerPlan.class, LinkedHashSet.class, ArrayList.class);
        int i = 1;
        for (AuditFeeDiffLedgerPlan o : ledgerPlans) {
            o.setFeeDiffLedgerCode(dto.getFeeDiffLedgerCode());
            o.setSerialNumber(i);
            i++;
        }
        this.auditFeeDiffLedgerPlanRepository.saveOrUpdateBatch(ledgerPlans);
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AuditFeeDiffLedgerPlanVo update(AuditFeeDiffLedgerPlanVo auditFeeDiffLedgerPlanVo) {
        this.updateValidation(auditFeeDiffLedgerPlanVo);
        String currentId = auditFeeDiffLedgerPlanVo.getId();
        AuditFeeDiffLedgerPlan current = auditFeeDiffLedgerPlanRepository.findById(currentId);
        current = Validate.notNull(current, "修改信息不存在");
        AuditFeeDiffLedgerPlanVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(current, AuditFeeDiffLedgerPlanVo.class, HashSet.class, ArrayList.class);


        this.auditFeeDiffLedgerPlanRepository.saveOrUpdate(current);
        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditFeeDiffLedgerPlanEventListener auditFeeDiffLedgerPlanEventListener : eventListeners) {
                auditFeeDiffLedgerPlanEventListener.onUpdate(oldVo, auditFeeDiffLedgerPlanVo);
            }
        }

        // 发送修改通知
        AuditFeeDiffLedgerPlanLogEventDto logEventDto = new AuditFeeDiffLedgerPlanLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditFeeDiffLedgerPlanVo);
        SerializableBiConsumer<AuditFeeDiffLedgerPlanLogEventListener, AuditFeeDiffLedgerPlanLogEventDto> onUpdate =
                AuditFeeDiffLedgerPlanLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditFeeDiffLedgerPlanLogEventListener.class, onUpdate);
        return auditFeeDiffLedgerPlanVo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffLedgerPlanRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffLedgerPlanRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffLedgerPlanRepository.updateDelFlagByIds(ids);
    }

    @Override
    public List<AuditFeeDiffLedgerPlanVo> findDetailByLedgerId(String feeDiffLedgerId) {
        if (StringUtils.isEmpty(feeDiffLedgerId)) {
            return Lists.newArrayList();
        }
        List<AuditFeeDiffLedgerPlan> auditFeeDiffLedgerPlans = this.auditFeeDiffLedgerPlanRepository.findDetailByLedgerId(feeDiffLedgerId);
        if (CollectionUtils.isEmpty(auditFeeDiffLedgerPlans)) {
            return Lists.newArrayList();
        }

        return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(auditFeeDiffLedgerPlans, AuditFeeDiffLedgerPlan.class, AuditFeeDiffLedgerPlanVo.class, HashSet.class, ArrayList.class));
    }

    private void createValidation(AuditFeeDiffLedgerPlanVo auditFeeDiffLedgerPlanVo) {
        // TODO 具体实现
        this.validation(auditFeeDiffLedgerPlanVo);
    }

    private void updateValidation(AuditFeeDiffLedgerPlanVo auditFeeDiffLedgerPlanVo) {
        // TODO 具体实现
        this.validation(auditFeeDiffLedgerPlanVo);
    }

    private void validation(AuditFeeDiffLedgerPlanVo auditFeeDiffLedgerPlanVo) {
        // TODO 具体实现
    }

    @Override
    public void createByCacheKey(String cacheKey) {

    }
}
